/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.smooth;

import com.hunantv.media.p2p.IP2pTask;
import com.hunantv.media.player.MgtvMediaPlayer;
import com.hunantv.media.player.MgtvMediaSource;
import com.hunantv.media.player.flow.FlowReportProcessor;
import com.hunantv.media.player.utils.UrlUtil;
import com.hunantv.media.report.ReportParams;
import com.hunantv.media.report.a;
import com.hunantv.media.utils.NumericUtil;

public class SmoothMediaSource
extends MgtvMediaSource {
    public static final int SMOOTH_LEVEL1 = 0;
    public static final int SMOOTH_LEVEL2 = 1;
    public static final int SMOOTH_LEVEL3 = 2;
    public static final int SWITCHMOD_NORMAL = 0;
    public static final int SWITCHMOD_ONLY_AUDIO = 1;
    private int level = 1;
    private Object data;
    private String updateUrl;
    private MgtvMediaPlayer bindPlayer;
    private a reporter;
    private ReportParams reportParams;
    int switchMod;
    public int retry;
    public boolean lastRetry;
    public boolean isp2p;
    public boolean throwErrorIfSwitchFailed;
    public String videoFileHash;
    public volatile long s_event_0_timestamp;
    public volatile long s_event_2_timestamp;
    public volatile long s_event_3_timestamp;
    public volatile long s_event_11_timestamp;
    volatile FlowReportProcessor flowReportProcessor;
    String tsFlowTag;
    private Object flowReporterLocker = new Object();

    public SmoothMediaSource(String string) {
        super(string);
    }

    public SmoothMediaSource(int n2, String string) {
        super(n2, string);
    }

    public SmoothMediaSource(int n2, String string, String string2) {
        super(n2, string, string2);
    }

    public SmoothMediaSource(int n2, String string, String string2, int n3) {
        super(n2, string, string2);
        this.switchMod = n3;
    }

    public void bind(MgtvMediaPlayer mgtvMediaPlayer) {
        if (this.bindPlayer != mgtvMediaPlayer) {
            this.bindPlayer = mgtvMediaPlayer;
            this.reporter = new a(mgtvMediaPlayer, true);
            if (this.reportParams == null) {
                this.reportParams = this.bindPlayer != null ? new ReportParams(this.bindPlayer.getReportParams()) : new ReportParams();
            }
            this.url = FlowReportProcessor.replaceUrlSftcNoP2p(this.url, this.reportParams);
            this.proxyUrl = FlowReportProcessor.replaceUrlSftcNoP2p(this.proxyUrl, this.reportParams);
            this.playingUrl = this.readType == 0 ? this.url : this.proxyUrl;
            if (this.reportParams.getVideoType() == ReportParams.VideoType.VOD && this.switchMod == 1) {
                this.reportParams.setVideoType(ReportParams.VideoType.VOD_AUDIO);
            }
            this.reportParams.setDef(this.def);
            this.reportParams.setUrl(UrlUtil.getHostName(this.url));
            this.reportParams.setVideoFileHash(this.videoFileHash);
            this.reporter.a(this);
            this.reporter.a(this.reportParams);
        }
    }

    public ReportParams getReportParams() {
        return this.reportParams;
    }

    public SmoothMediaSource setReportParams(ReportParams reportParams) {
        this.reportParams = reportParams;
        if (this.reporter != null) {
            this.reporter.a(reportParams);
        }
        return this;
    }

    public a getReporter() {
        return this.reporter;
    }

    public SmoothMediaSource setLevel(int n2) {
        this.level = n2;
        return this;
    }

    public int getLevel() {
        return this.level;
    }

    public Object getData() {
        return this.data;
    }

    public SmoothMediaSource setData(Object object) {
        this.data = object;
        return this;
    }

    @Override
    public SmoothMediaSource setVideoFormat(String string) {
        super.setVideoFormat(string);
        return this;
    }

    @Override
    public SmoothMediaSource setAudioFormat(String string) {
        super.setAudioFormat(string);
        return this;
    }

    @Override
    public SmoothMediaSource setFileFormat(String string) {
        super.setFileFormat(string);
        return this;
    }

    public SmoothMediaSource setVideoFileHash(String string) {
        this.videoFileHash = string;
        if (this.reportParams != null) {
            this.reportParams.setVideoFileHash(string);
        }
        return this;
    }

    public String getUpdateUrl() {
        return this.updateUrl;
    }

    public SmoothMediaSource setUpdateUrl(String string) {
        this.updateUrl = string;
        return this;
    }

    public String useUpdateUrl() {
        this.playingUrl = this.updateUrl;
        return this.playingUrl;
    }

    public int getArg() {
        if (this.isFileFormat("HLS-TS")) {
            return 1;
        }
        if (this.isFileFormat("HLS-FMP4")) {
            return 2;
        }
        if (this.isFileFormat("MPEG-TS")) {
            return 3;
        }
        if (this.isFileFormat("MPEG-4")) {
            return 4;
        }
        if (this.isFileFormat("FLV")) {
            return 5;
        }
        return 0;
    }

    private boolean isFileFormat(String string) {
        return string != null && string.equalsIgnoreCase(this.fileFormat);
    }

    @Override
    public String getVid() {
        return super.getVid();
    }

    @Override
    public SmoothMediaSource setVid(String string) {
        super.setVid(string);
        return this;
    }

    @Override
    public String getDef() {
        return super.getDef();
    }

    @Override
    public SmoothMediaSource setDef(String string) {
        super.setDef(string);
        return this;
    }

    public long getVVTimeT1() {
        if (this.s_event_0_timestamp > 0L && this.s_event_2_timestamp > 0L) {
            return this.s_event_2_timestamp - this.s_event_0_timestamp;
        }
        return -1L;
    }

    public long getVVTimeT4() {
        if (this.s_event_2_timestamp > 0L && this.s_event_3_timestamp > 0L) {
            return this.s_event_3_timestamp - this.s_event_2_timestamp;
        }
        return -1L;
    }

    public long getVVTimeT6() {
        if (this.s_event_3_timestamp > 0L && this.s_event_11_timestamp > 0L) {
            return this.s_event_11_timestamp - this.s_event_3_timestamp;
        }
        return -1L;
    }

    public long getVVTimeVVT() {
        if (this.s_event_0_timestamp > 0L && this.s_event_11_timestamp > 0L) {
            return this.s_event_11_timestamp - this.s_event_0_timestamp;
        }
        return -1L;
    }

    public int getRetry() {
        return this.retry;
    }

    public SmoothMediaSource setRetry(int n2) {
        this.retry = n2;
        return this;
    }

    public boolean isLastRetry() {
        return this.lastRetry;
    }

    public SmoothMediaSource setLastRetry(boolean bl) {
        this.lastRetry = bl;
        return this;
    }

    public boolean isIsp2p() {
        return this.isp2p;
    }

    public SmoothMediaSource setIsp2p(boolean bl) {
        this.isp2p = bl;
        return this;
    }

    public boolean isThrowErrorIfSwitchFailed() {
        return this.throwErrorIfSwitchFailed;
    }

    public SmoothMediaSource setThrowErrorIfSwitchFailed(boolean bl) {
        this.throwErrorIfSwitchFailed = bl;
        return this;
    }

    public int getSwitchMod() {
        return this.switchMod;
    }

    public SmoothMediaSource setSwitchMod(int n2) {
        this.switchMod = n2;
        return this;
    }

    @Override
    public SmoothMediaSource setP2pTask(IP2pTask iP2pTask) {
        super.setP2pTask(iP2pTask);
        return this;
    }

    @Override
    public SmoothMediaSource setReadType(int n2) {
        super.setReadType(n2);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genFlowReporter() {
        Object object = this.flowReporterLocker;
        synchronized (object) {
            if (this.flowReportProcessor == null && this.reportParams != null) {
                boolean bl = false;
                if (this.p2pTask != null && (this.reportParams.getProxyType() == ReportParams.ProxyType.ONLY_P2P || this.reportParams.getProxyType() == ReportParams.ProxyType.P2P_DRM)) {
                    bl = true;
                }
                this.flowReportProcessor = new FlowReportProcessor(this.url, this.reportParams.getVid(), NumericUtil.parseInt(this.reportParams.getDef()), this.reportParams.getVideoSession(), bl, "smooth");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowReportProcessor getFlowReportProcessor() {
        Object object = this.flowReporterLocker;
        synchronized (object) {
            return this.flowReportProcessor;
        }
    }

    public SmoothMediaSource setTsFlowTag(String string) {
        this.tsFlowTag = string;
        if (this.reportParams != null) {
            this.reportParams.setFlowt(string);
        }
        return this;
    }

    public String getTsFlowTag() {
        return this.tsFlowTag;
    }

    @Override
    public synchronized void release() {
        super.release();
    }

    @Override
    public String toString() {
        return "SmoothMediaSource{level=" + this.level + ", data=" + this.data + ", updateUrl='" + this.updateUrl + '\'' + ", bindPlayer=" + this.bindPlayer + ", reporter=" + this.reporter + ", reportParams=" + this.reportParams + ", retry=" + this.retry + ", lastRetry=" + this.lastRetry + ", isp2p=" + this.isp2p + ", readType=" + this.readType + ", url='" + this.url + '\'' + ", proxyUrl='" + this.proxyUrl + '\'' + ", playingUrl='" + this.playingUrl + '\'' + ", videoFormat='" + this.videoFormat + '\'' + ", fileFormat='" + this.fileFormat + '\'' + ", vid='" + this.vid + '\'' + ", def='" + this.def + '\'' + ", throwErrorIfSwitchFailed='" + this.throwErrorIfSwitchFailed + '\'' + ", switchMod='" + this.switchMod + '\'' + ", tsFlowTag='" + this.tsFlowTag + '\'' + '}';
    }
}

