/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.subtitle;

import android.os.Handler;
import android.os.HandlerThread;
import com.hunantv.media.player.subtitle.MediaFormat;
import com.hunantv.media.player.subtitle.c;
import com.hunantv.media.player.subtitle.d;
import com.hunantv.media.player.utils.ThreadUtil;
import com.hunantv.media.report.c.f;
import com.hunantv.media.utils.ByteUtil;
import com.hunantv.media.utils.StreamUtil;
import com.hunantv.media.utils.StringUtil;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Scanner;

public class SubtitleSource {
    private InputStream mInputStream;
    private String mPath;
    private byte[] mContent;
    private MediaFormat mFormat;
    private String mCharset = "UTF-8";
    private volatile boolean mReleased;
    private volatile boolean mReading;
    private volatile boolean mReaded;
    private Object sync = new Object();
    private volatile SubtitleSourceHolder mHolder;
    private ErrorResult mErrorResult = new ErrorResult();
    private SubtitleSourceCallback mCallback;

    public SubtitleSource(InputStream inputStream, MediaFormat mediaFormat) {
        this.mInputStream = inputStream;
        this.mFormat = mediaFormat;
    }

    public SubtitleSource(String string, MediaFormat mediaFormat) {
        this.mPath = string;
        this.mFormat = mediaFormat;
        this.mInputStream = StreamUtil.createFileInputStream(string);
    }

    public SubtitleSource(byte[] byArray, MediaFormat mediaFormat) {
        this.mContent = byArray;
        this.mFormat = mediaFormat;
        this.mReaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindHolder(SubtitleSourceHolder subtitleSourceHolder) {
        Object object = this.sync;
        synchronized (object) {
            this.mHolder = subtitleSourceHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unBindHolder() {
        Object object = this.sync;
        synchronized (object) {
            this.mHolder = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBinded() {
        Object object = this.sync;
        synchronized (object) {
            return this.mHolder != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.sync;
        synchronized (object) {
            this.mReleased = true;
            if (!this.mReading) {
                f.a(this.mInputStream);
                this.mCallback = null;
            }
            this.mInputStream = null;
            this.mReaded = false;
        }
    }

    public boolean isReleased() {
        return this.mReleased;
    }

    public InputStream getInputStream() {
        return this.mInputStream;
    }

    public String getPath() {
        return this.mPath;
    }

    public MediaFormat getFormat() {
        return this.mFormat;
    }

    public byte[] getContent() {
        return this.mContent;
    }

    public String getCharset() {
        return this.mCharset;
    }

    public void setCharset(String string) {
        this.mCharset = string;
    }

    public boolean isValid() {
        return !this.isReleased() && (this.getInputStream() != null || !ByteUtil.isEmpty(this.mContent)) && this.getFormat() != null;
    }

    public boolean isReading() {
        return this.mReading;
    }

    private byte[] readContentBytes() {
        if (!this.isValid()) {
            return null;
        }
        if (this.mContent != null) {
            return this.mContent;
        }
        String string = this.readContentStrImpl();
        if (!StringUtil.isSpace(string)) {
            try {
                this.mContent = string.getBytes(this.getCharset());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        if (this.mReleased) {
            f.a(this.mInputStream);
        }
        return this.mContent;
    }

    private String readContentStrImpl() {
        Scanner scanner = new Scanner(this.getInputStream(), this.getCharset());
        if (scanner != null) {
            String string = scanner.useDelimiter("\\A").next();
            this.mReaded = true;
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSource(d d2, SubtitleSource subtitleSource) {
        Object object = this.sync;
        synchronized (object) {
            if (ByteUtil.isEmpty(this.mContent)) {
                this.asyncReadSource(d2, subtitleSource);
            } else if (this.mCallback != null) {
                this.mCallback.onSuccess(d2, subtitleSource);
            }
        }
    }

    public void setCallback(SubtitleSourceCallback subtitleSourceCallback) {
        this.mCallback = subtitleSourceCallback;
    }

    private void asyncReadSource(final d d2, final SubtitleSource subtitleSource) {
        if (this.mReading) {
            return;
        }
        final HandlerThread handlerThread = new HandlerThread("SubtitleReadThread", 9);
        handlerThread.start();
        this.mReading = true;
        Handler handler = new Handler(handlerThread.getLooper());
        handler.post(new Runnable(){

            private void addTrack() {
                c.b("subtitle", "addTrack in");
                if (subtitleSource == null || d2 == null) {
                    if (SubtitleSource.this.mCallback != null) {
                        SubtitleSource.this.mCallback.onFailed(0);
                    }
                    return;
                }
                c.b("subtitle", "before new Scanner");
                byte[] byArray = subtitleSource.readContentBytes();
                if (ByteUtil.isEmpty(byArray)) {
                    if (SubtitleSource.this.mCallback != null) {
                        SubtitleSource.this.mCallback.onFailed(1);
                    }
                    return;
                }
                if (SubtitleSource.this.mCallback != null) {
                    SubtitleSource.this.mCallback.onSuccess(d2, subtitleSource);
                }
            }

            @Override
            public void run() {
                this.addTrack();
                SubtitleSource.this.mReading = false;
                if (SubtitleSource.this.mReleased) {
                    SubtitleSource.this.mCallback = null;
                }
                ThreadUtil.quit(handlerThread.getLooper());
            }
        });
    }

    public ErrorResult getErrorResult() {
        return this.mErrorResult;
    }

    public static interface SubtitleSourceCallback {
        public void onSuccess(d var1, SubtitleSource var2);

        public void onFailed(int var1);
    }

    public static class ErrorResult {
        public static final int ERROR_DEFAULT = -1;
        public static final int ERROR_NOT_ENABLE_MODULE = -2;
        public int code = 0;

        public ErrorResult setCode(int n2) {
            this.code = n2;
            return this;
        }
    }

    public static interface SubtitleSourceHolder {
    }
}

