/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.utils;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.hunantv.media.player.pragma.DebugLog;
import java.lang.ref.WeakReference;

public class ExTicker {
    private static final int MIN_TICKTIME = 10;
    private static final int MSG_UPDATE_TICK = 65536;
    private onTickListener mOnTickListener;
    private OnExTickListener mOnExTickListener;
    private int mTickTime = 10;
    private int mTickCount;
    private int mSubTickCount;
    private Handler handler = new InternalHandler(this);
    private volatile Status mCurState = Status.STATE_STOP;
    private Object mLocker = new Object();
    private String mHostLogTag;
    private String mTypeStr;

    public ExTicker(int n2) {
        this.mTickTime = n2;
        if (n2 < 10) {
            this.mTickTime = 10;
        }
    }

    public ExTicker(Looper looper, int n2) {
        this(n2);
        this.handler = new InternalHandler(looper, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.stop();
        Object object = this.mLocker;
        synchronized (object) {
            this.mTickCount = 0;
            this.mSubTickCount = 0;
            DebugLog.i(this.getLogTag(), "ExTicker start.status:" + (Object)((Object)this.mCurState));
            this.mCurState = Status.STATE_START;
            this.callbackExTickPlayOrPause(true);
            this.handler.sendEmptyMessage(65536);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.mLocker;
        synchronized (object) {
            if (this.mCurState != Status.STATE_START) {
                return;
            }
            this.mSubTickCount = 0;
            DebugLog.i(this.getLogTag(), "ExTicker pause.status:" + (Object)((Object)this.mCurState));
            this.mCurState = Status.STATE_PAUSE;
            this.callbackExTickPlayOrPause(false);
            this.handler.removeMessages(65536);
        }
    }

    public void seekto(int n2) {
        this.mTickCount = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.mLocker;
        synchronized (object) {
            if (this.mCurState != Status.STATE_PAUSE) {
                return;
            }
            DebugLog.i(this.getLogTag(), "ExTicker resume.status:" + (Object)((Object)this.mCurState));
            this.mCurState = Status.STATE_START;
            this.callbackExTickPlayOrPause(true);
            this.handler.removeMessages(65536);
            this.handler.sendEmptyMessage(65536);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mLocker;
        synchronized (object) {
            if (this.mCurState == Status.STATE_STOP) {
                return;
            }
            DebugLog.d(this.getLogTag(), "ExTicker stop");
            this.mCurState = Status.STATE_STOP;
            this.callbackExTickPlayOrPause(false);
            this.handler.removeMessages(65536);
        }
    }

    public void setCallback(onTickListener onTickListener2) {
        this.mOnTickListener = onTickListener2;
    }

    public void setExCallback(OnExTickListener onExTickListener) {
        this.mOnExTickListener = onExTickListener;
    }

    private void callbackExTickPlayOrPause(boolean bl) {
        if (this.mOnExTickListener != null) {
            this.mOnExTickListener.onPlayOrPause(bl);
        }
    }

    public int getTickCount() {
        return this.mTickCount;
    }

    public void updateTickTime(int n2) {
        DebugLog.d(this.getLogTag(), "updateTickTime tickTime:" + n2);
        this.mTickTime = n2;
    }

    public int getTickTime() {
        return this.mTickTime;
    }

    public boolean isTicking() {
        return this.mCurState == Status.STATE_START;
    }

    public boolean isPaused() {
        return this.mCurState == Status.STATE_PAUSE;
    }

    public ExTicker setHostLogTag(String string) {
        this.mHostLogTag = string;
        return this;
    }

    private String getLogTag() {
        return "[" + this.mHostLogTag + "-" + this.mTypeStr + "-exTicker]";
    }

    public ExTicker setTypeStr(String string) {
        this.mTypeStr = string;
        return this;
    }

    private static class InternalHandler
    extends Handler {
        WeakReference<ExTicker> wrObj;

        public InternalHandler(ExTicker exTicker) {
            this.wrObj = new WeakReference<ExTicker>(exTicker);
        }

        public InternalHandler(Looper looper, ExTicker exTicker) {
            super(looper);
            this.wrObj = new WeakReference<ExTicker>(exTicker);
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            if (this.wrObj != null && this.wrObj.get() != null) {
                ExTicker exTicker = (ExTicker)this.wrObj.get();
                switch (message.what) {
                    case 65536: {
                        if (exTicker == null || exTicker.mCurState != Status.STATE_START) break;
                        exTicker.mTickCount++;
                        exTicker.mSubTickCount++;
                        DebugLog.d(exTicker.getLogTag(), "ExTicker count:" + exTicker.mTickCount + "_" + exTicker.mSubTickCount);
                        exTicker.handler.sendEmptyMessageDelayed(65536, (long)exTicker.mTickTime);
                        if (exTicker.mOnTickListener != null) {
                            exTicker.mOnTickListener.onTick(exTicker.mTickCount);
                        }
                        if (exTicker.mOnExTickListener == null) break;
                        exTicker.mOnExTickListener.onTick(exTicker.mTickCount, exTicker.mSubTickCount);
                        break;
                    }
                }
            }
        }
    }

    public static interface OnExTickListener {
        public void onTick(int var1, int var2);

        public void onPlayOrPause(boolean var1);
    }

    public static interface onTickListener {
        public void onTick(int var1);
    }

    private static enum Status {
        STATE_START,
        STATE_PAUSE,
        STATE_STOP;

    }
}

