/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.utils;

import android.content.Context;
import androidx.annotation.Nullable;
import com.hunantv.media.player.utils.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAssert(Context context, String string) {
        if (context == null) {
            return null;
        }
        InputStreamReader inputStreamReader = null;
        try {
            char[] cArray = new char[1024];
            StringBuffer stringBuffer = new StringBuffer();
            inputStreamReader = new InputStreamReader(context.getAssets().open(string));
            int n2 = 0;
            while ((n2 = inputStreamReader.read(cArray)) >= 0) {
                stringBuffer.append(cArray, 0, n2);
            }
            String string2 = stringBuffer.toString();
            FileUtil.close(inputStreamReader);
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            FileUtil.close(inputStreamReader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyAssertThrow(Context context, String string, String string2) throws IOException {
        boolean bl;
        if (context == null || StringUtil.isEmpty(string) || StringUtil.isEmpty(string2)) {
            return false;
        }
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = context.getAssets().open(string);
            File file = new File(string2);
            FileUtil.deleteFile(file);
            FileUtil.mkdirs(file.getParentFile());
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            int n2 = 0;
            while ((n2 = inputStream.read(byArray)) >= 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                fileOutputStream.flush();
            }
            bl = true;
        }
        catch (Throwable throwable) {
            FileUtil.close(inputStream);
            FileUtil.close(fileOutputStream);
            throw throwable;
        }
        FileUtil.close(inputStream);
        FileUtil.close(fileOutputStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(String string) {
        InputStreamReader inputStreamReader = null;
        try {
            char[] cArray = new char[1024];
            StringBuffer stringBuffer = new StringBuffer();
            inputStreamReader = new InputStreamReader(new FileInputStream(string));
            int n2 = 0;
            while ((n2 = inputStreamReader.read(cArray)) >= 0) {
                stringBuffer.append(cArray, 0, n2);
            }
            String string2 = stringBuffer.toString();
            FileUtil.close(inputStreamReader);
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            FileUtil.close(inputStreamReader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(String string) {
        FileInputStream fileInputStream = null;
        try {
            File file = new File(string);
            if (file.length() >= Integer.MAX_VALUE) {
                byte[] byArray = null;
                return byArray;
            }
            fileInputStream = new FileInputStream(file);
            byte[] byArray = FileUtil.readBytes(fileInputStream);
            FileUtil.close(fileInputStream);
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            FileUtil.close(fileInputStream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n2;
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[2048];
            while ((n2 = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            FileUtil.close(byteArrayOutputStream);
        }
        return null;
    }

    public static boolean deleteDir(String string) {
        if (!StringUtil.isEmpty(string)) {
            try {
                return FileUtil.deleteDir(new File(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public static boolean deleteDir(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            String[] stringArray;
            for (String string : stringArray = file.list()) {
                boolean bl = FileUtil.deleteDir(new File(file, string));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static boolean mkdirs(String string) {
        return FileUtil.mkdirs(new File(string));
    }

    public static boolean remkdirs(String string) {
        FileUtil.deleteDir(string);
        return FileUtil.mkdirs(string) && FileUtil.exist(string);
    }

    public static boolean exist(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        try {
            File file = new File(string);
            return file.exists();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return bl;
        }
    }

    public static boolean mkdirs(File file) {
        if (file == null) {
            return false;
        }
        return file.mkdirs() || file.isDirectory();
    }

    public static boolean deleteFile(File file) {
        if (file == null) {
            return false;
        }
        boolean bl = file.delete();
        return bl;
    }

    public static int listCount(File file, String string) {
        String[] stringArray = FileUtil.list(file, string);
        if (stringArray != null) {
            return stringArray.length;
        }
        return 0;
    }

    public static String[] list(File file, final String string) {
        if (file == null) {
            return null;
        }
        try {
            if (string == null) {
                return file.list();
            }
            return file.list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string2) {
                    if (string2 != null) {
                        return string2.endsWith(string);
                    }
                    return false;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean copyFile(File file, File file2) {
        block11: {
            boolean bl;
            if (!file2.exists()) {
                if (!FileUtil.mkdirs(file2.getParentFile()) || !FileUtil.createNewFile(file2)) {
                    return false;
                }
            } else if (file2.isDirectory()) {
                file2 = new File(file2, file.getName());
            }
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2);
                FileChannel fileChannel = fileInputStream.getChannel();
                FileChannel fileChannel2 = fileOutputStream.getChannel();
                fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
                FileUtil.close(fileChannel);
                FileUtil.close(fileChannel2);
                bl = true;
                FileUtil.close(fileOutputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                break block11;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                FileUtil.close(fileOutputStream);
                FileUtil.close(fileInputStream);
            }
            FileUtil.close(fileInputStream);
            return bl;
        }
        return false;
    }

    public static void close(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static boolean createNewFile(File file) {
        boolean bl;
        if (file == null) {
            return false;
        }
        try {
            bl = file.createNewFile() || file.isFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        return bl;
    }
}

