/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.utils;

import android.content.Context;
import android.content.SharedPreferences;

public final class PreferencesUtil {
    public static final String PREKEY_MEDIACODEC_H264_SUPPORT_BASELINE = "prekey_h264_support_base";
    public static final String PREKEY_MEDIACODEC_H264_SUPPORT_MAIN = "prekey_h264_support_main";
    public static final String PREKEY_MEDIACODEC_H264_SUPPORT_HIGH = "prekey_h264_support_high";
    public static final String PREKEY_MEDIACODEC_H265_SUPPORT = "prekey_h265_support";
    private static final String PREFERENCE_NAME = "MgtvPlayerConfig";
    private Context mContext;

    public PreferencesUtil(Context context) {
        this.mContext = context;
    }

    public boolean putString(String string, String string2) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(PREFERENCE_NAME);
        if (sharedPreferences == null) {
            return false;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(string, string2);
        return this.safeCommit(editor);
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public String getString(String string, String string2) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(PREFERENCE_NAME);
        if (sharedPreferences == null) {
            return string2;
        }
        return sharedPreferences.getString(string, string2);
    }

    public boolean putInt(String string, int n2) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(PREFERENCE_NAME);
        if (sharedPreferences == null) {
            return false;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(string, n2);
        return this.safeCommit(editor);
    }

    public int getInt(String string) {
        return this.getInt(string, -1);
    }

    public int getInt(String string, int n2) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(PREFERENCE_NAME);
        if (sharedPreferences == null) {
            return n2;
        }
        return sharedPreferences.getInt(string, n2);
    }

    public boolean putLong(String string, long l2) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(PREFERENCE_NAME);
        if (sharedPreferences == null) {
            return false;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(string, l2);
        return this.safeCommit(editor);
    }

    public long getLong(String string) {
        return this.getLong(string, -1L);
    }

    public long getLong(String string, long l2) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(PREFERENCE_NAME);
        if (sharedPreferences == null) {
            return l2;
        }
        return sharedPreferences.getLong(string, l2);
    }

    public boolean putFloat(String string, float f2) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(PREFERENCE_NAME);
        if (sharedPreferences == null) {
            return false;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putFloat(string, f2);
        return this.safeCommit(editor);
    }

    public float getFloat(String string) {
        return this.getFloat(string, -1.0f);
    }

    public float getFloat(String string, float f2) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(PREFERENCE_NAME);
        if (sharedPreferences == null) {
            return f2;
        }
        return sharedPreferences.getFloat(string, f2);
    }

    public boolean putBoolean(String string, boolean bl) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(PREFERENCE_NAME);
        if (sharedPreferences == null) {
            return false;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(string, bl);
        return this.safeCommit(editor);
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(String string, boolean bl) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(PREFERENCE_NAME);
        if (sharedPreferences == null) {
            return bl;
        }
        return sharedPreferences != null && sharedPreferences.getBoolean(string, bl);
    }

    private SharedPreferences getSharedPreferences(String string) {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getSharedPreferences(string, 0);
    }

    private boolean safeCommit(SharedPreferences.Editor editor) {
        try {
            return editor.commit();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void removeKey(String string) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(PREFERENCE_NAME);
        if (sharedPreferences == null) {
            return;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove(string);
        this.safeCommit(editor);
    }
}

