/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.utils;

import com.hunantv.media.player.utils.StringUtil;

public final class Size {
    private final int mWidth;
    private final int mHeight;

    public Size(int n2, int n3) {
        this.mWidth = n2;
        this.mHeight = n3;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof Size) {
            Size size = (Size)object;
            return this.mWidth == size.mWidth && this.mHeight == size.mHeight;
        }
        return false;
    }

    public String toString() {
        return this.mWidth + "x" + this.mHeight;
    }

    private static NumberFormatException invalidSize(String string) {
        throw new NumberFormatException("Invalid Size: \"" + string + "\"");
    }

    public static Size parseSize(String string) throws NumberFormatException {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        int n2 = string.indexOf(42);
        if (n2 < 0) {
            n2 = string.indexOf(120);
        }
        if (n2 < 0) {
            throw Size.invalidSize(string);
        }
        try {
            return new Size(Integer.parseInt(string.substring(0, n2)), Integer.parseInt(string.substring(n2 + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            throw Size.invalidSize(string);
        }
    }

    public int hashCode() {
        return this.mHeight ^ (this.mWidth << 16 | this.mWidth >>> 16);
    }
}

