/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.utils;

import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.InvalidParameterException;

public class SocketUtil {
    public static String getAddress(URL uRL) {
        if (uRL == null) {
            return null;
        }
        try {
            return SocketUtil.getAddress(uRL.getHost());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String getAddress(String string) {
        try {
            return SocketUtil.getAddressThrowable(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String getAddressThrowable(String string) throws UnknownHostException, SecurityException, InvalidParameterException {
        if (string == null || string.trim().equals("")) {
            throw new InvalidParameterException("getAddressThrowable domainName invalid");
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        if (inetAddress != null) {
            return inetAddress.getHostAddress();
        }
        return null;
    }

    public static String[] getAllAddressThrowable(String string) throws UnknownHostException, SecurityException, InvalidParameterException {
        if (string == null || string.trim().equals("")) {
            throw new InvalidParameterException("getAddressThrowable domainName invalid");
        }
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        int n2 = inetAddressArray.length;
        if (inetAddressArray != null && n2 > 0) {
            String[] stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = inetAddressArray[i2].getHostAddress();
            }
            return stringArray;
        }
        return null;
    }
}

