/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.utils;

public class StringUtil {
    public static String removeSpace(String string) {
        if (string == null) {
            return null;
        }
        return string.replace(" ", "");
    }

    public static String safeToLowerCase(String string) {
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        return string.toLowerCase();
    }

    public static String trim(String string) {
        try {
            if (string == null) {
                return "";
            }
            return string.trim();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static boolean isEmpty(String string) {
        return string == null || "".equals(string.trim());
    }

    public static boolean contains(String string, String string2) {
        if (StringUtil.isEmpty(string) || StringUtil.isEmpty(string2)) {
            return false;
        }
        return string.contains(string2);
    }

    public static String padRight(CharSequence charSequence, Number number) {
        return StringUtil.padRight(charSequence, number, " ");
    }

    public static String padRight(CharSequence charSequence, Number number, CharSequence charSequence2) {
        int n2 = number.intValue();
        return n2 <= charSequence.length() ? charSequence.toString() : charSequence + StringUtil.getPadding(charSequence2.toString(), n2 - charSequence.length());
    }

    private static String getPadding(CharSequence charSequence, int n2) {
        return charSequence.length() < n2 ? StringUtil.multiply(charSequence, n2 / charSequence.length() + 1).substring(0, n2) : "" + charSequence.subSequence(0, n2);
    }

    public static String multiply(CharSequence charSequence, Number number) {
        int n2 = number.intValue();
        if (n2 == 0) {
            return "";
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("multiply() should be called with a number of 0 or greater not: " + n2);
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence);
        for (int i2 = 1; i2 < n2; ++i2) {
            stringBuilder.append(charSequence);
        }
        return stringBuilder.toString();
    }

    public static boolean isHtml(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        return string.contains("<!DOCTYPE html>") || string.contains("<html>");
    }

    public static String parseValue(String string, String string2) {
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        try {
            String[] stringArray = string.split(string2);
            if (stringArray.length == 1) {
                return "";
            }
            if (stringArray.length >= 2) {
                return stringArray[1];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }
}

