/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.utils;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.view.Window;
import com.hunantv.media.player.helper.BuildHelper;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.utils.StringUtil;
import com.hunantv.media.utils.NumericUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;

public class SystemUtil {
    private static final String TAG = "SystemUtil";
    private static String sPrimaryCpuAbi;
    private static final int ROOT_ERR = 2;
    private static final int ROOT_YES = 1;
    private static final int ROOT_NO = 0;
    private static final int ROOT_NULL = -1;
    private static int sRoot1;
    private static final int VALUE_NOT_GET = -1;
    public static int sHwEmuiAPILevel;

    public static boolean isWindowScreenOn(Activity activity) {
        if (activity == null) {
            return false;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return false;
        }
        return (window.getAttributes().flags & 0x80) != 0;
    }

    public static String getPrimaryCpuAbi(Context context) {
        if (sPrimaryCpuAbi == null) {
            try {
                if (BuildHelper.isApi21_LollipopOrLater()) {
                    if (context == null) {
                        sPrimaryCpuAbi = Build.CPU_ABI;
                        return sPrimaryCpuAbi;
                    }
                    ApplicationInfo applicationInfo = context.getApplicationInfo();
                    Field field = applicationInfo.getClass().getDeclaredField("primaryCpuAbi");
                    field.setAccessible(true);
                    Object object = field.get(applicationInfo);
                    if (object instanceof String && !"".equals(((String)object).trim())) {
                        sPrimaryCpuAbi = (String)object;
                        return sPrimaryCpuAbi;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            sPrimaryCpuAbi = Build.CPU_ABI;
            return sPrimaryCpuAbi;
        }
        return sPrimaryCpuAbi;
    }

    public static synchronized int isRoot1() {
        try {
            if (sRoot1 == -1) {
                sRoot1 = SystemUtil.isRoot1Impl() ? 1 : 0;
            }
        }
        catch (Exception exception) {
            sRoot1 = 2;
        }
        return sRoot1;
    }

    private static boolean isRoot1Impl() {
        boolean bl = SystemUtil.checkRootMethod1() || SystemUtil.checkRootMethod2() || SystemUtil.checkRootMethod3();
        return bl;
    }

    private static boolean checkRootMethod1() {
        String string = Build.TAGS;
        return string != null && string.contains("test-keys");
    }

    private static boolean checkRootMethod2() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"/system/app/Superuser.apk", "/sbin/su", "/system/bin/su", "/system/xbin/su", "/data/local/xbin/su", "/data/local/bin/su", "/system/sd/xbin/su", "/system/bin/failsafe/su", "/data/local/su", "/su/bin/su"}) {
            if (!new File(string).exists()) continue;
            return true;
        }
        return false;
    }

    private static boolean checkRootMethod3() {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(new String[]{"/system/xbin/which", "su"});
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            boolean bl = bufferedReader.readLine() != null;
            return bl;
        }
        catch (Throwable throwable) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    public static int getHwEmuiAPILevel() {
        if (sHwEmuiAPILevel == -1) {
            String string = SystemUtil.getSystemProperty("ro.build.magic_api_level");
            if (StringUtil.isEmpty(string)) {
                string = SystemUtil.getSystemProperty("ro.build.hw_emui_api_level");
            }
            DebugLog.e(TAG, "getHwEmuiAPILevel str" + string);
            sHwEmuiAPILevel = NumericUtil.parseInt(string, 0);
            DebugLog.e(TAG, "getHwEmuiAPILevel int" + sHwEmuiAPILevel);
        }
        return sHwEmuiAPILevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSystemProperty(String string) {
        String string2;
        BufferedReader bufferedReader = null;
        try {
            Process process = Runtime.getRuntime().exec("getprop " + string);
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 1024);
            string2 = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            DebugLog.e(TAG, "IOException Unable to read sysprop" + string, iOException);
            String string3 = null;
            return string3;
        }
        catch (Exception exception) {
            DebugLog.e(TAG, "Exception Unable to read sysprop " + string, exception);
            String string4 = null;
            return string4;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    DebugLog.e(TAG, "Exception while closing InputStream", iOException);
                }
            }
        }
        return string2;
    }

    static {
        sRoot1 = -1;
        sHwEmuiAPILevel = -1;
    }
}

