/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.utils;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;

public class ThreadUtil {
    public static void runOnTargetLooper(Looper looper, Runnable runnable) {
        if (looper != null && runnable != null) {
            new Handler(looper).post(runnable);
        }
    }

    public static void runOnUiThread(Runnable runnable) {
        Looper looper = Looper.getMainLooper();
        if (Thread.currentThread() == looper.getThread()) {
            runnable.run();
        } else {
            ThreadUtil.postOnUiThread(runnable);
        }
    }

    public static void postOnUiThread(Runnable runnable) {
        new Handler(Looper.getMainLooper()).post(runnable);
    }

    public static void quit(Looper looper) {
        if (looper != null) {
            if (Build.VERSION.SDK_INT >= 18) {
                looper.quitSafely();
            } else {
                looper.quit();
            }
        }
    }
}

