/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.utils;

import android.net.Uri;
import com.hunantv.media.player.utils.StringUtil;
import java.net.URLEncoder;
import java.util.Locale;

public class UrlUtil {
    public static final String STR_FILE = "file";

    public static boolean isSuffixUrl(String string, String string2) {
        boolean bl = false;
        if (string == null || string2 == null) {
            return false;
        }
        try {
            Uri uri = Uri.parse((String)string.toLowerCase(Locale.US));
            if (!StringUtil.isEmpty(uri.getPath())) {
                bl = uri.getPath().endsWith(string2.toLowerCase(Locale.US));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return bl;
    }

    public static boolean isSegment(String string) {
        return UrlUtil.isSuffixUrl(string, ".ts") || UrlUtil.isSuffixUrl(string, ".m4s") || UrlUtil.isSuffixUrl(string, ".mp4");
    }

    public static boolean isM3u8(String string) {
        return UrlUtil.isSuffixUrl(string, ".m3u8") || UrlUtil.isSuffixUrl(string, ".m3u");
    }

    public static String getValidUrl(String string) {
        String string2 = "http://";
        String string3 = string;
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        int n2 = string.indexOf(string2);
        if (n2 != -1) {
            string3 = string.substring(n2);
        } else {
            string2 = "https://";
            n2 = string.indexOf(string2);
            if (n2 != -1) {
                string3 = string.substring(n2);
            }
        }
        return string3;
    }

    public static String getValidHttpUrl(String string) {
        String string2 = "http://";
        String string3 = null;
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        int n2 = string.indexOf(string2);
        if (n2 != -1) {
            string3 = string.substring(n2);
        } else {
            string2 = "https://";
            n2 = string.indexOf(string2);
            if (n2 != -1) {
                string3 = string.substring(n2);
            }
        }
        return string3;
    }

    public static boolean isFilePrefix(String string) {
        return string != null && string.toLowerCase(Locale.US).startsWith("file://");
    }

    public static String addLocalPrefix(String string) {
        if (string == null || UrlUtil.isFilePrefix(string)) {
            return string;
        }
        return "file://" + string;
    }

    public static String[] addLocalPrefix(String[] stringArray) {
        if (stringArray == null || stringArray.length <= 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        for (String string : stringArray) {
            stringArray2[n2] = UrlUtil.addLocalPrefix(string);
            ++n2;
        }
        return stringArray2;
    }

    public static String getFileName(String string) {
        try {
            if (StringUtil.isEmpty(string)) {
                return null;
            }
            Uri uri = Uri.parse((String)string);
            if (uri == null || uri.getPath() == null) {
                return null;
            }
            String[] stringArray = uri.getPath().split("/");
            if (stringArray.length >= 1) {
                return stringArray[stringArray.length - 1];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static String getProtocol(String string) {
        String string2 = STR_FILE;
        try {
            Uri uri;
            if (!StringUtil.isEmpty(string) && (uri = Uri.parse((String)string)).getScheme() != null) {
                string2 = uri.getScheme();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public static boolean isLocal(String string) {
        if (string == null) {
            return false;
        }
        return STR_FILE.equalsIgnoreCase(UrlUtil.getProtocol(string));
    }

    public static String getHostName(String string) {
        String string2 = null;
        try {
            if (StringUtil.isEmpty(string)) {
                return null;
            }
            Uri uri = Uri.parse((String)string);
            string2 = uri.getHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String getSuffix(String string) {
        if (string == null) {
            return null;
        }
        try {
            Uri uri = Uri.parse((String)string.toLowerCase(Locale.US));
            String string2 = uri.getPath();
            int n2 = string2.lastIndexOf(".");
            if (n2 != -1) {
                return string2.substring(n2 + 1).toLowerCase(Locale.US);
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String getUrlParamsValue(String string, String string2) {
        if (StringUtil.isEmpty(string) || StringUtil.isEmpty(string2)) {
            return null;
        }
        String string3 = null;
        String string4 = "&" + string2 + "=";
        try {
            int n2 = string.indexOf(string4);
            if (n2 >= 0) {
                String string5 = string.substring(n2 += string4.length());
                if (StringUtil.isEmpty(string5)) {
                    return null;
                }
                int n3 = string5.indexOf("&");
                if (n3 >= 0) {
                    return string5.substring(0, n3);
                }
                return string5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    public static boolean existParams(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        try {
            if (string.indexOf("?") > 0) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static String urlEncode(String string) {
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        try {
            return URLEncoder.encode(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }
}

