/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.recoder;

import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.hunantv.media.player.MgtvMediaPlayer;
import com.hunantv.media.player.e.a;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.utils.ExTicker;
import com.hunantv.media.utils.BitmapUtil;
import com.hunantv.media.utils.FileUtil;
import java.io.File;
import java.lang.ref.WeakReference;

public class GifRecorder {
    private static final String TAG = "[GifRecorder]";
    private static final int MAX_SNAPSHOT_ERROR = 10;
    private static final int DEFAULT_WIDTH = -1;
    private static final int DEFAULT_HEIGHT = -1;
    public static final int ERR_RESON_BASE = 100;
    public static final int ERR_REASON_NOT_SUPPORTED = 101;
    public static final int ERR_REASON_ILLEGAL_STATUS = 103;
    public static final int ERR_REASON_ILLEGAL_ARGUMENT = 105;
    public static final int ERR_REASON_ILLEGAL_FRAMES_DIR = 109;
    public static final int ERR_RESON_RECORD_BASE = 200;
    public static final int ERR_REASON_RECORD_FRAMES_ERROR = 201;
    public static final int ERR_RESON_MAKE_GIF_BASE = 300;
    public static final int ERR_RESON_NO_FRAMES_MAKE_GIF = 301;
    public static final int ERR_RESON_MAKE_GIF_ERROR = 302;
    private static final int INTERRUPT_INNER_REASON = 100;
    public static final int INTERRUPT_REASON_ERROR = 101;
    public static final int INTERRUPT_REASON_COMPLETE = 102;
    public static final int INTERRUPT_REASON_RESET = 103;
    public static final int INTERRUPT_REASON_RECORD_FRAMES_TOO_MUCH = 105;
    public static final int MAX_FRAME_WIDTH = 848;
    private static final String FRAMES_SUFFIX = ".jpeg";
    private MgtvMediaPlayer mPlayer;
    private ExTicker mTicker;
    private HandlerThread mProcessThread;
    private Configuration mConfiguration;
    private int mIndex = 0;
    private int mFramesErrorCounter = 0;
    private int mMaxFramesError = 10;
    private Callback mCallback;
    private volatile Status mStatus = Status.IDLE;
    private String mTempFrameDir = null;
    private WeakHandler mAsyncHandler;
    private boolean mIsMakingGif;
    private ExTicker.onTickListener mOnTickListener = new ExTicker.onTickListener(){

        @Override
        public void onTick(int n2) {
            if (GifRecorder.this.mStatus != Status.START) {
                return;
            }
            int n3 = ((GifRecorder)GifRecorder.this).mConfiguration.maxDuration * ((GifRecorder)GifRecorder.this).mConfiguration.fps;
            if (GifRecorder.this.mIndex > n3) {
                GifRecorder.this.interrupt(105, 0, "interrupt beyond maxFrames:" + n3);
                return;
            }
            String string = GifRecorder.this.mTempFrameDir + GifRecorder.this.mIndex + GifRecorder.FRAMES_SUFFIX;
            Bitmap bitmap = GifRecorder.this.mPlayer.getSnapshot(((GifRecorder)GifRecorder.this).mConfiguration.framesWidth, ((GifRecorder)GifRecorder.this).mConfiguration.framesHeight);
            if (BitmapUtil.saveJpeg(bitmap, string)) {
                GifRecorder.this.mIndex++;
                GifRecorder.this.mFramesErrorCounter = 0;
            } else {
                GifRecorder.this.mFramesErrorCounter++;
            }
            if (bitmap != null && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
            if (GifRecorder.this.mFramesErrorCounter >= GifRecorder.this.mMaxFramesError) {
                GifRecorder.this.callbackError(201, 0, "framesErrorCounter:" + GifRecorder.this.mFramesErrorCounter);
                return;
            }
        }
    };

    public void bindMediaPlayer(MgtvMediaPlayer mgtvMediaPlayer) {
        this.mPlayer = mgtvMediaPlayer;
    }

    public boolean start(Configuration configuration) {
        DebugLog.i(TAG, "try start snapshot");
        if (!this.isSupported()) {
            this.callbackError(101);
            return false;
        }
        this.reset();
        if (this.mStatus != Status.IDLE) {
            this.callbackError(103);
            return false;
        }
        if (configuration == null || configuration.saveDir == null || "".equals(configuration.saveDir.trim())) {
            this.callbackError(105, 0, configuration == null ? "config == null" : "config.saveDir:" + configuration.saveDir);
            return false;
        }
        try {
            this.stopRecorder();
            if (this.mPlayer.isPlaying()) {
                this.mConfiguration = configuration;
                if (this.mConfiguration.framesWidth == -1) {
                    this.mConfiguration.framesWidth = this.mPlayer.getVideoWidth();
                }
                if (this.mConfiguration.framesHeight == -1) {
                    this.mConfiguration.framesHeight = this.mPlayer.getVideoHeight();
                }
                if (this.mConfiguration.framesWidth > 848) {
                    this.mConfiguration.framesHeight = this.mConfiguration.framesHeight * 848 / this.mConfiguration.framesWidth;
                    this.mConfiguration.framesWidth = 848;
                }
                DebugLog.i(TAG, "start record. framesWidth:" + this.mConfiguration.framesWidth + ", framesHeight:" + this.mConfiguration.framesHeight);
                if (this.mConfiguration.maxFramesError > 0) {
                    this.mMaxFramesError = this.mConfiguration.maxFramesError;
                }
                if (this.mConfiguration.saveFramsDir != null) {
                    this.mTempFrameDir = this.mConfiguration.saveFramsDir;
                } else {
                    this.mConfiguration.saveFramsDir = this.mTempFrameDir = this.mConfiguration.saveDir + "/temp_frame/";
                }
                if (!FileUtil.remkdirs(this.mTempFrameDir)) {
                    this.callbackError(109, 0, this.mTempFrameDir + " can't remkdirs");
                    return false;
                }
                this.mIndex = 0;
                if (this.mProcessThread == null) {
                    this.mProcessThread = new HandlerThread("mgtvmp_jGif1Pro");
                    this.mProcessThread.start();
                }
                if (this.mAsyncHandler == null) {
                    this.mAsyncHandler = new WeakHandler(this.mProcessThread.getLooper(), this);
                }
                DebugLog.i(TAG, "start record. Configuration:" + this.mConfiguration);
                this.mTicker = new ExTicker(this.mProcessThread.getLooper(), 1000 / this.mConfiguration.fps);
                this.mTicker.setCallback(this.mOnTickListener);
                this.mTicker.start();
                this.mStatus = Status.START;
                if (this.mCallback != null) {
                    this.mCallback.onStart();
                }
                return true;
            }
        }
        catch (Exception exception) {
            this.callbackError(100, 0, exception == null ? "" : exception.getMessage());
            return false;
        }
        this.callbackError(100, 1, "");
        this.stopRecorder();
        return false;
    }

    public void pause() {
        if (this.mStatus != Status.START) {
            return;
        }
        DebugLog.i(TAG, "pause record");
        if (this.mTicker != null) {
            this.mTicker.pause();
        }
        this.mStatus = Status.PAUSE;
        if (this.mCallback != null) {
            this.mCallback.onPause();
        }
    }

    public void resume() {
        if (this.mStatus != Status.PAUSE) {
            return;
        }
        DebugLog.i(TAG, "resume record");
        if (this.mTicker != null) {
            this.mTicker.resume();
        }
        this.mStatus = Status.START;
        if (this.mCallback != null) {
            this.mCallback.onResume();
        }
    }

    public void end() {
        if (this.mStatus == Status.IDLE) {
            return;
        }
        this.stopRecorder();
        this.mStatus = Status.STOP;
        if (this.mCallback != null) {
            this.mCallback.onEndRecord();
        }
        if (this.mConfiguration != null && this.mConfiguration.autoResult) {
            this.makeGifAsync();
        }
    }

    public String makeGif() {
        if (this.mStatus != Status.STOP && this.mStatus != Status.INTERRUPT || this.mIsMakingGif) {
            return null;
        }
        try {
            DebugLog.i(TAG, "start makeGif");
            this.mIsMakingGif = true;
            if (FileUtil.listCount(new File(this.mTempFrameDir), FRAMES_SUFFIX) <= 0) {
                this.callbackError(301, 0, "no frames to make gif");
                return null;
            }
            String string = this.mTempFrameDir + "#d" + FRAMES_SUFFIX;
            String string2 = this.mConfiguration.saveDir + "/test.gif";
            FileUtil.deleteFile(new File(string2));
            int n2 = this.mConfiguration.fps;
            if (this.mCallback != null) {
                this.mCallback.onMakingGif();
            }
            int n3 = 0;
            n3 = this.mConfiguration.width <= 0 || this.mConfiguration.height <= 0 ? a.a(string, string2, n2) : a.a(string, string2, this.mConfiguration.width + "x" + this.mConfiguration.height, n2);
            this.mIsMakingGif = false;
            DebugLog.i(TAG, "makeGif result:" + n3 + ",gifPath:" + string2);
            if (n3 == 0) {
                if (this.mCallback != null) {
                    this.mCallback.onResultGif(string2);
                }
                return string2;
            }
            this.callbackError(302, n3, "make gif failed");
            return null;
        }
        catch (Exception exception) {
            this.callbackError(300, 0, exception == null ? "make gif exception" : exception.getMessage());
            return null;
        }
    }

    public void makeGifAsync() {
        if (this.mStatus != Status.STOP && this.mStatus != Status.INTERRUPT || this.mIsMakingGif) {
            return;
        }
        if (this.mAsyncHandler != null) {
            this.mAsyncHandler.sendEmptyMessage(256);
        }
    }

    private void stopRecorder() {
        if (this.mTicker != null) {
            DebugLog.i(TAG, "stop record.frame_num:" + this.mIndex);
            this.mTicker.stop();
            this.mTicker = null;
        }
    }

    public void interrupt(int n2) {
        this.interrupt(n2, 0, null);
    }

    public void interrupt(int n2, int n3, String string) {
        if (this.mStatus == Status.IDLE || this.mStatus == Status.STOP || this.mStatus == Status.ERROR || this.mStatus == Status.INTERRUPT) {
            return;
        }
        DebugLog.i(TAG, "interrupt by reason:" + n2);
        this.stopRecorder();
        this.mStatus = Status.INTERRUPT;
        if (this.mCallback != null) {
            this.mCallback.onInterrupted(n2, n3, string);
        }
    }

    public void reset() {
        if (this.mStatus == Status.IDLE) {
            return;
        }
        this.interrupt(103);
        FileUtil.deleteDir(this.mTempFrameDir);
        if (this.mAsyncHandler != null) {
            this.mAsyncHandler.removeMessages(256);
            this.mAsyncHandler = null;
        }
        if (this.mProcessThread != null) {
            this.mProcessThread.quit();
            this.mProcessThread = null;
        }
        this.mTempFrameDir = null;
        this.mIndex = 0;
        this.mFramesErrorCounter = 0;
        this.mStatus = Status.IDLE;
    }

    public void release() {
    }

    public boolean isSupported() {
        if (this.mPlayer != null) {
            if (this.mPlayer.isHardware()) {
                if (Build.VERSION.SDK_INT > 22) {
                    return this.mPlayer.isSupportedSnapshot();
                }
            } else {
                return this.mPlayer.isSupportedSnapshot();
            }
        }
        return false;
    }

    public boolean isRecording() {
        return this.mStatus == Status.START || this.mStatus == Status.PAUSE;
    }

    public boolean isPaused() {
        return this.mStatus == Status.PAUSE;
    }

    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public Status getStatus() {
        return this.mStatus;
    }

    private void callbackError(int n2) {
        this.callbackError(n2, 0, "");
    }

    private void callbackError(int n2, int n3, String string) {
        string = string + ",status:" + this.getStatus().name();
        DebugLog.e(TAG, "callbackError reason:" + n2 + ",extra:" + n3 + ",msg:" + string);
        this.stopRecorder();
        this.mStatus = Status.ERROR;
        this.reset();
        if (this.mCallback != null) {
            this.mCallback.onError(n2, n3, string);
        }
    }

    public static interface Callback {
        public void onStart();

        public void onPause();

        public void onResume();

        public void onEndRecord();

        public void onInterrupted(int var1, int var2, String var3);

        public void onMakingGif();

        public void onResultGif(String var1);

        public void onError(int var1, int var2, String var3);
    }

    private static class WeakHandler
    extends Handler {
        public static final int MSG_ASYNC_RESULT_GIF = 256;
        private WeakReference<GifRecorder> mWeakGifRecorder;

        public WeakHandler(Looper looper, GifRecorder gifRecorder) {
            super(looper);
            this.mWeakGifRecorder = new WeakReference<GifRecorder>(gifRecorder);
        }

        public void handleMessage(Message message) {
            GifRecorder gifRecorder = (GifRecorder)this.mWeakGifRecorder.get();
            if (gifRecorder == null) {
                return;
            }
            switch (message.what) {
                case 256: {
                    String string = gifRecorder.makeGif();
                }
            }
        }
    }

    public static class Configuration {
        public int width = -1;
        public int height = -1;
        public int framesWidth = -1;
        public int framesHeight = -1;
        public int fps = 3;
        public int loopCount = 0;
        public int maxDuration = 60;
        public String saveDir;
        public String saveFramsDir;
        public boolean autoResult;
        public int maxFramesError;

        public Configuration setWidth(int n2) {
            this.width = n2;
            return this;
        }

        public Configuration setHeight(int n2) {
            this.height = n2;
            return this;
        }

        public Configuration setFps(int n2) {
            this.fps = n2;
            return this;
        }

        public Configuration setLoopCount(int n2) {
            this.loopCount = n2;
            return this;
        }

        public Configuration setSaveDir(String string) {
            this.saveDir = string;
            return this;
        }

        public Configuration setAutoResult(boolean bl) {
            this.autoResult = bl;
            return this;
        }

        public Configuration setMaxFramesError(int n2) {
            this.maxFramesError = n2;
            return this;
        }

        public Configuration setMaxDuration(int n2) {
            this.maxDuration = n2;
            return this;
        }

        public String toString() {
            return "[width-" + this.width + ",height-" + this.height + ",fps-" + this.fps + ",autoResult-" + this.autoResult + ",saveDir-" + this.saveDir + ",maxFramesError-" + this.maxFramesError + ",maxDuration-" + this.maxDuration + "]";
        }
    }

    public static enum Status {
        IDLE,
        START,
        PAUSE,
        STOP,
        INTERRUPT,
        ERROR;

    }
}

