/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.report;

import android.content.Context;
import com.hunantv.media.report.a;
import java.util.HashMap;
import java.util.Map;

public class ReportParams {
    private DRM drm;
    private KeyInfo keyInfo = new KeyInfo();
    public static final int MAX_LEAVE_VALID_TIME = 540;
    private String mVideoSession;
    private VideoType mVideoType = VideoType.NONE;
    private int mCaseType;
    private ProxyType mProxyType = ProxyType.NO_PROXY;
    private int mRetryIndex;
    private String vid = "";
    private String cdnip = "n";
    private String local_md5;
    private int lastErrorCodeExtra;
    private long mRouterTimeStamp;
    private End end = new End();
    private String mDownloadSDKVersion;
    private int mHasAd = -1;
    private int svtp = 0;
    private int renvtp;
    public static final int SPTP_NORMAL = 0;
    public static final int SPTP_M3U8_DATA = 1;
    private int sptp;
    private long mLeaveTimeS;
    private int mRenderType;
    private int mEnhanceQualityType;
    private int mAddrInfoInt;
    private int p2ps;
    private String def = "";
    private String svds;
    private String encinfo;
    private String flowt;
    private Map<String, String> exCommonFields;
    private Map<String, String> exServiceFields;
    private String bsid = "";
    private String pay = "";
    private String fpid = "";
    private String ap = "";
    private String fpn = "";
    private String url = "";
    private String plid = "";
    private String fpa = "";
    private String cid = "";
    private String istry = "";
    private String isad = "";
    private String cf = "";
    private String switcher = "";
    private String submit = "";
    private String bdid = "";
    private String cpn = "";
    private String datano;
    private String refmdid;
    private String acp;
    private String abt;
    private String fileHash;
    private String videoFileHash;
    private String remote_md5;

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public ReportParams() {
    }

    public ReportParams(ReportParams reportParams) {
        this.deepCopy(reportParams);
    }

    public ReportParams deepCopy(ReportParams reportParams) {
        if (reportParams != null) {
            if (reportParams.drm != null) {
                this.drm = new DRM(reportParams.drm);
            }
            this.keyInfo = new KeyInfo(reportParams.keyInfo);
            this.mVideoSession = reportParams.mVideoSession;
            this.mVideoType = reportParams.mVideoType;
            this.mCaseType = reportParams.mCaseType;
            this.mProxyType = reportParams.mProxyType;
            this.mRetryIndex = reportParams.mRetryIndex;
            this.vid = reportParams.vid;
            this.cdnip = reportParams.cdnip;
            this.local_md5 = reportParams.local_md5;
            this.lastErrorCodeExtra = reportParams.lastErrorCodeExtra;
            this.mRouterTimeStamp = reportParams.mRouterTimeStamp;
            this.end = new End(reportParams.end);
            this.mDownloadSDKVersion = reportParams.mDownloadSDKVersion;
            this.mHasAd = reportParams.mHasAd;
            this.mLeaveTimeS = reportParams.mLeaveTimeS;
            this.mRenderType = reportParams.mRenderType;
            this.mEnhanceQualityType = reportParams.mEnhanceQualityType;
            this.mAddrInfoInt = reportParams.mAddrInfoInt;
            this.p2ps = reportParams.p2ps;
            this.def = reportParams.def;
            if (reportParams.exCommonFields != null) {
                this.exCommonFields = new HashMap<String, String>(reportParams.exCommonFields);
            }
            if (reportParams.exServiceFields != null) {
                this.exServiceFields = new HashMap<String, String>(reportParams.exServiceFields);
            }
            this.bsid = reportParams.bsid;
            this.pay = reportParams.pay;
            this.fpid = reportParams.fpid;
            this.ap = reportParams.ap;
            this.fpn = reportParams.fpn;
            this.url = reportParams.url;
            this.plid = reportParams.plid;
            this.fpa = reportParams.fpa;
            this.cid = reportParams.cid;
            this.istry = reportParams.istry;
            this.isad = reportParams.isad;
            this.cf = reportParams.cf;
            this.switcher = reportParams.switcher;
            this.submit = reportParams.submit;
            this.bdid = reportParams.bdid;
            this.cpn = reportParams.cpn;
            this.datano = reportParams.datano;
            this.refmdid = reportParams.refmdid;
            this.acp = reportParams.acp;
            this.abt = reportParams.abt;
            this.fileHash = reportParams.fileHash;
            this.remote_md5 = reportParams.remote_md5;
            this.videoFileHash = reportParams.videoFileHash;
        }
        return this;
    }

    public String toString() {
        return "ReportParams{mVideoSession='" + this.mVideoSession + '\'' + ", mVideoType=" + (Object)((Object)this.mVideoType) + ", vid='" + this.vid + '\'' + ", cdnip='" + this.cdnip + '\'' + ", p2ps=" + this.p2ps + ", def='" + this.def + '\'' + '}';
    }

    public String getVideoSession() {
        return this.mVideoSession;
    }

    public ReportParams setVideoSession(String string) {
        this.mVideoSession = string;
        return this;
    }

    public VideoType getVideoType() {
        return this.mVideoType;
    }

    public ReportParams setVideoType(VideoType videoType) {
        this.mVideoType = videoType;
        return this;
    }

    public int getCaseType() {
        return this.mCaseType;
    }

    public ReportParams setCaseType(int n2) {
        this.mCaseType = n2;
        return this;
    }

    public ProxyType getProxyType() {
        return this.mProxyType;
    }

    public ReportParams setProxyType(ProxyType proxyType) {
        this.mProxyType = proxyType;
        return this;
    }

    public int getRetryIndex() {
        return this.mRetryIndex;
    }

    public ReportParams setRetryIndex(int n2) {
        this.mRetryIndex = n2;
        return this;
    }

    public String getVid() {
        return this.vid;
    }

    public ReportParams setVid(String string) {
        this.vid = string;
        return this;
    }

    public String getCdnip() {
        return this.cdnip;
    }

    public ReportParams setCdnip(String string) {
        this.cdnip = string;
        return this;
    }

    public static String createSessionID(Context context) {
        return a.a(context);
    }

    public String getLocalMd5() {
        return this.local_md5;
    }

    public ReportParams setLocalMd5(String string) {
        this.local_md5 = string;
        return this;
    }

    public End getEnd() {
        return this.end;
    }

    public Map<String, String> getExCommonFields() {
        return this.exCommonFields;
    }

    public ReportParams setExCommonFields(Map<String, String> map) {
        this.exCommonFields = map;
        return this;
    }

    public Map<String, String> getExServiceFields() {
        return this.exServiceFields;
    }

    public ReportParams setExServiceFields(Map<String, String> map) {
        this.exServiceFields = map;
        return this;
    }

    public long getLeaveTimeS() {
        return this.mLeaveTimeS;
    }

    public ReportParams setLeaveTimeS(long l2) {
        this.mLeaveTimeS = l2;
        return this;
    }

    public int getLastErrorCodeExtra() {
        return this.lastErrorCodeExtra;
    }

    public ReportParams setLastErrorCodeExtra(int n2) {
        this.lastErrorCodeExtra = n2;
        return this;
    }

    public long getRouterTimeStamp() {
        return this.mRouterTimeStamp;
    }

    public ReportParams setRouterTimeStamp(long l2) {
        this.mRouterTimeStamp = l2;
        return this;
    }

    public String getDownloadSDKVersion() {
        return this.mDownloadSDKVersion;
    }

    public ReportParams setDownloadSDKVersion(String string) {
        this.mDownloadSDKVersion = string;
        return this;
    }

    public int getHasAd() {
        return this.mHasAd;
    }

    public ReportParams setHasAd(int n2) {
        this.mHasAd = n2;
        return this;
    }

    public int getRenvtp() {
        return this.renvtp;
    }

    public ReportParams setRenvtp(int n2) {
        this.renvtp = n2;
        return this;
    }

    public int getSptp() {
        return this.sptp;
    }

    public ReportParams setSptp(int n2) {
        this.sptp = n2;
        return this;
    }

    public int getRenderType() {
        return this.mRenderType;
    }

    public ReportParams setRenderType(int n2) {
        this.mRenderType = n2;
        return this;
    }

    public int getEnhanceQualityType() {
        return this.mEnhanceQualityType;
    }

    public ReportParams setEnhanceQualityType(int n2) {
        this.mEnhanceQualityType = n2;
        return this;
    }

    public static String getVideoTypeName(VideoType videoType) {
        switch (videoType) {
            case VOD: {
                return "VOD";
            }
            case LIVE: {
                return "LIVE";
            }
            case LOCAL: {
                return "LOCAL";
            }
            case AD_PRE: {
                return "AD_PRE";
            }
            case AD_MID: {
                return "AD_MID";
            }
            case SHORT: {
                return "SHORT";
            }
            case HOME: {
                return "HOME";
            }
            case FILM: {
                return "FILM";
            }
            case AD_BOOT: {
                return "AD_BOOT";
            }
            case GAME: {
                return "GAME";
            }
            case HOME_PREVIEW: {
                return "HOME_PREVIEW";
            }
            case IMMERSIVE: {
                return "IMMERSIVE";
            }
            case VOD_FEED: {
                return "VOD_FEED";
            }
            case FANTUAN: {
                return "FANTUAN";
            }
            case VIP_RECOMMEND: {
                return "VIP_RECOMMEND";
            }
            case INTERACTIVE: {
                return "INTERACTIVE";
            }
            case HOME_PREVIEW_FEED: {
                return "HOME_PREVIEW_FEED";
            }
            case HOME_PREVIEW_DY_FEED: {
                return "HOME_PREVIEW_DY_FEED";
            }
            case SOCIAL_PLAY: {
                return "SOCIAL_PLAY";
            }
            case STAR_ROOM_LIVE: {
                return "STAR_ROOM_LIVE";
            }
            case GIF_PREVIEW_VIDEO: {
                return "GIF_PREVIEW_VIDEO";
            }
            case GIF_PREVIEW_IMAGE: {
                return "GIF_PREVIEW_IMAGE";
            }
            case GIF_CREATOR: {
                return "GIF_CREATOR";
            }
            case AUDIO: {
                return "AUDIO";
            }
            case VOD_AUDIO: {
                return "VOD_AUDIO";
            }
            case SOCIAL_AUDIO_CHAT: {
                return "SOCIAL_AUDIO_CHAT";
            }
            case ALPHA_PLAY: {
                return "ALPHA_PLAY";
            }
            case MINI_FILM: {
                return "MINI_FILM";
            }
            case SECRET_SPACE: {
                return "SECRET_SPACE";
            }
        }
        return "NONE";
    }

    public int getAddrInfoInt() {
        return this.mAddrInfoInt;
    }

    public ReportParams setAddrInfoInt(int n2) {
        this.mAddrInfoInt = n2;
        return this;
    }

    public int getP2ps() {
        return this.p2ps;
    }

    public ReportParams setP2ps(int n2) {
        this.p2ps = n2;
        return this;
    }

    public String getBsid() {
        return this.bsid;
    }

    public ReportParams setBsid(String string) {
        this.bsid = string;
        return this;
    }

    public String getPay() {
        return this.pay;
    }

    public ReportParams setPay(String string) {
        this.pay = string;
        return this;
    }

    public String getFpid() {
        return this.fpid;
    }

    public ReportParams setFpid(String string) {
        this.fpid = string;
        return this;
    }

    public String getAp() {
        return this.ap;
    }

    public ReportParams setAp(String string) {
        this.ap = string;
        return this;
    }

    public String getDef() {
        return this.def;
    }

    public ReportParams setDef(String string) {
        this.def = string;
        return this;
    }

    public String getFpn() {
        return this.fpn;
    }

    public ReportParams setFpn(String string) {
        this.fpn = string;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public ReportParams setUrl(String string) {
        this.url = string;
        return this;
    }

    public ReportParams setFileHash(String string) {
        this.fileHash = string;
        return this;
    }

    public String getVideoFileHash() {
        return this.videoFileHash;
    }

    public ReportParams setVideoFileHash(String string) {
        this.videoFileHash = string;
        return this;
    }

    public String getPlid() {
        return this.plid;
    }

    public ReportParams setPlid(String string) {
        this.plid = string;
        return this;
    }

    public String getFpa() {
        return this.fpa;
    }

    public ReportParams setFpa(String string) {
        this.fpa = string;
        return this;
    }

    public String getCid() {
        return this.cid;
    }

    public ReportParams setCid(String string) {
        this.cid = string;
        return this;
    }

    public String getIstry() {
        return this.istry;
    }

    public ReportParams setIstry(String string) {
        this.istry = string;
        return this;
    }

    public String getIsad() {
        return this.isad;
    }

    public ReportParams setIsad(String string) {
        this.isad = string;
        return this;
    }

    public String getCf() {
        return this.cf;
    }

    public ReportParams setCf(String string) {
        this.cf = string;
        return this;
    }

    public String getSwitcher() {
        return this.switcher;
    }

    public ReportParams setSwitcher(String string) {
        this.switcher = string;
        return this;
    }

    public String getSubmit() {
        return this.submit;
    }

    public ReportParams setSubmit(String string) {
        this.submit = string;
        return this;
    }

    public String getBdid() {
        return this.bdid;
    }

    public ReportParams setBdid(String string) {
        this.bdid = string;
        return this;
    }

    public String getCpn() {
        return this.cpn;
    }

    public ReportParams setCpn(String string) {
        this.cpn = string;
        return this;
    }

    public String getDatano() {
        return this.datano;
    }

    public ReportParams setDatano(String string) {
        this.datano = string;
        return this;
    }

    public String getRefmdid() {
        return this.refmdid;
    }

    public ReportParams setRefmdid(String string) {
        this.refmdid = string;
        return this;
    }

    public String getAcp() {
        return this.acp;
    }

    public ReportParams setAcp(String string) {
        this.acp = string;
        return this;
    }

    public String getAbt() {
        return this.abt;
    }

    public ReportParams setAbt(String string) {
        this.abt = string;
        return this;
    }

    public String getRemoteMd5() {
        return this.remote_md5;
    }

    public ReportParams setRemoteMd5(String string) {
        this.remote_md5 = string;
        return this;
    }

    public DRM getDrm() {
        return this.drm;
    }

    public ReportParams setDrm(DRM dRM) {
        this.drm = dRM;
        return this;
    }

    public int getSvtp() {
        return this.svtp;
    }

    public ReportParams setSvtp(SubVideoType subVideoType) {
        this.svtp = subVideoType.value();
        return this;
    }

    public boolean isP2p() {
        return this.p2ps == 2 || this.p2ps == 1 || this.mProxyType == ProxyType.ONLY_P2P || this.mProxyType == ProxyType.P2P_DRM;
    }

    public String getSvds() {
        return this.svds;
    }

    public ReportParams setSvds(String string) {
        this.svds = string;
        return this;
    }

    public String getEncinfo() {
        return this.encinfo;
    }

    public ReportParams setEncinfo(String string) {
        this.encinfo = string;
        return this;
    }

    public String getFlowt() {
        return this.flowt;
    }

    public ReportParams setFlowt(String string) {
        this.flowt = string;
        return this;
    }

    public static String getVideoTypeStr(VideoType videoType) {
        switch (videoType) {
            case VOD: {
                return "1";
            }
            case LIVE: {
                return "2";
            }
            case LOCAL: {
                return "3";
            }
            case AD_PRE: {
                return "4";
            }
            case AD_MID: {
                return "5";
            }
            case SHORT: {
                return "7";
            }
            case HOME: {
                return "8";
            }
            case FILM: {
                return "9";
            }
            case AD_BOOT: {
                return "10";
            }
            case GAME: {
                return "11";
            }
            case HOME_PREVIEW: {
                return "12";
            }
            case IMMERSIVE: {
                return "13";
            }
            case VOD_FEED: {
                return "14";
            }
            case FANTUAN: {
                return "15";
            }
            case VIP_RECOMMEND: {
                return "16";
            }
            case INTERACTIVE: {
                return "17";
            }
            case HOME_PREVIEW_FEED: {
                return "18";
            }
            case HOME_PREVIEW_DY_FEED: {
                return "19";
            }
            case SOCIAL_PLAY: {
                return "20";
            }
            case STAR_ROOM_LIVE: {
                return "21";
            }
            case MINI_FILM: {
                return "22";
            }
            case SECRET_SPACE: {
                return "23";
            }
            case GIF_PREVIEW_VIDEO: {
                return "30";
            }
            case GIF_PREVIEW_IMAGE: {
                return "31";
            }
            case GIF_CREATOR: {
                return "32";
            }
            case ALPHA_PLAY: {
                return "33";
            }
            case AUDIO: {
                return "50";
            }
            case VOD_AUDIO: {
                return "51";
            }
            case SOCIAL_AUDIO_CHAT: {
                return "52";
            }
        }
        return "0";
    }

    public static enum SubVideoType {
        NONE(0),
        VOD_NONE(10),
        VOD_VIP_PROTECT(11);

        private int mValue = 0;

        private SubVideoType(int n3) {
            this.mValue = n3;
        }

        public int value() {
            return this.mValue;
        }
    }

    public static enum ProxyType {
        NO_PROXY,
        ONLY_P2P,
        ONLY_UNICOM,
        NOPROXY_DRM,
        P2P_DRM,
        UNICOM_DRM,
        LOCAL_PROXY;

    }

    public static enum VideoType {
        NONE,
        VOD,
        LIVE,
        LOCAL,
        AD_PRE,
        AD_MID,
        SHORT,
        HOME,
        FILM,
        AD_BOOT,
        GAME,
        HOME_PREVIEW,
        IMMERSIVE,
        VOD_FEED,
        FANTUAN,
        VIP_RECOMMEND,
        INTERACTIVE,
        HOME_PREVIEW_FEED,
        HOME_PREVIEW_DY_FEED,
        SOCIAL_PLAY,
        STAR_ROOM_LIVE,
        GIF_PREVIEW_VIDEO,
        GIF_PREVIEW_IMAGE,
        GIF_CREATOR,
        AUDIO,
        VOD_AUDIO,
        SOCIAL_AUDIO_CHAT,
        ALPHA_PLAY,
        MINI_FILM,
        SECRET_SPACE;

    }

    public static class End {
        private Target target = Target.CHANGE_SOURCE;
        private boolean innerRetry = false;

        public End() {
        }

        public End(End end) {
            this.target = end.target;
            this.innerRetry = end.innerRetry;
        }

        public Target getTarget() {
            return this.target;
        }

        public End setTarget(Target target) {
            this.target = target;
            return this;
        }

        public boolean isInnerRetry() {
            return this.innerRetry;
        }

        public End setInnerRetry(boolean bl) {
            this.innerRetry = bl;
            return this;
        }

        public static enum Target {
            CHANGE_DEFINITION,
            CHANGE_SOURCE;

        }
    }

    public static class KeyInfo {
        public boolean keyInfoExist;
        public boolean keyInfoSet;
        public int keyInfoSetLayer;
        public int keyInfoRet;
        public String reqHttpCode = "n";
        public String reqErrMsg = "n";
        public String keyinfoVid = "n";
        public String keyinfoUrl = "n";
        public String keyinfoDef = "n";
        public String keyinfoFileName = "n";

        public KeyInfo() {
        }

        public KeyInfo(KeyInfo keyInfo) {
            this.keyInfoExist = keyInfo.keyInfoExist;
            this.keyInfoSet = keyInfo.keyInfoSet;
            this.keyInfoSetLayer = keyInfo.keyInfoSetLayer;
            this.keyInfoRet = keyInfo.keyInfoRet;
            this.reqHttpCode = keyInfo.reqHttpCode;
            this.reqErrMsg = keyInfo.reqErrMsg;
            this.keyinfoVid = keyInfo.keyinfoVid;
            this.keyinfoUrl = keyInfo.keyinfoUrl;
            this.keyinfoDef = keyInfo.keyinfoDef;
            this.keyinfoFileName = keyInfo.keyinfoFileName;
        }

        public void reset() {
            this.keyInfoExist = false;
            this.keyInfoSet = false;
            this.keyInfoSetLayer = 0;
            this.keyInfoRet = 0;
            this.reqHttpCode = "n";
            this.reqErrMsg = "n";
            this.keyinfoVid = "n";
            this.keyinfoUrl = "n";
            this.keyinfoDef = "n";
            this.keyinfoFileName = "n";
        }
    }

    public static class DRM {
        public String lic;
        public String firm;
        public String ec;

        public DRM() {
        }

        public DRM(DRM dRM) {
            this.lic = dRM.lic;
            this.firm = dRM.firm;
            this.ec = dRM.ec;
        }

        public DRM setLic(String string) {
            this.lic = string;
            return this;
        }

        public DRM setFirm(String string) {
            this.firm = string;
            return this;
        }

        public DRM setEc(String string) {
            this.ec = string;
            return this;
        }
    }

    public static class GlobalSet {
        private static String sAppVersionName = null;
        private static String sDownloadSDKVersion;
        private static String sValidPackageNames;
        private static String sChannelId;

        public static String getsValidPackageNames() {
            return sValidPackageNames;
        }

        public static void setsValidPackageNames(String string) {
            sValidPackageNames = string;
        }

        public static String getsChannelId() {
            return sChannelId;
        }

        public static void setsChannelId(String string) {
            sChannelId = string;
        }

        public static String getsAppVersionName() {
            return sAppVersionName;
        }

        public static void setsAppVersionName(String string) {
            sAppVersionName = string;
        }

        public static String getDownloadSDKVersion() {
            return sDownloadSDKVersion;
        }

        public static void setDownloadSDKVersion(String string) {
            sDownloadSDKVersion = string;
        }
    }
}

