/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.source;

import android.content.Context;
import com.hunantv.media.player.loader.ImgoLibLoader;
import com.hunantv.media.player.utils.StringUtil;
import com.hunantv.media.player.utils.ThreadUtil;
import com.hunantv.media.player.utils.UrlUtil;
import com.hunantv.media.source.ImgoCacheLogger;
import com.hunantv.media.source.M3u8CacheTask;
import com.hunantv.media.source.jni.ImgoSourceNative;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

@Deprecated
public class ImgoM3u8Cache {
    private static final String TAG = "ImgoM3u8Cache";
    private static final String USER_AGENT = "ImgoDataSource";
    private static final int NULL = 0;
    private static final int CONNECT_TIMEOUT = 10;
    private static final int REQUEST_TIMEOUT = 30;
    private long mManagerAddress;
    private String mCachePath;
    private ImgoSourceNative.InitParams mInitParams;
    private static final int MAX_RUNNING_SIZE = 1;
    private Queue<M3u8CacheTask> mPrepareTasks = new LinkedList<M3u8CacheTask>();
    private List<M3u8CacheTask> mRunningTasks = new LinkedList<M3u8CacheTask>();
    private TaskCallback mTaskCallback;
    private ImgoSourceNative.Callback mCallback = new ImgoSourceNative.Callback(){

        @Override
        public void onResult(final int n2, final ImgoSourceNative.CbResultParams cbResultParams) {
            if (cbResultParams != null) {
                ImgoCacheLogger.i(ImgoM3u8Cache.TAG, "native_callback result:" + n2 + ",taskid:" + cbResultParams.taskid + ",fullpath:" + cbResultParams.fullpath);
                if (cbResultParams.ts_names != null && cbResultParams.ts_names.length > 0) {
                    for (String string : cbResultParams.ts_names) {
                        ImgoCacheLogger.i(ImgoM3u8Cache.TAG, "native_callback ts_name:" + string);
                    }
                }
            }
            ThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    M3u8CacheTask m3u8CacheTask = null;
                    if (cbResultParams != null) {
                        m3u8CacheTask = this.findTask(ImgoM3u8Cache.this.mRunningTasks, cbResultParams.taskid);
                        ImgoCacheLogger.i(ImgoM3u8Cache.TAG, "onResult findTask " + m3u8CacheTask);
                        if (m3u8CacheTask != null) {
                            ImgoM3u8Cache.this.mRunningTasks.remove(m3u8CacheTask);
                            m3u8CacheTask.setFullPath(cbResultParams.fullpath);
                            m3u8CacheTask.setTsNames(cbResultParams.ts_names);
                            if (n2 == 0) {
                                ImgoCacheLogger.i(ImgoM3u8Cache.TAG, "onResult OK");
                                m3u8CacheTask.setCurrentStatus(M3u8CacheTask.Status.SUCCESS);
                                if (ImgoM3u8Cache.this.mTaskCallback != null) {
                                    ImgoM3u8Cache.this.mTaskCallback.onSuccess(m3u8CacheTask);
                                }
                            } else {
                                ImgoCacheLogger.i(ImgoM3u8Cache.TAG, "onResult FAILED");
                                m3u8CacheTask.setCurrentStatus(M3u8CacheTask.Status.FAILED);
                                if (ImgoM3u8Cache.this.mTaskCallback != null) {
                                    ImgoM3u8Cache.this.mTaskCallback.onFailed(m3u8CacheTask);
                                }
                            }
                        }
                    }
                    ImgoM3u8Cache.this.moveToRunningTasks((M3u8CacheTask)ImgoM3u8Cache.this.mPrepareTasks.poll());
                }
            });
        }

        @Override
        public void onError(ImgoSourceNative.CbErrorParams cbErrorParams) {
        }

        private M3u8CacheTask findTask(List<M3u8CacheTask> list, String string) {
            if (list == null || StringUtil.isEmpty(string)) {
                return null;
            }
            for (M3u8CacheTask m3u8CacheTask : list) {
                if (m3u8CacheTask == null || !string.equals(m3u8CacheTask.mTaskID)) continue;
                return m3u8CacheTask;
            }
            return null;
        }
    };

    public ImgoM3u8Cache(Context context, String string) {
        this(context, string, null);
    }

    private boolean loadLibs(Context context) {
        return false;
    }

    public boolean isLibsLoaded() {
        return ImgoLibLoader.getInstance().isDsLibLoaded() && ImgoLibLoader.getInstance().isCacheLibLoaded();
    }

    public ImgoM3u8Cache(Context context, String string, ImgoSourceNative.InitParams initParams) {
        if (!this.loadLibs(context) || StringUtil.isEmpty(string)) {
            return;
        }
        this.mCachePath = string;
        if (initParams != null) {
            this.mInitParams = initParams;
        } else {
            this.mInitParams = new ImgoSourceNative.InitParams();
            this.mInitParams.useragent = USER_AGENT;
            this.mInitParams.connect_timeout_ms = 10;
            this.mInitParams.request_timeout_ms = 30;
        }
        this.create();
    }

    private void create() {
        this.release();
        ImgoCacheLogger.i(TAG, "create in");
        this.mManagerAddress = ImgoSourceNative.newCacheManager(this.mCachePath, this.mInitParams);
        ImgoSourceNative.subscribeCallback(this.mCallback);
        ImgoCacheLogger.i(TAG, "create out");
    }

    public void setTaskCallback(TaskCallback taskCallback) {
        this.mTaskCallback = taskCallback;
    }

    public void cache(M3u8CacheTask m3u8CacheTask) {
        ImgoCacheLogger.d(TAG, "cache in");
        if (this.mManagerAddress == 0L || m3u8CacheTask == null || m3u8CacheTask.getVid() == null || m3u8CacheTask.getUrl() == null) {
            ImgoCacheLogger.i(TAG, "cache FAILED invalid task");
            return;
        }
        if (!UrlUtil.isM3u8(m3u8CacheTask.getUrl())) {
            ImgoCacheLogger.i(TAG, "cache FAILED cause by not m3u8 ");
            m3u8CacheTask.setCurrentStatus(M3u8CacheTask.Status.FAILED);
            if (this.mTaskCallback != null) {
                this.mTaskCallback.onFailed(m3u8CacheTask);
            }
            return;
        }
        ImgoCacheLogger.i(TAG, "cache in vid:" + m3u8CacheTask.getVid() + ",streamid:" + m3u8CacheTask.getStreamId());
        if (this.mRunningTasks.size() < 1) {
            this.moveToRunningTasks(m3u8CacheTask);
        } else {
            ImgoCacheLogger.i(TAG, "add to mPrepareTasks");
            this.mPrepareTasks.add(m3u8CacheTask);
        }
        ImgoCacheLogger.i(TAG, "cache out");
    }

    private void moveToRunningTasks(M3u8CacheTask m3u8CacheTask) {
        if (m3u8CacheTask == null) {
            return;
        }
        ImgoCacheLogger.i(TAG, "moveToRunningTasks vid:" + m3u8CacheTask.getVid() + ",StreamId" + m3u8CacheTask.getStreamId());
        ImgoSourceNative.startCache(this.mManagerAddress, m3u8CacheTask.getUrl(), m3u8CacheTask.getVid(), m3u8CacheTask.getStreamId(), 0, m3u8CacheTask.getTsNum(), m3u8CacheTask.isWriteM3u8() ? 1 : 0);
        this.mRunningTasks.add(m3u8CacheTask);
        if (this.mTaskCallback != null) {
            this.mTaskCallback.onStart(m3u8CacheTask);
        }
    }

    public void cancel(M3u8CacheTask m3u8CacheTask) {
        if (this.mManagerAddress == 0L || m3u8CacheTask == null) {
            return;
        }
        ImgoCacheLogger.i(TAG, "cancel in vid:" + m3u8CacheTask.getVid() + ",streamid:" + m3u8CacheTask.getStreamId());
        if (this.mRunningTasks.contains(m3u8CacheTask)) {
            ImgoCacheLogger.i(TAG, "cancel from mRunningTasks");
            this.mRunningTasks.remove(m3u8CacheTask);
        }
        if (this.mPrepareTasks.contains(m3u8CacheTask)) {
            ImgoCacheLogger.i(TAG, "cancel from mPrepareTasks");
            this.mPrepareTasks.remove(m3u8CacheTask);
        }
        ImgoSourceNative.cancelCache(this.mManagerAddress, null);
        ImgoCacheLogger.i(TAG, "cancel out");
    }

    public void release() {
        if (this.mManagerAddress == 0L) {
            return;
        }
        ImgoCacheLogger.i(TAG, "release in");
        ImgoSourceNative.removeCallback(this.mCallback);
        ImgoSourceNative.freeCacheManager(this.mManagerAddress);
        this.mManagerAddress = 0L;
        if (this.mPrepareTasks != null) {
            this.mPrepareTasks.clear();
        }
        if (this.mRunningTasks != null) {
            this.mRunningTasks.clear();
        }
        ImgoCacheLogger.i(TAG, "release out");
    }

    public static interface TaskCallback {
        public void onStart(M3u8CacheTask var1);

        public void onSuccess(M3u8CacheTask var1);

        public void onFailed(M3u8CacheTask var1);
    }
}

