/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.source;

import android.content.Context;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.hunantv.media.player.utils.StringUtil;
import com.hunantv.media.player.utils.ThreadUtil;
import com.hunantv.media.source.CacheTask;
import com.hunantv.media.source.IImgoCache;
import com.hunantv.media.source.IImgoMultiCache;
import com.hunantv.media.source.ImgoCacheLibLoader;
import com.hunantv.media.source.ImgoCacheLogger;
import com.hunantv.media.source.jni.ImgoSourceNative;
import com.hunantv.media.utils.FileUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ImgoMultiCache
implements IImgoMultiCache {
    private IImgoCache.TaskCallback mTaskCallback;
    private static final String USER_AGENT = "ImgoDataSource";
    public static final String TAG = "ImgoCache";
    public static final int NULL = 0;
    private static final int CONNECT_TIMEOUT_MS = 3000;
    private static final int REQUEST_TIMEOUT_MS = 5000;
    protected long mManagerAddress;
    private String mCachePath;
    private ImgoSourceNative.InitParams mInitParams;
    private Object mLock = new Object();
    private List<CacheTask> mStartTasks = Collections.synchronizedList(new LinkedList());
    private Looper mMyLooper;
    private ImgoSourceNative.Callback mCallback = new ImgoSourceNative.Callback(){

        @Override
        public void onResult(final int n2, final ImgoSourceNative.CbResultParams cbResultParams) {
            if (cbResultParams != null) {
                ImgoCacheLogger.d(ImgoMultiCache.this.TAG(), "native_resultcallback result:" + n2 + ",taskid:" + cbResultParams.taskid + ",fullpath:" + cbResultParams.fullpath + ",type" + cbResultParams.type);
                if (cbResultParams.ts_names != null && cbResultParams.ts_names.length > 0) {
                    for (String string : cbResultParams.ts_names) {
                        ImgoCacheLogger.i(ImgoMultiCache.this.TAG(), "native_callback ts_name:" + string);
                    }
                }
            }
            if (n2 == 0) {
                if (ImgoMultiCache.this.mMyLooper != null) {
                    ThreadUtil.runOnTargetLooper(ImgoMultiCache.this.mMyLooper, new Runnable(){

                        @Override
                        public void run() {
                            ImgoMultiCache.this.notifyTaskResult(n2, cbResultParams);
                        }
                    });
                } else {
                    ThreadUtil.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            ImgoMultiCache.this.notifyTaskResult(n2, cbResultParams);
                        }
                    });
                }
            }
        }

        @Override
        public void onError(final ImgoSourceNative.CbErrorParams cbErrorParams) {
            if (cbErrorParams != null) {
                ImgoCacheLogger.e(ImgoMultiCache.this.TAG(), "onError taskid:" + cbErrorParams.taskid + ",error_code:" + cbErrorParams.error_code + ",detail_code:" + cbErrorParams.detail_code);
                if (ImgoMultiCache.this.mMyLooper != null) {
                    ThreadUtil.runOnTargetLooper(ImgoMultiCache.this.mMyLooper, new Runnable(){

                        @Override
                        public void run() {
                            ImgoMultiCache.this.notifyTaskError(cbErrorParams);
                        }
                    });
                } else {
                    ThreadUtil.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            ImgoMultiCache.this.notifyTaskError(cbErrorParams);
                        }
                    });
                }
            } else {
                ImgoCacheLogger.e(ImgoMultiCache.this.TAG(), "onError params null");
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTaskError(ImgoSourceNative.CbErrorParams cbErrorParams) {
        ImgoCacheLogger.d(this.TAG(), "notifyTaskError");
        Object object = this.mLock;
        synchronized (object) {
            ImgoCacheLogger.d(this.TAG(), "notifyTaskError in");
            if (cbErrorParams != null && this.isStartingTask(cbErrorParams.taskid)) {
                CacheTask cacheTask = this.findTask(cbErrorParams.taskid);
                ImgoCacheLogger.i(this.TAG(), "notifyTaskError findTask " + cacheTask);
                if (cacheTask != null) {
                    this.mStartTasks.remove(cacheTask);
                    if (cacheTask != null && cbErrorParams != null) {
                        cacheTask.setErrorCode(cbErrorParams.error_code);
                        cacheTask.setDetailCode(cbErrorParams.detail_code);
                    }
                    ImgoCacheLogger.i(this.TAG(), "notifyTaskError FAILED IN");
                    cacheTask.setTempPath(null);
                    cacheTask.setCurrentStatus(CacheTask.Status.FAILED);
                    this.callOnFailed(cacheTask);
                    ImgoCacheLogger.i(this.TAG(), "notifyTaskError FAILED OUT");
                    ImgoCacheLogger.i(this.TAG(), "notifyTaskError FINISH IN");
                    this.callOnFinish(cacheTask);
                    ImgoCacheLogger.i(this.TAG(), "notifyTaskError FINISH OUT");
                }
            }
            ImgoCacheLogger.d(this.TAG(), "notifyTaskError out");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTaskResult(int n2, ImgoSourceNative.CbResultParams cbResultParams) {
        ImgoCacheLogger.d(this.TAG(), "notifyTaskResult");
        Object object = this.mLock;
        synchronized (object) {
            ImgoCacheLogger.d(this.TAG(), "notifyTaskResult in");
            if (cbResultParams != null && this.isStartingTask(cbResultParams.taskid)) {
                this.onTaskResult(this.findTask(cbResultParams.taskid), n2, cbResultParams);
            }
            ImgoCacheLogger.d(this.TAG(), "notifyTaskResult out");
        }
    }

    protected void onTaskResult(CacheTask cacheTask, int n2, ImgoSourceNative.CbResultParams cbResultParams) {
        ImgoCacheLogger.i(this.TAG(), "onResult findTask " + cacheTask);
        if (cacheTask != null) {
            this.mStartTasks.remove(cacheTask);
            if (cacheTask != null && cbResultParams != null) {
                this.updateParamsOnResult(cacheTask, cbResultParams);
            }
            if (n2 == 0) {
                ImgoCacheLogger.i(this.TAG(), "onResult OK IN");
                cacheTask.setCurrentStatus(CacheTask.Status.SUCCESS);
                this.callOnSuccess(cacheTask);
                ImgoCacheLogger.i(this.TAG(), "onResult OK OUT");
            } else {
                ImgoCacheLogger.i(this.TAG(), "onResult FAILED IN");
                cacheTask.setTempPath(null);
                cacheTask.setCurrentStatus(CacheTask.Status.FAILED);
                this.callOnFailed(cacheTask);
                ImgoCacheLogger.i(this.TAG(), "onResult FAILED OUT");
            }
            ImgoCacheLogger.i(this.TAG(), "onResult FINISH IN");
            this.callOnFinish(cacheTask);
            ImgoCacheLogger.i(this.TAG(), "onResult FINISH OUT");
        }
    }

    protected void updateParamsOnResult(@NonNull CacheTask cacheTask, @NonNull ImgoSourceNative.CbResultParams cbResultParams) {
        cacheTask.setFullPath(cbResultParams.fullpath);
        cacheTask.setFileName(cbResultParams.file_name);
        cacheTask.setType(cbResultParams.type);
        cacheTask.setTsNames(cbResultParams.ts_names);
    }

    protected void updateParamsOnStart(@NonNull CacheTask cacheTask, @NonNull ImgoSourceNative.CbStartParams cbStartParams) {
        cacheTask.setTempPath(cbStartParams.filepath);
        cacheTask.setCurrentStatus(CacheTask.Status.START);
        cacheTask.setTaskID(cbStartParams.taskid);
    }

    public ImgoMultiCache(Context context, String string) {
        this(context, string, null);
    }

    public ImgoMultiCache(Context context, String string, ImgoSourceNative.InitParams initParams) {
        if (!ImgoCacheLibLoader.loadLibs(context) || StringUtil.isEmpty(string)) {
            return;
        }
        this.mCachePath = string;
        FileUtil.mkdirs(this.mCachePath);
        if (initParams != null) {
            this.mInitParams = initParams;
        } else {
            this.mInitParams = new ImgoSourceNative.InitParams();
            this.mInitParams.useragent = USER_AGENT;
            this.mInitParams.connect_timeout_ms = 3000;
            this.mInitParams.request_timeout_ms = 5000;
        }
        this.mMyLooper = Looper.myLooper();
        this.create();
    }

    protected void create() {
        this.release();
        ImgoCacheLogger.i(this.TAG(), "create in");
        this.mManagerAddress = ImgoSourceNative.newCacheManager(this.mCachePath, this.mInitParams);
        ImgoSourceNative.setMaxTask(this.mManagerAddress, this.mInitParams.max_task_num);
        ImgoSourceNative.subscribeCallback(this.mCallback);
        ImgoCacheLogger.i(this.TAG(), "create out");
    }

    @Override
    public void cache(CacheTask cacheTask) {
        this.cache(cacheTask, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cache(CacheTask cacheTask, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mManagerAddress == 0L || cacheTask == null || cacheTask.getVid() == null || cacheTask.getUrl() == null || this.isStartingTask(cacheTask)) {
                return;
            }
            if (cacheTask.isStart()) {
                ImgoCacheLogger.i(this.TAG(), "cache in started cache taskid:" + cacheTask.getTaskID());
                return;
            }
            ImgoCacheLogger.i(this.TAG(), "cache in vid:" + cacheTask.getVid() + ",streamid:" + cacheTask.getStreamId());
            this.startCache(cacheTask);
            this.mStartTasks.add(cacheTask);
            this.callOnStart(cacheTask);
            ImgoCacheLogger.i(this.TAG(), "cache out force:" + bl);
        }
    }

    protected void startCache(CacheTask cacheTask) {
        ImgoCacheLogger.i(this.TAG(), "startCache vid:" + cacheTask.getVid() + ",StreamId" + cacheTask.getStreamId());
        ImgoSourceNative.CbStartParams cbStartParams = ImgoSourceNative.startCache(this.mManagerAddress, cacheTask.getUrl(), cacheTask.getVid(), cacheTask.getStreamId(), cacheTask.getStartTimeMs(), cacheTask.getTsNum(), cacheTask.getWriteM3u8());
        if (cacheTask != null && cbStartParams != null) {
            this.updateParamsOnStart(cacheTask, cbStartParams);
        }
        ImgoCacheLogger.i(this.TAG(), "startCache end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(CacheTask cacheTask) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mManagerAddress == 0L || cacheTask == null || StringUtil.isEmpty(cacheTask.getTaskID())) {
                return;
            }
            ImgoCacheLogger.i(this.TAG(), "pause in taskid:" + cacheTask.getTaskID() + " vid:" + cacheTask.getVid() + ",streamid:" + cacheTask.getStreamId());
            cacheTask.setCurrentStatus(CacheTask.Status.PAUSE);
            ImgoSourceNative.pauseCache(this.mManagerAddress, cacheTask.getTaskID());
            ImgoCacheLogger.i(this.TAG(), "pause out");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(CacheTask cacheTask) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mManagerAddress == 0L || cacheTask == null || StringUtil.isEmpty(cacheTask.getTaskID())) {
                return;
            }
            ImgoCacheLogger.i(this.TAG(), "resume in taskid:" + cacheTask.getTaskID() + " vid:" + cacheTask.getVid() + ",streamid:" + cacheTask.getStreamId());
            cacheTask.setCurrentStatus(CacheTask.Status.START);
            ImgoSourceNative.resumeCache(this.mManagerAddress, cacheTask.getTaskID());
            ImgoCacheLogger.i(this.TAG(), "resume out");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(CacheTask cacheTask) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mManagerAddress == 0L || cacheTask == null) {
                return;
            }
            ImgoCacheLogger.i(this.TAG(), "cancel in taskid:" + cacheTask.getTaskID() + " vid:" + cacheTask.getVid() + ",streamid:" + cacheTask.getStreamId());
            cacheTask.setCurrentStatus(CacheTask.Status.NONE);
            cacheTask.setTempPath(null);
            ImgoSourceNative.cancelCache(this.mManagerAddress, cacheTask.getTaskID());
            this.mStartTasks.remove(cacheTask);
            ImgoCacheLogger.i(this.TAG(), "cancel out");
        }
    }

    @Override
    public void setTaskCallback(IImgoCache.TaskCallback taskCallback) {
        this.mTaskCallback = taskCallback;
    }

    @Override
    public void release() {
        if (this.mManagerAddress == 0L) {
            return;
        }
        ImgoCacheLogger.i(this.TAG(), "release in");
        ImgoSourceNative.removeCallback(this.mCallback);
        ImgoSourceNative.freeCacheManager(this.mManagerAddress);
        this.mManagerAddress = 0L;
        ImgoCacheLogger.i(this.TAG(), "release out");
    }

    @Override
    public IImgoCache.ExtraInfo getExtraInfo() {
        IImgoCache.ExtraInfo extraInfo = new IImgoCache.ExtraInfo(this.mManagerAddress);
        return extraInfo;
    }

    protected void callOnStart(CacheTask cacheTask) {
        if (this.mTaskCallback != null) {
            this.mTaskCallback.onStart(cacheTask);
        }
    }

    protected void callOnSuccess(CacheTask cacheTask) {
        if (this.mTaskCallback != null) {
            this.mTaskCallback.onSuccess(cacheTask);
        }
    }

    protected void callOnFailed(CacheTask cacheTask) {
        if (this.mTaskCallback != null) {
            this.mTaskCallback.onFailed(cacheTask);
        }
    }

    protected void callOnFinish(CacheTask cacheTask) {
        if (this.mTaskCallback != null) {
            this.mTaskCallback.onFinish(cacheTask);
        }
    }

    private boolean isStartTaskEmpty() {
        return this.mStartTasks == null || this.mStartTasks.isEmpty();
    }

    private boolean isStartingTask(CacheTask cacheTask) {
        if (cacheTask == null || this.isStartTaskEmpty()) {
            return false;
        }
        return this.isStartingTask(cacheTask.getTaskID());
    }

    private boolean isStartingTask(String string) {
        if (this.isStartTaskEmpty() || StringUtil.isEmpty(string)) {
            return false;
        }
        CacheTask cacheTask = this.findTask(string);
        return cacheTask != null;
    }

    private CacheTask findTask(String string) {
        for (CacheTask cacheTask : this.mStartTasks) {
            if (!string.equals(cacheTask.getTaskID())) continue;
            return cacheTask;
        }
        return null;
    }

    public String TAG() {
        return "ImgoCache[" + this.hashCode() + "]";
    }
}

