/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.source;

import android.content.Context;
import androidx.annotation.NonNull;
import com.hunantv.media.player.utils.StringUtil;
import com.hunantv.media.player.utils.ThreadUtil;
import com.hunantv.media.source.CacheTask;
import com.hunantv.media.source.IImgoCache;
import com.hunantv.media.source.IImgoQueueCache;
import com.hunantv.media.source.ImgoCacheLibLoader;
import com.hunantv.media.source.ImgoCacheLogger;
import com.hunantv.media.source.jni.ImgoSourceNative;
import com.hunantv.media.utils.FileUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class ImgoQueueCache
implements IImgoQueueCache {
    private IImgoCache.TaskCallback mTaskCallback;
    private static final String USER_AGENT = "ImgoDataSource";
    public static final String TAG = "ImgoQueueCache";
    private static final int NULL = 0;
    private static final int CONNECT_TIMEOUT_MS = 3000;
    private static final int REQUEST_TIMEOUT_MS = 5000;
    protected long mManagerAddress;
    private String mCachePath;
    private ImgoSourceNative.InitParams mInitParams;
    private static final int MAX_RUNNING_SIZE = 1;
    private Queue<CacheTask> mPrepareTasks = new LinkedList<CacheTask>();
    private List<CacheTask> mRunningTasks = new LinkedList<CacheTask>();
    private Object mSyncLock = new Object();
    private ImgoSourceNative.Callback mCallback = new ImgoSourceNative.Callback(){

        @Override
        public void onResult(final int n2, final ImgoSourceNative.CbResultParams cbResultParams) {
            ImgoCacheLogger.d(ImgoQueueCache.this.TAG(), "onResult IN");
            if (cbResultParams != null) {
                ImgoCacheLogger.i(ImgoQueueCache.this.TAG(), "native_resultcallback result:" + n2 + ",taskid:" + cbResultParams.taskid + ",fullpath:" + cbResultParams.fullpath + ",type" + cbResultParams.type);
                if (cbResultParams.ts_names != null && cbResultParams.ts_names.length > 0) {
                    for (String string : cbResultParams.ts_names) {
                        ImgoCacheLogger.i(ImgoQueueCache.this.TAG(), "native_callback ts_name:" + string);
                    }
                }
            }
            ThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ImgoCacheLogger.d(ImgoQueueCache.this.TAG(), "onResult attach to UI thread");
                    CacheTask cacheTask = null;
                    if (cbResultParams != null) {
                        cacheTask = this.findTask(ImgoQueueCache.this.mRunningTasks, cbResultParams.taskid);
                        ImgoQueueCache.this.onTaskResult(cacheTask, n2, cbResultParams);
                    }
                    if (cacheTask != null && cacheTask.isSuccess()) {
                        ImgoQueueCache.this.cache((CacheTask)ImgoQueueCache.this.mPrepareTasks.poll(), true);
                    }
                }
            });
            ImgoCacheLogger.d(ImgoQueueCache.this.TAG(), "onResult OUT");
        }

        @Override
        public void onError(ImgoSourceNative.CbErrorParams cbErrorParams) {
        }

        private CacheTask findTask(List<CacheTask> list, String string) {
            if (list == null || string == null) {
                return null;
            }
            for (CacheTask cacheTask : list) {
                if (cacheTask == null || !string.equals(cacheTask.getTaskID())) continue;
                return cacheTask;
            }
            return null;
        }
    };

    protected void onTaskResult(CacheTask cacheTask, int n2, ImgoSourceNative.CbResultParams cbResultParams) {
        ImgoCacheLogger.i(this.TAG(), "onResult findTask " + cacheTask);
        if (cacheTask != null) {
            this.mRunningTasks.remove(cacheTask);
            if (cacheTask != null && cbResultParams != null) {
                this.updateParamsOnResult(cacheTask, cbResultParams);
            }
            if (n2 == 0) {
                ImgoCacheLogger.i(this.TAG(), "onResult OK IN");
                cacheTask.setCurrentStatus(CacheTask.Status.SUCCESS);
                this.callOnSuccess(cacheTask);
                ImgoCacheLogger.i(this.TAG(), "onResult OK OUT");
            } else {
                ImgoCacheLogger.i(this.TAG(), "onResult FAILED IN");
                cacheTask.setTempPath(null);
                cacheTask.setCurrentStatus(CacheTask.Status.FAILED);
                this.callOnFailed(cacheTask);
                ImgoCacheLogger.i(this.TAG(), "onResult FAILED OUT");
            }
        }
    }

    protected void updateParamsOnResult(@NonNull CacheTask cacheTask, @NonNull ImgoSourceNative.CbResultParams cbResultParams) {
        cacheTask.setFullPath(cbResultParams.fullpath);
        cacheTask.setFileName(cbResultParams.file_name);
        cacheTask.setType(cbResultParams.type);
        cacheTask.setTsNames(cbResultParams.ts_names);
    }

    protected void updateParamsOnStart(@NonNull CacheTask cacheTask, @NonNull ImgoSourceNative.CbStartParams cbStartParams) {
        cacheTask.setTempPath(cbStartParams.filepath);
        cacheTask.setCurrentStatus(CacheTask.Status.START);
        cacheTask.setTaskID(cbStartParams.taskid);
    }

    public ImgoQueueCache(Context context, String string) {
        this(context, string, null);
    }

    public ImgoQueueCache(Context context, String string, ImgoSourceNative.InitParams initParams) {
        if (!ImgoCacheLibLoader.loadLibs(context) || StringUtil.isEmpty(string)) {
            return;
        }
        this.mCachePath = string;
        FileUtil.mkdirs(this.mCachePath);
        if (initParams != null) {
            this.mInitParams = initParams;
        } else {
            this.mInitParams = new ImgoSourceNative.InitParams();
            this.mInitParams.useragent = USER_AGENT;
            this.mInitParams.connect_timeout_ms = 3000;
            this.mInitParams.request_timeout_ms = 5000;
        }
        this.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create() {
        this.release();
        Object object = this.mSyncLock;
        synchronized (object) {
            ImgoCacheLogger.i(this.TAG(), "create in");
            this.mManagerAddress = ImgoSourceNative.newCacheManager(this.mCachePath, this.mInitParams);
            ImgoSourceNative.setMaxTask(this.mManagerAddress, 1);
            ImgoSourceNative.subscribeCallback(this.mCallback);
            ImgoCacheLogger.i(this.TAG(), "create out");
        }
    }

    @Override
    public void cache(CacheTask cacheTask) {
        this.cache(cacheTask, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cache(CacheTask cacheTask, boolean bl) {
        Object object = this.mSyncLock;
        synchronized (object) {
            if (this.mManagerAddress == 0L || cacheTask == null || cacheTask.getVid() == null || cacheTask.getUrl() == null) {
                return;
            }
            ImgoCacheLogger.i(this.TAG(), "cache in vid:" + cacheTask.getVid() + ",streamid:" + cacheTask.getStreamId());
            if (bl) {
                if (this.mRunningTasks.size() > 0) {
                    ImgoCacheLogger.i(this.TAG(), "force cache vid:" + cacheTask.getVid() + ",StreamId" + cacheTask.getStreamId());
                    CacheTask cacheTask2 = this.mRunningTasks.get(0);
                    if (cacheTask2 != cacheTask) {
                        this.cancelImpl(cacheTask2);
                        if (!this.mPrepareTasks.contains(cacheTask2)) {
                            ImgoCacheLogger.i(this.TAG(), "add RunningTask to mPrepareTasks vid:" + cacheTask2.getVid());
                            this.mPrepareTasks.add(cacheTask2);
                        }
                    }
                }
                this.moveToRunningTasks(cacheTask);
            } else if (this.mRunningTasks.size() < 1) {
                this.moveToRunningTasks(cacheTask);
            } else {
                ImgoCacheLogger.i(this.TAG(), "add to mPrepareTasks vid:" + cacheTask.getVid());
                if (!this.mPrepareTasks.contains(cacheTask)) {
                    this.mPrepareTasks.add(cacheTask);
                }
            }
            ImgoCacheLogger.i(this.TAG(), "cache out force:" + bl);
        }
    }

    private void moveToRunningTasks(CacheTask cacheTask) {
        if (cacheTask == null || this.mRunningTasks.contains(cacheTask)) {
            return;
        }
        if (this.mPrepareTasks.contains(cacheTask)) {
            this.mPrepareTasks.remove(cacheTask);
        }
        ImgoCacheLogger.i(this.TAG(), "moveToRunningTasks vid:" + cacheTask.getVid() + ",StreamId" + cacheTask.getStreamId());
        this.startCache(cacheTask);
        this.mRunningTasks.add(cacheTask);
        this.callOnStart(cacheTask);
    }

    protected void startCache(CacheTask cacheTask) {
        ImgoCacheLogger.i(this.TAG(), "startCache vid:" + cacheTask.getVid() + ",StreamId" + cacheTask.getStreamId());
        ImgoSourceNative.CbStartParams cbStartParams = ImgoSourceNative.startCache(this.mManagerAddress, cacheTask.getUrl(), cacheTask.getVid(), cacheTask.getStreamId(), 0, 0, cacheTask.getWriteM3u8());
        if (cacheTask != null && cbStartParams != null) {
            this.updateParamsOnStart(cacheTask, cbStartParams);
        }
        ImgoCacheLogger.i(this.TAG(), "startCache end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(CacheTask cacheTask) {
        Object object = this.mSyncLock;
        synchronized (object) {
            this.cancelImpl(cacheTask);
        }
    }

    private void cancelImpl(CacheTask cacheTask) {
        if (this.mManagerAddress == 0L || cacheTask == null) {
            return;
        }
        ImgoCacheLogger.i(this.TAG(), "cancel in vid:" + cacheTask.getVid() + ",streamid:" + cacheTask.getStreamId());
        cacheTask.setCurrentStatus(CacheTask.Status.NONE);
        cacheTask.setTempPath(null);
        if (this.mRunningTasks.contains(cacheTask)) {
            ImgoCacheLogger.i(this.TAG(), "cancel from mRunningTasks");
            this.mRunningTasks.remove(cacheTask);
        }
        if (this.mPrepareTasks.contains(cacheTask)) {
            ImgoCacheLogger.i(this.TAG(), "cancel from mPrepareTasks");
            this.mPrepareTasks.remove(cacheTask);
        }
        ImgoSourceNative.cancelCache(this.mManagerAddress, cacheTask.getTaskID());
        ImgoCacheLogger.i(this.TAG(), "cancel out");
    }

    @Override
    public void setTaskCallback(IImgoCache.TaskCallback taskCallback) {
        this.mTaskCallback = taskCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.mSyncLock;
        synchronized (object) {
            if (this.mManagerAddress == 0L) {
                return;
            }
            ImgoCacheLogger.i(this.TAG(), "release in");
            ImgoSourceNative.removeCallback(this.mCallback);
            ImgoSourceNative.freeCacheManager(this.mManagerAddress);
            this.mManagerAddress = 0L;
            if (this.mPrepareTasks != null) {
                this.mPrepareTasks.clear();
            }
            if (this.mRunningTasks != null) {
                this.mRunningTasks.clear();
            }
            ImgoCacheLogger.i(this.TAG(), "release out");
        }
    }

    @Override
    public Queue<CacheTask> getPrepareQueue() {
        return this.mPrepareTasks;
    }

    @Override
    public List<CacheTask> getRunningList() {
        return this.mRunningTasks;
    }

    @Override
    public IImgoCache.ExtraInfo getExtraInfo() {
        IImgoCache.ExtraInfo extraInfo = new IImgoCache.ExtraInfo(this.mManagerAddress);
        return extraInfo;
    }

    protected void callOnStart(CacheTask cacheTask) {
        if (this.mTaskCallback != null) {
            this.mTaskCallback.onStart(cacheTask);
        }
    }

    protected void callOnSuccess(CacheTask cacheTask) {
        if (this.mTaskCallback != null) {
            this.mTaskCallback.onSuccess(cacheTask);
        }
    }

    protected void callOnFailed(CacheTask cacheTask) {
        if (this.mTaskCallback != null) {
            this.mTaskCallback.onFailed(cacheTask);
        }
    }

    public String TAG() {
        return "ImgoQueueCache[" + this.hashCode() + "]";
    }
}

