/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.source.jni;

import com.hunantv.media.source.ImgoCacheLogger;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;

public class ImgoSourceNative {
    public static final String TAG = "ImgoSourceNative";
    public static final int OK = 0;
    public static final int ERROR = -1;
    private static List<WeakReference<Callback>> sCallbacks = new LinkedList<WeakReference<Callback>>();

    public static void subscribeCallback(Callback callback) {
        sCallbacks.add(new WeakReference<Callback>(callback));
    }

    public static void removeCallback(Callback callback) {
        for (WeakReference<Callback> weakReference : sCallbacks) {
            Callback callback2 = (Callback)weakReference.get();
            if (callback2 == null || !callback2.equals(callback)) continue;
            sCallbacks.remove(weakReference);
            return;
        }
    }

    private static void native_resultcallback(int n2, CbResultParams cbResultParams) {
        for (WeakReference<Callback> weakReference : sCallbacks) {
            Callback callback = (Callback)weakReference.get();
            if (callback == null) continue;
            callback.onResult(n2, cbResultParams);
        }
    }

    private static void native_errorcallback(CbErrorParams cbErrorParams) {
        for (WeakReference<Callback> weakReference : sCallbacks) {
            Callback callback = (Callback)weakReference.get();
            if (callback == null) continue;
            callback.onError(cbErrorParams);
        }
    }

    private static void native_logger(int n2, String string, String string2) {
        ImgoCacheLogger.cbLog(n2, string, string2);
    }

    public static native long newCacheManager(String var0, InitParams var1);

    public static native void freeCacheManager(long var0);

    public static native void setMaxTask(long var0, int var2);

    public static native CbStartParams startCache(long var0, String var2, String var3, int var4, int var5, int var6, int var7);

    public static native void pauseCache(long var0, String var2);

    public static native void resumeCache(long var0, String var2);

    public static native void cancelCache(long var0, String var2);

    public static native String testJNI();

    public static native long getDynamicIntervalBytes(long var0);

    public static interface Callback {
        public void onResult(int var1, CbResultParams var2);

        public void onError(CbErrorParams var1);
    }

    public static class CbErrorParams {
        public String taskid;
        public int error_code;
        public int detail_code;
    }

    public static class CbStartParams {
        public String filepath;
        public String taskid;
    }

    public static class CbResultParams {
        public static final int FT_UNKNOW = -1;
        public static final int FT_M3U8 = 0;
        public static final int FT_MP4 = 1;
        public static final int FT_FLV = 2;
        public String fullpath;
        public String[] ts_names;
        public String file_name;
        public int type;
        public String taskid;
    }

    public static class InitParams {
        public String useragent;
        public int connect_timeout_ms;
        public int request_timeout_ms;
        public int max_task_num = 5;
    }
}

