/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import com.hunantv.media.player.pragma.DebugLog;

public class AudioUtil {
    private static final String TAG = "AudioUtil";
    private static volatile HeadsetPlugReceiver mHeadsetPlugReceiver;
    private static Object sLock;

    public static void requestAudioFocus(Context context) {
        if (context == null) {
            return;
        }
        DebugLog.i(TAG, "requestAudioFocus");
        try {
            if (Build.VERSION.SDK_INT < 21) {
                Intent intent = new Intent("com.android.music.musicservicecommand");
                intent.putExtra("command", "pause");
                context.sendBroadcast(intent);
                return;
            }
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            audioManager.requestAudioFocus(null, 3, 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void abandonAudioFocus(Context context) {
        if (context == null) {
            return;
        }
        DebugLog.i(TAG, "abandonAudioFocus");
        try {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            audioManager.abandonAudioFocus(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerHeadsetReceiverOnce(Context context) {
        if (mHeadsetPlugReceiver != null) {
            return;
        }
        if (context == null) {
            return;
        }
        Context context2 = context.getApplicationContext();
        if (context2 == null) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            if (mHeadsetPlugReceiver == null) {
                mHeadsetPlugReceiver = new HeadsetPlugReceiver();
                context2.registerReceiver((BroadcastReceiver)mHeadsetPlugReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unRegisterHeadsetReceiver(Context context) {
        if (mHeadsetPlugReceiver == null) {
            return;
        }
        if (context == null) {
            return;
        }
        Context context2 = context.getApplicationContext();
        if (context2 == null) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            context2.unregisterReceiver((BroadcastReceiver)mHeadsetPlugReceiver);
            mHeadsetPlugReceiver = null;
        }
    }

    public static boolean isWired(Context context) {
        block5: {
            if (context == null) {
                return false;
            }
            try {
                AudioManager audioManager = (AudioManager)context.getSystemService("audio");
                if (Build.VERSION.SDK_INT >= 23) {
                    AudioDeviceInfo[] audioDeviceInfoArray;
                    for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray = audioManager.getDevices(2)) {
                        int n2 = audioDeviceInfo.getType();
                        if (n2 != 3 && n2 != 4 && n2 != 8 && n2 != 7) continue;
                        return true;
                    }
                    break block5;
                }
                return audioManager.isWiredHeadsetOn() || audioManager.isBluetoothScoOn() || audioManager.isBluetoothA2dpOn();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    static {
        sLock = new Object();
    }

    public static class HeadsetPlugReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            try {
                AudioManager audioManager = (AudioManager)context.getSystemService("audio");
                if (audioManager != null && intent.getAction().equals("android.intent.action.HEADSET_PLUG")) {
                    int n2 = intent.getIntExtra("state", 0);
                    if (n2 == 0) {
                        audioManager.setSpeakerphoneOn(true);
                        DebugLog.i(AudioUtil.TAG, "setSpeakerphoneOn true");
                    } else if (n2 == 1) {
                        audioManager.setSpeakerphoneOn(false);
                        DebugLog.i(AudioUtil.TAG, "setSpeakerphoneOn false");
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

