/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.utils;

public class FpsStatistic {
    private static final int FPS_CALCULATE_TIME_S = 3;
    private volatile boolean mFpsStar;
    private volatile int mFpsCounter = 0;
    private volatile long mFpsStartTimeMs;
    private volatile int mFps = -1;

    public void onFrame() {
        if (this.mFpsStar) {
            if (this.mFpsStartTimeMs <= 0L) {
                this.mFpsStartTimeMs = System.currentTimeMillis();
            }
            int n2 = (int)((System.currentTimeMillis() - this.mFpsStartTimeMs) / 1000L);
            if (this.mFpsStartTimeMs > 0L && n2 > 0) {
                ++this.mFpsCounter;
                if (n2 > 3) {
                    this.mFps = this.mFpsCounter / n2;
                    this.resetFpsTimeAndCounter();
                }
            }
        } else {
            this.resetFpsTimeAndCounter();
        }
    }

    public void startFps() {
        this.mFpsStar = true;
    }

    public void stopFps() {
        this.mFpsStar = false;
        this.resetFpsTimeAndCounter();
    }

    public int getFps() {
        return this.mFps;
    }

    public void resetFps() {
        this.mFps = -1;
        this.resetFpsTimeAndCounter();
    }

    private void resetFpsTimeAndCounter() {
        this.mFpsStartTimeMs = 0L;
        this.mFpsCounter = 0;
    }
}

