/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.utils;

import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.utils.StringUtil;
import com.hunantv.media.report.c.f;
import java.io.File;
import java.io.FileInputStream;

public class LocalHelper {
    private static final String TAG = LocalHelper.class.getSimpleName();

    private static String filterLocalProtocol(String string) {
        try {
            if (string.startsWith("file:")) {
                int n2;
                for (n2 = 5; n2 < string.length() && string.charAt(n2) == '/'; ++n2) {
                }
                return string.substring(n2 - 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public static boolean validLocalPath(String string, MediaType mediaType) {
        boolean bl = LocalHelper.validLocalPathImpl(string, mediaType);
        DebugLog.i(TAG, "validLocalPath: " + bl);
        return bl;
    }

    private static boolean validLocalPathImpl(String string, MediaType mediaType) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        try {
            File file = new File(LocalHelper.filterLocalProtocol(string));
            if (file == null || !file.exists() || file.isDirectory()) {
                return false;
            }
            switch (mediaType) {
                case MP4: {
                    return LocalHelper.checkMP4(file);
                }
                case HLS: {
                    return LocalHelper.checkHLS(file);
                }
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean checkMP4(File file) {
        int n2 = 8;
        return file.length() > 8L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkHLS(File file) {
        FileInputStream fileInputStream;
        block8: {
            boolean bl;
            int n2;
            byte[] byArray;
            block7: {
                int n3 = 25;
                int n4 = 200;
                if (file.length() < 25L) {
                    return false;
                }
                byArray = new byte[200];
                n2 = 0;
                int n5 = 0;
                int n6 = 0;
                fileInputStream = null;
                fileInputStream = new FileInputStream(file);
                while ((n6 = 200 - n2) > 0 && (n5 = fileInputStream.read(byArray, n2, n6)) >= 0) {
                    n2 += n5;
                }
                if (n2 >= 25) break block7;
                boolean bl2 = false;
                f.a(fileInputStream);
                return bl2;
            }
            try {
                String string = new String(byArray, 0, n2);
                if (StringUtil.isEmpty(string) || !string.contains("#EXTM3U") || !string.contains("#EXT-X-STREAM-INF:") && !string.contains("#EXT-X-TARGETDURATION:") && !string.contains("#EXT-X-MEDIA-SEQUENCE:")) break block8;
                bl = true;
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    f.a(fileInputStream);
                    throw throwable;
                }
                f.a(fileInputStream);
            }
            f.a(fileInputStream);
            return bl;
        }
        f.a(fileInputStream);
        return false;
    }

    public static enum MediaType {
        MP4,
        HLS;

    }
}

