/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.hunantv.media.player.pragma.DebugLog;
import java.lang.ref.WeakReference;

public class MgtvPlayerBroadcastObserver {
    private static final String TAG = "MgtvPlayerBroadcastObserver";
    private Context mContext;
    private MgtvPlayerBroadcastReceiver receiver;
    private int mCurrentNetType = -1;
    public static final int TYPE_NONE = -1;
    private Object lock = new Object();
    private OnNetworkChangeListener onNetworkChangeListener;
    private OnBluetoothHeadsetListener onBluetoothHeadsetListener;
    private OnHeadsetListener onHeadsetListener;

    public MgtvPlayerBroadcastObserver(Context context) {
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        Object object = this.lock;
        synchronized (object) {
            if (this.receiver != null) {
                DebugLog.i(TAG, "already register");
                return;
            }
            if (this.mContext != null) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
                intentFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
                intentFilter.addAction("android.intent.action.HEADSET_PLUG");
                intentFilter.setPriority(1000);
                this.mCurrentNetType = MgtvPlayerBroadcastObserver.getCurrentNetworkType(this.mContext);
                this.receiver = new MgtvPlayerBroadcastReceiver(this);
                this.mContext.registerReceiver((BroadcastReceiver)this.receiver, intentFilter);
                DebugLog.i(TAG, "registerReceiver");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.mContext != null && this.receiver != null) {
                    this.mContext.unregisterReceiver((BroadcastReceiver)this.receiver);
                    this.receiver = null;
                    DebugLog.i(TAG, "unregisterReceiver");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.unregister();
    }

    public MgtvPlayerBroadcastObserver setOnNetworkChangeListener(OnNetworkChangeListener onNetworkChangeListener) {
        this.onNetworkChangeListener = onNetworkChangeListener;
        return this;
    }

    public MgtvPlayerBroadcastObserver setOnBluetoothHeadsetListener(OnBluetoothHeadsetListener onBluetoothHeadsetListener) {
        this.onBluetoothHeadsetListener = onBluetoothHeadsetListener;
        return this;
    }

    public MgtvPlayerBroadcastObserver setOnHeadsetListener(OnHeadsetListener onHeadsetListener) {
        this.onHeadsetListener = onHeadsetListener;
        return this;
    }

    public static int getCurrentNetworkType(Context context) {
        NetworkInfo networkInfo = null;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null) {
            try {
                networkInfo = connectivityManager.getActiveNetworkInfo();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (networkInfo == null || !networkInfo.isConnected()) {
            return -1;
        }
        return networkInfo.getType();
    }

    private static class MgtvPlayerBroadcastReceiver
    extends BroadcastReceiver {
        WeakReference<MgtvPlayerBroadcastObserver> observerWeakReference;

        public MgtvPlayerBroadcastReceiver(MgtvPlayerBroadcastObserver mgtvPlayerBroadcastObserver) {
            this.observerWeakReference = new WeakReference<MgtvPlayerBroadcastObserver>(mgtvPlayerBroadcastObserver);
        }

        public void onReceive(Context context, Intent intent) {
            if (context == null || intent == null) {
                return;
            }
            DebugLog.i(MgtvPlayerBroadcastObserver.TAG, "action" + intent.getAction());
            switch (intent.getAction()) {
                case "android.net.conn.CONNECTIVITY_CHANGE": {
                    this.connectivityChange(context, intent);
                    break;
                }
                case "android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED": {
                    this.bluetoothStateChange(context, intent);
                    break;
                }
                case "android.intent.action.HEADSET_PLUG": {
                    this.headsetStateChange(context, intent);
                }
            }
        }

        private void connectivityChange(Context context, Intent intent) {
            int n2;
            DebugLog.i(MgtvPlayerBroadcastObserver.TAG, "connectivityChange in");
            int n3 = MgtvPlayerBroadcastObserver.getCurrentNetworkType(context);
            MgtvPlayerBroadcastObserver mgtvPlayerBroadcastObserver = (MgtvPlayerBroadcastObserver)this.observerWeakReference.get();
            if (mgtvPlayerBroadcastObserver != null && (n2 = mgtvPlayerBroadcastObserver.mCurrentNetType) != n3) {
                mgtvPlayerBroadcastObserver.mCurrentNetType = n3;
                DebugLog.i(MgtvPlayerBroadcastObserver.TAG, "connectivityChange currentType:" + n3);
                OnNetworkChangeListener onNetworkChangeListener = mgtvPlayerBroadcastObserver.onNetworkChangeListener;
                if (onNetworkChangeListener != null) {
                    onNetworkChangeListener.onNetworkChanged(n2, n3);
                }
            }
            DebugLog.i(MgtvPlayerBroadcastObserver.TAG, "connectivityChange out");
        }

        private void bluetoothStateChange(Context context, Intent intent) {
            int n2 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
            DebugLog.i(MgtvPlayerBroadcastObserver.TAG, "bluetoothStateChange in.state:" + n2);
            MgtvPlayerBroadcastObserver mgtvPlayerBroadcastObserver = (MgtvPlayerBroadcastObserver)this.observerWeakReference.get();
            if (mgtvPlayerBroadcastObserver != null && mgtvPlayerBroadcastObserver.onBluetoothHeadsetListener != null) {
                mgtvPlayerBroadcastObserver.onBluetoothHeadsetListener.onBluetoothHeadsetStateChange(n2);
            }
            DebugLog.i(MgtvPlayerBroadcastObserver.TAG, "bluetoothStateChange out");
        }

        private void headsetStateChange(Context context, Intent intent) {
            int n2 = intent.getIntExtra("state", 0);
            DebugLog.i(MgtvPlayerBroadcastObserver.TAG, "headsetStateChange in.state:" + n2);
            MgtvPlayerBroadcastObserver mgtvPlayerBroadcastObserver = (MgtvPlayerBroadcastObserver)this.observerWeakReference.get();
            if (mgtvPlayerBroadcastObserver != null && mgtvPlayerBroadcastObserver.onHeadsetListener != null) {
                mgtvPlayerBroadcastObserver.onHeadsetListener.onHeadsetStateChange(n2);
            }
            DebugLog.i(MgtvPlayerBroadcastObserver.TAG, "headsetStateChange out");
        }
    }

    public static interface OnBluetoothHeadsetListener {
        public void onBluetoothHeadsetStateChange(int var1);
    }

    public static interface OnHeadsetListener {
        public void onHeadsetStateChange(int var1);
    }

    public static interface OnNetworkChangeListener {
        public void onNetworkChanged(int var1, int var2);
    }
}

