/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.utils;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NumericUtil {
    public static int parseInt(@Nullable String string) {
        return NumericUtil.parseInt(string, 0);
    }

    public static int parseInt(@Nullable String string, int n2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return n2;
        }
        int n3 = n2;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n3;
    }

    public static long parseLong(@Nullable String string) {
        return NumericUtil.parseLong(string, 0L);
    }

    public static long parseLong(@Nullable String string, long l2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return l2;
        }
        long l3 = l2;
        try {
            l3 = Long.parseLong(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l3;
    }

    public static float parseFloat(@Nullable String string) {
        return NumericUtil.parseFloat(string, 0.0f);
    }

    public static float parseFloat(@Nullable String string, float f2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return f2;
        }
        float f3 = f2;
        try {
            f3 = Float.parseFloat(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f3;
    }

    public static boolean isNumeric(@Nullable String string) {
        boolean bl = false;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return bl;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            bl = true;
        }
        return bl;
    }

    public static boolean isOdd(int n2) {
        return (n2 & 1) == 1;
    }

    public static String getDataNoByPageIndex(int n2) {
        String string = String.format("%02d", n2);
        if (n2 == 0) {
            return "";
        }
        return string;
    }
}

