/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;

public final class Util {
    public static final int SDK_INT = Build.VERSION.SDK_INT == 25 && Build.VERSION.CODENAME.charAt(0) == 'O' ? 26 : Build.VERSION.SDK_INT;
    public static final String DEVICE = Build.DEVICE;
    public static final String MANUFACTURER = Build.MANUFACTURER;
    public static final String MODEL = Build.MODEL;
    public static final String DEVICE_DEBUG_INFO = DEVICE + ", " + MODEL + ", " + MANUFACTURER + ", " + SDK_INT;
    private static final String TAG = "Util";
    private static final Pattern XS_DATE_TIME_PATTERN = Pattern.compile("(\\d\\d\\d\\d)\\-(\\d\\d)\\-(\\d\\d)[Tt](\\d\\d):(\\d\\d):(\\d\\d)([\\.,](\\d+))?([Zz]|((\\+|\\-)(\\d?\\d):?(\\d\\d)))?");
    private static final Pattern XS_DURATION_PATTERN = Pattern.compile("^(-)?P(([0-9]*)Y)?(([0-9]*)M)?(([0-9]*)D)?(T(([0-9]*)H)?(([0-9]*)M)?(([0-9.]*)S)?)?$");
    private static final Pattern ESCAPED_CHARACTER_PATTERN = Pattern.compile("%([A-Fa-f0-9]{2})");

    private Util() {
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @TargetApi(value=23)
    public static boolean maybeRequestReadExternalStoragePermission(Activity activity, Uri ... uriArray) {
        if (SDK_INT < 23) {
            return false;
        }
        for (Uri uri : uriArray) {
            if (!Util.isLocalFileUri(uri)) continue;
            if (activity.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") == 0) break;
            activity.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 0);
            return true;
        }
        return false;
    }

    public static boolean isLocalFileUri(Uri uri) {
        String string = uri.getScheme();
        return TextUtils.isEmpty((CharSequence)string) || string.equals("file");
    }

    public static boolean areEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static boolean contains(Object[] objectArray, Object object) {
        for (Object object2 : objectArray) {
            if (!Util.areEqual(object2, object)) continue;
            return true;
        }
        return false;
    }

    public static ExecutorService newSingleThreadExecutor(final String string) {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(@NonNull Runnable runnable) {
                return new Thread(runnable, string);
            }
        });
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String normalizeLanguageCode(String string) {
        try {
            return string == null ? null : new Locale(string).getISO3Language();
        }
        catch (MissingResourceException missingResourceException) {
            return string.toLowerCase();
        }
    }

    public static boolean isLinebreak(int n2) {
        return n2 == 10 || n2 == 13;
    }

    public static String toLowerInvariant(String string) {
        return string == null ? null : string.toLowerCase(Locale.US);
    }

    public static int ceilDivide(int n2, int n3) {
        return (n2 + n3 - 1) / n3;
    }

    public static long ceilDivide(long l2, long l3) {
        return (l2 + l3 - 1L) / l3;
    }

    public static int constrainValue(int n2, int n3, int n4) {
        return Math.max(n3, Math.min(n2, n4));
    }

    public static long constrainValue(long l2, long l3, long l4) {
        return Math.max(l3, Math.min(l2, l4));
    }

    public static float constrainValue(float f2, float f3, float f4) {
        return Math.max(f3, Math.min(f2, f4));
    }

    public static int binarySearchFloor(int[] nArray, int n2, boolean bl, boolean bl2) {
        int n3 = Arrays.binarySearch(nArray, n2);
        if (n3 < 0) {
            n3 = -(n3 + 2);
        } else {
            while (--n3 >= 0 && nArray[n3] == n2) {
            }
            if (bl) {
                ++n3;
            }
        }
        return bl2 ? Math.max(0, n3) : n3;
    }

    public static int binarySearchFloor(long[] lArray, long l2, boolean bl, boolean bl2) {
        int n2 = Arrays.binarySearch(lArray, l2);
        if (n2 < 0) {
            n2 = -(n2 + 2);
        } else {
            while (--n2 >= 0 && lArray[n2] == l2) {
            }
            if (bl) {
                ++n2;
            }
        }
        return bl2 ? Math.max(0, n2) : n2;
    }

    public static int binarySearchCeil(long[] lArray, long l2, boolean bl, boolean bl2) {
        int n2 = Arrays.binarySearch(lArray, l2);
        if (n2 < 0) {
            n2 ^= 0xFFFFFFFF;
        } else {
            while (++n2 < lArray.length && lArray[n2] == l2) {
            }
            if (bl) {
                --n2;
            }
        }
        return bl2 ? Math.min(lArray.length - 1, n2) : n2;
    }

    public static <T> int binarySearchFloor(List<? extends Comparable<? super T>> list, T t2, boolean bl, boolean bl2) {
        int n2 = Collections.binarySearch(list, t2);
        if (n2 < 0) {
            n2 = -(n2 + 2);
        } else {
            while (--n2 >= 0 && list.get(n2).compareTo(t2) == 0) {
            }
            if (bl) {
                ++n2;
            }
        }
        return bl2 ? Math.max(0, n2) : n2;
    }
}

