/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hunantv.media.config.NetPlayConfig;
import com.hunantv.media.drm.IDrmSession;
import com.hunantv.media.p2p.IP2pTask;
import com.hunantv.media.player.IMgtvRenderView;
import com.hunantv.media.player.MgtvMediaPlayer;
import com.hunantv.media.player.MgtvPlayerDataSource;
import com.hunantv.media.player.MgtvPlayerListener;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.smooth.SmoothMediaSource;
import com.hunantv.media.player.statistic.FlowDataStatistic;
import com.hunantv.media.player.subtitle.SubtitleConfig;
import com.hunantv.media.player.subtitle.SubtitleSource;
import com.hunantv.media.player.utils.ExTicker;
import com.hunantv.media.player.utils.ThreadUtil;
import com.hunantv.media.recoder.GifRecorder;
import com.hunantv.media.report.ReportParams;
import com.hunantv.media.widget.ISubtitle;
import com.hunantv.media.widget.IVideoView;
import com.hunantv.media.widget.MgtvAbstractVideoView;
import com.hunantv.media.widget.debug.DebugPanel;

public class FakeVideoView
extends FrameLayout
implements IVideoView {
    private static final String TAG = "FakeVideoView";
    boolean isPlaying;
    boolean isPrepared;
    boolean isRendered;
    ExTicker exTicker = new ExTicker(1000);
    int duration = 10800000;
    private int mCurrentState = 0;
    IVideoView.OnPreparedListener onPreparedListener;
    IVideoView.OnSeekCompleteListener onSeekCompleteListener;
    IVideoView.OnInfoListener onInfoListener;
    IVideoView.OnStartListener onStartListener;
    IVideoView.OnPauseListener onPauseListener;
    IVideoView.OnUpdateStatusListener onUpdateStatusListener;

    public FakeVideoView(Context context) {
        super(context);
    }

    public FakeVideoView(Context context, int n2) {
        super(context);
    }

    public FakeVideoView(Context context, int n2, boolean bl) {
        super(context);
    }

    public FakeVideoView(Context context, int n2, boolean bl, boolean bl2) {
        super(context);
    }

    public FakeVideoView(Context context, IVideoView.Configuration configuration) {
        super(context);
    }

    public FakeVideoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public FakeVideoView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    private void setCurrentState(int n2) {
        this.mCurrentState = n2;
        this.sendUpdateStatus();
    }

    @Override
    public void start() {
        DebugLog.i(TAG, "start");
        this.setCurrentState(3);
        this.isPlaying = true;
        this.exTicker.resume();
        if (this.onStartListener != null) {
            this.onStartListener.onStart();
        }
        if (!this.isRendered) {
            this.sendRenderStart();
        }
    }

    @Override
    public void pause() {
        DebugLog.i(TAG, "pause");
        this.setCurrentState(4);
        this.isPlaying = false;
        this.exTicker.pause();
        if (this.onPauseListener != null) {
            this.onPauseListener.onPause();
        }
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public int getCurrentPosition() {
        return this.exTicker.getTickCount() * 1000;
    }

    @Override
    public int getCurrentPositionUnsafe() {
        return this.exTicker.getTickCount() * 1000;
    }

    @Override
    public void seekTo(int n2) {
        this.exTicker.seekto(n2 / 1000);
        if (this.onSeekCompleteListener != null) {
            this.onSeekCompleteListener.onSeekComplete();
        }
    }

    @Override
    public void seekTo(int n2, boolean bl) {
        this.exTicker.seekto(n2 / 1000);
        if (this.onSeekCompleteListener != null) {
            this.onSeekCompleteListener.onSeekComplete();
        }
    }

    @Override
    public boolean isPlaying() {
        return this.isPlaying;
    }

    @Override
    public int getBufferingPercentage() {
        return 0;
    }

    @Override
    public int getTotalBuffering() {
        return 0;
    }

    @Override
    public long getBufferedPositionMs() {
        return 0L;
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared;
    }

    @Override
    public boolean isRendered() {
        return this.isRendered;
    }

    @Override
    public boolean isCompletion() {
        return false;
    }

    private void resetData() {
        this.setCurrentState(0);
        this.isPrepared = false;
        this.isPlaying = false;
        this.isRendered = false;
        this.exTicker.stop();
    }

    @Override
    public void stop() {
        DebugLog.i(TAG, "stop");
        this.resetData();
    }

    @Override
    public void reset() {
        DebugLog.i(TAG, "reset");
        this.resetData();
    }

    @Override
    public void resetRender() {
    }

    @Override
    public void release() {
        DebugLog.i(TAG, "release");
        this.resetData();
    }

    @Override
    public void setReadDataSourceType(int n2) {
    }

    @Override
    public int getReadDataSourceType() {
        return 0;
    }

    private void sendPrepared() {
        DebugLog.i(TAG, "sendPrepared in");
        this.setCurrentState(2);
        this.isPrepared = true;
        if (this.onPreparedListener != null) {
            DebugLog.i(TAG, "sendPrepared");
            this.onPreparedListener.onPrepared();
        }
    }

    private void sendRenderStart() {
        this.isRendered = true;
        ThreadUtil.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                FakeVideoView.this.exTicker.start();
                FakeVideoView.this.exTicker.setCallback(new ExTicker.onTickListener(){

                    @Override
                    public void onTick(int n2) {
                    }
                });
                if (FakeVideoView.this.onInfoListener != null) {
                    DebugLog.i(FakeVideoView.TAG, "sendRenderStart in");
                    FakeVideoView.this.onInfoListener.onInfo(900, 0);
                }
            }
        });
    }

    @Override
    public void setVideoPath(@NonNull String string) {
        DebugLog.i(TAG, "setVideoPath path:" + string);
        this.setCurrentState(1);
        this.sendPrepared();
    }

    @Override
    public void resetVideoPath(@NonNull String string) {
        DebugLog.i(TAG, "resetVideoPath path:" + string);
        this.sendPrepared();
    }

    @Override
    public void setVideoPath(@NonNull String string, @Nullable IP2pTask iP2pTask, @Nullable String string2) {
        DebugLog.i(TAG, "setVideoPath path:" + string);
        this.sendPrepared();
    }

    @Override
    public void setAudioPath(@NonNull String string) {
        this.setCurrentState(1);
        this.sendPrepared();
    }

    @Override
    public boolean isOnlyAudioMode() {
        return false;
    }

    @Override
    public void resetVideoPath(@NonNull String string, @Nullable IP2pTask iP2pTask, @Nullable String string2) {
        DebugLog.i(TAG, "resetVideoPath path:" + string);
        this.sendPrepared();
    }

    @Override
    public void setVideoDataSource(MgtvPlayerDataSource mgtvPlayerDataSource) {
    }

    @Override
    public void setTimeout(int n2, int n3) {
    }

    @Override
    public void setConnectTimeOut(int n2) {
    }

    @Override
    public void setReciveDataTimeOut(int n2) {
    }

    @Override
    public void setBufferTimeout(int n2) {
    }

    @Override
    public void setOnPreparedListener(IVideoView.OnPreparedListener onPreparedListener) {
        this.onPreparedListener = onPreparedListener;
    }

    @Override
    public void setOnCompletionListener(IVideoView.OnCompletionListener onCompletionListener) {
    }

    @Override
    public void setOnSeekCompleteListener(IVideoView.OnSeekCompleteListener onSeekCompleteListener) {
        this.onSeekCompleteListener = onSeekCompleteListener;
    }

    @Override
    public void setOnErrorListener(IVideoView.OnErrorListener onErrorListener) {
    }

    @Override
    public void setOnInfoListener(IVideoView.OnInfoListener onInfoListener) {
        this.onInfoListener = onInfoListener;
    }

    @Override
    public void setOnStartListener(IVideoView.OnStartListener onStartListener) {
        this.onStartListener = onStartListener;
    }

    @Override
    public void setOnPauseListener(IVideoView.OnPauseListener onPauseListener) {
        this.onPauseListener = onPauseListener;
    }

    @Override
    public void setSurfaceHolderListener(IVideoView.SurfaceHolderListener surfaceHolderListener) {
    }

    @Override
    public void setOnBufferingUpdateListener(IVideoView.OnBufferingUpdateListener onBufferingUpdateListener) {
    }

    @Override
    public void setOnWarningListener(MgtvPlayerListener.OnWarningListener onWarningListener) {
    }

    @Override
    public void setOnChangeSourceListener(IVideoView.OnChangeSourceListener onChangeSourceListener) {
    }

    @Override
    public void setOnRecordListener(IVideoView.OnRecordListener onRecordListener) {
    }

    @Override
    public void setOnUpdateStatusListener(IVideoView.OnUpdateStatusListener onUpdateStatusListener) {
        this.onUpdateStatusListener = onUpdateStatusListener;
    }

    private void sendUpdateStatus() {
        if (this.onUpdateStatusListener != null) {
            this.onUpdateStatusListener.onUpdateStatus();
        }
    }

    @Override
    public void setOnVideoSizeChangedListener(IVideoView.OnVideoSizeChangedListener onVideoSizeChangedListener) {
    }

    @Override
    public void setOnLoadDataListener(IVideoView.OnLoadDataListener onLoadDataListener) {
    }

    @Override
    public void setOnFrameListener(IVideoView.OnFrameListener onFrameListener) {
    }

    @Override
    public void setOnAVPlayListener(IVideoView.OnAVPlayListener onAVPlayListener) {
    }

    @Override
    public void setOnSwitchSmoothSourceListener(IVideoView.OnSwitchSmoothSourceListener onSwitchSmoothSourceListener) {
    }

    @Override
    public void setOnInfoStringListener(IVideoView.OnInfoStringListener onInfoStringListener) {
    }

    @Override
    public void setOnEventInfoListener(IVideoView.OnEventInfoListener onEventInfoListener) {
    }

    @Override
    public void setNETIsBroken(boolean bl) {
    }

    @Override
    public void setVideoFrameClockNotifyMs(int n2) {
    }

    @Override
    public void setVideoFrameClockNotifyPts(long l2, long l3) {
    }

    @Override
    public void addVideoPTSListener(MgtvPlayerListener.OnVideoPTSListener onVideoPTSListener) {
    }

    @Override
    public void removeVideoPTSListener(MgtvPlayerListener.OnVideoPTSListener onVideoPTSListener) {
    }

    @Override
    public void setLoopSeekPlay(boolean bl, int n2) {
    }

    @Override
    public void setPlayerDebug(boolean bl) {
    }

    @Override
    public void setPlayerHardwareMode(boolean bl) {
    }

    @Override
    public void setForceDecodeMode(boolean bl) {
    }

    @Override
    public boolean isHardware() {
        return true;
    }

    @Override
    public void setPlayerAudioMode(boolean bl) {
    }

    @Override
    public String getPlayerVersion() {
        return "Fake1.0";
    }

    @Override
    public int getVideoWidth() {
        return 1920;
    }

    @Override
    public int getVideoHeight() {
        return 1080;
    }

    @Override
    public int getBitRate() {
        return 0;
    }

    @Override
    public int getFPS() {
        return 0;
    }

    @Override
    public String getErrorMsg() {
        return "";
    }

    @Override
    public String getErrorUrl() {
        return "";
    }

    @Override
    public void setZOrderMediaOverlay(boolean bl) {
    }

    @Override
    public void cleanUri() {
    }

    @Override
    public void setRenderViewVisible(int n2) {
    }

    @Override
    public void setStreamKey(int n2) {
    }

    @Override
    public void setVideoIntroduction(String string) {
    }

    @Override
    public boolean isImgoSourceModuleOpen() {
        return false;
    }

    @Override
    public void openImgoDSModule(boolean bl) {
    }

    @Override
    public void changeSourceAsync(String string, int n2, int n3, int n4) {
    }

    @Override
    public void changeSourceAsync(IVideoView.MediaSource mediaSource, int n2, int n3, int n4) {
    }

    @Override
    public void resumeLoadData() {
    }

    @Override
    public void pauseLoadData() {
    }

    @Override
    public void setPlaybackSpeed(float f2) {
    }

    @Override
    public float getPlaybackSpeed() {
        return 0.0f;
    }

    @Override
    public void useSystemPlayer(boolean bl) {
    }

    @Override
    public void reBindTexture() {
    }

    @Override
    public boolean isSupportedSnapshot() {
        return false;
    }

    @Override
    public Bitmap getSnapshot(int n2, int n3) {
        return null;
    }

    @Override
    public void setAccurateSeekEnable(boolean bl) {
    }

    @Override
    public boolean isAccurateSeekEnable() {
        return false;
    }

    @Override
    public String getDLSpeedFormat() {
        return null;
    }

    @Override
    public int getDLSpeedB() {
        return 0;
    }

    @Override
    public void setNetAddrinfo(int n2, int n3) {
    }

    @Override
    public void setNetAddrinfo(int n2, int n3, boolean bl) {
    }

    @Override
    public void setNetAddrinfo(String string, int n2, boolean bl) {
    }

    @Override
    public void setLastFrameRecovery(boolean bl) {
    }

    @Override
    public void setReportParams(ReportParams reportParams) {
    }

    @Override
    public void configTsNotSkip(boolean bl) {
    }

    @Override
    public void configLoadMaxRetryTime(int n2) {
    }

    @Override
    public void configWeakNetSpeed(int n2) {
    }

    @Override
    public void configWeakBufferTimeout(int n2) {
    }

    @Override
    public void nativeCrashTest(int n2) {
    }

    @Override
    public void setM3u8Caches(String string, String[] stringArray) {
    }

    @Override
    public void enableM3u8Cache(boolean bl) {
    }

    @Override
    public void setVolume(float f2, float f3) {
    }

    @Override
    public float getLeftVolume() {
        return 0.0f;
    }

    @Override
    public float getRightVolume() {
        return 0.0f;
    }

    @Override
    public boolean isDataLoadPaused() {
        return false;
    }

    @Override
    public int getCurrentStatus() {
        return this.mCurrentState;
    }

    @Override
    public void enableCoreStartPauseListen(boolean bl) {
    }

    @Override
    public void setDataSourceInfo(MgtvMediaPlayer.DataSourceInfo dataSourceInfo) {
    }

    @Override
    public void setScreenOnWhilePlaying(boolean bl) {
    }

    @Override
    public String getLogTagKey() {
        return this.hashCode() + "";
    }

    @Override
    public void startRecord(String string) {
    }

    @Override
    public void stopRecord() {
    }

    @Override
    public boolean isRecording() {
        return false;
    }

    @Override
    public GifRecorder getGifRecorder() {
        return new GifRecorder();
    }

    @Override
    public void setSecure(boolean bl) {
    }

    @Override
    public View getRenderView() {
        return null;
    }

    @Override
    public DebugPanel showDebugPanel(boolean bl) {
        return null;
    }

    @Override
    @Nullable
    public MgtvMediaPlayer.PlayerExtraInfo getPlayerExtraInfo() {
        return new MgtvMediaPlayer.PlayerExtraInfo();
    }

    @Override
    public void setAspectRatio(int n2) {
    }

    @Override
    public void setRenderFilter(IVideoView.RenderFilter renderFilter) {
    }

    @Override
    public IVideoView.RenderFilter getRenderFilter() {
        return null;
    }

    @Override
    public void setLiveMode(boolean bl) {
    }

    @Override
    public void setLiveStartIndex(int n2) {
    }

    @Override
    public void setLiveReopen() {
    }

    @Override
    public void resume() {
    }

    @Override
    public int getAddrInfoTypeInt() {
        return 0;
    }

    @Override
    public void setStartPosMs(int n2) {
        this.exTicker.seekto(n2 / 1000);
    }

    @Override
    public void setFileStartTimeFloatS(float f2) {
    }

    @Override
    public float getFileStartTimeFloatS() {
        return 0.0f;
    }

    @Override
    public int getMemoryPlayType() {
        return 0;
    }

    @Override
    public String getLastErrorTypeCode() {
        return "";
    }

    @Override
    public FlowDataStatistic getFlowDataStatistic() {
        return new FlowDataStatistic();
    }

    @Override
    public void setFlowDataStatistic(FlowDataStatistic flowDataStatistic) {
    }

    @Override
    public void configDataCacheSizeKB(int n2) {
    }

    @Override
    public void setSkipLoopFilter(MgtvMediaPlayer.SkipLoopFilterType skipLoopFilterType) {
    }

    @Override
    public void enableTsSkipError(boolean bl) {
    }

    @Override
    public boolean isTsSkipErrorEnable() {
        return false;
    }

    @Override
    public void convertRender(int n2) {
    }

    @Override
    public int getRenderViewType() {
        return 0;
    }

    @Override
    public void setPrepared4StartMode(MgtvMediaPlayer.Prepared4StartMode prepared4StartMode) {
    }

    @Override
    public MgtvMediaPlayer.Prepared4StartMode getPrepared4StartMode() {
        return MgtvMediaPlayer.Prepared4StartMode.MODE_PREPARED4START_LOADDATA;
    }

    @Override
    public boolean isForceHttpDns() {
        return false;
    }

    @Override
    public void setForceHttpDns(boolean bl) {
    }

    @Override
    public void setEnableVideoStartTime(boolean bl) {
    }

    @Override
    public String getLogTag() {
        return "[" + this.getLogTagKey() + "][" + this.getClass().getSimpleName() + "]";
    }

    @Override
    public void setAntiViewShake(boolean bl) {
    }

    @Override
    public boolean isAntiViewShake() {
        return false;
    }

    @Override
    public void setDnsFamilyType(int n2) {
    }

    @Override
    public int getDnsFamilyType() {
        return 0;
    }

    @Override
    public void setAMCKeyFrameBackMode(int n2) {
    }

    @Override
    public boolean isSupportAMCKeyFrameBackup() {
        return false;
    }

    @Override
    public int getAMCKeyFrameBackMode() {
        return 0;
    }

    @Override
    public String getVideoPath() {
        return "";
    }

    @Override
    public String getVideoProxyPath() {
        return "";
    }

    @Override
    public void setNetPlayConfig(NetPlayConfig netPlayConfig) {
    }

    @Override
    public MgtvMediaPlayer.DataSourceType getDataSourceType() {
        return null;
    }

    @Override
    public void setDisplayFloatRect(IMgtvRenderView.FloatRect floatRect) {
    }

    @Override
    public IMgtvRenderView.FloatRect getDisplayFloatRect() {
        return new IMgtvRenderView.FloatRect();
    }

    @Override
    public IVideoView.Size getRenderViewSize() {
        return new IVideoView.Size();
    }

    @Override
    public boolean setLoopABPlay(boolean bl, MgtvAbstractVideoView.ABRegion aBRegion) {
        return false;
    }

    @Override
    public MgtvAbstractVideoView.ABRegion getABRegion() {
        return null;
    }

    @Override
    public void setMgtvFastMode(int n2) {
    }

    @Override
    public void setMediacodecRecreateformat(boolean bl, boolean bl2) {
    }

    @Override
    public int getMgtvFastMode() {
        return 0;
    }

    @Override
    public void stepPlaybackNextFrame() {
    }

    @Override
    public void enableFramePTSNotify(boolean bl) {
    }

    @Override
    public long getPropertyLong(int n2, long l2) {
        return 0L;
    }

    @Override
    public int setKeyInfoData(byte[] byArray, int n2, int n3) {
        return 0;
    }

    @Override
    public int setKeyInfoData(String string) {
        return 0;
    }

    @Override
    public int setSmoothKeyFrameInfo(byte[] byArray, String string, String string2) {
        return 0;
    }

    @Override
    public byte[] getKeyInfoData() {
        return new byte[0];
    }

    @Override
    public boolean isKeyInfoDataSet() {
        return false;
    }

    @Override
    public void setPreBufferTimeoutMs(int n2) {
    }

    @Override
    public void setDrmLicensePrepared() {
    }

    @Override
    public void bindDrmSession(IDrmSession iDrmSession) {
    }

    @Override
    public String getLastIP() {
        return null;
    }

    @Override
    public void setSeekAutoStartAfterComplete(boolean bl) {
    }

    @Override
    public int setWanosAudioEffectConfig(byte[] byArray) {
        return 0;
    }

    @Override
    public boolean isWanosAudioEffectValid() {
        return false;
    }

    @Override
    public void setEnableWanosAudioEffect(boolean bl) {
    }

    @Override
    public void setWanosAudioEffectChoice(int n2) {
    }

    @Override
    public int getWanosAudioEffectChoice() {
        return 0;
    }

    @Override
    public void setSmoothSwitchMode(int n2) {
    }

    @Override
    public boolean isSmoothSwitchOpen() {
        return false;
    }

    @Override
    public void switchSmoothSource(SmoothMediaSource smoothMediaSource) {
    }

    @Override
    public void startAVDecoder() {
    }

    @Override
    public MgtvMediaPlayer getMediaPlayer() {
        return null;
    }

    @Override
    public Uri getCurrentUri() {
        return null;
    }

    @Override
    public void setBackPlayEnable(boolean bl) {
    }

    @Override
    public boolean isBackPlayEnable() {
        return false;
    }

    @Override
    public void enableOppoFunc(int n2, boolean bl) {
    }

    @Override
    public void enableMediaCodecSW(boolean bl) {
    }

    @Override
    public boolean isMediaCodecSWEnable() {
        return false;
    }

    @Override
    public void enableLiveLowLatency(boolean bl) {
    }

    @Override
    public void setTsFlowTag(String string) {
    }

    @Override
    public void setBackground(boolean bl) {
    }

    @Override
    public boolean isBackground() {
        return false;
    }

    @Override
    public void setDisableAudioFocus(boolean bl) {
    }

    @Override
    public void enableImgoVSR(boolean bl) {
    }

    @Override
    public void enableSubtitle(boolean bl) {
    }

    @Override
    public void setSubtitleConfig(SubtitleConfig subtitleConfig) {
    }

    @Override
    public void setSubtitleSource(SubtitleSource subtitleSource) {
    }

    @Override
    public void setSubtitleCallback(ISubtitle.SubtitleCallback subtitleCallback) {
    }

    @Override
    @Nullable
    public SubtitleSource getSubtitleSource() {
        return null;
    }

    @Override
    public void removeSubtitleSource() {
    }
}

