/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.widget;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.CaptioningManager;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import com.hunantv.media.a.a;
import com.hunantv.media.config.NetPlayConfig;
import com.hunantv.media.drm.IDrmSession;
import com.hunantv.media.global.Constants;
import com.hunantv.media.global.PlayerReferenceObserver;
import com.hunantv.media.p2p.IP2pTask;
import com.hunantv.media.player.IMgtvRenderView;
import com.hunantv.media.player.MgtvMediaPlayer;
import com.hunantv.media.player.MgtvPlayerDataSource;
import com.hunantv.media.player.MgtvPlayerListener;
import com.hunantv.media.player.MgtvRenderView;
import com.hunantv.media.player.c;
import com.hunantv.media.player.l;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.smooth.SmoothMediaSource;
import com.hunantv.media.player.subtitle.SubtitleConfig;
import com.hunantv.media.player.subtitle.SubtitleSource;
import com.hunantv.media.player.utils.StringUtil;
import com.hunantv.media.player.utils.ThreadUtil;
import com.hunantv.media.report.ReportParams;
import com.hunantv.media.utils.AudioUtil;
import com.hunantv.media.utils.FileUtil;
import com.hunantv.media.utils.KeyFrameInfoUtils;
import com.hunantv.media.utils.ViewUtil;
import com.hunantv.media.widget.ISubtitle;
import com.hunantv.media.widget.IVideoView;
import com.hunantv.media.widget.debug.DebugPanel;
import com.hunantv.media.widget.extra.SubtitleView;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MgtvAbstractVideoView
extends FrameLayout
implements IVideoView {
    public static final int INVALID_FILE_START_TIME_VALUE = -1;
    MgtvMediaPlayer mMediaPlayer = null;
    int mRenderViewType = 0;
    MgtvMediaPlayer.Prepared4StartMode mPrepared4StartMode = MgtvMediaPlayer.Prepared4StartMode.MODE_PREPARED4START_DEFAULT;
    boolean mForceHttpDns;
    boolean mEnableVideoStartTime;
    float mFileStartTimeFloatS = -1.0f;
    boolean mAntiViewShake;
    int mDnsFamilyType = 1;
    boolean mKeyInfoSetEnable = true;
    boolean mKeyInfoSet;
    int mKeyInfoSetLayer = 0;
    byte[] mKeyInfoData;
    int mKeyInfoRet;
    Uri mCurrentUri = null;
    Uri mProxyUri;
    IP2pTask mMainP2pTask;
    c mFakeFrameView;
    MgtvRenderView mRenderView;
    l mResizableFrameView;
    IDrmSession mDrmSession;
    IDrmSession.OnProvisionSuccessListener mOnProvisionSuccessListener = new IDrmSession.OnProvisionSuccessListener(){

        @Override
        public void onSuccess(IDrmSession iDrmSession) {
            MgtvAbstractVideoView.this.mIsDrmPrepared = true;
            if (iDrmSession != null) {
                iDrmSession.setDrmLicensePrepared();
            }
        }
    };
    IMgtvRenderView.ISurfaceHolder mSurfaceHolder = null;
    boolean mIsSubtitleEnable;
    FrameLayout mDecorateLayout;
    SubtitleView mSubtitleView;
    SubtitleSource mSubtitleSource;
    ISubtitle.SubtitleCallback mOnSubtitleCallback;
    IVideoView.Configuration mConfiguration;
    boolean mForceReuseTexture = false;
    boolean mEnableTexture = true;
    int mAMCKeyFrameBackMode = -1;
    boolean mEnableMediacodecSW = false;
    Context mContext;
    volatile boolean mAudioFocusObtained = false;
    NetPlayConfig mNetPlayConfig;
    int mConnectTimeOut;
    int mReciveDataTimeOut;
    MgtvMediaPlayer.DataSourceType mDataSourceType = MgtvMediaPlayer.DataSourceType.TYPE_DATASOUCE_DEFAULT;
    IMgtvRenderView.FloatRect mDisplayFloatRect;
    int mMgtvFastMode = 1;
    boolean mMediacodecRecreateformat = false;
    boolean mMediacodecRecreateformatOnly4K = false;
    DebugPanel mDebugPanel;
    boolean mEnableDefaultFileStartTime = true;
    static boolean sAutoNativeStack = true;
    ReportParams mReportParams;
    MgtvMediaPlayer.DataSourceInfo mDataSourceInfo = new MgtvMediaPlayer.DataSourceInfo().setVideoFormat("init").setFileFormat("init").setBitRate("0");
    private int mPreBufferTimeoutMs;
    boolean mSeekAutoStartAfterCompleteEnable = false;
    int mAddrInfoTimeoutMs;
    boolean mJavaDnsEnable = false;
    boolean mIsDrmPrepared;
    int mSmoothSwitchMode;
    boolean mSmoothModeSwitch;
    boolean mSmoothModeOpen;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_ONLY_AUDIO = 1;
    int mLastMediaMode = 0;
    boolean mBackPlayEnable = false;
    String mVideoIntroduction = "";
    private boolean mLiveLowLatencyEnable = false;
    private byte[] mAudioEffectConfig;
    String tsFlowTag;
    float mLeftVolume = -1.0f;
    float mRightVolume = -1.0f;
    int mReadDataSourceTypeConfig = 0;
    MgtvPlayerDataSource mDataSource;
    IVideoView.OnFrameListener mOnFrameListener;
    IVideoView.OnAVPlayListener mOnAVPlayListener;
    IVideoView.OnSwitchSmoothSourceListener mOnSwitchSmoothSourceListener;
    IVideoView.OnInfoStringListener mOnInfoStringListener;
    private MgtvPlayerListener.OnAVPlayListener mAVPlayListener = new MgtvPlayerListener.OnAVPlayListener(){

        @Override
        public void onAVPauseOrPlay(boolean bl) {
            if (MgtvAbstractVideoView.this.mOnAVPlayListener != null) {
                MgtvAbstractVideoView.this.mOnAVPlayListener.onAVPauseOrPlay(bl);
            }
        }
    };
    private MgtvPlayerListener.OnFrameListener mFrameListener = new MgtvPlayerListener.OnFrameListener(){

        @Override
        public void onVFrameClockCome(MgtvPlayerListener.FrameClock frameClock) {
            if (MgtvAbstractVideoView.this.mOnFrameListener != null) {
                MgtvAbstractVideoView.this.mOnFrameListener.onVFrameClockCome(frameClock);
            }
        }
    };
    private MgtvPlayerListener.OnSwitchSmoothSourceListener mSwitchSmoothSourceListener = new MgtvPlayerListener.OnSwitchSmoothSourceListener(){

        @Override
        public boolean onSwitchSmoothSourceWillUpdate(SmoothMediaSource smoothMediaSource) {
            if (MgtvAbstractVideoView.this.mOnSwitchSmoothSourceListener != null) {
                return MgtvAbstractVideoView.this.mOnSwitchSmoothSourceListener.onSwitchSmoothSourceWillUpdate(smoothMediaSource);
            }
            return false;
        }

        @Override
        public void onSwitchSmoothSourceInfo(SmoothMediaSource smoothMediaSource, int n2) {
            if (MgtvAbstractVideoView.this.mOnSwitchSmoothSourceListener != null) {
                MgtvAbstractVideoView.this.mOnSwitchSmoothSourceListener.onSwitchSmoothSourceInfo(smoothMediaSource, n2);
            }
        }

        @Override
        public void onSwitchSmoothSourceSuccess(SmoothMediaSource smoothMediaSource) {
            if (smoothMediaSource != null) {
                MgtvAbstractVideoView.this.mCurrentUri = StringUtil.isEmpty(smoothMediaSource.getUrl()) ? null : Uri.parse((String)smoothMediaSource.getUrl().trim());
                MgtvAbstractVideoView.this.mProxyUri = StringUtil.isEmpty(smoothMediaSource.getProxyUrl()) ? null : Uri.parse((String)smoothMediaSource.getProxyUrl().trim());
                MgtvAbstractVideoView.this.mMainP2pTask = smoothMediaSource.getP2pTask();
            }
            DebugLog.i(MgtvAbstractVideoView.this.getLogTag(), "onSwitchSmoothSourceSuccess then change media mode");
            if (smoothMediaSource.getSwitchMod() == 1) {
                MgtvAbstractVideoView.this.setLastMediaMode(1);
            } else {
                MgtvAbstractVideoView.this.setLastMediaMode(0);
            }
            if (MgtvAbstractVideoView.this.mOnSwitchSmoothSourceListener != null) {
                MgtvAbstractVideoView.this.mOnSwitchSmoothSourceListener.onSwitchSmoothSourceSuccess(smoothMediaSource);
            }
        }

        @Override
        public void onSwitchSmoothSourceFail(SmoothMediaSource smoothMediaSource, int n2, int n3) {
            if (MgtvAbstractVideoView.this.mOnSwitchSmoothSourceListener != null) {
                MgtvAbstractVideoView.this.mOnSwitchSmoothSourceListener.onSwitchSmoothSourceFail(smoothMediaSource, n2, n3);
            }
        }

        @Override
        public void onSwitchSmoothSourceError(SmoothMediaSource smoothMediaSource, int n2, int n3) {
            if (MgtvAbstractVideoView.this.mOnSwitchSmoothSourceListener != null) {
                MgtvAbstractVideoView.this.mOnSwitchSmoothSourceListener.onSwitchSmoothSourceError(smoothMediaSource, n2, n3);
            }
        }
    };
    private MgtvPlayerListener.OnInfoStringListener mInfoStringListener = new MgtvPlayerListener.OnInfoStringListener(){

        @Override
        public boolean onInfo(int n2, String string) {
            switch (n2) {
                case 2860: {
                    DebugLog.i(MgtvAbstractVideoView.this.getLogTag(), "MEDIA_INFO_SEI_SYS_TIMESTAMP: " + string);
                    break;
                }
                case 2870: {
                    DebugLog.i(MgtvAbstractVideoView.this.getLogTag(), "MEDIA_INFO_VIDEO_STREAM_CODEC_INFO: " + string);
                    if (MgtvAbstractVideoView.this.mMediaPlayer == null || !MgtvAbstractVideoView.this.mMediaPlayer.isHDR() || MgtvAbstractVideoView.this.mRenderViewType == 0) break;
                    DebugLog.i(MgtvAbstractVideoView.this.getLogTag(), "MEDIA_INFO_VIDEO_STREAM_CODEC_INFO check the source is HDR. try to change to surfaceview");
                    ThreadUtil.postOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MgtvAbstractVideoView.this.toggleRenders(0);
                        }
                    });
                    break;
                }
                default: {
                    DebugLog.i(MgtvAbstractVideoView.this.getLogTag(), "OnInfoStringListener what: " + n2 + ", extra is " + string);
                }
            }
            if (MgtvAbstractVideoView.this.mOnInfoStringListener != null) {
                MgtvAbstractVideoView.this.mOnInfoStringListener.onInfo(n2, string);
            }
            return false;
        }
    };
    private ISubtitle.SubtitleCallback mSubtitleCallback = new ISubtitle.SubtitleCallback(){

        @Override
        public void onSuccess(SubtitleSource subtitleSource) {
            if (MgtvAbstractVideoView.this.mOnSubtitleCallback != null) {
                MgtvAbstractVideoView.this.mOnSubtitleCallback.onSuccess(subtitleSource);
            }
        }

        @Override
        public void onError(SubtitleSource subtitleSource) {
            if (MgtvAbstractVideoView.this.mOnSubtitleCallback != null) {
                if (subtitleSource.getErrorResult().code == 0) {
                    subtitleSource.getErrorResult().code = -1;
                }
                MgtvAbstractVideoView.this.mOnSubtitleCallback.onError(subtitleSource);
            }
        }
    };
    IVideoView.OnEventInfoListener mOnEventInfoListener;
    private MgtvPlayerListener.OnPlayerEventListener mPlayerEventListener = new MgtvPlayerListener.OnPlayerEventListener(){

        @Override
        public void onInfo(int n2, int n3) {
            DebugLog.d(MgtvAbstractVideoView.this.getLogTag(), "OnPlayerEventListener what:" + n2 + "-extra:" + n3);
            if (MgtvAbstractVideoView.this.mOnEventInfoListener != null) {
                MgtvAbstractVideoView.this.mOnEventInfoListener.onInfo(n2, n3);
            }
        }
    };
    public int mInitRenderViewType = 0;
    boolean mLoopABPlayEnable;
    ABRegion mABRegion;
    Set<MgtvPlayerListener.OnVideoPTSListener> ptsListeners = new HashSet<MgtvPlayerListener.OnVideoPTSListener>();
    Object ptsLocker = new Object();
    public boolean isBackground = false;
    AtomicInteger mSurfaceKeyGen = new AtomicInteger(10);
    boolean isRequestAudioFocus = true;

    public MgtvAbstractVideoView(Context context) {
        super(context);
        this.init(context);
    }

    public MgtvAbstractVideoView(Context context, IVideoView.Configuration configuration) {
        super(context);
        this.init(context);
        this.mConfiguration = configuration;
        if (configuration != null) {
            this.mForceReuseTexture = configuration.forceReuseTexture;
        }
    }

    public MgtvAbstractVideoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public MgtvAbstractVideoView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.mDecorateLayout = new FrameLayout(context);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
        this.mDecorateLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mDecorateLayout.setVisibility(8);
    }

    boolean isReuseTextureDisable() {
        return this.mForceReuseTexture && !this.mEnableTexture;
    }

    protected void configAudioImgoPlayer() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setPreBufferTimeoutMs(this.mPreBufferTimeoutMs);
            this.mMediaPlayer.setPrepared4StartMode(this.mPrepared4StartMode);
            this.mMediaPlayer.setForceHttpDns(this.mForceHttpDns);
            this.mMediaPlayer.setDnsFamilyType(this.mDnsFamilyType);
            this.mMediaPlayer.setNetPlayConfig(this.mNetPlayConfig);
            this.mMediaPlayer.setMgtvFastMode(this.mMgtvFastMode);
            this.mMediaPlayer.setDataSourceInfo(this.mDataSourceInfo);
            this.setLoopABPlay(this.mLoopABPlayEnable, this.mABRegion);
            this.mMediaPlayer.setTsFlowTag(this.tsFlowTag);
            this.setBackground(this.isBackground);
            this.mMediaPlayer.setWanosAudioEffectConfig(this.mAudioEffectConfig);
            DebugLog.i(this.getLogTag(), "configImgoPlayer -mPrepared4StartMode:" + (Object)((Object)this.mPrepared4StartMode) + "-mForceHttpDns:" + this.mForceHttpDns + "-mEnableVideoStartTime:" + this.mEnableVideoStartTime + "-mDnsFamilyType:" + this.mDnsFamilyType + "-mAMCKeyFrameBackMode:" + this.mAMCKeyFrameBackMode + "-mFileStartTimeFloatS:" + this.mFileStartTimeFloatS + "-mMgtvFastMode:" + this.mMgtvFastMode + "-mDataSourceInfo:" + this.mDataSourceInfo + "-mPreBufferTimeoutMs:" + this.mPreBufferTimeoutMs + "-isBackground:" + this.isBackground);
        }
    }

    public void toggleRenders(int n2) {
        this.mRenderViewType = n2;
    }

    public void beforeOpenVideo() {
        try {
            boolean bl;
            boolean bl2 = bl = this.mVideoIntroduction != null && this.mVideoIntroduction.matches("FFF2[0-9]222") || this.mReportParams != null && this.mReportParams.getSvds() != null && this.mReportParams.getSvds().matches("FFF2[0-9]222");
            if (this.mRenderViewType != 0 && bl) {
                DebugLog.i(this.getLogTag(), "beforeOpenVideo check the source is HDR. try to change to surfaceview");
                this.toggleRenders(0);
            } else if (!bl && this.mInitRenderViewType != this.mRenderViewType) {
                DebugLog.i(this.getLogTag(), "beforeOpenVideo check the source is not HDR. recovery renderview to " + this.mInitRenderViewType);
                this.toggleRenders(this.mInitRenderViewType);
            }
            if (this.mReportParams != null) {
                this.mReportParams.setRenvtp(this.mRenderViewType == 1 ? 1 : 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void configImgoPlayer() {
        if (this.isReuseTextureDisable()) {
            this.mAMCKeyFrameBackMode = 2;
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setPreBufferTimeoutMs(this.mPreBufferTimeoutMs);
            if (this.mIsSubtitleEnable && this.mSubtitleSource != null) {
                try {
                    this.mMediaPlayer.addSubtitleSource(this.mSubtitleView, this.mSubtitleSource);
                }
                catch (Exception exception) {
                    this.mSubtitleCallback.onError(this.mSubtitleSource);
                }
            }
            this.mMediaPlayer.setPrepared4StartMode(this.mPrepared4StartMode);
            if (this.mPrepared4StartMode == MgtvMediaPlayer.Prepared4StartMode.MODE_PREPARED4START_LOADDATA_DISAV) {
                this.mMediaPlayer.setDisableAVDecoderStart(true);
            } else {
                this.mMediaPlayer.setDisableAVDecoderStart(false);
            }
            this.mMediaPlayer.setForceHttpDns(this.mForceHttpDns);
            this.mMediaPlayer.setEnableVideoStartTime(this.mEnableVideoStartTime);
            this.mMediaPlayer.setDnsFamilyType(this.mDnsFamilyType);
            if (this.mAMCKeyFrameBackMode >= 0) {
                this.mMediaPlayer.setAMCKeyFrameBackMode(this.mAMCKeyFrameBackMode);
            }
            if (!Constants.FOR_OTT && NetPlayConfig.isCodecSWRenderOpen() && this.mReportParams != null && (this.mReportParams.getVideoType() == ReportParams.VideoType.IMMERSIVE || this.mReportParams.getVideoType() == ReportParams.VideoType.VOD)) {
                this.mEnableMediacodecSW = true;
            }
            this.mMediaPlayer.setEnableMediacodecSWRender(this.mEnableMediacodecSW);
            this.mMediaPlayer.setMarkMediacodecSWRender(NetPlayConfig.isCodecSWRenderMark());
            this.mMediaPlayer.setNetPlayConfig(this.mNetPlayConfig);
            this.mMediaPlayer.setMgtvFastMode(this.mMgtvFastMode);
            this.mMediaPlayer.setMediacodecRecreateformat(this.mMediacodecRecreateformat, this.mMediacodecRecreateformatOnly4K);
            if (this.mFileStartTimeFloatS == -1.0f && this.mEnableDefaultFileStartTime && this.mDataSourceInfo != null) {
                if ("h265".equalsIgnoreCase(this.mDataSourceInfo.getVideoFormat())) {
                    this.mFileStartTimeFloatS = 0.08f;
                } else if ("h264".equalsIgnoreCase(this.mDataSourceInfo.getVideoFormat())) {
                    this.mFileStartTimeFloatS = 1.48f;
                }
            }
            this.mMediaPlayer.setPlayerFileStartTimeFloatS(this.mFileStartTimeFloatS);
            if (this.mKeyInfoSet && this.mKeyInfoRet == 0) {
                this.setKeyInfoDataInner(this.mKeyInfoData);
            }
            this.mMediaPlayer.setDataSourceInfo(this.mDataSourceInfo);
            this.mMediaPlayer.bindDrmSession(this.mDrmSession);
            if (this.mIsDrmPrepared && this.mDrmSession != null) {
                this.mDrmSession.setDrmLicensePrepared();
            }
            this.setLoopABPlay(this.mLoopABPlayEnable, this.mABRegion);
            this.mMediaPlayer.setSeekAutoStartAfterComplete(this.mSeekAutoStartAfterCompleteEnable);
            this.enableLiveLowLatency(this.mLiveLowLatencyEnable);
            this.mMediaPlayer.setTsFlowTag(this.tsFlowTag);
            this.setBackground(this.isBackground);
            this.mMediaPlayer.setWanosAudioEffectConfig(this.mAudioEffectConfig);
            DebugLog.i(this.getLogTag(), "configImgoPlayer -mPrepared4StartMode:" + (Object)((Object)this.mPrepared4StartMode) + "-mForceHttpDns:" + this.mForceHttpDns + "-mEnableVideoStartTime:" + this.mEnableVideoStartTime + "-mDnsFamilyType:" + this.mDnsFamilyType + "-mAMCKeyFrameBackMode:" + this.mAMCKeyFrameBackMode + "-mFileStartTimeFloatS:" + this.mFileStartTimeFloatS + "-mMgtvFastMode:" + this.mMgtvFastMode + "-mMediacodecRecreateformat:" + this.mMediacodecRecreateformat + "-mMediacodecRecreateformatOnly4K:" + this.mMediacodecRecreateformatOnly4K + "-mDataSourceInfo:" + this.mDataSourceInfo + "-mPreBufferTimeoutMs:" + this.mPreBufferTimeoutMs + "-mLiveLowlantacyEnable:" + this.mLiveLowLatencyEnable + "-tsFlowTag:" + this.tsFlowTag + "-isBackground:" + this.isBackground);
        }
    }

    @Override
    public void setOnEventInfoListener(IVideoView.OnEventInfoListener onEventInfoListener) {
        this.mOnEventInfoListener = onEventInfoListener;
    }

    void initListener(MgtvMediaPlayer mgtvMediaPlayer) {
        if (mgtvMediaPlayer != null) {
            mgtvMediaPlayer.clearVideoPTSListener();
            for (MgtvPlayerListener.OnVideoPTSListener onVideoPTSListener : this.ptsListeners) {
                mgtvMediaPlayer.addVideoPTSListener(onVideoPTSListener);
            }
            mgtvMediaPlayer.setSubtitleCallback(this.mSubtitleCallback);
            mgtvMediaPlayer.setOnFrameListener(this.mFrameListener);
            mgtvMediaPlayer.setOnAVPlayListener(this.mAVPlayListener);
            mgtvMediaPlayer.setOnSwitchSmoothSourceListener(this.mSwitchSmoothSourceListener);
            mgtvMediaPlayer.setOnInfoStringListener(this.mInfoStringListener);
            mgtvMediaPlayer.setOnPlayerEventListener(this.mPlayerEventListener);
        }
    }

    @Override
    public void setPrepared4StartMode(MgtvMediaPlayer.Prepared4StartMode prepared4StartMode) {
        this.mPrepared4StartMode = prepared4StartMode;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setPrepared4StartMode(prepared4StartMode);
        }
    }

    @Override
    public MgtvMediaPlayer.Prepared4StartMode getPrepared4StartMode() {
        return this.mPrepared4StartMode;
    }

    @Override
    public boolean isForceHttpDns() {
        return this.mForceHttpDns;
    }

    @Override
    public void setForceHttpDns(boolean bl) {
        this.mForceHttpDns = bl;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setForceHttpDns(bl);
        }
    }

    @Override
    public void setEnableVideoStartTime(boolean bl) {
        this.mEnableVideoStartTime = bl;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setEnableVideoStartTime(bl);
        }
    }

    @Override
    public void setFileStartTimeFloatS(float f2) {
        this.mFileStartTimeFloatS = f2;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setPlayerFileStartTimeFloatS(this.mFileStartTimeFloatS);
        }
    }

    @Override
    public float getFileStartTimeFloatS() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getFileStartTimeFloatS();
        }
        return this.mFileStartTimeFloatS;
    }

    @Override
    public int getMemoryPlayType() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getMemoryPlayType();
        }
        return 0;
    }

    @Override
    public void setAntiViewShake(boolean bl) {
        this.mAntiViewShake = bl;
        if (this.mRenderView != null) {
            this.mRenderView.setAntiShake(this.mAntiViewShake);
        }
    }

    @Override
    public void enableSubtitle(boolean bl) {
        this.mIsSubtitleEnable = bl;
        if (this.mIsSubtitleEnable) {
            this.addSubtitleView();
            if (this.mDecorateLayout != null) {
                this.mDecorateLayout.setVisibility(0);
            }
        } else {
            this.removeSubtitleSource();
            this.removeSubtitleView();
        }
        if (this.mSubtitleView != null) {
            this.mSubtitleView.setVisible(this.mIsSubtitleEnable);
        }
    }

    @Override
    public void setMediacodecRecreateformat(boolean bl, boolean bl2) {
        DebugLog.i(this.getLogTag(), "setMediacodecRecreateformat:" + bl + ",only_4k:" + bl2);
        this.mMediacodecRecreateformat = bl;
        this.mMediacodecRecreateformatOnly4K = bl2;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setMediacodecRecreateformat(bl, bl2);
        }
    }

    @Override
    public void setSubtitleConfig(SubtitleConfig subtitleConfig) {
        if (this.mSubtitleView != null) {
            this.mSubtitleView.setSubtitleConfig(subtitleConfig);
        }
    }

    @Override
    public void setSubtitleSource(SubtitleSource subtitleSource) {
        if (!this.mIsSubtitleEnable) {
            this.mSubtitleSource.getErrorResult().setCode(-2);
            this.mSubtitleCallback.onError(this.mSubtitleSource);
            return;
        }
        this.removeSubtitleSource();
        this.mSubtitleSource = subtitleSource;
        if (this.mMediaPlayer != null && this.mSubtitleSource != null) {
            try {
                this.mMediaPlayer.addSubtitleSource(this.mSubtitleView, this.mSubtitleSource);
            }
            catch (Exception exception) {
                this.mSubtitleCallback.onError(this.mSubtitleSource);
            }
        }
    }

    @Override
    public void setSubtitleCallback(ISubtitle.SubtitleCallback subtitleCallback) {
        this.mOnSubtitleCallback = subtitleCallback;
    }

    @Override
    @Nullable
    public SubtitleSource getSubtitleSource() {
        return this.mSubtitleSource;
    }

    @Override
    public void removeSubtitleSource() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.removeSubtitleSources();
        }
        if (this.mSubtitleSource != null) {
            this.mSubtitleSource.release();
            this.mSubtitleSource = null;
        }
    }

    void addDecorateLayout() {
        if (this.mDecorateLayout != null && !ViewUtil.isViewExsit((ViewGroup)this, (View)this.mDecorateLayout)) {
            this.addView((View)this.mDecorateLayout);
        }
    }

    void removeDecorateLayout() {
        if (this.mDecorateLayout != null && ViewUtil.isViewExsit((ViewGroup)this, (View)this.mDecorateLayout)) {
            this.removeView((View)this.mDecorateLayout);
        }
    }

    void addSubtitleView() {
        if (!this.mIsSubtitleEnable) {
            return;
        }
        if (this.mSubtitleView == null) {
            this.mSubtitleView = new SubtitleView(this.mContext);
            if (Build.VERSION.SDK_INT >= 19) {
                CaptioningManager captioningManager = (CaptioningManager)this.mContext.getSystemService("captioning");
                a a2 = a.a(captioningManager.getUserStyle());
                if (captioningManager.isEnabled()) {
                    this.mSubtitleView.setStyle(a2);
                    this.mSubtitleView.setUserDefaultTextSize();
                }
            }
        }
        this.mSubtitleView.setVisible(this.mIsSubtitleEnable);
        if (this.mDecorateLayout != null && !ViewUtil.isViewExsit((ViewGroup)this.mDecorateLayout, this.mSubtitleView)) {
            this.mDecorateLayout.addView((View)this.mSubtitleView);
        }
    }

    void removeSubtitleView() {
        if (this.mDecorateLayout != null && this.mSubtitleView != null && ViewUtil.isViewExsit((ViewGroup)this.mDecorateLayout, this.mSubtitleView)) {
            this.mDecorateLayout.removeView((View)this.mSubtitleView);
        }
    }

    @Override
    public boolean isAntiViewShake() {
        return this.mAntiViewShake;
    }

    @Override
    public void setDnsFamilyType(int n2) {
        this.mDnsFamilyType = n2;
    }

    @Override
    public int getDnsFamilyType() {
        return this.mDnsFamilyType;
    }

    @Override
    public void setAMCKeyFrameBackMode(int n2) {
    }

    @Override
    public int getAMCKeyFrameBackMode() {
        return this.mAMCKeyFrameBackMode;
    }

    @Override
    public boolean isSupportAMCKeyFrameBackup() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.isSupportAMCKeyFrameBackup();
        }
        return false;
    }

    @Override
    public String getVideoPath() {
        if (this.mCurrentUri != null) {
            return this.mCurrentUri.toString();
        }
        return null;
    }

    @Override
    public String getVideoProxyPath() {
        if (this.mProxyUri != null) {
            return this.mProxyUri.toString();
        }
        return null;
    }

    @Override
    public void setNetPlayConfig(NetPlayConfig netPlayConfig) {
        this.mNetPlayConfig = netPlayConfig;
        DebugLog.i(this.getLogTag(), "setNetPlayConfig " + netPlayConfig);
        if (netPlayConfig != null) {
            if (netPlayConfig.is_soft >= 0) {
                this.setPlayerHardwareMode(netPlayConfig.is_soft != 1);
            }
            if (netPlayConfig.accurate_seek >= 0) {
                this.setAccurateSeekEnable(netPlayConfig.accurate_seek == 1);
            }
            if (netPlayConfig.ts_not_skip >= 0) {
                this.configTsNotSkip(netPlayConfig.ts_not_skip == 1);
            }
            if (netPlayConfig.load_retry_time >= 0) {
                this.configLoadMaxRetryTime(netPlayConfig.load_retry_time);
            }
            if (netPlayConfig.weak_net_speed >= 0) {
                this.configWeakNetSpeed(netPlayConfig.weak_net_speed);
            }
            int n2 = netPlayConfig.open_timeout * 1000;
            int n3 = netPlayConfig.rw_timeout * 1000;
            int n4 = netPlayConfig.buffer_timeout * 1000;
            if (n2 > 0) {
                this.setConnectTimeOut(n2);
            }
            if (n3 > 0) {
                this.setReciveDataTimeOut(n3);
            }
            if (n4 > 0) {
                this.setBufferTimeout(n4);
            }
            if (netPlayConfig.datasource_async >= 0) {
                this.openImgoDSModule(netPlayConfig.datasource_async == 1);
            }
            if (netPlayConfig.getAddrinfo_type() != null) {
                this.setNetAddrinfo(netPlayConfig.getAddrinfo_type(), netPlayConfig.getAddrinfo_timeout(), false);
            }
            if (netPlayConfig.dns_family_type == 0 || netPlayConfig.dns_family_type == 1) {
                this.setDnsFamilyType(netPlayConfig.dns_family_type == 0 ? 1 : 0);
            }
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setNetPlayConfig(netPlayConfig);
        }
    }

    @Override
    @Deprecated
    public void setAccurateSeekEnable(boolean bl) {
    }

    @Override
    public void configTsNotSkip(boolean bl) {
    }

    @Override
    public void configLoadMaxRetryTime(int n2) {
    }

    @Override
    public void configWeakNetSpeed(int n2) {
    }

    @Override
    public void setTimeout(int n2, int n3) {
    }

    @Override
    public void setConnectTimeOut(int n2) {
        this.mConnectTimeOut = n2;
    }

    @Override
    public void setReciveDataTimeOut(int n2) {
        this.mReciveDataTimeOut = n2;
    }

    @Override
    public void setBufferTimeout(int n2) {
    }

    @Override
    public void openImgoDSModule(boolean bl) {
    }

    @Override
    public MgtvMediaPlayer.DataSourceType getDataSourceType() {
        return this.mDataSourceType;
    }

    @Override
    public void stop() {
        this.stopInner();
    }

    void stopInner() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
        }
    }

    public void requestAudioFocus() {
        if (!this.mAudioFocusObtained) {
            AudioUtil.requestAudioFocus(this.mContext);
            this.mAudioFocusObtained = true;
        }
    }

    void abandonAudioFocus() {
        if (this.mAudioFocusObtained) {
            AudioUtil.abandonAudioFocus(this.mContext);
            this.mAudioFocusObtained = false;
        }
    }

    void releaseNoStatus() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.release();
            PlayerReferenceObserver.remove(this.mMediaPlayer.hashCode() + "");
            this.mMediaPlayer = null;
        }
    }

    void onVideoRenderStart() {
    }

    @Override
    public void setDisplayFloatRect(IMgtvRenderView.FloatRect floatRect) {
        DebugLog.i(this.getLogTag(), "setDisplayFloatRect " + floatRect);
        this.mDisplayFloatRect = floatRect;
        if (this.mRenderView != null && this.isRendered()) {
            this.mRenderView.setDisplayFloatRect(this.mDisplayFloatRect);
        }
    }

    @Override
    public IMgtvRenderView.FloatRect getDisplayFloatRect() {
        return this.mDisplayFloatRect;
    }

    @Override
    public void setOnFrameListener(IVideoView.OnFrameListener onFrameListener) {
        this.mOnFrameListener = onFrameListener;
    }

    @Override
    public void setOnAVPlayListener(IVideoView.OnAVPlayListener onAVPlayListener) {
        this.mOnAVPlayListener = onAVPlayListener;
    }

    @Override
    public void setNETIsBroken(boolean bl) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setNETIsBroken(bl);
        }
    }

    @Override
    public void setVideoFrameClockNotifyMs(int n2) {
        DebugLog.i(this.getLogTag(), "setVideoFrameClockNotifyMs " + n2);
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setVideoFrameClockNotifyMs(n2);
        }
    }

    @Override
    public ABRegion getABRegion() {
        return this.mABRegion;
    }

    @Override
    public boolean setLoopABPlay(boolean bl, ABRegion aBRegion) {
        DebugLog.i(this.getLogTag(), "setLoopABPlay in enable:" + bl + " " + aBRegion);
        if (bl && aBRegion != null && aBRegion.bPosMs <= aBRegion.aPosMs) {
            DebugLog.e(this.getLogTag(), "setLoopABPlay error b <= a");
            return false;
        }
        this.mLoopABPlayEnable = bl;
        this.mABRegion = aBRegion;
        long l2 = -1L;
        long l3 = -1L;
        if (this.mABRegion != null) {
            l2 = this.mABRegion.aPosMs;
            l3 = this.mABRegion.bPosMs;
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setLoopABPlay(bl, l2, l3);
            if (bl && l2 >= 0L && l3 >= 0L) {
                this.start();
                DebugLog.e(this.getLogTag(), "setLoopABPlay out success");
                return true;
            }
        }
        DebugLog.e(this.getLogTag(), "setLoopABPlay out failed");
        return false;
    }

    @Override
    public void setVideoFrameClockNotifyPts(long l2, long l3) {
        DebugLog.i(this.getLogTag(), "setVideoFrameClockNotify clockTimeStart:" + l2 + ",clockTimeEnd:" + l3);
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setVideoFrameClockNotifyPts(l2, l3);
        }
    }

    @Override
    public void setLoopSeekPlay(boolean bl, int n2) {
        DebugLog.i(this.getLogTag(), "setLoopSeekPlay enable:" + bl + ",loop_step_s:" + n2);
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setLoopSeekPlay(bl, n2);
        }
    }

    @Override
    public void setOnSwitchSmoothSourceListener(IVideoView.OnSwitchSmoothSourceListener onSwitchSmoothSourceListener) {
        this.mOnSwitchSmoothSourceListener = onSwitchSmoothSourceListener;
    }

    @Override
    public void setOnInfoStringListener(IVideoView.OnInfoStringListener onInfoStringListener) {
        this.mOnInfoStringListener = onInfoStringListener;
    }

    @Override
    public IVideoView.Size getRenderViewSize() {
        if (this.mDisplayFloatRect != null && this.mResizableFrameView != null) {
            IVideoView.Size size = new IVideoView.Size();
            size.width = this.mResizableFrameView.getCenterDisplayW();
            size.height = this.mResizableFrameView.getCenterDisplayH();
            return size;
        }
        IVideoView.Size size = new IVideoView.Size();
        if (this.mRenderView != null && this.mRenderView.getView() != null) {
            size.width = this.mRenderView.getView().getWidth();
            size.height = this.mRenderView.getView().getHeight();
        }
        return size;
    }

    @Override
    public void setMgtvFastMode(int n2) {
        DebugLog.i(this.getLogTag(), "setMgtvFastMode mode:" + n2);
        this.mMgtvFastMode = n2;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setMgtvFastMode(n2);
        }
    }

    @Override
    public int getMgtvFastMode() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getMgtvFastMode();
        }
        return this.mMgtvFastMode;
    }

    @Override
    public void stepPlaybackNextFrame() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setPlaybackStep(1);
        }
    }

    @Override
    public void enableFramePTSNotify(boolean bl) {
        DebugLog.i(this.getLogTag(), "enableFramePTSNotify " + bl);
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.enableFramePTSNotify(bl);
        }
    }

    @Override
    public void setDataSourceInfo(MgtvMediaPlayer.DataSourceInfo dataSourceInfo) {
        this.mDataSourceInfo = dataSourceInfo;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setDataSourceInfo(this.mDataSourceInfo);
        }
    }

    @Override
    public DebugPanel showDebugPanel(boolean bl) {
        if (bl) {
            if (this.mDebugPanel == null) {
                this.mDebugPanel = new DebugPanel(this.mContext, this);
            }
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
            ViewUtil.addView((ViewGroup)this, (View)this.mDebugPanel, (ViewGroup.LayoutParams)layoutParams);
        } else {
            ViewUtil.removeView((ViewGroup)this, (View)this.mDebugPanel);
        }
        return this.mDebugPanel;
    }

    @Override
    public void release() {
    }

    public void afterRelease() {
        if (this.mDebugPanel != null) {
            this.mDebugPanel.release();
        }
    }

    void resetDataBefore(ReleaseReason releaseReason) {
        if (this.mSubtitleView != null) {
            this.mSubtitleView.clear();
        }
        if (releaseReason == ReleaseReason.OUT) {
            this.mFileStartTimeFloatS = -1.0f;
            this.mSmoothModeOpen = false;
            this.removeSubtitleSource();
        }
    }

    void resetDataAfter(ReleaseReason releaseReason) {
        if (releaseReason == ReleaseReason.OUT) {
            this.mKeyInfoSet = false;
            this.mKeyInfoData = null;
            this.mKeyInfoRet = 0;
            this.mKeyInfoSetLayer = 0;
            if (this.mReportParams != null) {
                this.mReportParams.getKeyInfo().reset();
            }
            this.mIsDrmPrepared = false;
            if (this.mDrmSession != null) {
                this.mDrmSession.removeOnProvisionSuccessListener(this.mOnProvisionSuccessListener);
                this.mDrmSession = null;
            }
        }
    }

    @Override
    public long getPropertyLong(int n2, long l2) {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getPropertyLong(n2, l2);
        }
        return l2;
    }

    private void updateKeyInfoReport() {
        if (this.mReportParams != null) {
            this.mReportParams.getKeyInfo().keyInfoSet = this.mKeyInfoSet;
            this.mReportParams.getKeyInfo().keyInfoRet = this.mKeyInfoRet;
            this.mReportParams.getKeyInfo().keyInfoSetLayer = this.mKeyInfoSetLayer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setKeyInfoData(String string) {
        DebugLog.i(this.getLogTag(), "setKeyInfoData(String fileStr) in");
        if (!this.mKeyInfoSetEnable) {
            return 0;
        }
        this.mKeyInfoSet = true;
        this.mKeyInfoSetLayer = 1;
        if (StringUtil.isEmpty(string)) {
            this.mKeyInfoRet = -21;
            return -21;
        }
        try {
            File file = new File(string);
            if (!file.exists()) {
                this.mKeyInfoRet = -22;
                int n2 = -22;
                return n2;
            }
            if (file.length() <= 0L) {
                this.mKeyInfoRet = -23;
                int n3 = -23;
                return n3;
            }
            int n4 = this.setKeyInfoData(FileUtil.readFile(file));
            return n4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.mKeyInfoRet = -20;
            int n5 = -20;
            return n5;
        }
        finally {
            this.updateKeyInfoReport();
            DebugLog.i(this.getLogTag(), "setKeyInfoData(String fileStr) out." + this.mKeyInfoRet);
        }
    }

    int setKeyInfoData(byte[] byArray) {
        DebugLog.i(this.getLogTag(), "setKeyInfoData(byte[] data) in");
        if (!this.mKeyInfoSetEnable) {
            return 0;
        }
        try {
            this.mKeyInfoData = byArray;
            this.mKeyInfoSet = true;
            this.mKeyInfoSetLayer = 1;
            if (this.mMediaPlayer != null) {
                this.setKeyInfoDataInner(byArray);
                int n2 = this.mKeyInfoRet;
                return n2;
            }
            int n3 = this.mKeyInfoRet;
            return n3;
        }
        finally {
            this.updateKeyInfoReport();
            DebugLog.i(this.getLogTag(), "setKeyInfoData(byte[] data) out. mKeyInfoRet:" + this.mKeyInfoRet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setKeyInfoData(byte[] byArray, int n2, int n3) {
        DebugLog.i(this.getLogTag(), "setKeyInfoData(byte[] data) vid:" + n2 + " def:" + n3 + " in");
        if (!this.mKeyInfoSetEnable) {
            return 0;
        }
        try {
            this.mKeyInfoData = byArray;
            this.mKeyInfoSet = true;
            this.mKeyInfoSetLayer = 1;
            if (this.mMediaPlayer != null) {
                this.setKeyInfoDataInner(byArray);
                int n4 = this.mKeyInfoRet;
                return n4;
            }
            int n5 = this.mKeyInfoRet;
            return n5;
        }
        finally {
            this.updateKeyInfoReport();
            DebugLog.i(this.getLogTag(), "setKeyInfoData(byte[] data) out. mKeyInfoRet:" + this.mKeyInfoRet);
        }
    }

    @Override
    public byte[] getKeyInfoData() {
        return this.mKeyInfoData;
    }

    @Override
    public boolean isKeyInfoDataSet() {
        return this.mKeyInfoSet;
    }

    private void setKeyInfoDataInner(byte[] byArray) {
        DebugLog.i(this.getLogTag(), "setKeyInfoDataInner in");
        if (this.mMediaPlayer != null) {
            String string = null;
            if (this.mReportParams != null) {
                string = this.mReportParams.getVideoFileHash();
            }
            if ((this.mKeyInfoRet = KeyFrameInfoUtils.isKeyFrameDataValid(byArray, string)) == 0) {
                this.mKeyInfoSetLayer = 2;
                this.mKeyInfoRet = this.mMediaPlayer.setKeyFrameInfoFileBuf(this.mKeyInfoData);
            }
            this.updateKeyInfoReport();
        }
        DebugLog.i(this.getLogTag(), "setKeyInfoDataInner out");
    }

    @Override
    public void setPreBufferTimeoutMs(int n2) {
        this.mPreBufferTimeoutMs = n2;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setPreBufferTimeoutMs(this.mPreBufferTimeoutMs);
        }
    }

    @Override
    @Deprecated
    public void setDrmLicensePrepared() {
        this.mIsDrmPrepared = true;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setDrmLicensePrepared();
        }
    }

    @Override
    public void bindDrmSession(IDrmSession iDrmSession) {
        this.mDrmSession = iDrmSession;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.bindDrmSession(this.mDrmSession);
        }
        if (this.mDrmSession != null) {
            if (this.mDrmSession.getCurrentStatus() == 2) {
                this.mIsDrmPrepared = true;
                this.mDrmSession.setDrmLicensePrepared();
            }
            this.mDrmSession.addOnProvisionSuccessListener(this.mOnProvisionSuccessListener);
        }
    }

    @Override
    public void startAVDecoder() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.startAVDecoder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVideoPTSListener(MgtvPlayerListener.OnVideoPTSListener onVideoPTSListener) {
        Object object = this.ptsLocker;
        synchronized (object) {
            this.ptsListeners.add(onVideoPTSListener);
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.addVideoPTSListener(onVideoPTSListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVideoPTSListener(MgtvPlayerListener.OnVideoPTSListener onVideoPTSListener) {
        Object object = this.ptsLocker;
        synchronized (object) {
            this.ptsListeners.remove(onVideoPTSListener);
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.removeVideoPTSListener(onVideoPTSListener);
            }
        }
    }

    @Override
    public String getLastIP() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getLastIP();
        }
        return null;
    }

    @Override
    public void setSeekAutoStartAfterComplete(boolean bl) {
        this.mSeekAutoStartAfterCompleteEnable = bl;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setSeekAutoStartAfterComplete(bl);
        }
    }

    @Override
    public int setWanosAudioEffectConfig(byte[] byArray) {
        this.mAudioEffectConfig = byArray;
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.setWanosAudioEffectConfig(byArray);
        }
        return -999;
    }

    @Override
    public boolean isWanosAudioEffectValid() {
        boolean bl = false;
        if (this.mMediaPlayer != null) {
            bl = this.mMediaPlayer.isWanosAudioEffectValid();
        }
        return bl;
    }

    @Override
    public void setEnableWanosAudioEffect(boolean bl) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setEnableWanosAudioEffect(bl);
        }
    }

    @Override
    public void setWanosAudioEffectChoice(int n2) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setWanosAudioEffectChoice(n2);
        }
    }

    @Override
    public int getWanosAudioEffectChoice() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getWanosAudioEffectChoice();
        }
        return 0;
    }

    @Override
    public void switchSmoothSource(SmoothMediaSource smoothMediaSource) {
        if (this.mMediaPlayer != null) {
            if (smoothMediaSource != null && smoothMediaSource.getSwitchMod() == 1) {
                this.setLastMediaMode(1);
            } else {
                this.setLastMediaMode(0);
            }
            this.mMediaPlayer.switchSmoothSource(smoothMediaSource);
        }
    }

    @Override
    public void setSmoothSwitchMode(int n2) {
        this.mSmoothSwitchMode = n2;
    }

    @Override
    public boolean isSmoothSwitchOpen() {
        return this.mSmoothModeOpen;
    }

    @Override
    public int setSmoothKeyFrameInfo(byte[] byArray, String string, String string2) {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.setSmoothKeyFrameInfo(byArray, string, string2);
        }
        return -1;
    }

    void defaultNetAddr() {
    }

    @Override
    public void setNetAddrinfo(String string, int n2, boolean bl) {
        DebugLog.i(this.getLogTag(), "setNetAddrinfo " + string + ",timeout:" + n2 + ",enablePreDns:" + bl);
        this.defaultNetAddr();
        if (n2 > 0) {
            this.mAddrInfoTimeoutMs = n2 * 1000;
        }
    }

    void setLastMediaMode(int n2) {
        DebugLog.i(this.getLogTag(), "setLastMediaMode:" + n2);
        this.mLastMediaMode = n2;
    }

    @Override
    public boolean isOnlyAudioMode() {
        return this.mLastMediaMode == 1;
    }

    @Override
    public void setBackPlayEnable(boolean bl) {
        DebugLog.i(this.getLogTag(), "setBackPlayEnable:" + bl);
        this.mBackPlayEnable = bl;
    }

    @Override
    public boolean isBackPlayEnable() {
        return this.mBackPlayEnable;
    }

    @Override
    public MgtvMediaPlayer getMediaPlayer() {
        return this.mMediaPlayer;
    }

    @Override
    public Uri getCurrentUri() {
        return this.mCurrentUri;
    }

    @Override
    public void setVideoIntroduction(String string) {
        DebugLog.i(this.getLogTag(), "setVideoIntroduction:" + string);
        this.mVideoIntroduction = string;
        if (this.mReportParams != null) {
            this.mReportParams.setSvds(this.mVideoIntroduction);
        }
    }

    @Override
    public void enableOppoFunc(int n2, boolean bl) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.enableOppoFunc(n2, bl);
        }
    }

    @Override
    public void enableMediaCodecSW(boolean bl) {
        this.mEnableMediacodecSW = bl;
    }

    @Override
    public boolean isMediaCodecSWEnable() {
        return this.mEnableMediacodecSW;
    }

    @Override
    public void enableLiveLowLatency(boolean bl) {
        this.mLiveLowLatencyEnable = bl;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.enableLiveLowLatency(bl);
        }
    }

    @Override
    public void setTsFlowTag(String string) {
        this.tsFlowTag = string;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setTsFlowTag(string);
        }
    }

    @Override
    public void setBackground(boolean bl) {
        this.isBackground = bl;
        DebugLog.i(this.getLogTag(), "setBackground " + bl + ",threadId:" + Thread.currentThread().getId());
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setBackground(bl);
        }
    }

    @Override
    public boolean isBackground() {
        return this.isBackground;
    }

    @Override
    public void setDisableAudioFocus(boolean bl) {
        this.isRequestAudioFocus = !bl;
    }

    @Override
    public void enableImgoVSR(boolean bl) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.enableImgoVSR(bl);
        }
    }

    @Override
    public void setVolume(float f2, float f3) {
        this.mLeftVolume = f2;
        this.mRightVolume = f3;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setVolume(f2, f3);
        }
    }

    @Override
    public float getLeftVolume() {
        return this.mLeftVolume;
    }

    @Override
    public float getRightVolume() {
        return this.mRightVolume;
    }

    @Override
    public void setVideoDataSource(MgtvPlayerDataSource mgtvPlayerDataSource) {
        this.mDataSource = mgtvPlayerDataSource;
        this.setReadDataSourceType(3);
        this.setVideoPath(this.mDataSource.getPath());
    }

    @Override
    public void setReadDataSourceType(int n2) {
        this.mReadDataSourceTypeConfig = n2;
    }

    @Override
    public int getReadDataSourceType() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getReadDataSourceType();
        }
        return this.mReadDataSourceTypeConfig;
    }

    @Override
    public long getBufferedPositionMs() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getBufferedPositionMs();
        }
        return 0L;
    }

    public static class ABRegion {
        public int aPosMs;
        public int bPosMs;

        public ABRegion(int n2, int n3) {
            this.aPosMs = n2;
            this.bPosMs = n3;
        }

        public String toString() {
            return "Region{startMs=" + this.aPosMs + ", endMs=" + this.bPosMs + '}';
        }
    }

    static enum ReleaseReason {
        OUT,
        DEFAULT_INNER,
        PAUSE_DATA_BEFORE_PREPEAD;

    }
}

