/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.widget;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.hunantv.media.global.Constants;
import com.hunantv.media.p2p.IP2pTask;
import com.hunantv.media.player.IMgtvRenderView;
import com.hunantv.media.player.MgtvMediaPlayer;
import com.hunantv.media.player.MgtvPlayerListener;
import com.hunantv.media.player.MgtvRenderView;
import com.hunantv.media.player.a.a;
import com.hunantv.media.player.c;
import com.hunantv.media.player.d.f;
import com.hunantv.media.player.l;
import com.hunantv.media.player.loader.ImgoLibLoader;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.statistic.FlowDataStatistic;
import com.hunantv.media.player.utils.StringUtil;
import com.hunantv.media.recoder.GifRecorder;
import com.hunantv.media.report.ReportParams;
import com.hunantv.media.utils.AudioUtil;
import com.hunantv.media.utils.MemoryUtil;
import com.hunantv.media.widget.IVideoView;
import com.hunantv.media.widget.MgtvAbstractVideoView;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.text.NumberFormat;

public class MgtvLoopVideoView
extends MgtvAbstractVideoView {
    private static final String LOGMSG_PLAYER_CALLBACK = "VideoViewCallBack";
    private int mVideoWidth;
    private int mVideoHeight;
    private int originalVideoWidth;
    private int originalVideoHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private volatile boolean mLastSurfaceDestroy = true;
    private int mSeekWhenPrepared;
    private IVideoView.OnCompletionListener mOnCompletionListener;
    private IVideoView.OnPreparedListener mOnPreparedListener;
    private IVideoView.OnBufferingUpdateListener mOnBufferringUpdateListener;
    private IVideoView.OnInfoListener mOnInfoListener;
    private IVideoView.OnErrorListener mOnErrorListener;
    private IVideoView.OnSeekCompleteListener mOnSeekCompleteListener;
    private IVideoView.SurfaceHolderListener mSurfaceHolderListener;
    private IVideoView.OnStartListener mOnStartListener;
    private IVideoView.OnPauseListener mOnPauseListener;
    private IVideoView.OnRecordListener mOnRecordListener;
    private IVideoView.OnUpdateStatusListener mOnUpdateStatusListener;
    private IVideoView.OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    private IVideoView.OnLoadDataListener mOnLoadDataListener;
    private boolean shouldGetVideoParams;
    private boolean isStretchScreen;
    private DisplayMetrics metrics;
    private int fromLeft;
    private int fromTop;
    private int fromRight;
    private int fromBottom;
    private int mCurrentState = 0;
    private int mTargetState = 0;
    private int mBufferTimeoutMs;
    private boolean mMgtvMediaPlayerHardwareMode = false;
    private boolean mForceDecodeMode = false;
    boolean mFromSurfaceDestroyToPlay = false;
    private int mFromSurfaceDestroyPlayPosition = 0;
    private boolean mMgtvMediaPlayerAudioMode = false;
    private String mErrorMsg = "";
    boolean mHasSurfaceHolderDestroy = false;
    private MgtvPlayerListener.OnWarningListener mOnWarningListener;
    private IVideoView.OnChangeSourceListener mOnChangeSourceListener;
    private boolean mLogCallBackOpen = true;
    private int mStreamKey = -1;
    private boolean mIsLive = false;
    private boolean mIsDataLoaderPaused = false;
    private int mVideoRotationDegree;
    private boolean mUseSystemPlayer = false;
    private boolean mRebindTexture;
    private boolean mAccurateSeekEnable;
    private MgtvMediaPlayer.AddrinfoType mAddrInfoType = MgtvMediaPlayer.AddrinfoType.TYPE_ADDRINFO_DEFAULT;
    private int mAddrInfoTypeInt = 0;
    private a.b mJavaDnsType = a.b.a;
    private boolean mNativeDnsAsyncEnable = true;
    private boolean mEnableMgtvMediaCodec = false;
    private boolean mLastFrameRecovery;
    private int mWeakNetSpeed = 0;
    private int mWeakBufferTimeoutMs = 0;
    private boolean mTsNotSkip = false;
    private int mLoadMaxRetryTime = 0;
    private boolean mCacheEnable;
    private String mCacheM3u8Path;
    private String[] mCacheTsPaths;
    private boolean mUserEnableCoreStartPauseListen = false;
    private boolean mEnableCoreStartPauseListen = false;
    private long mStartLeaveTimestamp;
    private boolean mIsScreenOnWhilePlaying = true;
    private String mRecordFilePath;
    private float mPlaySpeed = 1.0f;
    private int mLiveStartIndex = 0;
    private boolean mIsSecure = false;
    private int mAspectRatio = -1;
    private IVideoView.RenderFilter mRenderFilter = IVideoView.RenderFilter.NORMAL;
    private boolean mOpenVideoWhenSurfaceCreate;
    private boolean mIsLiveConfig = false;
    private boolean mEnableLiveMode = false;
    protected boolean mTargetIsLoopMode = false;
    protected boolean mIsLoopMode = false;
    private boolean mEnableOpengl;
    private int mRenderType;
    private int mEnhanceQualityType;
    private IP2pTask mMainP2pTask;
    int mStartPosMs = 0;
    boolean mNeedResetLoopPlay = false;
    private FlowDataStatistic mFlowDataStatistic = new FlowDataStatistic();
    private int mDataCacheSizeKB;
    private MgtvMediaPlayer.SkipLoopFilterType mSkipLoopFilterType = MgtvMediaPlayer.SkipLoopFilterType.TYPE_SKIPLOOPFILTER_ALL;
    private boolean mEnableTsSkipError;
    private long mNonSurfaceHolderPVTimestamp;
    IMgtvRenderView.IRenderCallback mSHCallback = new IMgtvRenderView.IRenderCallback(){

        @Override
        public void onSurfaceChanged(IMgtvRenderView.ISurfaceHolder iSurfaceHolder, int n2, int n3, int n4) {
            boolean bl;
            DebugLog.e(MgtvLoopVideoView.this.getLogTag(), "-----------surface changed");
            if (iSurfaceHolder.getRenderView() != MgtvLoopVideoView.this.mRenderView.getRenderView()) {
                DebugLog.e(MgtvLoopVideoView.this.getLogTag(), "onSurfaceChanged: unmatched render callback\n");
                return;
            }
            MgtvLoopVideoView.this.mSurfaceWidth = n3;
            MgtvLoopVideoView.this.mSurfaceHeight = n4;
            boolean bl2 = MgtvLoopVideoView.this.mTargetState == 3;
            boolean bl3 = bl = !MgtvLoopVideoView.this.mRenderView.shouldWaitForResize() || MgtvLoopVideoView.this.mVideoWidth == n3 && MgtvLoopVideoView.this.mVideoHeight == n4;
            if (MgtvLoopVideoView.this.mMediaPlayer != null && bl2 && bl) {
                if (!MgtvLoopVideoView.this.mIsLoopMode && MgtvLoopVideoView.this.mSeekWhenPrepared != 0) {
                    MgtvLoopVideoView.this.seekTo(MgtvLoopVideoView.this.mSeekWhenPrepared, false);
                }
                MgtvLoopVideoView.this.start();
            }
            if (MgtvLoopVideoView.this.mSurfaceHolderListener != null) {
                MgtvLoopVideoView.this.mSurfaceHolderListener.surfaceChanged();
            }
        }

        @Override
        public void onSurfaceCreated(IMgtvRenderView.ISurfaceHolder iSurfaceHolder, int n2, int n3) {
            long l2;
            if (MgtvLoopVideoView.this.mStartLeaveTimestamp > 0L && (l2 = (System.currentTimeMillis() - MgtvLoopVideoView.this.mStartLeaveTimestamp) / 1000L) > 540L) {
                if (MgtvLoopVideoView.this.mOnWarningListener != null) {
                    MgtvLoopVideoView.this.mOnWarningListener.onWarning(800010, MgtvLoopVideoView.this.mCurrentState + "", "", null);
                }
                if (MgtvLoopVideoView.this.mReportParams != null) {
                    MgtvLoopVideoView.this.mReportParams.setLeaveTimeS(l2);
                }
            }
            DebugLog.e(MgtvLoopVideoView.this.getLogTag(), "-----------surface create");
            if (iSurfaceHolder.getRenderView() != MgtvLoopVideoView.this.mRenderView.getRenderView()) {
                DebugLog.e(MgtvLoopVideoView.this.getLogTag(), "onSurfaceCreated: unmatched render callback\n");
                return;
            }
            DebugLog.i(MgtvLoopVideoView.this.getLogTag(), "onSurfaceCreated " + iSurfaceHolder);
            MgtvLoopVideoView.this.mSurfaceHolder = iSurfaceHolder;
            if (MgtvLoopVideoView.this.mRenderView.getRenderViewType() == 0) {
                SurfaceHolder surfaceHolder = MgtvLoopVideoView.this.mSurfaceHolder.getSurfaceHolder();
                if (surfaceHolder != null && surfaceHolder.getSurface() != null && surfaceHolder.getSurface().isValid()) {
                    this.bindHolder(iSurfaceHolder);
                } else {
                    MgtvLoopVideoView.this.mErrorListener.onError(7000009, 1);
                    MgtvLoopVideoView.this.mErrorMsg = "surfaceCreated surface is invalid";
                }
            } else {
                this.bindHolder(iSurfaceHolder);
            }
            if (MgtvLoopVideoView.this.mSurfaceHolderListener != null) {
                MgtvLoopVideoView.this.mSurfaceHolderListener.surfaceCreated();
            }
        }

        private boolean needOpenVideo() {
            return MgtvLoopVideoView.this.mOpenVideoWhenSurfaceCreate && MgtvLoopVideoView.this.mCurrentUri != null;
        }

        private void bindHolder(IMgtvRenderView.ISurfaceHolder iSurfaceHolder) {
            if (MgtvLoopVideoView.this.mMediaPlayer != null) {
                if (MgtvLoopVideoView.this.mHasSurfaceHolderDestroy && MgtvLoopVideoView.this.mRebindTexture && MgtvLoopVideoView.this.mCurrentUri != null) {
                    MgtvLoopVideoView.this.setStartPosMs(MgtvLoopVideoView.this.mMediaPlayer.getCurrentPosition());
                    MgtvLoopVideoView.this.openVideo();
                } else if (this.needOpenVideo()) {
                    MgtvLoopVideoView.this.openVideo();
                } else {
                    MgtvLoopVideoView.this.mMediaPlayer.setSurfaceHolder(iSurfaceHolder);
                    if (MgtvLoopVideoView.this.mNeedResetLoopPlay) {
                        MgtvLoopVideoView.this.resetVideoPath();
                    } else if (MgtvLoopVideoView.this.mFromSurfaceDestroyToPlay && MgtvLoopVideoView.this.mCurrentUri != null) {
                        if (MgtvLoopVideoView.this.mMgtvMediaPlayerHardwareMode) {
                            MgtvLoopVideoView.this.mFromSurfaceDestroyToPlay = false;
                            if (!MgtvLoopVideoView.this.mIsLoopMode) {
                                MgtvLoopVideoView.this.mMediaPlayer.seekTo(MgtvLoopVideoView.this.mFromSurfaceDestroyPlayPosition, false, true);
                            }
                            MgtvLoopVideoView.this.mFromSurfaceDestroyPlayPosition = 0;
                        }
                    } else if (MgtvLoopVideoView.this.mLastFrameRecovery && (!MgtvLoopVideoView.this.isHardware() || MgtvLoopVideoView.this.mLastSurfaceDestroy)) {
                        MgtvLoopVideoView.this.mMediaPlayer.setPlaybackStep();
                    }
                    MgtvLoopVideoView.this.mSizeChangedListener.onVideoSizeChanged(MgtvLoopVideoView.this.mMediaPlayer.getVideoWidth(), MgtvLoopVideoView.this.mMediaPlayer.getVideoHeight());
                }
            } else {
                MgtvLoopVideoView.this.openVideo();
            }
        }

        @Override
        public void onSurfaceDestroyed(IMgtvRenderView.ISurfaceHolder iSurfaceHolder, boolean bl) {
            MgtvLoopVideoView.this.mLastSurfaceDestroy = bl;
            if (iSurfaceHolder.getRenderView() != MgtvLoopVideoView.this.mRenderView.getRenderView()) {
                DebugLog.e(MgtvLoopVideoView.this.getLogTag(), "onSurfaceDestroyed: unmatched render callback\n");
                return;
            }
            DebugLog.i(MgtvLoopVideoView.this.getLogTag(), "onSurfaceDestroyed " + iSurfaceHolder);
            if (MgtvLoopVideoView.this.mSurfaceHolderListener != null) {
                MgtvLoopVideoView.this.mSurfaceHolderListener.surfaceDestroyed();
            }
            MgtvLoopVideoView.this.mSurfaceHolder = null;
            if (MgtvLoopVideoView.this.mMediaPlayer != null) {
                MgtvLoopVideoView.this.mMediaPlayer.setSurfaceHolder(null);
                if (MgtvLoopVideoView.this.isPrepared()) {
                    MgtvLoopVideoView.this.pauseLoadData();
                    if (MgtvLoopVideoView.this.mIsLive) {
                        DebugLog.e(MgtvLoopVideoView.this.getLogTag(), "-----------surface destroy to pause");
                        MgtvLoopVideoView.this.pauseInner();
                    } else {
                        DebugLog.e(MgtvLoopVideoView.this.getLogTag(), "-----------surface destroy to pause");
                        if (MgtvLoopVideoView.this.mRenderView.getRenderViewType() == 0) {
                            if (!MgtvLoopVideoView.this.mMediaPlayer.isSupportAMCKeyFrameBackup()) {
                                MgtvLoopVideoView.this.mFromSurfaceDestroyToPlay = true;
                                MgtvLoopVideoView.this.mFromSurfaceDestroyPlayPosition = MgtvLoopVideoView.this.mMediaPlayer.getCurrentPosition();
                            }
                        } else if (MgtvLoopVideoView.this.mRenderView.getRenderViewType() == 1) {
                            if (!MgtvLoopVideoView.this.isHardware()) {
                                MgtvLoopVideoView.this.mFromSurfaceDestroyToPlay = true;
                            }
                            if (!MgtvLoopVideoView.this.mIsLoopMode && MgtvLoopVideoView.this.mEnableTexture) {
                                MgtvLoopVideoView.this.mHasSurfaceHolderDestroy = true;
                            }
                        }
                        MgtvLoopVideoView.this.pauseInner();
                    }
                } else {
                    try {
                        if (MgtvLoopVideoView.this.mReportParams != null) {
                            MgtvLoopVideoView.this.mReportParams.getEnd().setInnerRetry(true);
                        }
                        MgtvLoopVideoView.this.release(true, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (MgtvLoopVideoView.this.mCurrentUri != null && MgtvLoopVideoView.this.mCurrentState != -1 && MgtvLoopVideoView.this.mCurrentState != 5) {
                    MgtvLoopVideoView.this.mStartLeaveTimestamp = System.currentTimeMillis();
                }
            }
        }
    };
    private f.a mFilterCallback = new f.a(){

        @Override
        public void onInfo(int n2, int n3, String string) {
            switch (n2) {
                case 1: {
                    MgtvLoopVideoView.this.mRenderType = n3;
                    if (MgtvLoopVideoView.this.mReportParams == null) break;
                    MgtvLoopVideoView.this.mReportParams.setRenderType(MgtvLoopVideoView.this.mRenderType);
                    break;
                }
                case 3: {
                    MgtvLoopVideoView.this.mEnhanceQualityType = n3;
                    if (MgtvLoopVideoView.this.mReportParams == null) break;
                    MgtvLoopVideoView.this.mReportParams.setEnhanceQualityType(MgtvLoopVideoView.this.mEnhanceQualityType);
                }
            }
        }
    };
    private MgtvPlayerListener.OnWarningListener mRenderWarning = new MgtvPlayerListener.OnWarningListener(){

        @Override
        public void onTsSkip(String string, int n2, int n3) {
        }

        @Override
        public void onWarning(int n2, String string, String string2, Object object) {
            DebugLog.i(MgtvLoopVideoView.this.getLogTag(), "opengl render warning:" + n2 + ",extra:" + string + ",msg:" + string2);
            if (MgtvLoopVideoView.this.mOnWarningListener != null) {
                MgtvLoopVideoView.this.mOnWarningListener.onWarning(n2, string, string2, object);
            }
        }
    };
    MgtvPlayerListener.OnVideoSizeChangedListener mSizeChangedListener = new MgtvPlayerListener.OnVideoSizeChangedListener(){

        @Override
        public void onVideoSizeChanged(int n2, int n3) {
            MgtvLoopVideoView.this.originalVideoWidth = (MgtvLoopVideoView.this.mVideoWidth = MgtvLoopVideoView.this.mMediaPlayer.getVideoWidth());
            MgtvLoopVideoView.this.originalVideoHeight = (MgtvLoopVideoView.this.mVideoHeight = MgtvLoopVideoView.this.mMediaPlayer.getVideoHeight());
            if (MgtvLoopVideoView.this.mVideoWidth != 0 && MgtvLoopVideoView.this.mVideoHeight != 0) {
                if (MgtvLoopVideoView.this.mRenderView != null) {
                    MgtvLoopVideoView.this.mRenderView.setVideoSize(MgtvLoopVideoView.this.mVideoWidth, MgtvLoopVideoView.this.mVideoHeight);
                }
                MgtvLoopVideoView.this.requestLayout();
            }
            if (MgtvLoopVideoView.this.mOnVideoSizeChangedListener != null) {
                MgtvLoopVideoView.this.mOnVideoSizeChangedListener.onVideoSizeChanged(n2, n3);
            }
        }
    };
    MgtvPlayerListener.OnPreparedListener mPreparedListener = new MgtvPlayerListener.OnPreparedListener(){

        @Override
        public void onPrepared() {
            MgtvLoopVideoView.this.changeCurrentState(2);
            MgtvLoopVideoView.this.originalVideoWidth = (MgtvLoopVideoView.this.mVideoWidth = MgtvLoopVideoView.this.mMediaPlayer.getVideoWidth());
            MgtvLoopVideoView.this.originalVideoHeight = (MgtvLoopVideoView.this.mVideoHeight = MgtvLoopVideoView.this.mMediaPlayer.getVideoHeight());
            if (MgtvLoopVideoView.this.mVideoWidth != 0 && MgtvLoopVideoView.this.mVideoHeight != 0) {
                int n2;
                DebugLog.i("@@@@", "video size: " + MgtvLoopVideoView.this.mVideoWidth + "/" + MgtvLoopVideoView.this.mVideoHeight);
                if (MgtvLoopVideoView.this.mRenderView != null) {
                    MgtvLoopVideoView.this.mRenderView.setVideoSize(MgtvLoopVideoView.this.mVideoWidth, MgtvLoopVideoView.this.mVideoHeight);
                }
                if ((n2 = MgtvLoopVideoView.this.mSeekWhenPrepared) != 0) {
                    MgtvLoopVideoView.this.seekTo(n2);
                }
                if ((!MgtvLoopVideoView.this.mRenderView.shouldWaitForResize() || MgtvLoopVideoView.this.mSurfaceWidth == MgtvLoopVideoView.this.mVideoWidth && MgtvLoopVideoView.this.mSurfaceHeight == MgtvLoopVideoView.this.mVideoHeight) && MgtvLoopVideoView.this.mTargetState == 3) {
                    MgtvLoopVideoView.this.start();
                }
            } else if (MgtvLoopVideoView.this.mTargetState == 3) {
                MgtvLoopVideoView.this.start();
            }
            if (MgtvLoopVideoView.this.mOnPreparedListener != null) {
                MgtvLoopVideoView.this.mOnPreparedListener.onPrepared();
            }
        }
    };
    private MgtvPlayerListener.OnCompletionListener mCompletionListener = new MgtvPlayerListener.OnCompletionListener(){

        @Override
        public void onCompletion(int n2, int n3) {
            if (n2 != 0) {
                MgtvLoopVideoView.this.changeCurrentState(0);
                MgtvLoopVideoView.this.mTargetState = 0;
                MgtvLoopVideoView.this.stopInner();
            } else {
                MgtvLoopVideoView.this.changeCurrentState(5);
                MgtvLoopVideoView.this.mTargetState = 5;
            }
            DebugLog.i(MgtvLoopVideoView.this.getLogTag(), "-------------on onCompletion what:" + n2 + ",extra:" + n3);
            if (MgtvLoopVideoView.this.mOnCompletionListener != null) {
                MgtvLoopVideoView.this.mOnCompletionListener.onCompletion(n2, n3);
            }
        }
    };
    private MgtvPlayerListener.OnInfoListener mInfoListener = new MgtvPlayerListener.OnInfoListener(){

        @Override
        public boolean onInfo(int n2, int n3) {
            block0 : switch (n2) {
                case 800: {
                    DebugLog.e(MgtvLoopVideoView.this.getLogTag(), "Bad interleaving of media file, audio/video are not well-formed, extra is " + n3);
                    n2 = 800;
                    break;
                }
                case 702: {
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "buffer end speed:" + MgtvLoopVideoView.this.getDLSpeedFormat());
                    n2 = 702;
                    break;
                }
                case 701: {
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "buffer start speed:" + MgtvLoopVideoView.this.getDLSpeedFormat());
                    n2 = 701;
                    break;
                }
                case 802: {
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "A new set of metadata is available, extra is " + n3);
                    n2 = 802;
                    break;
                }
                case 801: {
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "The stream not seekable status, extra is " + n3);
                    n2 = 801;
                    if (n3 == 1) {
                        MgtvLoopVideoView.this.mIsLive = true;
                        DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "The stream is live stream,can not seekable ");
                        break;
                    }
                    MgtvLoopVideoView.this.mIsLive = false;
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "The stream is not live stream,can seekable ");
                    break;
                }
                case 700: {
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "It's too complex for the decoder, extra is " + n3);
                    n2 = 700;
                    break;
                }
                case 1: {
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "Unknown info, extra is " + n3);
                    n2 = 1;
                    break;
                }
                case 3: {
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "msg coming: video decode succeeded");
                    n2 = 900;
                    MgtvLoopVideoView.this.onVideoRenderStart();
                    if (MgtvLoopVideoView.this.mOnInfoListener != null) {
                        DebugLog.i(MgtvLoopVideoView.this.getLogTag(), "video decode succeeded, start rendering");
                        MgtvLoopVideoView.this.mOnInfoListener.onInfo(n2, n3);
                    }
                    return true;
                }
                case 5: {
                    break;
                }
                case 200001: {
                    if (n3 == 1) {
                        MgtvLoopVideoView.this.mMgtvMediaPlayerHardwareMode = false;
                    } else {
                        MgtvLoopVideoView.this.mMgtvMediaPlayerHardwareMode = true;
                    }
                    MgtvLoopVideoView.this.convertRender(MgtvLoopVideoView.this.mRenderViewType);
                    break;
                }
                case 6: {
                    if (n3 == 0) {
                        MgtvLoopVideoView.this.mMgtvMediaPlayerHardwareMode = false;
                    } else if (n3 == 1) {
                        MgtvLoopVideoView.this.mMgtvMediaPlayerHardwareMode = true;
                    }
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "video decoder open,extra is " + n3);
                    break;
                }
                case 7: {
                    n2 = 700001;
                    break;
                }
                case 10001: {
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "video rotation changed,extra(degree) is " + n3);
                    MgtvLoopVideoView.this.mVideoRotationDegree = n3;
                    if (MgtvLoopVideoView.this.mRenderView == null) break;
                    MgtvLoopVideoView.this.mRenderView.setVideoRotation(MgtvLoopVideoView.this.mVideoRotationDegree);
                    break;
                }
                case 2804: {
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "accurate seek complete,time is " + n3);
                    break;
                }
                case 4: {
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "audio decode succeeded, start rendering");
                    break;
                }
                case 2805: {
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "acodec reconfigure ret is " + n3);
                    break;
                }
                case 2803: {
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "data source type is " + n3);
                    if (MgtvLoopVideoView.this.mMediaPlayer == null) break;
                    MgtvLoopVideoView.this.mDataSourceType = MgtvLoopVideoView.this.mMediaPlayer.getDataSourceType();
                    break;
                }
                case 2810: {
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "video fps is " + n3);
                    break;
                }
                case 2820: {
                    switch (n3) {
                        case 82001: {
                            DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "prepare av data: open input steam");
                            break block0;
                        }
                        case 82002: {
                            DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "prepare av data: find steam info");
                            break block0;
                        }
                        case 82003: {
                            DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "prepare av data: av stream component open");
                            break block0;
                        }
                        case 82004: {
                            DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "prepare av data: video decoded start");
                            break block0;
                        }
                        case 82005: {
                            DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "prepare av data: audio decoded start");
                            break block0;
                        }
                    }
                    DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "prepare av data: " + n3);
                    break;
                }
                case 2806: {
                    DebugLog.d(MgtvLoopVideoView.this.getLogTag(), "stream format type is " + n3);
                    break;
                }
                case 2830: {
                    DebugLog.i(MgtvLoopVideoView.this.getLogTag(), "MEDIA_INFO_PLAYBACK_STATE_CHANGED:" + n3);
                    if (MgtvLoopVideoView.this.mOnUpdateStatusListener == null) break;
                    MgtvLoopVideoView.this.mOnUpdateStatusListener.onUpdateStatus();
                    break;
                }
                default: {
                    DebugLog.d(MgtvLoopVideoView.this.getLogTag(), "Unknown info code: " + n2 + ", extra is " + n3);
                }
            }
            if (MgtvLoopVideoView.this.mOnInfoListener != null) {
                MgtvLoopVideoView.this.mOnInfoListener.onInfo(n2, n3);
            }
            return true;
        }
    };
    private MgtvPlayerListener.OnErrorListener mErrorListener = new MgtvPlayerListener.OnErrorListener(){

        @Override
        public boolean onError(int n2, int n3) {
            DebugLog.w(MgtvLoopVideoView.this.getLogTag(), "onError what:" + n2 + ",extra:" + n3);
            if (MgtvLoopVideoView.this.mMediaPlayer != null && n2 == 7000006) {
                MgtvLoopVideoView.this.releaseNoStatus();
                MgtvLoopVideoView.this.changeCurrentState(0);
                MgtvLoopVideoView.this.mTargetState = 0;
            } else {
                if (MgtvLoopVideoView.this.mMediaPlayer != null && MgtvLoopVideoView.this.mCurrentState != -1) {
                    MgtvLoopVideoView.this.mMediaPlayer.stop();
                }
                MgtvLoopVideoView.this.changeCurrentState(-1);
                MgtvLoopVideoView.this.mTargetState = -1;
            }
            MgtvLoopVideoView.this.mCurrentUri = null;
            MgtvLoopVideoView.this.mProxyUri = null;
            return MgtvLoopVideoView.this.mOnErrorListener != null && MgtvLoopVideoView.this.mOnErrorListener.onError(n2, n3);
        }
    };
    private MgtvPlayerListener.OnSeekCompleteListener mSeekCompleteListener = new MgtvPlayerListener.OnSeekCompleteListener(){

        @Override
        public void onSeekComplete(int n2, int n3) {
            if (MgtvLoopVideoView.this.mOnSeekCompleteListener != null) {
                DebugLog.i(MgtvLoopVideoView.this.getLogTag(), "onSeekComplete seekTargetTime:" + n2 + ",errorCode:" + n3);
                MgtvLoopVideoView.this.mOnSeekCompleteListener.onSeekComplete();
            }
        }
    };
    private MgtvPlayerListener.OnBufferingUpdateListener mBufferingUpdateListener = new MgtvPlayerListener.OnBufferingUpdateListener(){

        @Override
        public void onBufferingUpdate(int n2) {
            if (MgtvLoopVideoView.this.mOnBufferringUpdateListener != null) {
                MgtvLoopVideoView.this.mOnBufferringUpdateListener.onBufferingUpdate(n2);
            }
        }
    };
    private MgtvPlayerListener.OnBufferingTimeoutListener mBufferingTimeoutListener = new MgtvPlayerListener.OnBufferingTimeoutListener(){

        @Override
        public boolean onBufferingTimeout(int n2, int n3) {
            if (MgtvLoopVideoView.this.mMediaPlayer != null) {
                MgtvLoopVideoView.this.mMediaPlayer.stop();
            }
            MgtvLoopVideoView.this.changeCurrentState(-1);
            MgtvLoopVideoView.this.mTargetState = -1;
            MgtvLoopVideoView.this.mCurrentUri = null;
            MgtvLoopVideoView.this.mProxyUri = null;
            if (MgtvLoopVideoView.this.mOnErrorListener != null && MgtvLoopVideoView.this.mOnErrorListener.onError(n2, n3)) {
                return true;
            }
            return true;
        }
    };
    private MgtvPlayerListener.OnSwitchSourceListener mSwitchSourceListener = new MgtvPlayerListener.OnSwitchSourceListener(){

        @Override
        public void onSwitchSourceInfo(String string, int n2, int n3) {
            DebugLog.e(MgtvLoopVideoView.this.getLogTag(), "onSwitchSourceInfo url:" + string + ",event:" + n2 + ",time:" + n3);
            if (MgtvLoopVideoView.this.mOnChangeSourceListener != null) {
                MgtvLoopVideoView.this.mOnChangeSourceListener.onChangeSourceInfo(string, n2, n3);
            }
        }

        @Override
        public void onSwitchSourceComplete(String string, int n2, int n3) {
            DebugLog.e(MgtvLoopVideoView.this.getLogTag(), "onSwitchSourceComplete url:" + string + ",type:" + n2 + ",time:" + n3);
            if (MgtvLoopVideoView.this.mOnChangeSourceListener != null) {
                MgtvLoopVideoView.this.mOnChangeSourceListener.onChangeSourceSuccess(string, n2, n3);
            }
        }

        @Override
        public void onSwitchSourceFailed(String string, int n2, int n3) {
            DebugLog.e(MgtvLoopVideoView.this.getLogTag(), "onSwitchSourceFailed url:" + string + ",what:" + n2 + ",extra:" + n3);
            if (MgtvLoopVideoView.this.mOnChangeSourceListener != null) {
                MgtvLoopVideoView.this.mOnChangeSourceListener.onChangeSourceFailed(string, n2, n3);
            }
        }
    };
    private MgtvPlayerListener.OnWarningListener mPlayerWarning = new MgtvPlayerListener.OnWarningListener(){

        @Override
        public void onTsSkip(String string, int n2, int n3) {
            DebugLog.i(MgtvLoopVideoView.this.getLogTag(), "onTsSkip tsUrl:" + string);
            if (MgtvLoopVideoView.this.mOnWarningListener != null) {
                MgtvLoopVideoView.this.mOnWarningListener.onTsSkip(string, n2, n3);
            }
        }

        @Override
        public void onWarning(int n2, String string, String string2, Object object) {
            DebugLog.i(MgtvLoopVideoView.this.getLogTag(), "player render warning:" + n2 + ",extra:" + string + ",msg:" + string2);
            if (MgtvLoopVideoView.this.mOnWarningListener != null) {
                MgtvLoopVideoView.this.mOnWarningListener.onWarning(n2, string, string2, object);
            }
        }
    };
    private GifRecorder mGifRecorder = new GifRecorder();
    private MgtvPlayerListener.OnStartListener mStartListener = new MgtvPlayerListener.OnStartListener(){

        @Override
        public void onStart() {
            DebugLog.d(MgtvLoopVideoView.this.getLogTag(), "mgtvcore onStart");
            if (MgtvLoopVideoView.this.mEnableCoreStartPauseListen) {
                MgtvLoopVideoView.this.callbackOnStart();
            }
        }
    };
    private MgtvPlayerListener.OnPauseListener mPauseListener = new MgtvPlayerListener.OnPauseListener(){

        @Override
        public void onPause() {
            DebugLog.d(MgtvLoopVideoView.this.getLogTag(), "mgtvcore onPause");
            if (MgtvLoopVideoView.this.mEnableCoreStartPauseListen) {
                MgtvLoopVideoView.this.callbackOnPause();
            }
        }
    };
    private MgtvPlayerListener.OnRecordVideoListener mRecordVideoListener = new MgtvPlayerListener.OnRecordVideoListener(){

        @Override
        public void onRecordVideoInfo(int n2, int n3) {
            DebugLog.i(MgtvLoopVideoView.this.getLogTag(), "onRecordVideoInfo what:" + n2 + ",extra:" + n3);
            if (MgtvLoopVideoView.this.mOnRecordListener != null) {
                switch (n2) {
                    case 20: {
                        MgtvLoopVideoView.this.mOnRecordListener.onRecordStart(MgtvLoopVideoView.this.mRecordFilePath);
                        break;
                    }
                    case 30: {
                        MgtvLoopVideoView.this.mOnRecordListener.onRecordStop();
                    }
                }
                MgtvLoopVideoView.this.mOnRecordListener.onRecordInfo(n2, n3);
            }
        }

        @Override
        public void onRecordVideoErr(int n2, int n3) {
            DebugLog.e(MgtvLoopVideoView.this.getLogTag(), "onRecordVideoErr what:" + n2 + ",extra:" + n3);
            if (MgtvLoopVideoView.this.mOnRecordListener != null) {
                MgtvLoopVideoView.this.mOnRecordListener.onRecordError(n2, n3);
            }
        }
    };
    private MgtvPlayerListener.OnLoadDataListener mLoadDataListener = new MgtvPlayerListener.OnLoadDataListener(){

        @Override
        public void onBeforeLoadDataResume() {
            if (MgtvLoopVideoView.this.mOnLoadDataListener != null) {
                MgtvLoopVideoView.this.mOnLoadDataListener.onBeforeLoadDataResume();
            }
        }

        @Override
        public void onAfterLoadDataPaused() {
            if (MgtvLoopVideoView.this.mOnLoadDataListener != null) {
                MgtvLoopVideoView.this.mOnLoadDataListener.onAfterLoadDataPaused();
            }
        }
    };

    public MgtvLoopVideoView(Context context) {
        super(context);
        this.initVideoView(context);
    }

    public MgtvLoopVideoView(Context context, IVideoView.Configuration configuration) {
        super(context, configuration);
        if (configuration != null) {
            this.mEnableTexture = configuration.enableTexture;
            this.mEnableOpengl = configuration.opengl;
            this.mEnableLiveMode = this.mIsLiveConfig = configuration.isLiveMode;
            this.mTargetIsLoopMode = configuration.isLoopMode;
            this.initVideoView(context, configuration.renderViewType);
        } else {
            this.initVideoView(context);
        }
    }

    public MgtvLoopVideoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initVideoView(context);
    }

    public MgtvLoopVideoView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initVideoView(context);
    }

    @Override
    public void toggleRenders(int n2) {
        super.toggleRenders(n2);
        this.setRender(n2);
    }

    @Override
    public int getRenderViewType() {
        return this.mRenderViewType;
    }

    private void setRender(int n2) {
        DebugLog.i(this.getLogTag(), "setRender render:" + n2);
        switch (n2) {
            case 0: 
            case 1: {
                if (n2 == 1 && this.mMediaPlayer != null && this.mCurrentUri != null) {
                    this.mMediaPlayer.setSurfaceHolder(this.mSurfaceHolder);
                    this.mRenderView.setVideoSize(this.mMediaPlayer.getVideoWidth(), this.mMediaPlayer.getVideoHeight());
                }
                this.setRenderView(n2);
                break;
            }
            default: {
                DebugLog.e(this.getLogTag(), "invalid render:" + n2 + ", change to surfaceview");
                n2 = 0;
                this.mRenderViewType = 0;
                this.setRenderView(n2);
            }
        }
    }

    private void setRenderView(int n2) {
        View view;
        int n3 = -1;
        if (this.mRenderView != null) {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setSurfaceHolder(null);
            }
            view = this.mRenderView.getView();
            this.mRenderView.removeRenderCallback(this.mSHCallback);
            this.mRenderView.release();
            this.mRenderView = null;
            if (view != null) {
                DebugLog.i(this.getLogTag(), "setRenderView removeRenderView");
                n3 = this.indexOfChild(view);
                this.removeView(view);
            }
        }
        this.mRenderType = 0;
        this.mEnhanceQualityType = 0;
        if (this.mReportParams != null) {
            this.mReportParams.setRenderType(0);
            this.mReportParams.setEnhanceQualityType(0);
        }
        this.mRenderView = new MgtvRenderView(this.getContext(), n2, this.mEnableOpengl, this.mRenderWarning, this.mFilterCallback);
        this.mRenderView.bindFakeFrameView(this.mFakeFrameView);
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.bindRenderView(this.mRenderView != null ? this.mRenderView.getRenderView() : null);
        }
        if (this.mRenderView == null) {
            return;
        }
        this.setRenderFilter(this.mRenderFilter);
        this.mRenderView.addRenderCallback(this.mSHCallback);
        this.mRenderView.setVideoRotation(this.mVideoRotationDegree);
        this.mRenderView.setAntiShake(this.mAntiViewShake);
        if (this.mAspectRatio > 0) {
            this.mRenderView.setAspectRatio(this.mAspectRatio);
        }
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            this.mRenderView.setVideoSize(this.mVideoWidth, this.mVideoHeight);
        }
        if ((view = this.mRenderView.getView()) != null) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.setSecureImpl(this.mIsSecure);
            DebugLog.i(this.getLogTag(), "setRenderView addRenderView");
            if (n3 >= 0) {
                this.addView(view, n3);
            } else {
                this.addView(view);
            }
        }
        this.mRenderView.setDisplayFloatRect(this.mDisplayFloatRect);
        if (this.mResizableFrameView != null) {
            this.removeView(this.mResizableFrameView);
            this.mResizableFrameView = null;
        }
        this.mResizableFrameView = new l(this.mContext);
        this.addView(this.mResizableFrameView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        if (this.mRenderView != null) {
            this.mRenderView.bindResizableFrameView(this.mResizableFrameView);
        }
    }

    private void initVideoView(Context context) {
        this.initVideoView(context, 0);
    }

    private void initVideoView(Context context, int n2) {
        this.mContext = context;
        this.metrics = this.mContext.getResources().getDisplayMetrics();
        this.mInitRenderViewType = this.mRenderViewType = n2;
        if (n2 == 0) {
            this.mEnableTexture = false;
        }
        this.mFakeFrameView = new c(context);
        this.addView((View)this.mFakeFrameView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.toggleRenders(n2);
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        AudioUtil.registerHeadsetReceiverOnce(this.mContext);
        if (!Constants.FOR_OTT) {
            this.setFocusable(true);
            this.setFocusableInTouchMode(true);
            this.requestFocus();
        }
        if (context instanceof Activity) {
            ((Activity)context).setVolumeControlStream(3);
        }
        this.checkMemoryStatus(this.mContext);
        this.changeCurrentState(0);
        this.mTargetState = 0;
    }

    @Override
    public void convertRender(int n2) {
        DebugLog.i(this.getLogTag(), "convertRender to " + n2);
        try {
            this.release(true, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mInitRenderViewType = n2;
        this.toggleRenders(n2);
    }

    @Override
    public void setStartPosMs(int n2) {
        this.mStartPosMs = n2;
    }

    @Override
    public void setVideoPath(String string) {
        this.setVideoPath(string, null, null);
    }

    @Override
    public void resetVideoPath(String string) {
        this.resetVideoPath(string, null, null);
    }

    @Override
    public void setVideoPath(String string, IP2pTask iP2pTask, String string2) {
        DebugLog.i(this.getLogTag(), "setVideoPath path " + string + ",proxyPath:" + string2);
        this.mNeedResetLoopPlay = false;
        if (this.mEnableTexture) {
            if (Build.VERSION.SDK_INT <= 22) {
                DebugLog.i(this.getLogTag(), "setVideoPath need rebindTexture");
                this.mRebindTexture = true;
            } else {
                this.mRebindTexture = false;
            }
        } else {
            this.mRebindTexture = false;
        }
        this.mMainP2pTask = iP2pTask;
        this.mProxyUri = StringUtil.isEmpty(string2) ? null : Uri.parse((String)string2.trim());
        if (string == null) {
            this.mErrorListener.onError(7000011, 11);
        } else {
            this.setVideoURI(Uri.parse((String)string.trim()));
        }
    }

    @Override
    public void setAudioPath(@NonNull String string) {
    }

    @Override
    public boolean isOnlyAudioMode() {
        return false;
    }

    private void setVideoURI(Uri uri) {
        this.mNonSurfaceHolderPVTimestamp = 0L;
        this.mCurrentUri = uri;
        this.mSeekWhenPrepared = 0;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    private void resetVideoPath() {
        if (this.mCurrentUri == null) {
            DebugLog.e(this.getLogTag(), "resetVideoPath mCurrentUri == null return");
            return;
        }
        this.resetVideoPath(this.mCurrentUri.toString(), this.mMainP2pTask, this.mProxyUri != null ? this.mProxyUri.toString() : null);
    }

    @Override
    public void resetVideoPath(String string, IP2pTask iP2pTask, String string2) {
        DebugLog.i(this.getLogTag(), "resetVideoPath path " + string + ",proxyPath:" + string2);
        this.mNonSurfaceHolderPVTimestamp = 0L;
        this.mNeedResetLoopPlay = false;
        if (string == null) {
            this.mErrorListener.onError(7000011, 12);
        } else {
            this.mCurrentUri = Uri.parse((String)string.trim());
        }
        this.mMainP2pTask = iP2pTask;
        this.mProxyUri = StringUtil.isEmpty(string2) ? null : Uri.parse((String)string2.trim());
        if (this.mMediaPlayer != null) {
            if (Build.VERSION.SDK_INT <= 22) {
                DebugLog.i(this.getLogTag(), "resetVideoPath need rebindTexture");
                this.mRebindTexture = true;
            } else {
                this.mRebindTexture = false;
            }
            if (this.mHasSurfaceHolderDestroy) {
                this.convertRender(this.mRenderViewType);
            } else if (this.isInLoopValidState() && this.mIsLoopMode && !this.mMediaPlayer.isLoopSwitching()) {
                DebugLog.i(this.getLogTag(), "resetVideoPathLoopImpl in");
                this.resetVideoPathLoopImpl(string, iP2pTask, string2);
                DebugLog.i(this.getLogTag(), "resetVideoPathLoopImpl out");
            } else {
                if (this.mMediaPlayer.isLoopSwitching()) {
                    DebugLog.i(this.getLogTag(), "isLoopSwitching change to resetVideoPathNormalImpl");
                }
                DebugLog.i(this.getLogTag(), "resetVideoPathNormalImpl in");
                this.resetVideoPathNormalImpl(string, iP2pTask, string2);
                DebugLog.i(this.getLogTag(), "resetVideoPathNormalImpl in");
            }
        } else {
            this.setVideoPath(string, iP2pTask, string2);
        }
    }

    boolean isTextureView() {
        return this.mRenderView != null && this.mRenderView.getRenderViewType() == 1;
    }

    void resetVideoPathLoopImpl(String string, IP2pTask iP2pTask, String string2) {
        if (this.mMediaPlayer == null) {
            DebugLog.e(this.getLogTag(), "resetVideoPathLoopImpl mMediaPlayer == null return");
            return;
        }
        this.mMediaPlayer.setReportParams(this.mReportParams);
        this.mFromSurfaceDestroyToPlay = false;
        this.mHasSurfaceHolderDestroy = false;
        this.mMediaPlayer.resetLoopPlay();
        this.resumeLoadData();
        this.configImgoPlayer();
        if (this.mSurfaceHolder != null || this.mEnableTexture && this.isTextureView()) {
            if (this.mStartPosMs > 0) {
                this.mMediaPlayer.switchLoopSource(this.mReadDataSourceTypeConfig, string, iP2pTask, string2, this.mStartPosMs);
                this.mStartPosMs = 0;
            } else {
                this.mMediaPlayer.switchLoopSource(this.mReadDataSourceTypeConfig, string, iP2pTask, string2, 0);
            }
        } else {
            DebugLog.i(this.getLogTag(), "resetVideoPathLoopImpl mSurfaceHolder == null wait surface attach to window");
            this.mNeedResetLoopPlay = true;
        }
    }

    private void resetVideoPathNormalImpl(String string, IP2pTask iP2pTask, String string2) {
        this.mMediaPlayer.setSurfaceHolder(null);
        ResetResult resetResult = this.resetImpl(true);
        if (resetResult == ResetResult.NONE) {
            this.setVideoPath(string, iP2pTask, string2);
            return;
        }
        if (resetResult == ResetResult.RESET_ERR) {
            return;
        }
        if (this.mSurfaceHolder != null) {
            try {
                DebugLog.e(this.getLogTag(), "------chodison----reprepare MgtvMediaPlayer mMgtvMediaPlayerHardwareMode:" + this.mMgtvMediaPlayerHardwareMode + " url:" + this.mCurrentUri.toString());
                this.mMediaPlayer.setReportParams(this.mReportParams);
                this.configImgoPlayer();
                this.mFromSurfaceDestroyToPlay = false;
                this.mHasSurfaceHolderDestroy = false;
                DebugLog.i(this.getLogTag(), "resetVideoPath streamKey:" + this.mStreamKey);
                if (this.mMainP2pTask != null || this.mProxyUri != null) {
                    this.mMediaPlayer.setP2pDataSource(this.mCurrentUri.toString(), this.mMainP2pTask, this.mProxyUri != null ? this.mProxyUri.toString() : null, this.mStreamKey);
                } else {
                    this.mMediaPlayer.setReadDataSourceType(0);
                    this.mMediaPlayer.setDataSource(this.mCurrentUri.toString());
                }
                this.mMediaPlayer.setSurfaceHolder(this.mSurfaceHolder);
                this.mMediaPlayer.prepareAsync();
                this.changeCurrentState(1);
            }
            catch (InvalidParameterException invalidParameterException) {
                this.mErrorMsg = invalidParameterException.getMessage();
                this.mErrorListener.onError(7000009, 2);
                invalidParameterException.printStackTrace();
            }
            catch (Exception exception) {
                this.mErrorMsg = exception.getMessage();
                this.mErrorListener.onError(7000012, 0);
                exception.printStackTrace();
            }
        } else {
            this.mNonSurfaceHolderPVTimestamp = System.currentTimeMillis();
            this.mOpenVideoWhenSurfaceCreate = true;
        }
    }

    @Override
    void stopInner() {
        if (this.mIsLoopMode) {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.pause();
            }
        } else if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
        }
    }

    @Override
    public void reset() {
        this.resetImpl(false);
    }

    private ResetResult resetImpl(boolean bl) {
        if (this.mMediaPlayer != null) {
            this.resetDataBefore(bl ? MgtvAbstractVideoView.ReleaseReason.DEFAULT_INNER : MgtvAbstractVideoView.ReleaseReason.OUT);
            boolean bl2 = this.mMediaPlayer.reset();
            if (bl2) {
                this.changeCurrentState(0);
                this.mTargetState = 0;
            }
            this.resetDataAfter(bl ? MgtvAbstractVideoView.ReleaseReason.DEFAULT_INNER : MgtvAbstractVideoView.ReleaseReason.OUT);
            return bl2 ? ResetResult.RESET_OK : ResetResult.RESET_ERR;
        }
        return ResetResult.NONE;
    }

    @Override
    public void resetRender() {
        if (Constants.FOR_OTT && this.mEnableTexture) {
            this.mHasSurfaceHolderDestroy = true;
        }
    }

    @Override
    public void release() {
        super.release();
        this.release(true, false);
        this.afterRelease();
    }

    private void release(boolean bl, boolean bl2) {
        DebugLog.i(this.getLogTag(), "release player.clear.cleartargetstate:" + bl);
        if (this.mMediaPlayer != null) {
            if (bl) {
                this.mMediaPlayer.stop();
            }
            this.resetDataBefore(bl2 ? MgtvAbstractVideoView.ReleaseReason.DEFAULT_INNER : MgtvAbstractVideoView.ReleaseReason.OUT);
            this.releaseNoStatus();
            this.changeCurrentState(0);
            if (bl) {
                this.mTargetState = 0;
            }
            this.resetDataAfter(bl2 ? MgtvAbstractVideoView.ReleaseReason.DEFAULT_INNER : MgtvAbstractVideoView.ReleaseReason.OUT);
        }
        if (!bl2) {
            this.abandonAudioFocus();
        }
    }

    @Override
    public void setTimeout(int n2, int n3) {
        this.mConnectTimeOut = n2;
        this.mReciveDataTimeOut = n3;
    }

    @Override
    public void setBufferTimeout(int n2) {
        this.mBufferTimeoutMs = n2;
    }

    private void openVideo() {
        this.openVideo(this.mMgtvMediaPlayerHardwareMode);
    }

    private void openVideo(boolean bl) {
        SurfaceHolder surfaceHolder;
        this.mErrorMsg = "";
        if (this.mCurrentUri == null || this.mSurfaceHolder == null) {
            DebugLog.e(this.getLogTag(), "imgo openVideo: not ready for playback just yet, will try again later, mCurrentUri:" + this.mCurrentUri + ", mSurfaceHolder:" + this.mSurfaceHolder);
            if (this.mCurrentUri != null && this.mSurfaceHolder == null) {
                this.mNonSurfaceHolderPVTimestamp = System.currentTimeMillis();
                this.mOpenVideoWhenSurfaceCreate = true;
            }
            return;
        }
        if (this.mRenderView == null) {
            if (this.mErrorListener != null) {
                this.mErrorListener.onError(7000005, 0);
            }
            this.mErrorMsg = "openVideo renderView is null";
            DebugLog.e(this.getLogTag(), this.mErrorMsg);
            return;
        }
        if (!(this.mRenderView.getRenderViewType() != 0 || (surfaceHolder = this.mSurfaceHolder.getSurfaceHolder()) != null && surfaceHolder.getSurface() != null && surfaceHolder.getSurface().isValid())) {
            if (this.mErrorListener != null) {
                this.mErrorListener.onError(7000009, 0);
            }
            this.mErrorMsg = "openVideo surface is invalid";
            if (surfaceHolder != null) {
                DebugLog.e(this.getLogTag(), "openVideo surface is invalid " + surfaceHolder.getSurface());
            }
            return;
        }
        if (this.isRequestAudioFocus) {
            this.requestAudioFocus();
        }
        this.release(false, true);
        try {
            surfaceHolder = new Bundle();
            surfaceHolder.putString("BUNDLE_KEY_LOG_TAG_KEY", this.getLogTagKey());
            if (!this.mUseSystemPlayer) {
                int n2 = 0;
                if (this.mIsLiveConfig) {
                    n2 = 1;
                } else if (this.mTargetIsLoopMode) {
                    this.mIsLoopMode = true;
                    n2 = 2;
                }
                if (bl) {
                    if (this.mIsLoopMode) {
                        if (Build.VERSION.SDK_INT <= 22) {
                            this.mEnableTexture = false;
                        }
                        this.mMediaPlayer = new MgtvMediaPlayer(2, this.mContext, this.mEnableTexture, n2, (Bundle)surfaceHolder);
                    } else {
                        this.mEnableTexture = false;
                        this.mMediaPlayer = new MgtvMediaPlayer(2, this.mContext, this.mEnableTexture, n2, (Bundle)surfaceHolder);
                    }
                } else {
                    this.mEnableTexture = false;
                    this.mMediaPlayer = new MgtvMediaPlayer(1, this.mContext, this.mEnableTexture, n2, (Bundle)surfaceHolder);
                }
            } else {
                this.mMediaPlayer = new MgtvMediaPlayer(0, this.mContext, false, (Bundle)surfaceHolder);
            }
            this.mMediaPlayer.setFlowDataStatistic(this.mFlowDataStatistic);
            this.mMediaPlayer.setReportParams(this.mReportParams);
            this.configImgoPlayer();
            super.initListener(this.mMediaPlayer);
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnStartListener(this.mStartListener);
            this.mMediaPlayer.setOnPauseListener(this.mPauseListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.mMediaPlayer.setOnSeekCompleteListener(this.mSeekCompleteListener);
            this.mMediaPlayer.setOnBufferingTimeoutListener(this.mBufferingTimeoutListener);
            this.mMediaPlayer.setOnSwitchSourceListener(this.mSwitchSourceListener);
            this.mMediaPlayer.setOnWarningListener(this.mPlayerWarning);
            this.mMediaPlayer.setOnRecordVideoListener(this.mRecordVideoListener);
            this.mMediaPlayer.setOnLoadDataListener(this.mLoadDataListener);
            this.mFromSurfaceDestroyToPlay = false;
            this.mHasSurfaceHolderDestroy = false;
            if (this.mReadDataSourceTypeConfig == 3 && this.mDataSource != null) {
                this.mMediaPlayer.setReadDataSourceType(3);
                this.mMediaPlayer.setDataSource(this.mDataSource);
                DebugLog.i(this.getLogTag(), "setDataSource READ_DATASOURCE_TYPE_DATA_SOURCE");
            } else if (this.mMainP2pTask != null || this.mProxyUri != null) {
                this.mMediaPlayer.setP2pDataSource(this.mCurrentUri.toString(), this.mMainP2pTask, this.mProxyUri != null ? this.mProxyUri.toString() : null, this.mStreamKey);
            } else {
                this.mMediaPlayer.setReadDataSourceType(0);
                this.mMediaPlayer.setDataSource(this.mCurrentUri.toString());
            }
            this.mMediaPlayer.setSurfaceHolder(this.mSurfaceHolder);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(this.mIsScreenOnWhilePlaying);
            this.mMediaPlayer.prepareAsync();
            this.changeCurrentState(1);
            DebugLog.i(this.getLogTag(), "openVideo is over");
        }
        catch (InvalidParameterException invalidParameterException) {
            DebugLog.w(this.getLogTag(), "Unable to open content: " + this.mCurrentUri);
            this.mErrorMsg = invalidParameterException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000009, 3);
            return;
        }
        catch (IOException iOException) {
            DebugLog.w(this.getLogTag(), "Unable to open content: " + this.mCurrentUri);
            this.mErrorMsg = iOException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7001004, 0);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException != null) {
                DebugLog.w(this.getLogTag(), "Unable to open content: " + this.mCurrentUri + ",details:" + illegalArgumentException.getMessage());
            }
            this.mErrorMsg = illegalArgumentException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000001, 0);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            DebugLog.w(this.getLogTag(), "Unable to open content: " + this.mCurrentUri);
            this.mErrorMsg = illegalStateException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000002, 0);
            return;
        }
        catch (SecurityException securityException) {
            if (securityException != null) {
                DebugLog.i(this.getLogTag(), "SecurityException: " + this.mCurrentUri + ",details:" + securityException.getMessage());
            }
            this.mErrorMsg = securityException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000004, 0);
            return;
        }
        catch (NullPointerException nullPointerException) {
            if (nullPointerException != null) {
                DebugLog.i(this.getLogTag(), "NullPointerException: " + this.mCurrentUri + ",details:" + nullPointerException.getMessage());
            }
            this.mErrorMsg = nullPointerException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000005, 0);
            return;
        }
        catch (Exception exception) {
            if (exception != null) {
                DebugLog.w(this.getLogTag(), "Unable to open content: " + this.mCurrentUri + ",details:" + exception.getMessage());
            }
            this.mErrorMsg = exception.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000003, 0);
            return;
        }
        catch (com.hunantv.media.player.loader.c c2) {
            DebugLog.e(this.getLogTag(), "LibLoaderError: " + this.mCurrentUri + "details:" + c2.getMessage() + ",extra:" + c2.a());
            this.mErrorMsg = c2.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000010, c2.a());
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (unsatisfiedLinkError != null) {
                DebugLog.i(this.getLogTag(), "UnsatisfiedLinkError: " + this.mCurrentUri + ",details:" + unsatisfiedLinkError.getMessage());
            }
            this.mErrorMsg = unsatisfiedLinkError.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000010, 0);
            return;
        }
        catch (Throwable throwable) {
            if (throwable != null) {
                DebugLog.i(this.getLogTag(), "Throwable: " + this.mCurrentUri + ",details:" + throwable.getMessage());
            }
            this.mErrorMsg = throwable.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000003, 1);
            return;
        }
    }

    private void checkMemoryStatus(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        if (!ImgoLibLoader.getInstance().isAllPlayerLibLoaded() && (memoryInfo = MemoryUtil.getMemoryInfo(context)) != null && memoryInfo.lowMemory) {
            this.mPlayerWarning.onWarning(800600, (memoryInfo.availMem >> 20) + "", "[" + memoryInfo.availMem + "-" + memoryInfo.lowMemory + "-" + memoryInfo.threshold + "]", null);
        }
    }

    @Override
    public boolean isPrepared() {
        return this.isInPlaybackState();
    }

    @Override
    public boolean isRendered() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.isRendered();
        }
        return false;
    }

    @Override
    public boolean isCompletion() {
        return this.mCurrentState == 5;
    }

    public boolean isStretchScreen() {
        return this.isStretchScreen;
    }

    public void setStretchScreen() {
        if (this.shouldGetVideoParams) {
            DebugLog.i("@@@", "getFullScreenVideoParams");
            this.getFullScreenVideoParams();
            this.shouldGetVideoParams = false;
        }
        if (!this.isStretchScreen) {
            this.layout(0, 0, this.metrics.widthPixels, this.metrics.heightPixels);
            this.mVideoWidth = this.metrics.widthPixels;
            this.mVideoHeight = this.metrics.heightPixels;
            this.isStretchScreen = true;
        } else {
            this.mVideoWidth = this.originalVideoWidth;
            this.mVideoHeight = this.originalVideoHeight;
            this.layout(this.fromLeft, this.fromTop, this.fromRight, this.fromBottom);
            this.isStretchScreen = false;
        }
        if (this.mRenderView != null) {
            this.mRenderView.setVideoSize(this.mVideoWidth, this.mVideoHeight);
        }
    }

    private void getFullScreenVideoParams() {
        float f2 = (float)this.mVideoWidth / (float)this.mVideoHeight;
        if ((float)this.metrics.widthPixels / (float)this.metrics.heightPixels < f2) {
            int n2 = this.metrics.widthPixels * this.mVideoHeight / this.mVideoWidth;
            int n3 = (this.metrics.heightPixels - n2) / 2;
            this.fromLeft = 0;
            this.fromTop = n3;
            this.fromRight = this.metrics.widthPixels;
            this.fromBottom = n3 + n2;
        } else {
            int n4;
            int n5 = this.metrics.heightPixels * this.mVideoWidth / this.mVideoHeight;
            this.fromLeft = n4 = (this.metrics.widthPixels - n5) / 2;
            this.fromTop = 0;
            this.fromRight = n4 + n5;
            this.fromBottom = this.metrics.heightPixels;
        }
        DebugLog.i(this.getLogTag(), "fromLeft:" + this.fromLeft + "/fromTop:" + this.fromTop + "/fromRight:" + this.fromRight + "/fromBottom:" + this.fromBottom);
    }

    @Override
    public String getDLSpeedFormat() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(1);
        float f2 = 0.0f;
        if (this.mMediaPlayer != null) {
            f2 = (float)this.mMediaPlayer.getCurDLSpeed() / 1000.0f;
        }
        return numberFormat.format(f2) + "KB/S";
    }

    @Override
    public int getDLSpeedB() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getCurDLSpeed();
        }
        return 0;
    }

    @Override
    public void setOnBufferingUpdateListener(IVideoView.OnBufferingUpdateListener onBufferingUpdateListener) {
        this.mOnBufferringUpdateListener = onBufferingUpdateListener;
    }

    @Override
    public void setOnWarningListener(MgtvPlayerListener.OnWarningListener onWarningListener) {
        this.mOnWarningListener = onWarningListener;
    }

    @Override
    public void setOnChangeSourceListener(IVideoView.OnChangeSourceListener onChangeSourceListener) {
        this.mOnChangeSourceListener = onChangeSourceListener;
    }

    @Override
    public void setOnRecordListener(IVideoView.OnRecordListener onRecordListener) {
        this.mOnRecordListener = onRecordListener;
    }

    @Override
    public void setOnUpdateStatusListener(IVideoView.OnUpdateStatusListener onUpdateStatusListener) {
        this.mOnUpdateStatusListener = onUpdateStatusListener;
    }

    @Override
    public void setOnVideoSizeChangedListener(IVideoView.OnVideoSizeChangedListener onVideoSizeChangedListener) {
        this.mOnVideoSizeChangedListener = onVideoSizeChangedListener;
    }

    @Override
    public void setOnLoadDataListener(IVideoView.OnLoadDataListener onLoadDataListener) {
        this.mOnLoadDataListener = onLoadDataListener;
    }

    @Override
    public void setOnSwitchSmoothSourceListener(IVideoView.OnSwitchSmoothSourceListener onSwitchSmoothSourceListener) {
    }

    @Override
    public void setOnPreparedListener(IVideoView.OnPreparedListener onPreparedListener) {
        this.mOnPreparedListener = onPreparedListener;
    }

    @Override
    public void setOnCompletionListener(IVideoView.OnCompletionListener onCompletionListener) {
        this.mOnCompletionListener = onCompletionListener;
    }

    @Override
    public void setOnInfoListener(IVideoView.OnInfoListener onInfoListener) {
        this.mOnInfoListener = onInfoListener;
    }

    @Override
    public void setOnErrorListener(IVideoView.OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    @Override
    public void setOnSeekCompleteListener(IVideoView.OnSeekCompleteListener onSeekCompleteListener) {
        this.mOnSeekCompleteListener = onSeekCompleteListener;
    }

    @Override
    public void setOnStartListener(IVideoView.OnStartListener onStartListener) {
        this.mOnStartListener = onStartListener;
    }

    @Override
    public void setOnPauseListener(IVideoView.OnPauseListener onPauseListener) {
        this.mOnPauseListener = onPauseListener;
    }

    private boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentState != -1 && this.mCurrentState != 0 && this.mCurrentState != 1;
    }

    private boolean isInLoopValidState() {
        return this.mMediaPlayer != null && this.mCurrentState != -1 && this.mCurrentState != 0;
    }

    @Override
    public void start() {
        if (this.isInPlaybackState()) {
            if (this.isRequestAudioFocus) {
                this.requestAudioFocus();
            }
            if (this.mCurrentState != 3) {
                if (this.mCurrentState == 5) {
                    DebugLog.e(this.getLogTag(), "play video direct after complete");
                }
                this.resumeLoadData();
                this.mMediaPlayer.start();
                DebugLog.i(this.getLogTag(), "start play");
                if (!this.mEnableCoreStartPauseListen) {
                    this.callbackOnStart();
                }
            }
        }
        this.mTargetState = 3;
    }

    private void callbackOnStart() {
        this.changeCurrentState(3);
        if (this.mOnStartListener != null) {
            this.mOnStartListener.onStart();
        }
    }

    private void callbackOnPause() {
        this.changeCurrentState(4);
        if (this.mOnPauseListener != null) {
            this.mOnPauseListener.onPause();
        }
    }

    @Override
    public void pause() {
        this.pauseInner();
        this.mTargetState = 4;
    }

    private void pauseInner() {
        if (this.isInPlaybackState() && (this.mMediaPlayer.isPlaying() || this.isInLoopValidState() && this.mIsLoopMode && this.isCompletion())) {
            DebugLog.i(this.getLogTag(), "pause play");
            this.mMediaPlayer.pause();
            if (!this.mEnableCoreStartPauseListen) {
                this.callbackOnPause();
            }
        }
        if (this.isReuseTextureDisable()) {
            this.saveLastValidFrame();
        }
    }

    public void saveLastValidFrame() {
        if (this.mRenderView != null) {
            this.mRenderView.saveLastValidFrame();
        }
    }

    @Override
    public void resume() {
        this.openVideo();
    }

    @Override
    public int getDuration() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getDuration();
        }
        return -1;
    }

    @Override
    public int getCurrentPosition() {
        if (this.mMediaPlayer != null) {
            if (this.mCurrentState != 0 && this.mCurrentState != 1) {
                return this.mMediaPlayer.getCurrentPosition();
            }
        } else {
            DebugLog.d(this.getLogTag(), "getCurrentPosition mMediaPlayer is null");
        }
        return 0;
    }

    @Override
    public int getCurrentPositionUnsafe() {
        if (this.mMediaPlayer != null && this.mCurrentState != 0 && this.mCurrentState != 1) {
            return this.mMediaPlayer.getCurrentPositionUnSafe();
        }
        return 0;
    }

    @Override
    public void seekTo(int n2, boolean bl) {
        if (this.isInPlaybackState()) {
            if (n2 >= 0) {
                if (this.mFromSurfaceDestroyToPlay) {
                    this.mFromSurfaceDestroyPlayPosition = n2;
                }
                DebugLog.i(this.getLogTag(), "seekTo msec:" + n2);
                this.mMediaPlayer.seekTo(n2, bl);
                if (this.mSeekAutoStartAfterCompleteEnable && this.mCurrentState == 5) {
                    this.callbackOnStart();
                }
            }
            this.mSeekWhenPrepared = 0;
        } else {
            this.mSeekWhenPrepared = n2;
        }
    }

    @Override
    public void seekTo(int n2) {
        if (this.isInPlaybackState()) {
            if (n2 >= 0) {
                if (this.mFromSurfaceDestroyToPlay) {
                    this.mFromSurfaceDestroyPlayPosition = n2;
                }
                this.mMediaPlayer.seekTo(n2);
                if (this.mSeekAutoStartAfterCompleteEnable && this.mCurrentState == 5) {
                    this.callbackOnStart();
                }
            }
            this.mSeekWhenPrepared = 0;
        } else {
            this.mSeekWhenPrepared = n2;
        }
    }

    @Override
    public boolean isPlaying() {
        return this.isInPlaybackState() && this.mMediaPlayer.isPlaying();
    }

    @Override
    public int getBufferingPercentage() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getBufferingPercent();
        }
        return 0;
    }

    @Override
    public int getTotalBuffering() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getBufferedPercentage();
        }
        return 0;
    }

    @Override
    public void setPlayerHardwareMode(boolean bl) {
        this.mMgtvMediaPlayerHardwareMode = bl;
    }

    @Override
    public void setForceDecodeMode(boolean bl) {
        this.mForceDecodeMode = bl;
    }

    @Override
    public boolean isHardware() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.isHardware();
        }
        return false;
    }

    @Override
    public void setPlayerAudioMode(boolean bl) {
        this.mMgtvMediaPlayerAudioMode = bl;
    }

    @Override
    public String getPlayerVersion() {
        return MgtvLoopVideoView.getVersion();
    }

    public static String getVersion() {
        return "MGTV_1.22.0";
    }

    @Override
    public int getVideoWidth() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getVideoHeight();
        }
        return 0;
    }

    @Override
    public int getBitRate() {
        if (this.mMediaPlayer != null) {
            return (int)this.mMediaPlayer.getVideoBitRate();
        }
        return 0;
    }

    @Override
    public int getFPS() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getVideoFPS();
        }
        return 0;
    }

    @Override
    public String getErrorMsg() {
        return this.mErrorMsg;
    }

    @Override
    public String getErrorUrl() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.getErrorUrl();
        }
        return "";
    }

    @Override
    public void setZOrderMediaOverlay(boolean bl) {
        if (this.mRenderView != null && this.mRenderView.getView() != null && this.mRenderView.getView() instanceof SurfaceView) {
            ((SurfaceView)this.mRenderView.getView()).setZOrderMediaOverlay(bl);
        }
    }

    @Override
    public void setPlaybackSpeed(float f2) {
        this.mPlaySpeed = f2;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setPlaybackSpeed(f2);
        }
    }

    @Override
    public float getPlaybackSpeed() {
        return this.mPlaySpeed;
    }

    @Override
    public void changeSourceAsync(String string, int n2, int n3, int n4) {
        block5: {
            if (this.mMediaPlayer != null) {
                try {
                    this.mMediaPlayer.switchVideoSource(string, n2, n3, n4);
                    DebugLog.e(this.getLogTag(), "changeSourceAsync url:" + string);
                    DebugLog.e(this.getLogTag(), "changeSourceAsync src:" + n3 + ",dst:" + n4);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (this.mOnChangeSourceListener != null) {
                        this.mOnChangeSourceListener.onChangeSourceFailed(string, 7000001, 0);
                    }
                }
                catch (Exception exception) {
                    if (this.mOnChangeSourceListener == null) break block5;
                    this.mOnChangeSourceListener.onChangeSourceFailed(string, 7000003, 0);
                }
            }
        }
    }

    @Override
    public void changeSourceAsync(IVideoView.MediaSource mediaSource, int n2, int n3, int n4) {
        block9: {
            int n5 = 0;
            String string = null;
            IP2pTask iP2pTask = null;
            String string2 = null;
            if (mediaSource == null) {
                if (this.mOnChangeSourceListener != null) {
                    this.mOnChangeSourceListener.onChangeSourceFailed(string, 7000001, 0);
                }
                return;
            }
            n5 = mediaSource.readType;
            string = mediaSource.url;
            iP2pTask = mediaSource.p2pTask;
            string2 = mediaSource.proxyUrl;
            if (this.mMediaPlayer != null) {
                try {
                    if (n5 == 0 || iP2pTask == null && StringUtil.isEmpty(string2)) {
                        n5 = 0;
                        mediaSource.readType = 0;
                        this.mMediaPlayer.switchVideoSource(string, n2, n3, n4);
                    } else {
                        this.mMediaPlayer.switchP2pVideoSource(n5, string, iP2pTask, string2, n2, n3, n4);
                    }
                    DebugLog.i(this.getLogTag(), "changeSourceAsync url:" + string);
                    DebugLog.i(this.getLogTag(), "changeSourceAsync p2pTask:" + iP2pTask);
                    DebugLog.i(this.getLogTag(), "changeSourceAsync proxyUrl:" + string2);
                    DebugLog.i(this.getLogTag(), "changeSourceAsync type:" + n2 + "src:" + n3 + ",dst:" + n4);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (this.mOnChangeSourceListener != null) {
                        this.mOnChangeSourceListener.onChangeSourceFailed(string, 7000001, 0);
                    }
                }
                catch (Exception exception) {
                    if (this.mOnChangeSourceListener == null) break block9;
                    this.mOnChangeSourceListener.onChangeSourceFailed(string, 7000003, 0);
                }
            }
        }
    }

    @Override
    public void openImgoDSModule(boolean bl) {
        if (this.mTargetIsLoopMode) {
            return;
        }
        if (this.mDataSourceInfo != null) {
            DebugLog.i(this.getLogTag(), "openImgoDSModule fileFormat:" + this.mDataSourceInfo.getFileFormat());
        }
        this.mDataSourceType = bl ? MgtvMediaPlayer.DataSourceType.TYPE_DATASOUCE_IMGO : MgtvMediaPlayer.DataSourceType.TYPE_DATASOUCE_DEFAULT;
    }

    @Override
    public boolean isImgoSourceModuleOpen() {
        return ImgoLibLoader.getInstance().isDsLibLoaded() && this.mDataSourceType == MgtvMediaPlayer.DataSourceType.TYPE_DATASOUCE_IMGO;
    }

    @Override
    protected void configImgoPlayer() {
        super.configImgoPlayer();
        this.mOpenVideoWhenSurfaceCreate = false;
        if (this.mReportParams != null) {
            this.mReportParams.setAddrInfoInt(this.mAddrInfoTypeInt);
        }
        if (this.mDnsFamilyType != 1) {
            this.setNetAddrinfo(0, -1);
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.bindRenderView(this.mRenderView != null ? this.mRenderView.getRenderView() : null);
            this.mMediaPlayer.setTimeout(this.mConnectTimeOut, this.mReciveDataTimeOut, this.mBufferTimeoutMs);
            this.mMediaPlayer.setDataSourceType(this.mDataSourceType);
            this.mMediaPlayer.setAccurateSeekEnable(this.mAccurateSeekEnable);
            this.mMediaPlayer.setNetAddrinfo(this.mAddrInfoType, this.mAddrInfoTimeoutMs, this.mJavaDnsEnable, this.mJavaDnsType, this.mNativeDnsAsyncEnable);
            this.mMediaPlayer.configTsNotSkip(this.mTsNotSkip);
            if (this.mLoadMaxRetryTime > 0) {
                this.mMediaPlayer.configLoadMaxRetryTime(this.mLoadMaxRetryTime);
            }
            if (this.mWeakNetSpeed > 0) {
                this.mMediaPlayer.configWeakBufferSpeed(this.mWeakNetSpeed);
            }
            if (this.mWeakBufferTimeoutMs > 0) {
                this.mMediaPlayer.configWeakBufferTimeout(this.mWeakBufferTimeoutMs);
            }
            this.mMediaPlayer.enableM3u8Cache(this.mCacheEnable);
            this.mMediaPlayer.setM3u8Caches(this.mCacheM3u8Path, this.mCacheTsPaths);
            if (this.mLeftVolume >= 0.0f && this.mRightVolume >= 0.0f) {
                this.mMediaPlayer.setVolume(this.mLeftVolume, this.mRightVolume);
            }
            this.mEnableCoreStartPauseListen = this.mMediaPlayer.isMgtvCore() && this.mUserEnableCoreStartPauseListen;
            this.mMediaPlayer.configForceHW(this.mForceDecodeMode);
            this.mMediaPlayer.bindGifRecorder(this.mGifRecorder);
            this.mMediaPlayer.setPlaybackSpeed(this.mPlaySpeed);
            this.mMediaPlayer.setLiveStartIndex(this.mLiveStartIndex);
            if (this.mStartPosMs > 0) {
                this.mMediaPlayer.setPlayerPrepareStartPosMs(this.mStartPosMs);
                DebugLog.i(this.getLogTag(), "configImgoPlayer mLoopStartPosMs:" + this.mStartPosMs);
            }
            this.mMediaPlayer.setReadDataSourceType(this.mReadDataSourceTypeConfig);
            this.updateDataCacheSizeKB();
            this.updateSkipLoopFilter();
            this.mMediaPlayer.enableTsSkipError(this.mEnableTsSkipError);
            this.mMediaPlayer.enableMgtvMediaCodec(this.mEnableMgtvMediaCodec);
            DebugLog.i(this.getLogTag(), "configImgoPlayer mConnectTimeOut:" + this.mConnectTimeOut + ",mReciveDataTimeOut:" + this.mReciveDataTimeOut + ",mBufferTimeoutMs:" + this.mBufferTimeoutMs + ",mDataSourceType:" + (Object)((Object)this.mDataSourceType) + ",mAccurateSeekEnable:" + this.mAccurateSeekEnable + ",mAddrInfoType:" + (Object)((Object)this.mAddrInfoType) + ",mAddrInfoTimeoutMs:" + this.mAddrInfoTimeoutMs + ",mJavaDnsEnable:" + this.mJavaDnsEnable + ",mJavaDnsType:" + (Object)((Object)this.mJavaDnsType) + ",mPlaySpeed:" + this.mPlaySpeed + ",mLiveStartIndex:" + this.mLiveStartIndex + ",mEnableLiveMode:" + this.mEnableLiveMode + ",mReadDataSourceTypeConfig:" + this.mReadDataSourceTypeConfig + ",mNativeDnsAsyncEnable:" + this.mNativeDnsAsyncEnable + ",mEnableTsSkipError:" + this.mEnableTsSkipError + ",mEnableMgtvMediaCodec:" + this.mEnableMgtvMediaCodec);
            if (this.mNonSurfaceHolderPVTimestamp > 0L) {
                this.mMediaPlayer.setNetdSVCTimeMs(System.currentTimeMillis() - this.mNonSurfaceHolderPVTimestamp);
            } else {
                this.mMediaPlayer.setNetdSVCTimeMs(0L);
            }
        }
    }

    @Override
    public void setPlayerDebug(boolean bl) {
        MgtvMediaPlayer.setPlayerDebug(bl);
    }

    @Override
    public void setStreamKey(int n2) {
        this.mStreamKey = n2;
    }

    @Override
    void resetDataBefore(MgtvAbstractVideoView.ReleaseReason releaseReason) {
        super.resetDataBefore(releaseReason);
        this.mIsLive = false;
        this.mIsDataLoaderPaused = false;
        if (this.mRenderView != null) {
            this.mRenderView.reset();
        }
        if (releaseReason == MgtvAbstractVideoView.ReleaseReason.OUT) {
            this.mStartLeaveTimestamp = 0L;
            this.mCacheM3u8Path = null;
            this.mCacheTsPaths = null;
            this.mStartPosMs = 0;
            if (this.mFlowDataStatistic != null && this.mFlowDataStatistic.isBindPlayerLifecycle()) {
                this.mFlowDataStatistic.reset();
            }
            this.mNonSurfaceHolderPVTimestamp = 0L;
        }
        this.mOpenVideoWhenSurfaceCreate = false;
        this.mNeedResetLoopPlay = false;
        this.mSeekWhenPrepared = 0;
    }

    @Override
    public void pauseLoadData() {
        DebugLog.i(this.getLogTag(), "pauseLoadData");
        if (this.mMediaPlayer != null) {
            DebugLog.i(this.getLogTag(), "pauseLoadData in");
            this.mIsDataLoaderPaused = true;
            this.mMediaPlayer.pauseLoadData();
        }
    }

    @Override
    public void resumeLoadData() {
        DebugLog.i(this.getLogTag(), "resumeLoadData");
        if (this.mMediaPlayer != null && this.mIsDataLoaderPaused) {
            DebugLog.i(this.getLogTag(), "resumeLoadData in");
            this.mIsDataLoaderPaused = false;
            this.mMediaPlayer.resumeLoadData();
        }
    }

    @Override
    public void cleanUri() {
        DebugLog.i(this.getLogTag(), "cleanUri");
        this.mCurrentUri = null;
        this.mProxyUri = null;
    }

    @Override
    public void setRenderViewVisible(int n2) {
        if (this.mRenderView != null && this.mRenderView.getView() != null) {
            this.mRenderView.getView().setVisibility(n2);
        }
    }

    @Override
    public void useSystemPlayer(boolean bl) {
        this.mUseSystemPlayer = bl;
    }

    @Override
    public void reBindTexture() {
    }

    @Override
    public boolean isSupportedSnapshot() {
        boolean bl = false;
        if (this.mMediaPlayer != null) {
            bl = this.mMediaPlayer.isSupportedSnapshot();
        }
        return bl;
    }

    @Override
    public Bitmap getSnapshot(int n2, int n3) {
        Bitmap bitmap = null;
        if (this.mMediaPlayer != null) {
            bitmap = this.mMediaPlayer.getSnapshot(n2, n3);
        }
        return bitmap;
    }

    @Override
    @Deprecated
    public void setAccurateSeekEnable(boolean bl) {
        this.mAccurateSeekEnable = bl;
    }

    @Override
    public boolean isAccurateSeekEnable() {
        return this.mAccurateSeekEnable;
    }

    @Override
    public void setNetAddrinfo(int n2, int n3) {
        this.setNetAddrinfo(n2, n3, false);
    }

    @Override
    public void setNetAddrinfo(int n2, int n3, boolean bl) {
        bl = false;
        if (bl && n2 == 3) {
            n2 = 0;
        }
        this.mNativeDnsAsyncEnable = true;
        if (this.mReportParams != null && (this.mReportParams.getVideoType() == ReportParams.VideoType.AD_PRE || this.mReportParams.getVideoType() == ReportParams.VideoType.AD_MID || this.mReportParams.getVideoType() == ReportParams.VideoType.AD_BOOT) && n2 > 3) {
            n2 = 3;
        }
        DebugLog.i(this.getLogTag(), "setNetAddrinfo " + n2 + ",timeout:" + n3 + ",enablePreDns:" + bl);
        this.mAddrInfoTypeInt = n2;
        this.mEnableMgtvMediaCodec = false;
        if (this.mDnsFamilyType == 1) {
            switch (n2) {
                case 1: {
                    this.mAddrInfoType = MgtvMediaPlayer.AddrinfoType.TYPE_ADDRINFO_THREAD;
                    break;
                }
                case 2: {
                    this.mAddrInfoType = MgtvMediaPlayer.AddrinfoType.TYPE_ADDRINFO_ONE_BY_ONE;
                    break;
                }
                case 3: {
                    this.mAddrInfoType = MgtvMediaPlayer.AddrinfoType.TYPE_DNS_CACHE;
                    break;
                }
                case 4: {
                    this.mAddrInfoType = MgtvMediaPlayer.AddrinfoType.TYPE_DNS_CACHE;
                    bl = true;
                    this.mJavaDnsType = a.b.b;
                    break;
                }
                case 9: {
                    this.mNativeDnsAsyncEnable = false;
                    break;
                }
                case 20: {
                    this.mEnableMgtvMediaCodec = true;
                    break;
                }
                default: {
                    this.mAddrInfoType = MgtvMediaPlayer.AddrinfoType.TYPE_ADDRINFO_DEFAULT;
                    break;
                }
            }
        } else {
            this.mAddrInfoType = MgtvMediaPlayer.AddrinfoType.TYPE_ADDRINFO_DEFAULT;
        }
        if (n3 > 0) {
            this.mAddrInfoTimeoutMs = n3 * 1000;
        }
        this.mJavaDnsEnable = bl;
    }

    @Override
    public int getAddrInfoTypeInt() {
        return this.mAddrInfoTypeInt;
    }

    @Override
    public void setLastFrameRecovery(boolean bl) {
        this.mLastFrameRecovery = bl;
    }

    @Override
    public void setReportParams(ReportParams reportParams) {
        this.mReportParams = reportParams;
        if (this.mReportParams != null) {
            this.mReportParams.setRenderType(this.mRenderType);
            this.mReportParams.setEnhanceQualityType(this.mEnhanceQualityType);
            this.mReportParams.setSvds(this.mVideoIntroduction);
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setReportParams(this.mReportParams);
        }
    }

    @Override
    public void configTsNotSkip(boolean bl) {
        this.mTsNotSkip = bl;
    }

    @Override
    public void configLoadMaxRetryTime(int n2) {
        this.mLoadMaxRetryTime = n2;
    }

    @Override
    public void configWeakNetSpeed(int n2) {
        this.mWeakNetSpeed = n2;
    }

    @Override
    public void configWeakBufferTimeout(int n2) {
        this.mWeakBufferTimeoutMs = n2;
    }

    @Override
    public void setRenderFilter(IVideoView.RenderFilter renderFilter) {
        int n2 = 0;
        this.mRenderFilter = renderFilter;
        switch (renderFilter) {
            case UNSHARP_EDGE: {
                n2 = 1;
                break;
            }
            case UNSHARP_EDGE_COMPARE: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        if (this.mRenderView != null) {
            this.mRenderView.setRenderFilter(n2);
        }
    }

    @Override
    public IVideoView.RenderFilter getRenderFilter() {
        return this.mRenderFilter;
    }

    @Override
    public void setLiveMode(boolean bl) {
        this.mEnableLiveMode = this.mIsLiveConfig = bl;
    }

    @Override
    public void setLiveStartIndex(int n2) {
        this.mLiveStartIndex = n2;
    }

    @Override
    public void setLiveReopen() {
        if (this.mEnableLiveMode && this.mMediaPlayer != null) {
            this.mMediaPlayer.setLiveReopen();
        }
    }

    @Override
    public void nativeCrashTest(int n2) {
        MgtvMediaPlayer.NativeSoType nativeSoType;
        switch (n2) {
            default: {
                nativeSoType = MgtvMediaPlayer.NativeSoType.TYPE_NATIVESO_IMGOFFMPEG;
                break;
            }
            case 1: {
                nativeSoType = MgtvMediaPlayer.NativeSoType.TYPE_NATIVESO_IMGOHELP;
                break;
            }
            case 2: {
                nativeSoType = MgtvMediaPlayer.NativeSoType.TYPE_NATIVESO_IMGOMEDIAPLAYER;
                break;
            }
            case 3: {
                nativeSoType = MgtvMediaPlayer.NativeSoType.TYPE_NATIVESO_IMGODS;
            }
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.nativeCrashTest(nativeSoType);
        }
    }

    @Override
    public void setSurfaceHolderListener(IVideoView.SurfaceHolderListener surfaceHolderListener) {
        this.mSurfaceHolderListener = surfaceHolderListener;
    }

    @Override
    public void setM3u8Caches(String string, String[] stringArray) {
        this.mCacheM3u8Path = string;
        this.mCacheTsPaths = stringArray;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setM3u8Caches(this.mCacheM3u8Path, this.mCacheTsPaths);
        }
    }

    @Override
    public void enableM3u8Cache(boolean bl) {
        this.mCacheEnable = bl;
    }

    @Override
    public boolean isDataLoadPaused() {
        return this.mIsDataLoaderPaused;
    }

    @Override
    public int getCurrentStatus() {
        return this.mCurrentState;
    }

    @Override
    public String getLogTagKey() {
        String string = ReportParams.getVideoTypeName(ReportParams.VideoType.NONE);
        if (this.mReportParams != null) {
            string = ReportParams.getVideoTypeName(this.mReportParams.getVideoType());
        }
        String string2 = "";
        if (sAutoNativeStack) {
            string2 = "STACK-";
        }
        return string2 + string + "-" + this.hashCode() + "-" + this.getRenderViewName();
    }

    public String getRenderViewName() {
        return this.mRenderViewType == 0 ? "surface" : "texture";
    }

    @Override
    public void startRecord(String string) {
        this.mRecordFilePath = string;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.startRecVideo(string);
        }
    }

    @Override
    public void stopRecord() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stopRecVideo();
        }
    }

    @Override
    public boolean isRecording() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.isRecording();
        }
        return false;
    }

    @Override
    public GifRecorder getGifRecorder() {
        return this.mGifRecorder;
    }

    @Override
    public String getLogTag() {
        return "[" + this.getLogTagKey() + "][" + this.getClass().getSimpleName() + "-" + (this.mIsLoopMode ? "1" : "00") + "]";
    }

    @Override
    public void enableCoreStartPauseListen(boolean bl) {
        this.mUserEnableCoreStartPauseListen = bl;
    }

    @Override
    public void setScreenOnWhilePlaying(boolean bl) {
        this.mIsScreenOnWhilePlaying = bl;
    }

    @Override
    public void setSecure(boolean bl) {
        this.mIsSecure = bl;
        this.setSecureImpl(this.mIsSecure);
    }

    private void setSecureImpl(boolean bl) {
        if (this.mRenderView != null && this.mRenderView.getView() instanceof SurfaceView && Build.VERSION.SDK_INT >= 17) {
            DebugLog.i(this.getLogTag(), "setSecure " + bl);
            ((SurfaceView)this.mRenderView.getView()).setSecure(bl);
        }
    }

    @Override
    public View getRenderView() {
        if (this.mRenderView != null) {
            return this.mRenderView.getView();
        }
        return null;
    }

    @Override
    public MgtvMediaPlayer.PlayerExtraInfo getPlayerExtraInfo() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getPlayerExtraInfo();
        }
        return null;
    }

    @Override
    public void setAspectRatio(int n2) {
        this.mAspectRatio = n2;
        if (this.mRenderView != null) {
            DebugLog.i(this.getLogTag(), "setAspectRatio:" + n2);
            this.mRenderView.setAspectRatio(n2);
        }
    }

    public MgtvLoopVideoView setTargetIsLoopMode(boolean bl) {
        this.mTargetIsLoopMode = bl;
        return this;
    }

    private void changeCurrentState(int n2) {
        this.mCurrentState = n2;
        DebugLog.i(this.getLogTag(), "changeCurrentState:" + n2);
        if (this.mOnUpdateStatusListener != null) {
            this.mOnUpdateStatusListener.onUpdateStatus();
        }
    }

    @Override
    public String getLastErrorTypeCode() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getLastErrorTypeCode();
        }
        return null;
    }

    @Override
    public FlowDataStatistic getFlowDataStatistic() {
        return this.mFlowDataStatistic;
    }

    @Override
    public void setFlowDataStatistic(FlowDataStatistic flowDataStatistic) {
        this.mFlowDataStatistic = flowDataStatistic;
    }

    @Override
    public void configDataCacheSizeKB(int n2) {
        this.mDataCacheSizeKB = n2;
        this.updateDataCacheSizeKB();
    }

    private void updateDataCacheSizeKB() {
        if (this.mDataCacheSizeKB > 0 && this.mMediaPlayer != null) {
            this.mMediaPlayer.configDSMemoryKeepSize(this.mDataCacheSizeKB, this.mDataCacheSizeKB);
        }
    }

    @Override
    public void setSkipLoopFilter(MgtvMediaPlayer.SkipLoopFilterType skipLoopFilterType) {
        this.mSkipLoopFilterType = skipLoopFilterType;
        this.updateSkipLoopFilter();
    }

    @Override
    public void enableTsSkipError(boolean bl) {
        this.mEnableTsSkipError = bl;
    }

    @Override
    public boolean isTsSkipErrorEnable() {
        return this.mEnableTsSkipError;
    }

    private void updateSkipLoopFilter() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setSkipLoopFilter(this.mSkipLoopFilterType);
        }
    }

    @Override
    public void enableSubtitle(boolean bl) {
    }

    @Override
    void onVideoRenderStart() {
        super.onVideoRenderStart();
        if (this.mRenderView != null) {
            this.mRenderView.setDisplayFloatRect(this.mDisplayFloatRect);
        }
    }

    private static enum ResetResult {
        NONE,
        RESET_OK,
        RESET_ERR;

    }
}

