/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.widget;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.hunantv.media.config.NetPlayConfig;
import com.hunantv.media.global.Constants;
import com.hunantv.media.p2p.IP2pTask;
import com.hunantv.media.player.IMgtvRenderView;
import com.hunantv.media.player.MgtvMediaPlayer;
import com.hunantv.media.player.MgtvPlayerListener;
import com.hunantv.media.player.MgtvRenderView;
import com.hunantv.media.player.a.a;
import com.hunantv.media.player.d.f;
import com.hunantv.media.player.loader.ImgoLibLoader;
import com.hunantv.media.player.loader.c;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.statistic.FlowDataStatistic;
import com.hunantv.media.player.utils.StringUtil;
import com.hunantv.media.recoder.GifRecorder;
import com.hunantv.media.report.ReportParams;
import com.hunantv.media.utils.AudioUtil;
import com.hunantv.media.utils.MemoryUtil;
import com.hunantv.media.widget.IVideoView;
import com.hunantv.media.widget.MgtvAbstractVideoView;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.text.NumberFormat;

public class MgtvVideoView
extends MgtvAbstractVideoView {
    private static final String LOGMSG_PLAYER_CALLBACK = "VideoViewCallBack";
    private int mVideoWidth;
    private int mVideoHeight;
    private int originalVideoWidth;
    private int originalVideoHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private volatile boolean mLastSurfaceDestroy = true;
    private int mSeekWhenPrepared;
    private IVideoView.OnCompletionListener mOnCompletionListener;
    private IVideoView.OnPreparedListener mOnPreparedListener;
    private IVideoView.OnBufferingUpdateListener mOnBufferringUpdateListener;
    private IVideoView.OnInfoListener mOnInfoListener;
    private IVideoView.OnErrorListener mOnErrorListener;
    private IVideoView.OnSeekCompleteListener mOnSeekCompleteListener;
    private IVideoView.SurfaceHolderListener mSurfaceHolderListener;
    private IVideoView.OnStartListener mOnStartListener;
    private IVideoView.OnPauseListener mOnPauseListener;
    private IVideoView.OnRecordListener mOnRecordListener;
    private IVideoView.OnUpdateStatusListener mOnUpdateStatusListener;
    private IVideoView.OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    private IVideoView.OnLoadDataListener mOnLoadDataListener;
    private boolean shouldGetVideoParams;
    private boolean isStretchScreen;
    private DisplayMetrics metrics;
    private int fromLeft;
    private int fromTop;
    private int fromRight;
    private int fromBottom;
    private int mCurrentState = 0;
    private int mTargetState = 0;
    private int mBufferTimeoutMs;
    private boolean mMgtvMediaPlayerHardwareMode = false;
    private boolean mForceDecodeMode = false;
    private boolean mFromSurfaceDestroyToPlay = false;
    private int mFromSurfaceDestroyPlayPosition = 0;
    private boolean mMgtvMediaPlayerAudioMode = false;
    private String mErrorMsg = "";
    private boolean mHasSurfaceHolderDestroy = false;
    private MgtvPlayerListener.OnWarningListener mOnWarningListener;
    private IVideoView.OnChangeSourceListener mOnChangeSourceListener;
    private boolean mLogCallBackOpen = true;
    private int mStreamKey = -1;
    private boolean mIsLive = false;
    private int mVideoRotationDegree;
    private MgtvRenderView mRenderView;
    private boolean mUseSystemPlayer = false;
    private boolean mRebindTexture;
    private boolean mAccurateSeekEnable;
    private MgtvMediaPlayer.AddrinfoType mAddrInfoType = MgtvMediaPlayer.AddrinfoType.TYPE_ADDRINFO_DEFAULT;
    private int mAddrInfoTypeInt = 0;
    private boolean mOpenAddrDefaultConfig = true;
    private a.b mJavaDnsType = a.b.a;
    private boolean mNativeDnsAsyncEnable = true;
    private boolean mBackJavaDns = false;
    private boolean mEnableHttpDnsRetry = false;
    private boolean mEnableDnsNoNetStrategy = true;
    private boolean mEnableP2pHttpDns = false;
    private int mHlsMD5CheckValue = 0;
    private boolean mEnableMgtvMediaCodec = true;
    private boolean mEnableJavaIPCache = false;
    private boolean mLastFrameRecovery = true;
    private int mWeakNetSpeed = 0;
    private int mWeakBufferTimeoutMs = 0;
    private boolean mTsNotSkip = false;
    private int mLoadMaxRetryTime = 0;
    private boolean mCacheEnable;
    private String mCacheM3u8Path;
    private String[] mCacheTsPaths;
    private boolean mUserEnableCoreStartPauseListen = false;
    private boolean mEnableCoreStartPauseListen = false;
    private long mStartLeaveTimestamp;
    private boolean mIsScreenOnWhilePlaying = true;
    private String mRecordFilePath;
    private float mPlaySpeed = 1.0f;
    private int mLiveStartIndex = 0;
    private boolean mIsSecure = false;
    private int mAspectRatio = -1;
    private IVideoView.RenderFilter mRenderFilter = IVideoView.RenderFilter.NORMAL;
    private boolean mOpenVideoWhenSurfaceCreate;
    private boolean mIsLiveConfig = false;
    private boolean mEnableLiveMode = false;
    private boolean mEnableOpengl;
    private int mRenderType;
    private int mEnhanceQualityType;
    private int mStartPosMs = 0;
    private FlowDataStatistic mFlowDataStatistic = new FlowDataStatistic();
    private int mDataCacheSizeKB;
    private MgtvMediaPlayer.SkipLoopFilterType mSkipLoopFilterType = MgtvMediaPlayer.SkipLoopFilterType.TYPE_SKIPLOOPFILTER_ALL;
    private boolean mEnableTsSkipError;
    private long mNonSurfaceHolderPVTimestamp;
    IMgtvRenderView.IRenderCallback mSHCallback = new IMgtvRenderView.IRenderCallback(){

        @Override
        public void onSurfaceChanged(IMgtvRenderView.ISurfaceHolder iSurfaceHolder, int n2, int n3, int n4) {
            DebugLog.e(MgtvVideoView.this.getLogTag(), "-----------surface changed. threadId:" + Thread.currentThread().getId());
            if (!MgtvVideoView.this.isOnlyAudioMode() && !MgtvVideoView.this.mBackPlayEnable) {
                this.videoSurfaceChanged(iSurfaceHolder, n2, n3, n4);
            }
            if (MgtvVideoView.this.mSurfaceHolderListener != null) {
                MgtvVideoView.this.mSurfaceHolderListener.surfaceChanged();
            }
        }

        private void videoSurfaceChanged(IMgtvRenderView.ISurfaceHolder iSurfaceHolder, int n2, int n3, int n4) {
            if (MgtvVideoView.this.mRenderView != null && iSurfaceHolder.getRenderView() != MgtvVideoView.this.mRenderView.getRenderView()) {
                DebugLog.e(MgtvVideoView.this.getLogTag(), "onSurfaceChanged: unmatched render callback\n");
                return;
            }
            MgtvVideoView.this.autoStartByStateAndSize(n3, n4);
        }

        @Override
        public void onSurfaceCreated(IMgtvRenderView.ISurfaceHolder iSurfaceHolder, int n2, int n3) {
            long l2;
            DebugLog.e(MgtvVideoView.this.getLogTag(), "-----------surface create. threadId:" + Thread.currentThread().getId());
            if (MgtvVideoView.this.mStartLeaveTimestamp > 0L && (l2 = (System.currentTimeMillis() - MgtvVideoView.this.mStartLeaveTimestamp) / 1000L) > 540L) {
                if (MgtvVideoView.this.mOnWarningListener != null) {
                    MgtvVideoView.this.mOnWarningListener.onWarning(800010, MgtvVideoView.this.mCurrentState + "", "", null);
                }
                if (MgtvVideoView.this.mReportParams != null) {
                    MgtvVideoView.this.mReportParams.setLeaveTimeS(l2);
                }
            }
            MgtvVideoView.this.mSurfaceHolder = iSurfaceHolder;
            if (!MgtvVideoView.this.isOnlyAudioMode() && !MgtvVideoView.this.mBackPlayEnable) {
                this.videoSurfaceCreate(iSurfaceHolder, n2, n3);
            }
            if (MgtvVideoView.this.mSurfaceHolderListener != null) {
                MgtvVideoView.this.mSurfaceHolderListener.surfaceCreated();
            }
        }

        private void videoSurfaceCreate(IMgtvRenderView.ISurfaceHolder iSurfaceHolder, int n2, int n3) {
            if (MgtvVideoView.this.mRenderView != null && iSurfaceHolder.getRenderView() != MgtvVideoView.this.mRenderView.getRenderView()) {
                DebugLog.e(MgtvVideoView.this.getLogTag(), "onSurfaceCreated: unmatched render callback\n");
                return;
            }
            DebugLog.i(MgtvVideoView.this.getLogTag(), "videoSurfaceCreate " + iSurfaceHolder);
            if (MgtvVideoView.this.mRenderView != null && MgtvVideoView.this.mRenderView.getRenderViewType() == 0) {
                SurfaceHolder surfaceHolder = MgtvVideoView.this.mSurfaceHolder.getSurfaceHolder();
                if (surfaceHolder != null && surfaceHolder.getSurface() != null && surfaceHolder.getSurface().isValid()) {
                    this.bindHolder(iSurfaceHolder, n2, n3);
                } else {
                    MgtvVideoView.this.mErrorListener.onError(7000009, 1);
                    MgtvVideoView.this.mErrorMsg = "surfaceCreated surface is invalid";
                }
            } else {
                this.bindHolder(iSurfaceHolder, n2, n3);
            }
        }

        private boolean needOpenVideo() {
            return MgtvVideoView.this.mOpenVideoWhenSurfaceCreate && MgtvVideoView.this.mCurrentUri != null;
        }

        private void bindHolder(IMgtvRenderView.ISurfaceHolder iSurfaceHolder, int n2, int n3) {
            if (MgtvVideoView.this.mMediaPlayer != null) {
                if (!MgtvVideoView.this.mEnableMediacodecSW && MgtvVideoView.this.mHasSurfaceHolderDestroy && MgtvVideoView.this.mRebindTexture && MgtvVideoView.this.mCurrentUri != null) {
                    MgtvVideoView.this.setStartPosMs(MgtvVideoView.this.mMediaPlayer.getCurrentPosition());
                    MgtvVideoView.this.openVideo();
                } else if (this.needOpenVideo()) {
                    MgtvVideoView.this.openVideo();
                } else {
                    MgtvVideoView.this.mMediaPlayer.setSurfaceHolder(iSurfaceHolder);
                    if (MgtvVideoView.this.mCurrentUri != null) {
                        if (MgtvVideoView.this.mFromSurfaceDestroyToPlay && MgtvVideoView.this.mMgtvMediaPlayerHardwareMode) {
                            MgtvVideoView.this.mFromSurfaceDestroyToPlay = false;
                            DebugLog.i(MgtvVideoView.this.getLogTag(), "use frame backup seekto pos=" + MgtvVideoView.this.mFromSurfaceDestroyPlayPosition);
                            MgtvVideoView.this.mMediaPlayer.seekTo(MgtvVideoView.this.mFromSurfaceDestroyPlayPosition, false, true);
                            MgtvVideoView.this.mFromSurfaceDestroyPlayPosition = 0;
                        }
                        if (MgtvVideoView.this.mLastFrameRecovery && (!MgtvVideoView.this.isHardware() || MgtvVideoView.this.mLastSurfaceDestroy)) {
                            MgtvVideoView.this.mMediaPlayer.setPlaybackStep();
                        }
                    }
                    MgtvVideoView.this.mSizeChangedListener.onVideoSizeChanged(MgtvVideoView.this.mMediaPlayer.getVideoWidth(), MgtvVideoView.this.mMediaPlayer.getVideoHeight());
                    MgtvVideoView.this.autoStartByStateAndSize(n2, n3);
                }
            } else {
                MgtvVideoView.this.openVideo();
            }
        }

        @Override
        public void onSurfaceDestroyed(IMgtvRenderView.ISurfaceHolder iSurfaceHolder, boolean bl) {
            DebugLog.e(MgtvVideoView.this.getLogTag(), "-----------surface destroy. threadId:" + Thread.currentThread().getId());
            MgtvVideoView.this.mLastSurfaceDestroy = bl;
            if (MgtvVideoView.this.mRenderView != null && iSurfaceHolder.getRenderView() != MgtvVideoView.this.mRenderView.getRenderView()) {
                DebugLog.e(MgtvVideoView.this.getLogTag(), "onSurfaceDestroyed: unmatched render callback\n");
                return;
            }
            DebugLog.i(MgtvVideoView.this.getLogTag(), "onSurfaceDestroyed " + iSurfaceHolder);
            if (MgtvVideoView.this.mSurfaceHolderListener != null) {
                MgtvVideoView.this.mSurfaceHolderListener.surfaceDestroyed();
            }
            if (bl && MgtvVideoView.this.mSurfaceHolder != null) {
                MgtvVideoView.this.mSurfaceHolder.releaseSurface();
            }
            MgtvVideoView.this.mSurfaceHolder = null;
            if (!MgtvVideoView.this.isOnlyAudioMode() && !MgtvVideoView.this.mBackPlayEnable) {
                MgtvVideoView.this.videoSurfaceDestroyed();
            }
            if (MgtvVideoView.this.mCurrentUri != null && MgtvVideoView.this.mCurrentState != -1 && MgtvVideoView.this.mCurrentState != 5) {
                MgtvVideoView.this.mStartLeaveTimestamp = System.currentTimeMillis();
            }
        }
    };
    private f.a mFilterCallback = new f.a(){

        @Override
        public void onInfo(int n2, int n3, String string) {
            switch (n2) {
                case 1: {
                    MgtvVideoView.this.mRenderType = n3;
                    if (MgtvVideoView.this.mReportParams == null) break;
                    MgtvVideoView.this.mReportParams.setRenderType(MgtvVideoView.this.mRenderType);
                    break;
                }
                case 3: {
                    MgtvVideoView.this.mEnhanceQualityType = n3;
                    if (MgtvVideoView.this.mReportParams == null) break;
                    MgtvVideoView.this.mReportParams.setEnhanceQualityType(MgtvVideoView.this.mEnhanceQualityType);
                }
            }
        }
    };
    private MgtvPlayerListener.OnWarningListener mRenderWarning = new MgtvPlayerListener.OnWarningListener(){

        @Override
        public void onTsSkip(String string, int n2, int n3) {
        }

        @Override
        public void onWarning(int n2, String string, String string2, Object object) {
            DebugLog.i(MgtvVideoView.this.getLogTag(), "opengl render warning:" + n2 + ",extra:" + string + ",msg:" + string2);
            if (MgtvVideoView.this.mOnWarningListener != null) {
                MgtvVideoView.this.mOnWarningListener.onWarning(n2, string, string2, object);
            }
        }
    };
    MgtvPlayerListener.OnVideoSizeChangedListener mSizeChangedListener = new MgtvPlayerListener.OnVideoSizeChangedListener(){

        @Override
        public void onVideoSizeChanged(int n2, int n3) {
            MgtvVideoView.this.originalVideoWidth = (MgtvVideoView.this.mVideoWidth = MgtvVideoView.this.mMediaPlayer.getVideoWidth());
            MgtvVideoView.this.originalVideoHeight = (MgtvVideoView.this.mVideoHeight = MgtvVideoView.this.mMediaPlayer.getVideoHeight());
            if (MgtvVideoView.this.mVideoWidth != 0 && MgtvVideoView.this.mVideoHeight != 0) {
                if (MgtvVideoView.this.mRenderView != null) {
                    MgtvVideoView.this.mRenderView.setVideoSize(MgtvVideoView.this.mVideoWidth, MgtvVideoView.this.mVideoHeight);
                }
                MgtvVideoView.this.requestLayout();
            }
            if (MgtvVideoView.this.mOnVideoSizeChangedListener != null) {
                MgtvVideoView.this.mOnVideoSizeChangedListener.onVideoSizeChanged(n2, n3);
            }
        }
    };
    MgtvPlayerListener.OnPreparedListener mPreparedListener = new MgtvPlayerListener.OnPreparedListener(){

        @Override
        public void onPrepared() {
            MgtvVideoView.this.changeCurrentState(2);
            MgtvVideoView.this.originalVideoWidth = (MgtvVideoView.this.mVideoWidth = MgtvVideoView.this.mMediaPlayer.getVideoWidth());
            MgtvVideoView.this.originalVideoHeight = (MgtvVideoView.this.mVideoHeight = MgtvVideoView.this.mMediaPlayer.getVideoHeight());
            if (MgtvVideoView.this.mVideoWidth != 0 && MgtvVideoView.this.mVideoHeight != 0) {
                DebugLog.i("@@@@", "video size: " + MgtvVideoView.this.mVideoWidth + "/" + MgtvVideoView.this.mVideoHeight);
                if (MgtvVideoView.this.mRenderView != null) {
                    MgtvVideoView.this.mRenderView.setVideoSize(MgtvVideoView.this.mVideoWidth, MgtvVideoView.this.mVideoHeight);
                }
                if (MgtvVideoView.this.mUseSystemPlayer) {
                    int n2 = MgtvVideoView.this.mStartPosMs;
                    DebugLog.i(MgtvVideoView.this.getLogTag(), "seekto when onPrepared pos=" + n2);
                    if (n2 != 0) {
                        MgtvVideoView.this.seekTo(n2);
                    }
                }
                if ((MgtvVideoView.this.mRenderView != null && !MgtvVideoView.this.mRenderView.shouldWaitForResize() || MgtvVideoView.this.mSurfaceWidth == MgtvVideoView.this.mVideoWidth && MgtvVideoView.this.mSurfaceHeight == MgtvVideoView.this.mVideoHeight) && MgtvVideoView.this.mTargetState == 3) {
                    MgtvVideoView.this.start();
                }
            } else if (MgtvVideoView.this.mTargetState == 3) {
                MgtvVideoView.this.start();
            }
            if (MgtvVideoView.this.mOnPreparedListener != null) {
                MgtvVideoView.this.mOnPreparedListener.onPrepared();
            }
        }
    };
    private MgtvPlayerListener.OnCompletionListener mCompletionListener = new MgtvPlayerListener.OnCompletionListener(){

        @Override
        public void onCompletion(int n2, int n3) {
            if (n2 != 0) {
                MgtvVideoView.this.stopInner();
            }
            MgtvVideoView.this.changeCurrentState(5);
            MgtvVideoView.this.mTargetState = 5;
            DebugLog.i(MgtvVideoView.this.getLogTag(), "-------------on onCompletion what:" + n2 + ",extra:" + n3);
            if (MgtvVideoView.this.mOnCompletionListener != null) {
                MgtvVideoView.this.mOnCompletionListener.onCompletion(n2, n3);
            }
        }
    };
    private MgtvPlayerListener.OnInfoListener mInfoListener = new MgtvPlayerListener.OnInfoListener(){

        @Override
        public boolean onInfo(int n2, int n3) {
            block0 : switch (n2) {
                case 800: {
                    DebugLog.e(MgtvVideoView.this.getLogTag(), "Bad interleaving of media file, audio/video are not well-formed, extra is " + n3);
                    n2 = 800;
                    break;
                }
                case 702: {
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "buffer end speed:" + MgtvVideoView.this.getDLSpeedFormat());
                    n2 = 702;
                    break;
                }
                case 701: {
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "buffer start speed:" + MgtvVideoView.this.getDLSpeedFormat());
                    n2 = 701;
                    break;
                }
                case 802: {
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "A new set of metadata is available, extra is " + n3);
                    n2 = 802;
                    break;
                }
                case 801: {
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "The stream not seekable status, extra is " + n3);
                    n2 = 801;
                    if (n3 == 1) {
                        MgtvVideoView.this.mIsLive = true;
                        DebugLog.w(MgtvVideoView.this.getLogTag(), "The stream is live stream,can not seekable ");
                        break;
                    }
                    MgtvVideoView.this.mIsLive = false;
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "The stream is not live stream,can seekable ");
                    break;
                }
                case 700: {
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "It's too complex for the decoder, extra is " + n3);
                    n2 = 700;
                    break;
                }
                case 1: {
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "Unknown info, extra is " + n3);
                    n2 = 1;
                    break;
                }
                case 3: {
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "video decode succeeded, start rendering");
                    n2 = 900;
                    MgtvVideoView.this.onVideoRenderStart();
                    if (MgtvVideoView.this.mOnInfoListener != null) {
                        MgtvVideoView.this.mOnInfoListener.onInfo(n2, n3);
                    }
                    return true;
                }
                case 5: {
                    break;
                }
                case 200001: {
                    if (n3 == 1) {
                        MgtvVideoView.this.mMgtvMediaPlayerHardwareMode = false;
                    } else {
                        MgtvVideoView.this.mMgtvMediaPlayerHardwareMode = true;
                    }
                    MgtvVideoView.this.convertRender(MgtvVideoView.this.mRenderViewType);
                    break;
                }
                case 6: {
                    if (n3 == 0) {
                        MgtvVideoView.this.mMgtvMediaPlayerHardwareMode = false;
                    } else if (n3 == 1) {
                        MgtvVideoView.this.mMgtvMediaPlayerHardwareMode = true;
                    }
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "video decoder open,extra is " + n3);
                    break;
                }
                case 7: {
                    n2 = 700001;
                    break;
                }
                case 10001: {
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "video rotation changed,extra(degree) is " + n3);
                    MgtvVideoView.this.mVideoRotationDegree = n3;
                    if (MgtvVideoView.this.mRenderView == null) break;
                    MgtvVideoView.this.mRenderView.setVideoRotation(MgtvVideoView.this.mVideoRotationDegree);
                    break;
                }
                case 2804: {
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "accurate seek complete,time is " + n3);
                    break;
                }
                case 4: {
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "audio decode succeeded, start rendering");
                    if (!MgtvVideoView.this.isOnlyAudioMode()) break;
                    n2 = 900;
                    if (MgtvVideoView.this.mOnInfoListener != null) {
                        MgtvVideoView.this.mOnInfoListener.onInfo(n2, n3);
                    }
                    return true;
                }
                case 2805: {
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "acodec reconfigure ret is " + n3);
                    break;
                }
                case 2803: {
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "data source type is " + n3);
                    if (MgtvVideoView.this.mMediaPlayer == null) break;
                    MgtvVideoView.this.mDataSourceType = MgtvVideoView.this.mMediaPlayer.getDataSourceType();
                    break;
                }
                case 2810: {
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "video fps is " + n3);
                    break;
                }
                case 2820: {
                    switch (n3) {
                        case 82001: {
                            DebugLog.w(MgtvVideoView.this.getLogTag(), "prepare av data: open input steam");
                            break block0;
                        }
                        case 82002: {
                            DebugLog.w(MgtvVideoView.this.getLogTag(), "prepare av data: find steam info");
                            break block0;
                        }
                        case 82003: {
                            DebugLog.w(MgtvVideoView.this.getLogTag(), "prepare av data: av stream component open");
                            break block0;
                        }
                        case 82004: {
                            DebugLog.w(MgtvVideoView.this.getLogTag(), "prepare av data: video decoded start");
                            break block0;
                        }
                        case 82005: {
                            DebugLog.w(MgtvVideoView.this.getLogTag(), "prepare av data: audio decoded start");
                            break block0;
                        }
                    }
                    DebugLog.w(MgtvVideoView.this.getLogTag(), "prepare av data: " + n3);
                    break;
                }
                case 2806: {
                    DebugLog.d(MgtvVideoView.this.getLogTag(), "stream format type is " + n3);
                    break;
                }
                case 2830: {
                    DebugLog.i(MgtvVideoView.this.getLogTag(), "MEDIA_INFO_PLAYBACK_STATE_CHANGED:" + n3);
                    if (MgtvVideoView.this.mOnUpdateStatusListener == null) break;
                    MgtvVideoView.this.mOnUpdateStatusListener.onUpdateStatus();
                    break;
                }
                default: {
                    DebugLog.d(MgtvVideoView.this.getLogTag(), "Unknown info code: " + n2 + ", extra is " + n3);
                }
            }
            if (MgtvVideoView.this.mOnInfoListener != null) {
                MgtvVideoView.this.mOnInfoListener.onInfo(n2, n3);
            }
            return true;
        }
    };
    private MgtvPlayerListener.OnErrorListener mErrorListener = new MgtvPlayerListener.OnErrorListener(){

        @Override
        public boolean onError(int n2, int n3) {
            DebugLog.w(MgtvVideoView.this.getLogTag(), "onError what:" + n2 + ",extra:" + n3);
            if (MgtvVideoView.this.mMediaPlayer != null && n2 == 7000006) {
                MgtvVideoView.this.releaseNoStatus();
                MgtvVideoView.this.changeCurrentState(0);
                MgtvVideoView.this.mTargetState = 0;
            } else {
                if (MgtvVideoView.this.mMediaPlayer != null && MgtvVideoView.this.mCurrentState != -1) {
                    MgtvVideoView.this.mMediaPlayer.stop();
                }
                MgtvVideoView.this.changeCurrentState(-1);
                MgtvVideoView.this.mTargetState = -1;
            }
            MgtvVideoView.this.cleanUri();
            return MgtvVideoView.this.mOnErrorListener != null && MgtvVideoView.this.mOnErrorListener.onError(n2, n3);
        }
    };
    private MgtvPlayerListener.OnSeekCompleteListener mSeekCompleteListener = new MgtvPlayerListener.OnSeekCompleteListener(){

        @Override
        public void onSeekComplete(int n2, int n3) {
            if (Build.VERSION.SDK_INT < 23 && !MgtvVideoView.this.isRendered()) {
                return;
            }
            if (MgtvVideoView.this.mOnSeekCompleteListener != null) {
                DebugLog.i(MgtvVideoView.this.getLogTag(), "onSeekComplete seekTargetTime:" + n2 + ",errorCode:" + n3);
                MgtvVideoView.this.mOnSeekCompleteListener.onSeekComplete();
            }
        }
    };
    private MgtvPlayerListener.OnBufferingUpdateListener mBufferingUpdateListener = new MgtvPlayerListener.OnBufferingUpdateListener(){

        @Override
        public void onBufferingUpdate(int n2) {
            if (MgtvVideoView.this.mOnBufferringUpdateListener != null) {
                MgtvVideoView.this.mOnBufferringUpdateListener.onBufferingUpdate(n2);
            }
        }
    };
    private MgtvPlayerListener.OnBufferingTimeoutListener mBufferingTimeoutListener = new MgtvPlayerListener.OnBufferingTimeoutListener(){

        @Override
        public boolean onBufferingTimeout(int n2, int n3) {
            if (MgtvVideoView.this.mMediaPlayer != null) {
                MgtvVideoView.this.mMediaPlayer.stop();
            }
            MgtvVideoView.this.changeCurrentState(-1);
            MgtvVideoView.this.mTargetState = -1;
            MgtvVideoView.this.cleanUri();
            if (MgtvVideoView.this.mOnErrorListener != null && MgtvVideoView.this.mOnErrorListener.onError(n2, n3)) {
                return true;
            }
            return true;
        }
    };
    private MgtvPlayerListener.OnSwitchSourceListener mSwitchSourceListener = new MgtvPlayerListener.OnSwitchSourceListener(){

        @Override
        public void onSwitchSourceInfo(String string, int n2, int n3) {
            DebugLog.e(MgtvVideoView.this.getLogTag(), "onSwitchSourceInfo url:" + string + ",event:" + n2 + ",time:" + n3);
            if (MgtvVideoView.this.mOnChangeSourceListener != null) {
                MgtvVideoView.this.mOnChangeSourceListener.onChangeSourceInfo(string, n2, n3);
            }
        }

        @Override
        public void onSwitchSourceComplete(String string, int n2, int n3) {
            DebugLog.e(MgtvVideoView.this.getLogTag(), "onSwitchSourceComplete url:" + string + ",type:" + n2 + ",time:" + n3);
            if (MgtvVideoView.this.mOnChangeSourceListener != null) {
                MgtvVideoView.this.mOnChangeSourceListener.onChangeSourceSuccess(string, n2, n3);
            }
        }

        @Override
        public void onSwitchSourceFailed(String string, int n2, int n3) {
            DebugLog.e(MgtvVideoView.this.getLogTag(), "onSwitchSourceFailed url:" + string + ",what:" + n2 + ",extra:" + n3);
            if (MgtvVideoView.this.mOnChangeSourceListener != null) {
                MgtvVideoView.this.mOnChangeSourceListener.onChangeSourceFailed(string, n2, n3);
            }
        }
    };
    private MgtvPlayerListener.OnWarningListener mPlayerWarning = new MgtvPlayerListener.OnWarningListener(){

        @Override
        public void onTsSkip(String string, int n2, int n3) {
            DebugLog.i(MgtvVideoView.this.getLogTag(), "onTsSkip tsUrl:" + string);
            if (MgtvVideoView.this.mOnWarningListener != null) {
                MgtvVideoView.this.mOnWarningListener.onTsSkip(string, n2, n3);
            }
        }

        @Override
        public void onWarning(int n2, String string, String string2, Object object) {
            DebugLog.i(MgtvVideoView.this.getLogTag(), "player render warning:" + n2 + ",extra:" + string + ",msg:" + string2);
            if (MgtvVideoView.this.mOnWarningListener != null) {
                MgtvVideoView.this.mOnWarningListener.onWarning(n2, string, string2, object);
            }
        }
    };
    private boolean mReleasedByPauseLoadData;
    private GifRecorder mGifRecorder = new GifRecorder();
    private MgtvPlayerListener.OnStartListener mStartListener = new MgtvPlayerListener.OnStartListener(){

        @Override
        public void onStart() {
            DebugLog.d(MgtvVideoView.this.getLogTag(), "mgtvcore onStart");
            if (MgtvVideoView.this.mEnableCoreStartPauseListen) {
                MgtvVideoView.this.callbackOnStart();
            }
        }
    };
    private MgtvPlayerListener.OnPauseListener mPauseListener = new MgtvPlayerListener.OnPauseListener(){

        @Override
        public void onPause() {
            DebugLog.d(MgtvVideoView.this.getLogTag(), "mgtvcore onPause");
            if (MgtvVideoView.this.mEnableCoreStartPauseListen) {
                MgtvVideoView.this.callbackOnPause();
            }
        }
    };
    private MgtvPlayerListener.OnRecordVideoListener mRecordVideoListener = new MgtvPlayerListener.OnRecordVideoListener(){

        @Override
        public void onRecordVideoInfo(int n2, int n3) {
            DebugLog.i(MgtvVideoView.this.getLogTag(), "onRecordVideoInfo what:" + n2 + ",extra:" + n3);
            if (MgtvVideoView.this.mOnRecordListener != null) {
                switch (n2) {
                    case 20: {
                        MgtvVideoView.this.mOnRecordListener.onRecordStart(MgtvVideoView.this.mRecordFilePath);
                        break;
                    }
                    case 30: {
                        MgtvVideoView.this.mOnRecordListener.onRecordStop();
                    }
                }
                MgtvVideoView.this.mOnRecordListener.onRecordInfo(n2, n3);
            }
        }

        @Override
        public void onRecordVideoErr(int n2, int n3) {
            DebugLog.e(MgtvVideoView.this.getLogTag(), "onRecordVideoErr what:" + n2 + ",extra:" + n3);
            if (MgtvVideoView.this.mOnRecordListener != null) {
                MgtvVideoView.this.mOnRecordListener.onRecordError(n2, n3);
            }
        }
    };
    private MgtvPlayerListener.OnLoadDataListener mLoadDataListener = new MgtvPlayerListener.OnLoadDataListener(){

        @Override
        public void onBeforeLoadDataResume() {
            if (MgtvVideoView.this.mOnLoadDataListener != null) {
                MgtvVideoView.this.mOnLoadDataListener.onBeforeLoadDataResume();
            }
        }

        @Override
        public void onAfterLoadDataPaused() {
            if (MgtvVideoView.this.mOnLoadDataListener != null) {
                MgtvVideoView.this.mOnLoadDataListener.onAfterLoadDataPaused();
            }
        }
    };

    public MgtvVideoView(Context context) {
        super(context);
        this.initVideoView(context);
    }

    public MgtvVideoView(Context context, int n2) {
        super(context);
        this.initVideoView(context, n2);
    }

    public MgtvVideoView(Context context, int n2, boolean bl) {
        super(context);
        this.mEnableTexture = bl;
        this.initVideoView(context, n2);
    }

    public MgtvVideoView(Context context, int n2, boolean bl, boolean bl2) {
        super(context);
        this.mEnableTexture = bl;
        this.mEnableOpengl = bl2;
        this.initVideoView(context, n2);
    }

    public MgtvVideoView(Context context, IVideoView.Configuration configuration) {
        super(context, configuration);
        if (configuration != null) {
            this.mEnableTexture = configuration.enableTexture;
            this.mEnableOpengl = configuration.opengl;
            this.mEnableLiveMode = this.mIsLiveConfig = configuration.isLiveMode;
            this.initVideoView(context, configuration.renderViewType);
        } else {
            this.initVideoView(context);
        }
    }

    public MgtvVideoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initVideoView(context);
    }

    public MgtvVideoView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initVideoView(context);
    }

    private void autoStartByStateAndSize(int n2, int n3) {
        boolean bl;
        this.mSurfaceWidth = n2;
        this.mSurfaceHeight = n3;
        boolean bl2 = this.mTargetState == 3;
        boolean bl3 = bl = this.mRenderView != null && !this.mRenderView.shouldWaitForResize() || this.mVideoWidth == n2 && this.mVideoHeight == n3;
        if (this.mMediaPlayer != null && bl2 && bl) {
            if (this.mSeekWhenPrepared != 0) {
                this.seekTo(this.mSeekWhenPrepared, false);
                this.mSeekWhenPrepared = 0;
            }
            this.start();
        }
    }

    private void videoSurfaceDestroyed() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setSurfaceHolder(null);
            if (this.isPrepared()) {
                if (!this.mMediaPlayer.isBackground()) {
                    // empty if block
                }
                this.pauseLoadData();
                if (this.mIsLive) {
                    DebugLog.e(this.getLogTag(), "-----------surface destroy to pause");
                    this.pauseInner();
                    if (this.mEnableTexture) {
                        this.mHasSurfaceHolderDestroy = true;
                    }
                } else {
                    DebugLog.e(this.getLogTag(), "-----------surface destroy to pause");
                    if (this.mRenderView != null && this.mRenderView.getRenderViewType() == 0) {
                        if (!this.mMediaPlayer.isSupportAMCKeyFrameBackup()) {
                            this.mFromSurfaceDestroyToPlay = true;
                            this.mFromSurfaceDestroyPlayPosition = this.mMediaPlayer.getCurrentPosition();
                        }
                    } else if (this.mRenderView != null && this.mRenderView.getRenderViewType() == 1) {
                        if (this.mEnableTexture) {
                            this.mHasSurfaceHolderDestroy = true;
                        } else if (!this.mMediaPlayer.isSupportAMCKeyFrameBackup()) {
                            this.mFromSurfaceDestroyToPlay = true;
                            this.mFromSurfaceDestroyPlayPosition = this.mMediaPlayer.getCurrentPosition();
                        }
                    }
                    this.pauseInner();
                }
            } else {
                try {
                    if (this.mReportParams != null) {
                        this.mReportParams.getEnd().setInnerRetry(true);
                    }
                    this.release(true, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void toggleRenders(int n2) {
        super.toggleRenders(n2);
        this.mSurfaceHolder = null;
        this.setRender(n2);
    }

    @Override
    public int getRenderViewType() {
        return this.mRenderViewType;
    }

    private void setRender(int n2) {
        DebugLog.i(this.getLogTag(), "setRender render:" + n2);
        switch (n2) {
            case 0: 
            case 1: {
                if (n2 == 1 && this.mMediaPlayer != null && this.mCurrentUri != null) {
                    this.mMediaPlayer.setSurfaceHolder(this.mSurfaceHolder);
                    if (this.mRenderView != null) {
                        this.mRenderView.setVideoSize(this.mMediaPlayer.getVideoWidth(), this.mMediaPlayer.getVideoHeight());
                    }
                }
                this.setRenderView(n2);
                break;
            }
            default: {
                DebugLog.e(this.getLogTag(), "invalid render:" + n2 + ", change to surfaceview");
                n2 = 0;
                this.mRenderViewType = 0;
                this.setRenderView(n2);
            }
        }
    }

    private void addRenderView() {
        if (this.mRenderView == null) {
            return;
        }
        View view = this.mRenderView.getView();
        if (view != null) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.setSecureImpl(this.mIsSecure);
            DebugLog.i(this.getLogTag(), "setRenderView addRenderView");
            this.addView(view);
        }
    }

    private void setRenderView(int n2) {
        View view;
        int n3 = -1;
        if (this.mRenderView != null) {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setSurfaceHolder(null);
            }
            if ((view = this.mRenderView.getView()) != null) {
                DebugLog.i(this.getLogTag(), "setRenderView removeRenderView");
                n3 = this.indexOfChild(view);
                this.removeView(view);
            }
            this.removeDecorateLayout();
            this.mRenderView.removeRenderCallback(this.mSHCallback);
            this.mRenderView.release();
            this.mRenderView = null;
        }
        this.mRenderType = 0;
        this.mEnhanceQualityType = 0;
        if (this.mReportParams != null) {
            this.mReportParams.setRenderType(0);
            this.mReportParams.setEnhanceQualityType(0);
        }
        this.mRenderView = new MgtvRenderView(this.getContext(), n2, this.mEnableOpengl, this.mRenderWarning, this.mFilterCallback);
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.bindRenderView(this.mRenderView != null ? this.mRenderView.getRenderView() : null);
        }
        if (this.mRenderView == null) {
            return;
        }
        this.mRenderView.bind(this);
        this.mRenderView.setDisplayFloatRect(this.mDisplayFloatRect);
        this.setRenderFilter(this.mRenderFilter);
        this.mRenderView.addRenderCallback(this.mSHCallback);
        this.mRenderView.setVideoRotation(this.mVideoRotationDegree);
        this.mRenderView.setAntiShake(this.mAntiViewShake);
        if (this.mAspectRatio > 0) {
            this.mRenderView.setAspectRatio(this.mAspectRatio);
        }
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            this.mRenderView.setVideoSize(this.mVideoWidth, this.mVideoHeight);
        }
        if ((view = this.mRenderView.getView()) != null) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.setSecureImpl(this.mIsSecure);
            DebugLog.i(this.getLogTag(), "setRenderView addRenderView");
            if (n3 >= 0) {
                this.addView(view, n3);
            } else {
                this.addView(view);
            }
            this.addDecorateLayout();
        }
    }

    private void initVideoView(Context context) {
        this.initVideoView(context, 0);
    }

    private void initVideoView(Context context, int n2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setImportantForAccessibility(2);
        }
        this.mContext = context;
        this.metrics = this.mContext.getResources().getDisplayMetrics();
        this.mInitRenderViewType = this.mRenderViewType = n2;
        if (n2 == 0) {
            this.mEnableTexture = false;
        }
        this.toggleRenders(n2);
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        AudioUtil.registerHeadsetReceiverOnce(this.mContext);
        if (!Constants.FOR_OTT) {
            this.setFocusable(true);
            this.setFocusableInTouchMode(true);
            this.requestFocus();
        }
        if (context instanceof Activity) {
            ((Activity)context).setVolumeControlStream(3);
        }
        this.checkMemoryStatus(this.mContext);
        this.changeCurrentState(0);
        this.mTargetState = 0;
    }

    @Override
    public void convertRender(int n2) {
        DebugLog.i(this.getLogTag(), "convertRender to " + n2);
        try {
            this.release(true, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mInitRenderViewType = n2;
        this.toggleRenders(n2);
    }

    @Override
    public void setVideoPath(String string) {
        this.setVideoPath(string, null, null);
    }

    @Override
    public void resetVideoPath(String string) {
        this.resetVideoPath(string, null, null);
    }

    @Override
    public void setVideoPath(String string, IP2pTask iP2pTask, String string2) {
        DebugLog.i(this.getLogTag(), "setVideoPath in");
        DebugLog.d(this.getLogTag(), string + ",task:" + iP2pTask + ",proxyPath:" + string2);
        this.beforeOpenVideo();
        if (this.mEnableTexture) {
            if (Build.VERSION.SDK_INT <= 22) {
                DebugLog.i(this.getLogTag(), "setVideoPath need rebindTexture");
                this.mRebindTexture = true;
            } else {
                this.mRebindTexture = false;
            }
        } else {
            this.mRebindTexture = false;
        }
        this.mMainP2pTask = iP2pTask;
        this.mProxyUri = StringUtil.isEmpty(string2) ? null : Uri.parse((String)string2.trim());
        if (string == null) {
            this.mErrorListener.onError(7000011, 11);
        } else {
            this.setVideoURI(Uri.parse((String)string.trim()));
        }
    }

    @Override
    public void setAudioPath(@NonNull String string) {
        this.mMainP2pTask = null;
        this.mProxyUri = null;
        if (StringUtil.isEmpty(string)) {
            this.mErrorListener.onError(7000011, 11);
        } else {
            this.setAudioURI(Uri.parse((String)string.trim()));
        }
    }

    private void setVideoURI(Uri uri) {
        this.mNonSurfaceHolderPVTimestamp = 0L;
        this.mCurrentUri = uri;
        this.mSeekWhenPrepared = 0;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    private void setAudioURI(Uri uri) {
        this.mNonSurfaceHolderPVTimestamp = 0L;
        this.mCurrentUri = uri;
        this.mSeekWhenPrepared = 0;
        this.openAudio();
    }

    @Override
    public void resetVideoPath(String string, IP2pTask iP2pTask, String string2) {
        DebugLog.i(this.getLogTag(), "resetVideoPath in");
        DebugLog.d(this.getLogTag(), string + ",task:" + iP2pTask + ",proxyPath:" + string2);
        this.beforeOpenVideo();
        this.mNonSurfaceHolderPVTimestamp = 0L;
        if (string == null) {
            this.mErrorListener.onError(7000011, 12);
        } else {
            this.mCurrentUri = Uri.parse((String)string.trim());
        }
        this.mMainP2pTask = iP2pTask;
        this.mProxyUri = StringUtil.isEmpty(string2) ? null : Uri.parse((String)string2.trim());
        if (this.mSurfaceHolder == null) {
            DebugLog.e(this.getLogTag(), "resetVideoPath: not ready for playback just yet, will try again later, mCurrentUri:" + this.mCurrentUri + ", mSurfaceHolder:" + this.mSurfaceHolder);
            this.mNonSurfaceHolderPVTimestamp = System.currentTimeMillis();
            this.mOpenVideoWhenSurfaceCreate = true;
            return;
        }
        if (this.mMediaPlayer != null && !this.isOnlyAudioMode()) {
            if (Build.VERSION.SDK_INT <= 22) {
                DebugLog.i(this.getLogTag(), "resetVideoPath need rebindTexture");
                this.mRebindTexture = true;
            } else {
                this.mRebindTexture = false;
            }
            if (this.mHasSurfaceHolderDestroy) {
                this.convertRender(this.mRenderViewType);
            } else {
                this.mMediaPlayer.setSurfaceHolder(null);
                ResetResult resetResult = this.resetImpl(true);
                if (resetResult == ResetResult.NONE) {
                    this.setVideoPath(string, iP2pTask, string2);
                    return;
                }
                if (resetResult == ResetResult.RESET_ERR) {
                    return;
                }
                if (this.mSurfaceHolder != null) {
                    try {
                        DebugLog.e(this.getLogTag(), "------chodison----reprepare MgtvMediaPlayer mMgtvMediaPlayerHardwareMode:" + this.mMgtvMediaPlayerHardwareMode + " url:" + this.mCurrentUri.toString());
                        this.mMediaPlayer.setReportParams(this.mReportParams);
                        this.configImgoPlayer();
                        this.mFromSurfaceDestroyToPlay = false;
                        this.mHasSurfaceHolderDestroy = false;
                        DebugLog.i(this.getLogTag(), "resetVideoPath streamKey:" + this.mStreamKey);
                        if (this.mMainP2pTask != null || this.mProxyUri != null) {
                            this.mMediaPlayer.setP2pDataSource(this.mCurrentUri.toString(), this.mMainP2pTask, this.mProxyUri != null ? this.mProxyUri.toString() : null, this.mStreamKey);
                        } else {
                            this.mMediaPlayer.setReadDataSourceType(0);
                            this.mMediaPlayer.setDataSource(this.mCurrentUri.toString());
                        }
                        this.mMediaPlayer.setSurfaceHolder(this.mSurfaceHolder);
                        this.mMediaPlayer.prepareAsync();
                        this.changeCurrentState(1);
                    }
                    catch (InvalidParameterException invalidParameterException) {
                        this.mErrorMsg = invalidParameterException.getMessage();
                        this.mErrorListener.onError(7000009, 2);
                        invalidParameterException.printStackTrace();
                    }
                    catch (Exception exception) {
                        this.mErrorMsg = exception.getMessage();
                        this.mErrorListener.onError(7000012, 0);
                        exception.printStackTrace();
                    }
                } else {
                    this.mNonSurfaceHolderPVTimestamp = System.currentTimeMillis();
                    this.mOpenVideoWhenSurfaceCreate = true;
                }
            }
        } else {
            this.setVideoPath(string, iP2pTask, string2);
        }
    }

    @Override
    public void reset() {
        this.resetImpl(false);
    }

    private ResetResult resetImpl(boolean bl) {
        if (this.mMediaPlayer != null) {
            this.resetDataBefore(bl ? MgtvAbstractVideoView.ReleaseReason.DEFAULT_INNER : MgtvAbstractVideoView.ReleaseReason.OUT);
            boolean bl2 = this.mMediaPlayer.reset();
            if (bl2) {
                this.changeCurrentState(0);
                this.mTargetState = 0;
            }
            this.resetDataAfter(bl ? MgtvAbstractVideoView.ReleaseReason.DEFAULT_INNER : MgtvAbstractVideoView.ReleaseReason.OUT);
            return bl2 ? ResetResult.RESET_OK : ResetResult.RESET_ERR;
        }
        return ResetResult.NONE;
    }

    @Override
    public void resetRender() {
        if (Constants.FOR_OTT && this.mEnableTexture) {
            this.mHasSurfaceHolderDestroy = true;
        }
    }

    @Override
    public void release() {
        super.release();
        this.release(true, false);
        this.afterRelease();
    }

    private void release(boolean bl, boolean bl2) {
        this.release(bl, bl2 ? MgtvAbstractVideoView.ReleaseReason.DEFAULT_INNER : MgtvAbstractVideoView.ReleaseReason.OUT);
    }

    private void release(boolean bl, MgtvAbstractVideoView.ReleaseReason releaseReason) {
        DebugLog.i(this.getLogTag(), "release player.clear.cleartargetstate:" + bl);
        if (this.mMediaPlayer != null) {
            if (bl) {
                this.mMediaPlayer.stop();
            }
            this.resetDataBefore(releaseReason);
            this.releaseNoStatus();
            this.setLastMediaMode(0);
            this.changeCurrentState(0);
            if (bl) {
                this.mTargetState = 0;
            }
            this.resetDataAfter(releaseReason);
        }
        if (releaseReason == MgtvAbstractVideoView.ReleaseReason.OUT) {
            this.abandonAudioFocus();
        }
    }

    @Override
    public void setTimeout(int n2, int n3) {
        this.mConnectTimeOut = n2;
        this.mReciveDataTimeOut = n3;
    }

    @Override
    public void setBufferTimeout(int n2) {
        this.mBufferTimeoutMs = n2;
    }

    private void openVideo() {
        this.openVideo(this.mMgtvMediaPlayerHardwareMode);
    }

    private void openVideo(boolean bl) {
        SurfaceHolder surfaceHolder;
        this.mErrorMsg = "";
        this.release(false, true);
        if (this.mCurrentUri == null || this.mSurfaceHolder == null) {
            DebugLog.e(this.getLogTag(), "imgo openVideo: not ready for playback just yet, will try again later, mCurrentUri:" + this.mCurrentUri + ", mSurfaceHolder:" + this.mSurfaceHolder);
            if (this.mCurrentUri != null && this.mSurfaceHolder == null) {
                this.mNonSurfaceHolderPVTimestamp = System.currentTimeMillis();
                this.mOpenVideoWhenSurfaceCreate = true;
            }
            return;
        }
        if (this.mRenderView == null) {
            if (this.mErrorListener != null) {
                this.mErrorListener.onError(7000005, 0);
            }
            this.mErrorMsg = "openVideo renderView is null";
            DebugLog.e(this.getLogTag(), this.mErrorMsg);
            return;
        }
        if (!(this.mRenderView.getRenderViewType() != 0 || (surfaceHolder = this.mSurfaceHolder.getSurfaceHolder()) != null && surfaceHolder.getSurface() != null && surfaceHolder.getSurface().isValid())) {
            if (this.mErrorListener != null) {
                this.mErrorListener.onError(7000009, 0);
            }
            this.mErrorMsg = "openVideo surface is invalid";
            if (surfaceHolder != null) {
                DebugLog.e(this.getLogTag(), "openVideo surface is invalid " + surfaceHolder.getSurface());
            }
            return;
        }
        if (this.isRequestAudioFocus) {
            this.requestAudioFocus();
        }
        try {
            surfaceHolder = new Bundle();
            surfaceHolder.putString("BUNDLE_KEY_LOG_TAG_KEY", this.getLogTagKey());
            int n2 = 0;
            if (this.mIsLiveConfig) {
                n2 = 1;
            }
            if (!this.mUseSystemPlayer) {
                if (bl) {
                    if (this.mRenderView != null && this.mRenderView.getRenderViewType() == 0) {
                        this.mEnableTexture = false;
                    }
                    this.mMediaPlayer = new MgtvMediaPlayer(2, this.mContext, this.mEnableTexture, n2, (Bundle)surfaceHolder);
                } else {
                    this.mEnableTexture = false;
                    this.mMediaPlayer = new MgtvMediaPlayer(1, this.mContext, this.mEnableTexture, n2, (Bundle)surfaceHolder);
                }
            } else {
                this.mMgtvMediaPlayerHardwareMode = true;
                this.mMediaPlayer = new MgtvMediaPlayer(0, this.mContext, false, (Bundle)surfaceHolder);
            }
            this.setLastMediaMode(0);
            this.mMediaPlayer.setFlowDataStatistic(this.mFlowDataStatistic);
            if (this.mFlowDataStatistic != null) {
                this.mFlowDataStatistic.setLogTag(this.getLogTag());
            }
            this.mMediaPlayer.setReportParams(this.mReportParams);
            this.configImgoPlayer();
            super.initListener(this.mMediaPlayer);
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnStartListener(this.mStartListener);
            this.mMediaPlayer.setOnPauseListener(this.mPauseListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.mMediaPlayer.setOnSeekCompleteListener(this.mSeekCompleteListener);
            this.mMediaPlayer.setOnBufferingTimeoutListener(this.mBufferingTimeoutListener);
            this.mMediaPlayer.setOnSwitchSourceListener(this.mSwitchSourceListener);
            this.mMediaPlayer.setOnWarningListener(this.mPlayerWarning);
            this.mMediaPlayer.setOnRecordVideoListener(this.mRecordVideoListener);
            this.mMediaPlayer.setOnLoadDataListener(this.mLoadDataListener);
            this.mFromSurfaceDestroyToPlay = false;
            this.mHasSurfaceHolderDestroy = false;
            if (this.mReadDataSourceTypeConfig == 3 && this.mDataSource != null) {
                this.mMediaPlayer.setReadDataSourceType(3);
                this.mMediaPlayer.setDataSource(this.mDataSource);
                DebugLog.i(this.getLogTag(), "setDataSource READ_DATASOURCE_TYPE_DATA_SOURCE");
            } else if (this.mMainP2pTask != null || this.mProxyUri != null) {
                this.mMediaPlayer.setP2pDataSource(this.mCurrentUri.toString(), this.mMainP2pTask, this.mProxyUri != null ? this.mProxyUri.toString() : null, this.mStreamKey);
            } else {
                this.mMediaPlayer.setReadDataSourceType(0);
                this.mMediaPlayer.setDataSource(this.mCurrentUri.toString());
            }
            this.mMediaPlayer.setSurfaceHolder(this.mSurfaceHolder);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(this.mIsScreenOnWhilePlaying);
            this.mMediaPlayer.prepareAsync();
            this.changeCurrentState(1);
            DebugLog.i(this.getLogTag(), "openVideo is over");
        }
        catch (InvalidParameterException invalidParameterException) {
            DebugLog.w(this.getLogTag(), "Unable to open content: " + this.mCurrentUri);
            this.mErrorMsg = invalidParameterException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000009, 3);
            return;
        }
        catch (IOException iOException) {
            DebugLog.w(this.getLogTag(), "Unable to open content: " + this.mCurrentUri);
            this.mErrorMsg = iOException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7001004, 0);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException != null) {
                DebugLog.w(this.getLogTag(), "Unable to open content: " + this.mCurrentUri + ",details:" + illegalArgumentException.getMessage());
            }
            this.mErrorMsg = illegalArgumentException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000001, 0);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            DebugLog.w(this.getLogTag(), "Unable to open content: " + this.mCurrentUri);
            this.mErrorMsg = illegalStateException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000002, 0);
            return;
        }
        catch (SecurityException securityException) {
            if (securityException != null) {
                DebugLog.i(this.getLogTag(), "SecurityException: " + this.mCurrentUri + ",details:" + securityException.getMessage());
            }
            this.mErrorMsg = securityException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000004, 0);
            return;
        }
        catch (NullPointerException nullPointerException) {
            if (nullPointerException != null) {
                DebugLog.i(this.getLogTag(), "NullPointerException: " + this.mCurrentUri + ",details:" + nullPointerException.getMessage());
            }
            this.mErrorMsg = nullPointerException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000005, 0);
            return;
        }
        catch (Exception exception) {
            if (exception != null) {
                DebugLog.w(this.getLogTag(), "Unable to open content: " + this.mCurrentUri + ",details:" + exception.getMessage());
            }
            this.mErrorMsg = exception.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000003, 0);
            return;
        }
        catch (c c2) {
            DebugLog.e(this.getLogTag(), "LibLoaderError: " + this.mCurrentUri + "details:" + c2.getMessage() + ",extra:" + c2.a());
            this.mErrorMsg = c2.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000010, c2.a());
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (unsatisfiedLinkError != null) {
                DebugLog.i(this.getLogTag(), "UnsatisfiedLinkError: " + this.mCurrentUri + ",details:" + unsatisfiedLinkError.getMessage());
            }
            this.mErrorMsg = unsatisfiedLinkError.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000010, 0);
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (outOfMemoryError != null) {
                DebugLog.i(this.getLogTag(), "OutOfMemoryError: " + this.mCurrentUri + ",details:" + outOfMemoryError.getMessage());
            }
            this.mErrorMsg = outOfMemoryError.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000006, 0);
            return;
        }
        catch (Throwable throwable) {
            if (throwable != null) {
                DebugLog.i(this.getLogTag(), "Throwable: " + this.mCurrentUri + ",details:" + throwable.getMessage());
            }
            this.mErrorMsg = throwable.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000003, 1);
            return;
        }
    }

    private void openAudio() {
        this.mErrorMsg = "";
        if (this.mCurrentUri == null) {
            DebugLog.e(this.getLogTag(), "imgo openAudio: not ready for playback just yet, will try again later, mCurrentUri:" + this.mCurrentUri);
            return;
        }
        this.requestAudioFocus();
        this.release(false, true);
        try {
            Bundle bundle = new Bundle();
            bundle.putString("BUNDLE_KEY_LOG_TAG_KEY", this.getLogTagKey());
            bundle.putBoolean("BUNDLE_KEY_BOOLEAN_AUDIO_MODE", true);
            this.mMediaPlayer = new MgtvMediaPlayer(1, this.mContext, bundle);
            this.setLastMediaMode(1);
            this.mMediaPlayer.setConfig(201507067, 1);
            this.mMediaPlayer.setFlowDataStatistic(this.mFlowDataStatistic);
            if (this.mFlowDataStatistic != null) {
                this.mFlowDataStatistic.setLogTag(this.getLogTag());
            }
            this.mMediaPlayer.setReportParams(this.mReportParams);
            this.configAudioImgoPlayer();
            super.initListener(this.mMediaPlayer);
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnStartListener(this.mStartListener);
            this.mMediaPlayer.setOnPauseListener(this.mPauseListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.mMediaPlayer.setOnSeekCompleteListener(this.mSeekCompleteListener);
            this.mMediaPlayer.setOnBufferingTimeoutListener(this.mBufferingTimeoutListener);
            this.mMediaPlayer.setOnSwitchSourceListener(this.mSwitchSourceListener);
            this.mMediaPlayer.setOnWarningListener(this.mPlayerWarning);
            this.mMediaPlayer.setOnRecordVideoListener(this.mRecordVideoListener);
            this.mMediaPlayer.setOnLoadDataListener(this.mLoadDataListener);
            this.mFromSurfaceDestroyToPlay = false;
            this.mHasSurfaceHolderDestroy = false;
            if (this.mMainP2pTask != null || this.mProxyUri != null) {
                this.mMediaPlayer.setP2pDataSource(this.mCurrentUri.toString(), this.mMainP2pTask, this.mProxyUri != null ? this.mProxyUri.toString() : null, this.mStreamKey);
            } else {
                this.mMediaPlayer.setReadDataSourceType(0);
                this.mMediaPlayer.setDataSource(this.mCurrentUri.toString());
            }
            this.mMediaPlayer.setSurfaceHolder(this.mSurfaceHolder);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(this.mIsScreenOnWhilePlaying);
            this.mMediaPlayer.prepareAsync();
            this.changeCurrentState(1);
            DebugLog.i(this.getLogTag(), "openAudio is over");
        }
        catch (InvalidParameterException invalidParameterException) {
            DebugLog.w(this.getLogTag(), "Unable to open content: " + this.mCurrentUri);
            this.mErrorMsg = invalidParameterException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000009, 3);
            return;
        }
        catch (IOException iOException) {
            DebugLog.w(this.getLogTag(), "Unable to open content: " + this.mCurrentUri);
            this.mErrorMsg = iOException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7001004, 0);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException != null) {
                DebugLog.w(this.getLogTag(), "Unable to open content: " + this.mCurrentUri + ",details:" + illegalArgumentException.getMessage());
            }
            this.mErrorMsg = illegalArgumentException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000001, 0);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            DebugLog.w(this.getLogTag(), "Unable to open content: " + this.mCurrentUri);
            this.mErrorMsg = illegalStateException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000002, 0);
            return;
        }
        catch (SecurityException securityException) {
            if (securityException != null) {
                DebugLog.i(this.getLogTag(), "SecurityException: " + this.mCurrentUri + ",details:" + securityException.getMessage());
            }
            this.mErrorMsg = securityException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000004, 0);
            return;
        }
        catch (NullPointerException nullPointerException) {
            if (nullPointerException != null) {
                DebugLog.i(this.getLogTag(), "NullPointerException: " + this.mCurrentUri + ",details:" + nullPointerException.getMessage());
            }
            this.mErrorMsg = nullPointerException.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000005, 0);
            return;
        }
        catch (Exception exception) {
            if (exception != null) {
                DebugLog.w(this.getLogTag(), "Unable to open content: " + this.mCurrentUri + ",details:" + exception.getMessage());
            }
            this.mErrorMsg = exception.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000003, 0);
            return;
        }
        catch (c c2) {
            DebugLog.e(this.getLogTag(), "LibLoaderError: " + this.mCurrentUri + "details:" + c2.getMessage() + ",extra:" + c2.a());
            this.mErrorMsg = c2.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000010, c2.a());
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (unsatisfiedLinkError != null) {
                DebugLog.i(this.getLogTag(), "UnsatisfiedLinkError: " + this.mCurrentUri + ",details:" + unsatisfiedLinkError.getMessage());
            }
            this.mErrorMsg = unsatisfiedLinkError.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000010, 0);
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (outOfMemoryError != null) {
                DebugLog.i(this.getLogTag(), "OutOfMemoryError: " + this.mCurrentUri + ",details:" + outOfMemoryError.getMessage());
            }
            this.mErrorMsg = outOfMemoryError.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000006, 0);
            return;
        }
        catch (Throwable throwable) {
            if (throwable != null) {
                DebugLog.i(this.getLogTag(), "Throwable: " + this.mCurrentUri + ",details:" + throwable.getMessage());
            }
            this.mErrorMsg = throwable.getMessage();
            this.changeCurrentState(-1);
            this.mTargetState = -1;
            this.mErrorListener.onError(7000003, 1);
            return;
        }
    }

    private void checkMemoryStatus(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        if (!ImgoLibLoader.getInstance().isAllPlayerLibLoaded() && (memoryInfo = MemoryUtil.getMemoryInfo(context)) != null && memoryInfo.lowMemory) {
            this.mPlayerWarning.onWarning(800600, (memoryInfo.availMem >> 20) + "", "[" + memoryInfo.availMem + "-" + memoryInfo.lowMemory + "-" + memoryInfo.threshold + "]", null);
        }
    }

    @Override
    public boolean isPrepared() {
        return this.isInPlaybackState();
    }

    @Override
    public boolean isRendered() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.isRendered();
        }
        return false;
    }

    @Override
    public boolean isCompletion() {
        return this.mCurrentState == 5;
    }

    public boolean isStretchScreen() {
        return this.isStretchScreen;
    }

    public void setStretchScreen() {
        if (this.shouldGetVideoParams) {
            DebugLog.i("@@@", "getFullScreenVideoParams");
            this.getFullScreenVideoParams();
            this.shouldGetVideoParams = false;
        }
        if (!this.isStretchScreen) {
            this.layout(0, 0, this.metrics.widthPixels, this.metrics.heightPixels);
            this.mVideoWidth = this.metrics.widthPixels;
            this.mVideoHeight = this.metrics.heightPixels;
            this.isStretchScreen = true;
        } else {
            this.mVideoWidth = this.originalVideoWidth;
            this.mVideoHeight = this.originalVideoHeight;
            this.layout(this.fromLeft, this.fromTop, this.fromRight, this.fromBottom);
            this.isStretchScreen = false;
        }
        if (this.mRenderView != null) {
            this.mRenderView.setVideoSize(this.mVideoWidth, this.mVideoHeight);
        }
    }

    private void getFullScreenVideoParams() {
        float f2 = (float)this.mVideoWidth / (float)this.mVideoHeight;
        if ((float)this.metrics.widthPixels / (float)this.metrics.heightPixels < f2) {
            int n2 = this.metrics.widthPixels * this.mVideoHeight / this.mVideoWidth;
            int n3 = (this.metrics.heightPixels - n2) / 2;
            this.fromLeft = 0;
            this.fromTop = n3;
            this.fromRight = this.metrics.widthPixels;
            this.fromBottom = n3 + n2;
        } else {
            int n4;
            int n5 = this.metrics.heightPixels * this.mVideoWidth / this.mVideoHeight;
            this.fromLeft = n4 = (this.metrics.widthPixels - n5) / 2;
            this.fromTop = 0;
            this.fromRight = n4 + n5;
            this.fromBottom = this.metrics.heightPixels;
        }
        DebugLog.i(this.getLogTag(), "fromLeft:" + this.fromLeft + "/fromTop:" + this.fromTop + "/fromRight:" + this.fromRight + "/fromBottom:" + this.fromBottom);
    }

    @Override
    public String getDLSpeedFormat() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(1);
        float f2 = 0.0f;
        if (this.mMediaPlayer != null) {
            f2 = (float)this.mMediaPlayer.getCurDLSpeed() / 1000.0f;
        }
        return numberFormat.format(f2) + "KB/S";
    }

    @Override
    public int getDLSpeedB() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getCurDLSpeed();
        }
        return 0;
    }

    @Override
    public void setOnBufferingUpdateListener(IVideoView.OnBufferingUpdateListener onBufferingUpdateListener) {
        this.mOnBufferringUpdateListener = onBufferingUpdateListener;
    }

    @Override
    public void setOnWarningListener(MgtvPlayerListener.OnWarningListener onWarningListener) {
        this.mOnWarningListener = onWarningListener;
    }

    @Override
    public void setOnChangeSourceListener(IVideoView.OnChangeSourceListener onChangeSourceListener) {
        this.mOnChangeSourceListener = onChangeSourceListener;
    }

    @Override
    public void setOnRecordListener(IVideoView.OnRecordListener onRecordListener) {
        this.mOnRecordListener = onRecordListener;
    }

    @Override
    public void setOnUpdateStatusListener(IVideoView.OnUpdateStatusListener onUpdateStatusListener) {
        this.mOnUpdateStatusListener = onUpdateStatusListener;
    }

    @Override
    public void setOnVideoSizeChangedListener(IVideoView.OnVideoSizeChangedListener onVideoSizeChangedListener) {
        this.mOnVideoSizeChangedListener = onVideoSizeChangedListener;
    }

    @Override
    public void setOnLoadDataListener(IVideoView.OnLoadDataListener onLoadDataListener) {
        this.mOnLoadDataListener = onLoadDataListener;
    }

    @Override
    public void setOnPreparedListener(IVideoView.OnPreparedListener onPreparedListener) {
        this.mOnPreparedListener = onPreparedListener;
    }

    @Override
    public void setOnCompletionListener(IVideoView.OnCompletionListener onCompletionListener) {
        this.mOnCompletionListener = onCompletionListener;
    }

    @Override
    public void setOnInfoListener(IVideoView.OnInfoListener onInfoListener) {
        this.mOnInfoListener = onInfoListener;
    }

    @Override
    public void setOnErrorListener(IVideoView.OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    @Override
    public void setOnSeekCompleteListener(IVideoView.OnSeekCompleteListener onSeekCompleteListener) {
        this.mOnSeekCompleteListener = onSeekCompleteListener;
    }

    @Override
    public void setOnStartListener(IVideoView.OnStartListener onStartListener) {
        this.mOnStartListener = onStartListener;
    }

    @Override
    public void setOnPauseListener(IVideoView.OnPauseListener onPauseListener) {
        this.mOnPauseListener = onPauseListener;
    }

    private boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentState != -1 && this.mCurrentState != 0 && this.mCurrentState != 1;
    }

    @Override
    public void start() {
        if (this.isInPlaybackState()) {
            if (this.isRequestAudioFocus) {
                this.requestAudioFocus();
            }
            if (this.mCurrentState != 3) {
                if (this.mCurrentState == 5) {
                    DebugLog.e(this.getLogTag(), "play video direct after complete");
                }
                this.resumeLoadData();
                this.mMediaPlayer.start();
                DebugLog.i(this.getLogTag(), "start play");
                if (!this.mEnableCoreStartPauseListen) {
                    this.callbackOnStart();
                }
            }
        }
        this.mTargetState = 3;
    }

    private void callbackOnStart() {
        this.changeCurrentState(3);
        if (this.mOnStartListener != null) {
            this.mOnStartListener.onStart();
        }
    }

    private void callbackOnPause() {
        this.changeCurrentState(4);
        if (this.mOnPauseListener != null) {
            this.mOnPauseListener.onPause();
        }
    }

    @Override
    public void pause() {
        this.pauseInner();
        this.mTargetState = 4;
    }

    private void pauseInner() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            DebugLog.i(this.getLogTag(), "pause play");
            try {
                this.mMediaPlayer.pause();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!this.mEnableCoreStartPauseListen) {
                this.callbackOnPause();
            }
        }
    }

    @Override
    public void resume() {
        this.openVideo();
    }

    @Override
    public int getDuration() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getDuration();
        }
        return -1;
    }

    @Override
    public int getCurrentPosition() {
        if (this.mMediaPlayer != null && this.mCurrentState != 0 && this.mCurrentState != 1) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public int getCurrentPositionUnsafe() {
        if (this.mMediaPlayer != null && this.mCurrentState != 0 && this.mCurrentState != 1) {
            return this.mMediaPlayer.getCurrentPositionUnSafe();
        }
        return 0;
    }

    @Override
    public void seekTo(int n2, boolean bl) {
        this.seekTo(n2, bl, false);
    }

    public void seekTo(int n2, boolean bl, boolean bl2) {
        if (this.isInPlaybackState()) {
            if (n2 >= 0) {
                if (this.mFromSurfaceDestroyToPlay) {
                    this.mFromSurfaceDestroyPlayPosition = n2;
                }
                DebugLog.i(this.getLogTag(), "seekTo msec:" + n2);
                this.mMediaPlayer.seekTo(n2, bl, bl2);
                if (this.mSeekAutoStartAfterCompleteEnable && this.mCurrentState == 5) {
                    this.callbackOnStart();
                }
            }
            this.mSeekWhenPrepared = 0;
        } else {
            this.mSeekWhenPrepared = n2;
            DebugLog.i(this.getLogTag(), "seekto before prepared record pos= " + this.mSeekWhenPrepared);
        }
    }

    @Override
    public void seekTo(int n2) {
        if (this.isInPlaybackState()) {
            if (n2 >= 0) {
                if (this.mFromSurfaceDestroyToPlay) {
                    this.mFromSurfaceDestroyPlayPosition = n2;
                }
                this.mMediaPlayer.seekTo(n2);
                if (this.mSeekAutoStartAfterCompleteEnable && this.mCurrentState == 5) {
                    this.callbackOnStart();
                }
            }
            this.mSeekWhenPrepared = 0;
        } else {
            this.mSeekWhenPrepared = n2;
            DebugLog.i(this.getLogTag(), "seekto before prepared record pos= " + this.mSeekWhenPrepared);
        }
    }

    @Override
    public boolean isPlaying() {
        return this.isInPlaybackState() && this.mMediaPlayer.isPlaying();
    }

    @Override
    public int getBufferingPercentage() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getBufferingPercent();
        }
        return 0;
    }

    @Override
    public int getTotalBuffering() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getBufferedPercentage();
        }
        return 0;
    }

    @Override
    public void setPlayerHardwareMode(boolean bl) {
        DebugLog.i(this.getLogTag(), "setPlayerHardwareMode : " + bl);
        this.mMgtvMediaPlayerHardwareMode = bl;
    }

    @Override
    public void setForceDecodeMode(boolean bl) {
        this.mForceDecodeMode = bl;
    }

    @Override
    public boolean isHardware() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.isHardware();
        }
        return false;
    }

    @Override
    public void setPlayerAudioMode(boolean bl) {
        this.mMgtvMediaPlayerAudioMode = bl;
    }

    @Override
    public String getPlayerVersion() {
        return MgtvVideoView.getVersion();
    }

    public static String getVersion() {
        return "MGTV_1.22.0";
    }

    @Override
    public int getVideoWidth() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getVideoHeight();
        }
        return 0;
    }

    @Override
    public int getBitRate() {
        if (this.mMediaPlayer != null) {
            return (int)this.mMediaPlayer.getVideoBitRate();
        }
        return 0;
    }

    @Override
    public int getFPS() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getVideoFPS();
        }
        return 0;
    }

    @Override
    public String getErrorMsg() {
        return this.mErrorMsg;
    }

    @Override
    public String getErrorUrl() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.getErrorUrl();
        }
        return "";
    }

    @Override
    public void setZOrderMediaOverlay(boolean bl) {
        if (this.mRenderView != null && this.mRenderView.getView() != null && this.mRenderView.getView() instanceof SurfaceView) {
            ((SurfaceView)this.mRenderView.getView()).setZOrderMediaOverlay(bl);
        }
    }

    @Override
    public void setPlaybackSpeed(float f2) {
        this.mPlaySpeed = f2;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setPlaybackSpeed(f2);
        }
    }

    @Override
    public float getPlaybackSpeed() {
        return this.mPlaySpeed;
    }

    @Override
    public void changeSourceAsync(String string, int n2, int n3, int n4) {
        IVideoView.MediaSource mediaSource = new IVideoView.MediaSource().setReadType(0).setUrl(string);
        this.changeSourceAsync(mediaSource, n2, n3, n4);
    }

    @Override
    public void changeSourceAsync(IVideoView.MediaSource mediaSource, int n2, int n3, int n4) {
        block11: {
            int n5 = 0;
            String string = null;
            IP2pTask iP2pTask = null;
            String string2 = null;
            if (mediaSource == null) {
                if (this.mOnChangeSourceListener != null) {
                    this.mOnChangeSourceListener.onChangeSourceFailed(string, 7000001, 0);
                }
                return;
            }
            n5 = mediaSource.readType;
            string = mediaSource.url;
            iP2pTask = mediaSource.p2pTask;
            string2 = mediaSource.proxyUrl;
            if (this.mMediaPlayer != null) {
                try {
                    if (n5 == 0 || iP2pTask == null && StringUtil.isEmpty(string2)) {
                        n5 = 0;
                        mediaSource.readType = 0;
                        if (StringUtil.isEmpty(string)) {
                            if (this.mOnChangeSourceListener != null) {
                                this.mOnChangeSourceListener.onChangeSourceFailed(string, 7000001, 0);
                            }
                            return;
                        }
                        this.mMediaPlayer.switchVideoSource(string, n2, n3, n4);
                    } else {
                        this.mMediaPlayer.switchP2pVideoSource(n5, string, iP2pTask, string2, n2, n3, n4);
                    }
                    DebugLog.i(this.getLogTag(), "changeSourceAsync url:" + string);
                    DebugLog.i(this.getLogTag(), "changeSourceAsync p2pTask:" + iP2pTask);
                    DebugLog.i(this.getLogTag(), "changeSourceAsync proxyUrl:" + string2);
                    DebugLog.i(this.getLogTag(), "changeSourceAsync type:" + n2 + "src:" + n3 + ",dst:" + n4);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (this.mOnChangeSourceListener != null) {
                        this.mOnChangeSourceListener.onChangeSourceFailed(string, 7000001, 0);
                    }
                }
                catch (Exception exception) {
                    if (this.mOnChangeSourceListener == null) break block11;
                    this.mOnChangeSourceListener.onChangeSourceFailed(string, 7000003, 0);
                }
            }
        }
    }

    @Override
    public void openImgoDSModule(boolean bl) {
        if (this.mDataSourceInfo != null) {
            DebugLog.i(this.getLogTag(), "openImgoDSModule fileFormat:" + this.mDataSourceInfo.getFileFormat());
        }
        this.mDataSourceType = bl ? MgtvMediaPlayer.DataSourceType.TYPE_DATASOUCE_IMGO : MgtvMediaPlayer.DataSourceType.TYPE_DATASOUCE_DEFAULT;
    }

    @Override
    public boolean isImgoSourceModuleOpen() {
        return ImgoLibLoader.getInstance().isDsLibLoaded() && this.mDataSourceType == MgtvMediaPlayer.DataSourceType.TYPE_DATASOUCE_IMGO;
    }

    @Override
    protected void configAudioImgoPlayer() {
        super.configAudioImgoPlayer();
        this.mOpenVideoWhenSurfaceCreate = false;
        if (this.mReportParams != null) {
            this.mReportParams.setAddrInfoInt(this.mAddrInfoTypeInt);
        }
        if (this.mDnsFamilyType == 1) {
            this.updateVodDefaultDnsType();
        } else {
            this.setNetAddrinfo(0, -1);
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setTimeout(this.mConnectTimeOut, this.mReciveDataTimeOut, this.mBufferTimeoutMs);
            this.mMediaPlayer.setDataSourceType(this.mDataSourceType);
            this.mMediaPlayer.setAccurateSeekEnable(true);
            this.mMediaPlayer.setNetAddrinfo(this.mAddrInfoType, this.mAddrInfoTimeoutMs, this.mJavaDnsEnable, this.mJavaDnsType, this.mNativeDnsAsyncEnable, this.mBackJavaDns);
            this.mMediaPlayer.configTsNotSkip(this.mTsNotSkip);
            if (this.mLoadMaxRetryTime > 0) {
                this.mMediaPlayer.configLoadMaxRetryTime(this.mLoadMaxRetryTime);
            }
            if (this.mWeakNetSpeed > 0) {
                this.mMediaPlayer.configWeakBufferSpeed(this.mWeakNetSpeed);
            }
            if (this.mWeakBufferTimeoutMs > 0) {
                this.mMediaPlayer.configWeakBufferTimeout(this.mWeakBufferTimeoutMs);
            }
            if (this.mLeftVolume >= 0.0f && this.mRightVolume >= 0.0f) {
                this.mMediaPlayer.setVolume(this.mLeftVolume, this.mRightVolume);
            }
            this.mEnableCoreStartPauseListen = this.mMediaPlayer.isMgtvCore() && this.mUserEnableCoreStartPauseListen;
            this.mMediaPlayer.setPlaybackSpeed(this.mPlaySpeed);
            this.mMediaPlayer.setLiveStartIndex(this.mLiveStartIndex);
            if (this.mEnableLiveMode) {
                this.mLastFrameRecovery = false;
                this.mMediaPlayer.setEnablePlayerMode(MgtvMediaPlayer.PlayerModeType.TYPE_PLAYER_MODE_LIVE);
            } else {
                this.mMediaPlayer.setEnablePlayerMode(MgtvMediaPlayer.PlayerModeType.TYPE_PLAYER_MODE_NORMAL);
            }
            if (this.mStartPosMs > 0) {
                this.mMediaPlayer.setPlayerSeekAtStartPosMs(this.mStartPosMs);
                DebugLog.i(this.getLogTag(), "configImgoPlayer mStartPosMs:" + this.mStartPosMs);
            }
            this.mMediaPlayer.enableTsSkipError(this.mEnableTsSkipError);
            this.mMediaPlayer.setHttpDnsNeedRetry(this.mEnableHttpDnsRetry);
            this.mMediaPlayer.setP2pHttpDns(this.mEnableP2pHttpDns, false);
            this.mMediaPlayer.setEnableDnsNoNetStrategy(this.mEnableDnsNoNetStrategy);
            DebugLog.i(this.getLogTag(), "configImgoPlayer 1 mConnectTimeOut:" + this.mConnectTimeOut + ",mReciveDataTimeOut:" + this.mReciveDataTimeOut + ",mBufferTimeoutMs:" + this.mBufferTimeoutMs + ",mDataSourceType:" + (Object)((Object)this.mDataSourceType) + ",mAccurateSeekEnable:" + this.mAccurateSeekEnable + ",mAddrInfoType:" + (Object)((Object)this.mAddrInfoType) + ",mAddrInfoTimeoutMs:" + this.mAddrInfoTimeoutMs + ",mJavaDnsEnable:" + this.mJavaDnsEnable + ",mJavaDnsType:" + (Object)((Object)this.mJavaDnsType) + ",mPlaySpeed:" + this.mPlaySpeed + ",mLiveStartIndex:" + this.mLiveStartIndex + ",mEnableLiveMode:" + this.mEnableLiveMode);
            DebugLog.i(this.getLogTag(), "configImgoPlayer mReadDataSourceTypeConfig:" + this.mReadDataSourceTypeConfig + ",mNativeDnsAsyncEnable:" + this.mNativeDnsAsyncEnable + ",mEnableTsSkipError:" + this.mEnableTsSkipError + ",mHlsMD5CheckValue:" + this.mHlsMD5CheckValue + ",mEnableMgtvMediaCodec:" + this.mEnableMgtvMediaCodec + ",mEnableHttpDnsRetry:" + this.mEnableHttpDnsRetry + ",mEnableP2pHttpDns:" + this.mEnableP2pHttpDns + ",mEnableDnsNoNetStrategy:" + this.mEnableDnsNoNetStrategy);
            if (this.mNonSurfaceHolderPVTimestamp > 0L) {
                this.mMediaPlayer.setNetdSVCTimeMs(System.currentTimeMillis() - this.mNonSurfaceHolderPVTimestamp);
            } else {
                this.mMediaPlayer.setNetdSVCTimeMs(0L);
            }
        }
    }

    @Override
    protected void configImgoPlayer() {
        super.configImgoPlayer();
        this.mOpenVideoWhenSurfaceCreate = false;
        if (this.mReportParams != null) {
            this.mReportParams.setAddrInfoInt(this.mAddrInfoTypeInt);
        }
        if (this.mDnsFamilyType == 1) {
            this.updateVodDefaultDnsType();
        } else {
            this.setNetAddrinfo(0, -1);
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.bindRenderView(this.mRenderView != null ? this.mRenderView.getRenderView() : null);
            this.mMediaPlayer.setTimeout(this.mConnectTimeOut, this.mReciveDataTimeOut, this.mBufferTimeoutMs);
            this.mMediaPlayer.setDataSourceType(this.mDataSourceType);
            this.mMediaPlayer.setAccurateSeekEnable(this.mAccurateSeekEnable);
            this.mMediaPlayer.setNetAddrinfo(this.mAddrInfoType, this.mAddrInfoTimeoutMs, this.mJavaDnsEnable, this.mJavaDnsType, this.mNativeDnsAsyncEnable, this.mBackJavaDns);
            this.mMediaPlayer.configTsNotSkip(this.mTsNotSkip);
            if (this.mLoadMaxRetryTime > 0) {
                this.mMediaPlayer.configLoadMaxRetryTime(this.mLoadMaxRetryTime);
            }
            if (this.mWeakNetSpeed > 0) {
                this.mMediaPlayer.configWeakBufferSpeed(this.mWeakNetSpeed);
            }
            if (this.mWeakBufferTimeoutMs > 0) {
                this.mMediaPlayer.configWeakBufferTimeout(this.mWeakBufferTimeoutMs);
            }
            this.mMediaPlayer.enableM3u8Cache(this.mCacheEnable);
            this.mMediaPlayer.setM3u8Caches(this.mCacheM3u8Path, this.mCacheTsPaths);
            if (this.mLeftVolume >= 0.0f && this.mRightVolume >= 0.0f) {
                this.mMediaPlayer.setVolume(this.mLeftVolume, this.mRightVolume);
            }
            this.mEnableCoreStartPauseListen = this.mMediaPlayer.isMgtvCore() && this.mUserEnableCoreStartPauseListen;
            this.mMediaPlayer.configForceHW(this.mForceDecodeMode);
            this.mMediaPlayer.bindGifRecorder(this.mGifRecorder);
            this.mMediaPlayer.setPlaybackSpeed(this.mPlaySpeed);
            this.mMediaPlayer.setLiveStartIndex(this.mLiveStartIndex);
            if (this.mEnableLiveMode) {
                this.mLastFrameRecovery = false;
                this.mMediaPlayer.setEnablePlayerMode(MgtvMediaPlayer.PlayerModeType.TYPE_PLAYER_MODE_LIVE);
            } else if (this.mSmoothModeSwitch) {
                this.mMediaPlayer.setEnablePlayerMode(MgtvMediaPlayer.PlayerModeType.TYPE_PLAYER_MODE_SMOOTH);
                this.mSmoothModeOpen = true;
            } else {
                this.mMediaPlayer.setEnablePlayerMode(MgtvMediaPlayer.PlayerModeType.TYPE_PLAYER_MODE_NORMAL);
            }
            if (this.mStartPosMs > 0) {
                this.mMediaPlayer.setPlayerSeekAtStartPosMs(this.mStartPosMs);
                DebugLog.i(this.getLogTag(), "configImgoPlayer mStartPosMs:" + this.mStartPosMs);
            }
            this.mMediaPlayer.setReadDataSourceType(this.mReadDataSourceTypeConfig);
            this.updateDataCacheSizeKB();
            this.updateSkipLoopFilter();
            this.mMediaPlayer.enableJAVAIPCacheMap(this.mEnableJavaIPCache);
            this.mMediaPlayer.enableTsSkipError(this.mEnableTsSkipError);
            this.mMediaPlayer.setHlsCheckMD5(this.mHlsMD5CheckValue);
            this.mMediaPlayer.enableMgtvMediaCodec(this.mEnableMgtvMediaCodec);
            this.mMediaPlayer.setHttpDnsNeedRetry(this.mEnableHttpDnsRetry);
            this.mMediaPlayer.setP2pHttpDns(this.mEnableP2pHttpDns, false);
            this.mMediaPlayer.setEnableDnsNoNetStrategy(this.mEnableDnsNoNetStrategy);
            DebugLog.i(this.getLogTag(), "configImgoPlayer 1 mConnectTimeOut:" + this.mConnectTimeOut + ",mReciveDataTimeOut:" + this.mReciveDataTimeOut + ",mBufferTimeoutMs:" + this.mBufferTimeoutMs + ",mDataSourceType:" + (Object)((Object)this.mDataSourceType) + ",mAccurateSeekEnable:" + this.mAccurateSeekEnable + ",mAddrInfoType:" + (Object)((Object)this.mAddrInfoType) + ",mAddrInfoTimeoutMs:" + this.mAddrInfoTimeoutMs + ",mJavaDnsEnable:" + this.mJavaDnsEnable + ",mJavaDnsType:" + (Object)((Object)this.mJavaDnsType) + ",mPlaySpeed:" + this.mPlaySpeed + ",mLiveStartIndex:" + this.mLiveStartIndex + ",mEnableLiveMode:" + this.mEnableLiveMode);
            DebugLog.i(this.getLogTag(), "configImgoPlayer mReadDataSourceTypeConfig:" + this.mReadDataSourceTypeConfig + ",mNativeDnsAsyncEnable:" + this.mNativeDnsAsyncEnable + ",mEnableTsSkipError:" + this.mEnableTsSkipError + ",mHlsMD5CheckValue:" + this.mHlsMD5CheckValue + ",mEnableMgtvMediaCodec:" + this.mEnableMgtvMediaCodec + ",mEnableHttpDnsRetry:" + this.mEnableHttpDnsRetry + ",mEnableP2pHttpDns:" + this.mEnableP2pHttpDns + ",mEnableDnsNoNetStrategy:" + this.mEnableDnsNoNetStrategy);
            if (this.mNonSurfaceHolderPVTimestamp > 0L) {
                this.mMediaPlayer.setNetdSVCTimeMs(System.currentTimeMillis() - this.mNonSurfaceHolderPVTimestamp);
            } else {
                this.mMediaPlayer.setNetdSVCTimeMs(0L);
            }
        }
    }

    @Override
    public void setPlayerDebug(boolean bl) {
        MgtvMediaPlayer.setPlayerDebug(bl);
    }

    @Override
    public void setStreamKey(int n2) {
        this.mStreamKey = n2;
    }

    @Override
    void resetDataBefore(MgtvAbstractVideoView.ReleaseReason releaseReason) {
        super.resetDataBefore(releaseReason);
        this.mIsLive = false;
        if (this.mRenderView != null) {
            this.mRenderView.reset();
        }
        if (releaseReason == MgtvAbstractVideoView.ReleaseReason.OUT) {
            this.mStartLeaveTimestamp = 0L;
            this.mCacheM3u8Path = null;
            this.mCacheTsPaths = null;
            this.mStartPosMs = 0;
            if (this.mFlowDataStatistic != null && this.mFlowDataStatistic.isBindPlayerLifecycle()) {
                this.mFlowDataStatistic.reset();
            }
            this.mNonSurfaceHolderPVTimestamp = 0L;
        }
        this.mReleasedByPauseLoadData = releaseReason == MgtvAbstractVideoView.ReleaseReason.PAUSE_DATA_BEFORE_PREPEAD;
        this.mOpenVideoWhenSurfaceCreate = false;
    }

    @Override
    public void pauseLoadData() {
        DebugLog.i(this.getLogTag(), "call pauseLoadData. waiting call native pauseLoadData");
        if (this.isPrepared()) {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.pauseLoadData();
            }
        } else {
            DebugLog.i(this.getLogTag(), "called pauseLoadData before preapred. release player");
            try {
                if (this.mReportParams != null) {
                    this.mReportParams.getEnd().setInnerRetry(true);
                }
                this.release(true, MgtvAbstractVideoView.ReleaseReason.PAUSE_DATA_BEFORE_PREPEAD);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void resumeLoadData() {
        DebugLog.i(this.getLogTag(), "call resumeLoadData. waiting call native resumeLoadData");
        if (this.mReleasedByPauseLoadData) {
            this.mReleasedByPauseLoadData = false;
            if (this.mCurrentUri != null) {
                DebugLog.i(this.getLogTag(), "call resumeLoadData. player release by call pauseLoadData.reopen it");
                this.resume();
                return;
            }
            DebugLog.i(this.getLogTag(), "call resumeLoadData. mCurrentUri == null waiting setVideoPath");
        } else if (this.mMediaPlayer != null) {
            this.mMediaPlayer.resumeLoadData();
        }
    }

    @Override
    public void cleanUri() {
        DebugLog.i(this.getLogTag(), "cleanUri");
        this.mCurrentUri = null;
        this.mProxyUri = null;
        this.mDataSource = null;
    }

    @Override
    public void setRenderViewVisible(int n2) {
        if (this.mRenderView != null && this.mRenderView.getView() != null) {
            this.mRenderView.getView().setVisibility(n2);
        }
    }

    @Override
    public void useSystemPlayer(boolean bl) {
        this.mUseSystemPlayer = bl;
    }

    @Override
    public void reBindTexture() {
    }

    @Override
    public boolean isSupportedSnapshot() {
        boolean bl = false;
        if (this.mMediaPlayer != null) {
            bl = this.mMediaPlayer.isSupportedSnapshot();
        }
        return bl;
    }

    @Override
    public Bitmap getSnapshot(int n2, int n3) {
        Bitmap bitmap = null;
        if (this.mMediaPlayer != null) {
            bitmap = this.mMediaPlayer.getSnapshot(n2, n3);
        }
        return bitmap;
    }

    @Override
    @Deprecated
    public void setAccurateSeekEnable(boolean bl) {
        this.mAccurateSeekEnable = bl;
    }

    @Override
    public boolean isAccurateSeekEnable() {
        return this.mAccurateSeekEnable;
    }

    @Override
    public void setNetAddrinfo(int n2, int n3) {
        this.setNetAddrinfo(n2, n3, false);
    }

    @Override
    public void setNetAddrinfo(int n2, int n3, boolean bl) {
        bl = false;
        if (bl && n2 == 3) {
            n2 = 0;
        }
        this.mNativeDnsAsyncEnable = true;
        this.mBackJavaDns = false;
        if (this.mReportParams != null && (this.mReportParams.getVideoType() == ReportParams.VideoType.AD_PRE || this.mReportParams.getVideoType() == ReportParams.VideoType.AD_MID || this.mReportParams.getVideoType() == ReportParams.VideoType.AD_BOOT) && n2 > 3) {
            n2 = 3;
        }
        DebugLog.i(this.getLogTag(), "setNetAddrinfo " + n2 + ",timeout:" + n3 + ",enablePreDns:" + bl);
        this.mAddrInfoTypeInt = n2;
        this.mHlsMD5CheckValue = 0;
        this.mEnableMgtvMediaCodec = true;
        this.mEnableHttpDnsRetry = false;
        this.mEnableP2pHttpDns = false;
        this.mEnableDnsNoNetStrategy = false;
        this.mOpenAddrDefaultConfig = false;
        if (this.mDnsFamilyType == 1) {
            switch (n2) {
                case 1: {
                    this.mAddrInfoType = MgtvMediaPlayer.AddrinfoType.TYPE_ADDRINFO_THREAD;
                    break;
                }
                case 2: {
                    this.mAddrInfoType = MgtvMediaPlayer.AddrinfoType.TYPE_ADDRINFO_ONE_BY_ONE;
                    break;
                }
                case 3: 
                case 23: {
                    this.mEnableDnsNoNetStrategy = true;
                    this.defaultNetAddr();
                    break;
                }
                case 9: {
                    this.mNativeDnsAsyncEnable = false;
                    break;
                }
                case 11: {
                    this.mEnableJavaIPCache = true;
                    this.mHlsMD5CheckValue = 1;
                    break;
                }
                case 12: {
                    this.mEnableJavaIPCache = true;
                    this.mHlsMD5CheckValue = 2;
                    break;
                }
                case 29: {
                    this.mEnableMgtvMediaCodec = false;
                    this.defaultNetAddr();
                    break;
                }
                case 30: {
                    this.setMgtvFastMode(0);
                    this.mEnableDefaultFileStartTime = false;
                    break;
                }
                case 31: 
                case 32: 
                case 33: {
                    this.setMgtvFastMode(n2 % 30);
                    break;
                }
                case 39: {
                    this.mKeyInfoSetEnable = false;
                    break;
                }
                case 40: {
                    this.setMgtvFastMode(0);
                    this.mEnableDefaultFileStartTime = false;
                    this.mKeyInfoSetEnable = false;
                    break;
                }
                case 999: {
                    break;
                }
                case 4: {
                    this.mEnableP2pHttpDns = true;
                }
                case 5: {
                    this.mEnableHttpDnsRetry = true;
                }
                default: {
                    this.defaultNetAddr();
                    break;
                }
            }
        } else {
            this.defaultNetAddr();
        }
        if (n3 > 0) {
            this.mAddrInfoTimeoutMs = n3 * 1000;
        }
        this.mJavaDnsEnable = bl;
    }

    @Override
    public void setNetAddrinfo(String string, int n2, boolean bl) {
        super.setNetAddrinfo(string, n2, bl);
        if (NetPlayConfig.sConfigFastMode != 0) {
            int n3 = NetPlayConfig.sConfigFastMode == 9 ? 0 : NetPlayConfig.sConfigFastMode;
            this.setMgtvFastMode(n3);
        }
        if (NetPlayConfig.sConfigP2pHttpDns != 0) {
            boolean bl2 = this.mEnableP2pHttpDns = NetPlayConfig.sConfigP2pHttpDns != 9;
        }
        if (NetPlayConfig.sConfigMgtvMediaCodec != 0) {
            this.mEnableMgtvMediaCodec = NetPlayConfig.sConfigMgtvMediaCodec != 9;
        }
        DebugLog.i(this.getLogTag(), "setNetAddrinfo mMgtvFastMode:" + this.mMgtvFastMode + ",mEnableP2pHttpDns:" + this.mEnableP2pHttpDns + ",mEnableMgtvMediaCodec:" + this.mEnableMgtvMediaCodec);
    }

    @Override
    void defaultNetAddr() {
        super.defaultNetAddr();
        if (this.mDnsFamilyType == 1) {
            this.mAddrInfoType = MgtvMediaPlayer.AddrinfoType.TYPE_ADDRINFO_DEFAULT;
            this.mOpenAddrDefaultConfig = true;
            this.updateVodDefaultDnsType();
        } else {
            this.mAddrInfoType = MgtvMediaPlayer.AddrinfoType.TYPE_ADDRINFO_DEFAULT;
        }
    }

    private void updateVodDefaultDnsType() {
        if (this.mOpenAddrDefaultConfig && this.mReportParams != null && this.mReportParams.getVideoType() == ReportParams.VideoType.VOD) {
            this.mAddrInfoType = MgtvMediaPlayer.AddrinfoType.TYPE_DNS_CACHE;
            this.mBackJavaDns = true;
            this.mPrepared4StartMode = MgtvMediaPlayer.Prepared4StartMode.MODE_PREPARED4START_LOADDATA;
        }
    }

    @Override
    public int getAddrInfoTypeInt() {
        return this.mAddrInfoTypeInt;
    }

    @Override
    public void setStartPosMs(int n2) {
        this.mStartPosMs = n2;
    }

    @Override
    public String getLastErrorTypeCode() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getLastErrorTypeCode();
        }
        return null;
    }

    @Override
    public FlowDataStatistic getFlowDataStatistic() {
        return this.mFlowDataStatistic;
    }

    @Override
    public void setFlowDataStatistic(FlowDataStatistic flowDataStatistic) {
        this.mFlowDataStatistic = flowDataStatistic;
    }

    @Override
    public void configDataCacheSizeKB(int n2) {
        this.mDataCacheSizeKB = n2;
        this.updateDataCacheSizeKB();
    }

    private void updateDataCacheSizeKB() {
        if (this.mDataCacheSizeKB > 0 && this.mMediaPlayer != null) {
            this.mMediaPlayer.configDSMemoryKeepSize(this.mDataCacheSizeKB, this.mDataCacheSizeKB);
        }
    }

    @Override
    public void setSkipLoopFilter(MgtvMediaPlayer.SkipLoopFilterType skipLoopFilterType) {
        this.mSkipLoopFilterType = skipLoopFilterType;
        this.updateSkipLoopFilter();
    }

    @Override
    public void enableTsSkipError(boolean bl) {
        this.mEnableTsSkipError = bl;
    }

    @Override
    public boolean isTsSkipErrorEnable() {
        return this.mEnableTsSkipError;
    }

    private void updateSkipLoopFilter() {
        if (this.mMediaPlayer != null) {
            DebugLog.i(this.getLogTag(), "updateSkipLoopFilter:" + (Object)((Object)this.mSkipLoopFilterType));
            this.mMediaPlayer.setSkipLoopFilter(this.mSkipLoopFilterType);
        }
    }

    @Override
    public void setLastFrameRecovery(boolean bl) {
        this.mLastFrameRecovery = bl;
    }

    @Override
    public void setReportParams(ReportParams reportParams) {
        this.mReportParams = reportParams;
        if (this.mReportParams != null) {
            this.mReportParams.setRenderType(this.mRenderType);
            this.mReportParams.setEnhanceQualityType(this.mEnhanceQualityType);
            this.mReportParams.setSvds(this.mVideoIntroduction);
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setReportParams(this.mReportParams);
        }
    }

    @Override
    public void configTsNotSkip(boolean bl) {
        this.mTsNotSkip = bl;
    }

    @Override
    public void configLoadMaxRetryTime(int n2) {
        this.mLoadMaxRetryTime = n2;
    }

    @Override
    public void configWeakNetSpeed(int n2) {
        this.mWeakNetSpeed = n2;
    }

    @Override
    public void configWeakBufferTimeout(int n2) {
        this.mWeakBufferTimeoutMs = n2;
    }

    @Override
    public void setRenderFilter(IVideoView.RenderFilter renderFilter) {
        int n2 = 0;
        this.mRenderFilter = renderFilter;
        switch (renderFilter) {
            case UNSHARP_EDGE: {
                n2 = 1;
                break;
            }
            case UNSHARP_EDGE_COMPARE: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        if (this.mRenderView != null) {
            this.mRenderView.setRenderFilter(n2);
        }
    }

    @Override
    public IVideoView.RenderFilter getRenderFilter() {
        return this.mRenderFilter;
    }

    @Override
    public void setLiveMode(boolean bl) {
        this.mEnableLiveMode = this.mIsLiveConfig = bl;
    }

    @Override
    public void setLiveStartIndex(int n2) {
        this.mLiveStartIndex = n2;
    }

    @Override
    public void setLiveReopen() {
        if (this.mEnableLiveMode && this.mMediaPlayer != null) {
            this.mMediaPlayer.setLiveReopen();
        }
    }

    @Override
    public void nativeCrashTest(int n2) {
        MgtvMediaPlayer.NativeSoType nativeSoType;
        switch (n2) {
            default: {
                nativeSoType = MgtvMediaPlayer.NativeSoType.TYPE_NATIVESO_IMGOFFMPEG;
                break;
            }
            case 1: {
                nativeSoType = MgtvMediaPlayer.NativeSoType.TYPE_NATIVESO_IMGOHELP;
                break;
            }
            case 2: {
                nativeSoType = MgtvMediaPlayer.NativeSoType.TYPE_NATIVESO_IMGOMEDIAPLAYER;
                break;
            }
            case 3: {
                nativeSoType = MgtvMediaPlayer.NativeSoType.TYPE_NATIVESO_IMGODS;
            }
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.nativeCrashTest(nativeSoType);
        }
    }

    @Override
    public void setSurfaceHolderListener(IVideoView.SurfaceHolderListener surfaceHolderListener) {
        this.mSurfaceHolderListener = surfaceHolderListener;
    }

    @Override
    public void setM3u8Caches(String string, String[] stringArray) {
        this.mCacheM3u8Path = string;
        this.mCacheTsPaths = stringArray;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setM3u8Caches(this.mCacheM3u8Path, this.mCacheTsPaths);
        }
    }

    @Override
    public void enableM3u8Cache(boolean bl) {
        this.mCacheEnable = bl;
    }

    @Override
    public boolean isDataLoadPaused() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.isLoadDataPaused();
        }
        return false;
    }

    @Override
    public int getCurrentStatus() {
        return this.mCurrentState;
    }

    @Override
    public String getLogTagKey() {
        String string = ReportParams.getVideoTypeName(ReportParams.VideoType.NONE);
        if (this.mReportParams != null) {
            string = ReportParams.getVideoTypeName(this.mReportParams.getVideoType());
        }
        String string2 = "";
        if (sAutoNativeStack) {
            string2 = "STACK-";
        }
        return string2 + string + "-" + this.hashCode() + "-" + this.getRenderViewName();
    }

    public String getRenderViewName() {
        return this.mRenderViewType == 0 ? "surface" : "texture";
    }

    @Override
    public void startRecord(String string) {
        this.mRecordFilePath = string;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.startRecVideo(string);
        }
    }

    @Override
    public void stopRecord() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stopRecVideo();
        }
    }

    @Override
    public boolean isRecording() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.isRecording();
        }
        return false;
    }

    @Override
    public GifRecorder getGifRecorder() {
        return this.mGifRecorder;
    }

    @Override
    public String getLogTag() {
        return "[" + this.getLogTagKey() + "][" + this.getClass().getSimpleName() + "]";
    }

    @Override
    public void enableCoreStartPauseListen(boolean bl) {
        this.mUserEnableCoreStartPauseListen = bl;
    }

    @Override
    public void setScreenOnWhilePlaying(boolean bl) {
        this.mIsScreenOnWhilePlaying = bl;
    }

    @Override
    public void setSecure(boolean bl) {
        this.mIsSecure = bl;
        this.setSecureImpl(this.mIsSecure);
    }

    private void setSecureImpl(boolean bl) {
        if (this.mRenderView != null && this.mRenderView.getView() instanceof SurfaceView && Build.VERSION.SDK_INT >= 17) {
            DebugLog.i(this.getLogTag(), "setSecure " + bl);
            ((SurfaceView)this.mRenderView.getView()).setSecure(bl);
        }
    }

    @Override
    public View getRenderView() {
        if (this.mRenderView != null) {
            return this.mRenderView.getView();
        }
        return null;
    }

    @Override
    public MgtvMediaPlayer.PlayerExtraInfo getPlayerExtraInfo() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getPlayerExtraInfo();
        }
        return null;
    }

    @Override
    public void setAspectRatio(int n2) {
        this.mAspectRatio = n2;
        if (this.mRenderView != null) {
            DebugLog.i(this.getLogTag(), "setAspectRatio:" + n2);
            this.mRenderView.setAspectRatio(n2);
        }
    }

    private void changeCurrentState(int n2) {
        this.mCurrentState = n2;
        DebugLog.i(this.getLogTag(), "changeCurrentState:" + n2);
        if (this.mOnUpdateStatusListener != null) {
            this.mOnUpdateStatusListener.onUpdateStatus();
        }
    }

    @Override
    public void setDisplayFloatRect(IMgtvRenderView.FloatRect floatRect) {
    }

    @Override
    public void setSmoothSwitchMode(int n2) {
        super.setSmoothSwitchMode(n2);
        this.mSmoothModeSwitch = n2 != 0;
    }

    private static enum ResetResult {
        NONE,
        RESET_OK,
        RESET_ERR;

    }
}

