/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.widget.debug;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.hunantv.media.config.NetPlayConfig;
import com.hunantv.media.player.IMgtvRenderView;
import com.hunantv.media.player.MgtvMediaPlayer;
import com.hunantv.media.player.MgtvPlayerListener;
import com.hunantv.media.player.d.a.a.a;
import com.hunantv.media.player.d.d;
import com.hunantv.media.player.helper.MediaCodecHelp;
import com.hunantv.media.player.utils.ThreadUtil;
import com.hunantv.media.utils.NumericUtil;
import com.hunantv.media.widget.IVideoView;
import com.hunantv.media.widget.debug.TestBroadCastReceiver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DebugPanel
extends RelativeLayout {
    private IVideoView mMgtvVideoView;
    private ScrollView mScrollLayout;
    private LinearLayout mRootLayout;
    private Context mContext;
    private String mUrl = null;
    private static Setting sSetting = new Setting();
    private TestBroadCastReceiver mBroadCastReceiver = new TestBroadCastReceiver();
    private static boolean sReportLogOpen;
    private TextView mPtsTextView;
    private MgtvPlayerListener.OnVideoPTSListener mPtsListener = new MgtvPlayerListener.OnVideoPTSListener(){

        @Override
        public void onVideoPTS(final MgtvPlayerListener.FrameClock frameClock) {
            ThreadUtil.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    DebugPanel.this.updatePts(frameClock.clock_type + "-" + frameClock.vframe_time);
                }
            });
        }
    };
    ScrollView baseInfoScrollLayout;
    TextView baseInfoTextView;
    String baseInfoText = "";
    byte[] keyInfoData;

    public DebugPanel(Context context, IVideoView iVideoView) {
        super(context);
        this.mContext = context;
        this.mMgtvVideoView = iVideoView;
        this.init();
    }

    private void reset() {
        sSetting = new Setting();
        this.setSetting();
        if (this.mRootLayout != null) {
            this.mRootLayout.removeAllViews();
            this.initContent(this.mRootLayout);
        }
    }

    private void setSetting() {
        if (this.mMgtvVideoView != null) {
            DebugPanel.sSetting.addrInfoTypeInt = this.mMgtvVideoView.getAddrInfoTypeInt();
            this.mMgtvVideoView.setRenderFilter(DebugPanel.sSetting.renderFilter);
            this.mMgtvVideoView.setNetAddrinfo(DebugPanel.sSetting.addrInfoTypeInt, -1);
            this.mMgtvVideoView.openImgoDSModule(DebugPanel.sSetting.openImgods);
            this.mMgtvVideoView.setAspectRatio(DebugPanel.sSetting.aspectRatios);
            this.mMgtvVideoView.setPlaybackSpeed(DebugPanel.sSetting.playSpeed);
            this.mMgtvVideoView.setAccurateSeekEnable(DebugPanel.sSetting.enableAccSeek);
            this.mMgtvVideoView.enableTsSkipError(DebugPanel.sSetting.enableTsSkipError);
            this.mMgtvVideoView.setPrepared4StartMode(DebugPanel.sSetting.prepared4StartMode);
            this.mMgtvVideoView.setForceHttpDns(DebugPanel.sSetting.isForceHttpDns);
            this.mMgtvVideoView.setAntiViewShake(DebugPanel.sSetting.isAntiViewShake);
        }
    }

    private void registerLocalBroadCast() {
        LocalBroadcastManager.getInstance((Context)this.mContext).registerReceiver((BroadcastReceiver)this.mBroadCastReceiver, new IntentFilter("mgtv.player.action.PLAYER_REPORT_EVENT"));
    }

    private void unregisterLocalBroadCast() {
        LocalBroadcastManager.getInstance((Context)this.mContext).unregisterReceiver((BroadcastReceiver)this.mBroadCastReceiver);
    }

    public void updatePts(String string) {
        if (this.mPtsTextView != null) {
            this.mPtsTextView.setText((CharSequence)string);
        }
        this.mPtsTextView.invalidate();
    }

    private void init() {
        Button button = new Button(this.mContext);
        button.setText((CharSequence)"\u8bbe\u7f6e");
        if (Build.VERSION.SDK_INT >= 17) {
            button.setId(View.generateViewId());
        }
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (DebugPanel.this.mScrollLayout.getVisibility() == 8 || DebugPanel.this.mScrollLayout.getVisibility() == 4) {
                    DebugPanel.this.mScrollLayout.setVisibility(0);
                } else {
                    DebugPanel.this.mScrollLayout.setVisibility(8);
                }
            }
        });
        this.addView((View)button, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        Button button2 = new Button(this.mContext);
        button2.setText((CharSequence)"\u5237\u5e27");
        button2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DebugPanel.this.mPtsTextView.setVisibility(0);
                DebugPanel.this.mMgtvVideoView.enableFramePTSNotify(true);
                DebugPanel.this.mMgtvVideoView.stepPlaybackNextFrame();
                DebugPanel.this.mMgtvVideoView.addVideoPTSListener(DebugPanel.this.mPtsListener);
            }
        });
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(3, button.getId());
        this.addView((View)button2, (ViewGroup.LayoutParams)layoutParams);
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setOrientation(0);
        this.initBaseInfoLayout(linearLayout);
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams2);
        this.mPtsTextView = new TextView(this.mContext);
        this.mPtsTextView.setBackgroundColor(-16777216);
        this.mPtsTextView.setTextColor(-65536);
        this.mPtsTextView.setVisibility(8);
        this.mPtsTextView.setTextSize(1, 25.0f);
        RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams3.addRule(13);
        this.addView((View)this.mPtsTextView, (ViewGroup.LayoutParams)layoutParams3);
        this.mScrollLayout = new ScrollView(this.mContext);
        this.mScrollLayout.setVisibility(8);
        HorizontalScrollView horizontalScrollView = new HorizontalScrollView(this.mContext);
        this.mRootLayout = new LinearLayout(this.mContext);
        this.initContent(this.mRootLayout);
        FrameLayout.LayoutParams layoutParams4 = new FrameLayout.LayoutParams(-1, -1);
        horizontalScrollView.addView((View)this.mRootLayout, (ViewGroup.LayoutParams)layoutParams4);
        this.mScrollLayout.addView((View)horizontalScrollView, (ViewGroup.LayoutParams)layoutParams4);
        RelativeLayout.LayoutParams layoutParams5 = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams5.addRule(1, button.getId());
        this.addView((View)this.mScrollLayout, (ViewGroup.LayoutParams)layoutParams5);
    }

    private void initContent(LinearLayout linearLayout) {
        linearLayout.setBackgroundColor(-1);
        linearLayout.setOrientation(1);
        this.initKeyInfoView();
        this.initABTestView();
        if (sReportLogOpen) {
            this.registerLocalBroadCast();
        }
        Button button = this.createBtn(this.mContext, "\u91cd\u7f6e");
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DebugPanel.this.reset();
            }
        });
        this.createNewLinear("\u6062\u590d\u9ed8\u8ba4:", Arrays.asList(button));
        Button button2 = this.createBtn(this.mContext, "\u6253\u5f00");
        button2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!sReportLogOpen) {
                    DebugPanel.this.registerLocalBroadCast();
                    sReportLogOpen = true;
                } else {
                    DebugPanel.this.unregisterLocalBroadCast();
                    sReportLogOpen = false;
                }
            }
        });
        this.createNewLinear("\u4e0a\u62a5\u65e5\u5fd7:", Arrays.asList(button2));
        this.initBackPlayView();
        this.initMediaCodecSwView();
        this.initOppoSRView();
        this.initOppoOSIEView();
        this.initEnhanceView();
        this.initEnhanceFilterView();
        this.initDisplayFloatRect();
        this.initDnsView();
        this.initFileStartTimeView();
        this.initSourceSelectView();
        this.initAspectRatioView();
        this.initPlaySpeedView();
        this.initAccSeekView();
        this.initTsSkipErrView();
        this.initPreparedStartModeView();
        this.initForceHttpDnsView();
        this.initAntiShakeView();
        this.initDnsFamilyTypeView();
        this.setSetting();
    }

    private void initBaseInfoLayout(LinearLayout linearLayout) {
        Button button = new Button(this.mContext);
        button.setText((CharSequence)"\u57fa\u672c\u4fe1\u606f");
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (DebugPanel.this.baseInfoScrollLayout.getVisibility() == 8 || DebugPanel.this.baseInfoScrollLayout.getVisibility() == 4) {
                    DebugPanel.this.updateBaseInfoText();
                    DebugPanel.this.baseInfoScrollLayout.setVisibility(0);
                } else {
                    DebugPanel.this.baseInfoScrollLayout.setVisibility(8);
                }
            }
        });
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 80;
        linearLayout.addView((View)button, (ViewGroup.LayoutParams)layoutParams);
        this.baseInfoScrollLayout = new ScrollView(this.mContext);
        this.baseInfoScrollLayout.setVisibility(8);
        this.baseInfoScrollLayout.setBackgroundColor(-1);
        HorizontalScrollView horizontalScrollView = new HorizontalScrollView(this.mContext);
        this.baseInfoTextView = new TextView(this.mContext);
        this.baseInfoTextView.setTextColor(-16777216);
        horizontalScrollView.addView((View)this.baseInfoTextView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.baseInfoScrollLayout.addView((View)horizontalScrollView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        linearLayout.addView((View)this.baseInfoScrollLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
    }

    public void updateBaseInfoText() {
        ThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Object object;
                Object object2;
                String string = "***********************\u89e3\u7801\u5668\u6027\u80fd\u5217\u8868******************\n";
                MediaCodecHelp.getHardWareperformance(true);
                ArrayList<MediaCodecHelp.CodecPerformance> arrayList = MediaCodecHelp.sCodecPerformanceList.isEmpty() ? MediaCodecHelp.getCodecPerformanceList(false) : MediaCodecHelp.sCodecPerformanceList;
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    object2 = arrayList.get((int)i2).mimeType;
                    object = arrayList.get((int)i2).codecName;
                    String string2 = arrayList.get((int)i2).performance;
                    String string3 = arrayList.get((int)i2).hdr;
                    string = string + "MimeType:" + (String)object2 + " CodecName:" + (String)object + " Performance:" + string2 + " hdr:" + string3 + "\n";
                }
                String string4 = MediaCodecHelp.getScreenPerformance(DebugPanel.this.getContext());
                string = string + "\u5c4f\u5e55\u6027\u80fd:" + string4 + "\n";
                DebugPanel.this.baseInfoText = string = string + "*******************************************************\n";
                if (DebugPanel.this.mMgtvVideoView != null && DebugPanel.this.mMgtvVideoView.getMediaPlayer() != null) {
                    object2 = DebugPanel.this.mMgtvVideoView.getMediaPlayer();
                    DebugPanel.this.baseInfoText = DebugPanel.this.baseInfoText + "TAG:" + DebugPanel.this.mMgtvVideoView.getLogTag() + "\nURL:" + (DebugPanel.this.mMgtvVideoView.getCurrentUri() != null ? DebugPanel.this.mMgtvVideoView.getCurrentUri().toString() : "") + "\n\n\u89e3\u7801\u5668(OMX\u5f00\u5934\u4e3a\u786c\u89e3):" + ((MgtvMediaPlayer)object2).getCurrentVideoDecoderName() + "\n\u5206\u8fa8\u7387:" + ((MgtvMediaPlayer)object2).getVideoWidth() + "x" + ((MgtvMediaPlayer)object2).getVideoHeight() + "\nFPS:" + ((MgtvMediaPlayer)object2).getVideoFPS() + "\n\n\u8d77\u64ad\u603b\u8017\u65f6:" + ((MgtvMediaPlayer)object2).getPropertyLong(20407, 0L) + " ms\n\u8d77\u64adt1:" + ((MgtvMediaPlayer)object2).getPropertyLong(20401, 0L) + " ms\n\u8d77\u64adt2:" + ((MgtvMediaPlayer)object2).getPropertyLong(20402, 0L) + " ms\n\u8d77\u64adt3:" + ((MgtvMediaPlayer)object2).getPropertyLong(20403, 0L) + " ms\n\u8d77\u64adt4:" + ((MgtvMediaPlayer)object2).getPropertyLong(20404, 0L) + " ms\n\u8d77\u64adt5:" + ((MgtvMediaPlayer)object2).getPropertyLong(20405, 0L) + " ms\n\u8d77\u64adt6:" + ((MgtvMediaPlayer)object2).getPropertyLong(20406, 0L) + " ms\n\n";
                    object = ((MgtvMediaPlayer)object2).getMediaInfo();
                    if (object != null) {
                        DebugPanel.this.baseInfoText = DebugPanel.this.baseInfoText + "mediaInfo: " + object + "\n";
                    }
                } else {
                    DebugPanel.this.baseInfoText = "\u64ad\u653e\u5668\u5c1a\u672a\u51c6\u5907\u597d";
                }
                DebugPanel.this.baseInfoTextView.setText((CharSequence)DebugPanel.this.baseInfoText);
            }
        });
    }

    private void initBackPlayView() {
        if (this.mMgtvVideoView != null) {
            this.createRadioLayout("\u80cc\u666f\u64ad\u653e:", this.mMgtvVideoView.isBackPlayEnable() ? 0 : 1, Arrays.asList("\u6253\u5f00", "\u5173\u95ed"), new OnRadioCheckListener(){

                @Override
                public void onRadioCheckChanged(int n2) {
                    if (DebugPanel.this.mMgtvVideoView != null) {
                        boolean bl = n2 == 0;
                        DebugPanel.this.mMgtvVideoView.setBackPlayEnable(bl);
                    }
                }
            });
        }
    }

    private void initMediaCodecSwView() {
        if (this.mMgtvVideoView != null) {
            this.createRadioLayout("\u8f6f\u6e32\u67d3:", this.mMgtvVideoView.isMediaCodecSWEnable() ? 0 : 1, Arrays.asList("\u6253\u5f00", "\u5173\u95ed"), new OnRadioCheckListener(){

                @Override
                public void onRadioCheckChanged(int n2) {
                    if (DebugPanel.this.mMgtvVideoView != null) {
                        boolean bl = n2 == 0;
                        DebugPanel.this.mMgtvVideoView.enableMediaCodecSW(bl);
                        DebugPanel.this.mMgtvVideoView.resume();
                    }
                }
            });
        }
    }

    private void initOppoSRView() {
        if (this.mMgtvVideoView != null) {
            this.createRadioLayout("oppo_sr:", 1, Arrays.asList("\u6253\u5f00", "\u5173\u95ed"), new OnRadioCheckListener(){

                @Override
                public void onRadioCheckChanged(int n2) {
                    if (DebugPanel.this.mMgtvVideoView != null) {
                        boolean bl = n2 == 0;
                        DebugPanel.this.mMgtvVideoView.enableOppoFunc(1, bl);
                    }
                }
            });
        }
    }

    private void initOppoOSIEView() {
        if (this.mMgtvVideoView != null) {
            this.createRadioLayout("oppo_osie:", 1, Arrays.asList("\u6253\u5f00", "\u5173\u95ed"), new OnRadioCheckListener(){

                @Override
                public void onRadioCheckChanged(int n2) {
                    if (DebugPanel.this.mMgtvVideoView != null) {
                        boolean bl = n2 == 0;
                        DebugPanel.this.mMgtvVideoView.enableOppoFunc(2, bl);
                    }
                }
            });
        }
    }

    private void initFileStartTimeView() {
        final EditText editText = new EditText(this.mContext);
        editText.setText((CharSequence)(DebugPanel.sSetting.fileStartTimeFloatS + ""));
        Button button = this.createBtn(this.mContext, "\u8bbe\u7f6e");
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (DebugPanel.this.mMgtvVideoView != null) {
                    sSetting.fileStartTimeFloatS = NumericUtil.parseFloat(editText.getText().toString(), -1.0f);
                }
            }
        });
        this.createNewLinear("FileStartTime:", Arrays.asList(editText, button));
    }

    private void initABTestView() {
        final EditText editText = new EditText(this.mContext);
        NetPlayConfig netPlayConfig = NetPlayConfig.getsGlobalNetPlayConfig();
        if (netPlayConfig != null) {
            editText.setText((CharSequence)netPlayConfig.player_support);
        }
        Button button = this.createBtn(this.mContext, "\u8bbe\u7f6e");
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                NetPlayConfig netPlayConfig;
                if (DebugPanel.this.mMgtvVideoView != null && (netPlayConfig = NetPlayConfig.getsGlobalNetPlayConfig()) != null) {
                    netPlayConfig.player_support = editText.getText().toString();
                    NetPlayConfig.setGlobalNetPlayConfig(netPlayConfig);
                }
            }
        });
        this.createNewLinear("AB\u6d4b\u503c(play_support):", Arrays.asList(editText, button));
    }

    private void initDnsView() {
        final EditText editText = new EditText(this.mContext);
        editText.setText((CharSequence)(DebugPanel.sSetting.addrInfoTypeInt + ""));
        Button button = this.createBtn(this.mContext, "\u8bbe\u7f6e");
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (DebugPanel.this.mMgtvVideoView != null) {
                    sSetting.addrInfoTypeInt = NumericUtil.parseInt(editText.getText().toString());
                    DebugPanel.this.mMgtvVideoView.setNetAddrinfo(sSetting.addrInfoTypeInt, -1);
                }
            }
        });
        this.createNewLinear("DNS\u503c:", Arrays.asList(editText, button));
    }

    private void initDisplayFloatRect() {
        final EditText editText = new EditText(this.mContext);
        editText.setText((CharSequence)"0.0f");
        final EditText editText2 = new EditText(this.mContext);
        editText2.setText((CharSequence)"0.0f");
        final EditText editText3 = new EditText(this.mContext);
        editText3.setText((CharSequence)"0.5f");
        final EditText editText4 = new EditText(this.mContext);
        editText4.setText((CharSequence)"1.0f");
        Button button = this.createBtn(this.mContext, "\u8bbe\u7f6e");
        button.setOnClickListener(new View.OnClickListener((View)button){
            final /* synthetic */ View val$setBtn;
            {
                this.val$setBtn = view;
            }

            public void onClick(View view) {
                if (DebugPanel.this.mMgtvVideoView != null) {
                    try {
                        IMgtvRenderView.FloatRect floatRect = new IMgtvRenderView.FloatRect();
                        floatRect.lt = new IMgtvRenderView.Coordinate(Float.parseFloat(editText.getText().toString()), Float.parseFloat(editText2.getText().toString()));
                        floatRect.rb = new IMgtvRenderView.Coordinate(Float.parseFloat(editText3.getText().toString()), Float.parseFloat(editText4.getText().toString()));
                        DebugPanel.this.mMgtvVideoView.setDisplayFloatRect(floatRect);
                        ((Button)this.val$setBtn).setText((CharSequence)"\u8bbe\u7f6e\u6210\u529f");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        ((Button)this.val$setBtn).setText((CharSequence)"\u8bbe\u7f6e\u5f02\u5e38");
                    }
                }
            }
        });
        this.createNewLinear("DNS\u503c(ltx-lty-rbx-rby):", Arrays.asList(editText, editText2, editText3, editText4, button));
    }

    private void initKeyInfoView() {
        if (this.mMgtvVideoView != null) {
            this.createRadioLayout("KeyInfo:", this.mMgtvVideoView.isKeyInfoDataSet() ? 1 : 0, Arrays.asList("enable", "disable"), new OnRadioCheckListener(){

                @Override
                public void onRadioCheckChanged(int n2) {
                    if (DebugPanel.this.mMgtvVideoView != null) {
                        if (n2 == 0) {
                            if (DebugPanel.this.keyInfoData != null) {
                                DebugPanel.this.mMgtvVideoView.reset();
                                DebugPanel.this.mMgtvVideoView.setKeyInfoData(DebugPanel.this.keyInfoData, 0, 0);
                                DebugPanel.this.mMgtvVideoView.resume();
                            }
                        } else if (n2 == 1) {
                            DebugPanel.this.keyInfoData = DebugPanel.this.mMgtvVideoView.getKeyInfoData();
                            DebugPanel.this.mMgtvVideoView.reset();
                            DebugPanel.this.mMgtvVideoView.resume();
                        }
                    }
                }
            });
        }
    }

    private void initSourceSelectView() {
        if (this.mMgtvVideoView != null) {
            this.createRadioLayout("\u6570\u636e\u6a21\u5757:", DebugPanel.sSetting.openImgods ? 1 : 0, Arrays.asList("ffmpegDS", "curlDS"), new OnRadioCheckListener(){

                @Override
                public void onRadioCheckChanged(int n2) {
                    if (DebugPanel.this.mMgtvVideoView != null) {
                        sSetting.openImgods = n2 != 0;
                        DebugPanel.this.mMgtvVideoView.openImgoDSModule(sSetting.openImgods);
                        DebugPanel.this.mMgtvVideoView.resume();
                    }
                }
            });
        }
    }

    private void setButtonSelect(Button button, boolean bl) {
        button.setSelected(bl);
        button.setTextColor(button.isSelected() ? Color.parseColor((String)"#FF8B18") : Color.parseColor((String)"#000000"));
    }

    private void initEnhanceView() {
        Button button = this.createBtn(this.mContext, "Debug");
        this.setButtonSelect(button, a.h);
        button.setOnClickListener(new View.OnClickListener((View)button){
            final /* synthetic */ View val$debug;
            {
                this.val$debug = view;
            }

            public void onClick(View view) {
                a.h = !this.val$debug.isSelected();
                DebugPanel.this.setButtonSelect((Button)this.val$debug, a.h);
            }
        });
        this.createNewLinear("\u56fe\u50cf\u589e\u5f3aShader\u66ff\u6362:", Arrays.asList(button));
    }

    private void initEnhanceFilterView() {
        int n2 = 0;
        switch (DebugPanel.sSetting.renderFilter) {
            case UNSHARP_EDGE: {
                n2 = 1;
                break;
            }
            case UNSHARP_EDGE_COMPARE: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        this.createRadioLayout("\u56fe\u50cf\u589e\u5f3a:", n2, Arrays.asList("\u6b63\u5e38", "\u5168\u5c4f", "\u534a\u5c4f"), new OnRadioCheckListener(){

            @Override
            public void onRadioCheckChanged(int n2) {
                switch (n2) {
                    case 1: {
                        d.a = true;
                        sSetting.renderFilter = IVideoView.RenderFilter.UNSHARP_EDGE;
                        break;
                    }
                    case 2: {
                        d.a = true;
                        sSetting.renderFilter = IVideoView.RenderFilter.UNSHARP_EDGE_COMPARE;
                        break;
                    }
                    default: {
                        sSetting.renderFilter = IVideoView.RenderFilter.NORMAL;
                    }
                }
                if (DebugPanel.this.mMgtvVideoView != null) {
                    DebugPanel.this.mMgtvVideoView.setRenderFilter(sSetting.renderFilter);
                }
            }
        });
    }

    private void initPreparedStartModeView() {
        int n2 = 0;
        switch (DebugPanel.sSetting.prepared4StartMode) {
            case MODE_PREPARED4START_AUTOPLAY: {
                n2 = 1;
                break;
            }
            case MODE_PREPARED4START_LOADDATA: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        this.createRadioLayout("Prepared\u6a21\u5f0f:", n2, Arrays.asList("DEFAULT", "AUTOPLAY", "LOADDATA", "LOAD_DISAV"), new OnRadioCheckListener(){

            @Override
            public void onRadioCheckChanged(int n2) {
                switch (n2) {
                    case 1: {
                        sSetting.prepared4StartMode = MgtvMediaPlayer.Prepared4StartMode.MODE_PREPARED4START_AUTOPLAY;
                        break;
                    }
                    case 2: {
                        sSetting.prepared4StartMode = MgtvMediaPlayer.Prepared4StartMode.MODE_PREPARED4START_LOADDATA;
                        break;
                    }
                    case 3: {
                        sSetting.prepared4StartMode = MgtvMediaPlayer.Prepared4StartMode.MODE_PREPARED4START_LOADDATA_DISAV;
                        break;
                    }
                    default: {
                        sSetting.prepared4StartMode = MgtvMediaPlayer.Prepared4StartMode.MODE_PREPARED4START_DEFAULT;
                    }
                }
                if (DebugPanel.this.mMgtvVideoView != null) {
                    DebugPanel.this.mMgtvVideoView.setPrepared4StartMode(sSetting.prepared4StartMode);
                }
            }
        });
    }

    private void initForceHttpDnsView() {
        if (this.mMgtvVideoView != null) {
            this.createRadioLayout("httpdns:", DebugPanel.sSetting.isForceHttpDns ? 1 : 0, Arrays.asList("close", "open"), new OnRadioCheckListener(){

                @Override
                public void onRadioCheckChanged(int n2) {
                    boolean bl = sSetting.isForceHttpDns = n2 != 0;
                    if (DebugPanel.this.mMgtvVideoView != null) {
                        DebugPanel.this.mMgtvVideoView.setForceHttpDns(sSetting.isForceHttpDns);
                        DebugPanel.this.mMgtvVideoView.resume();
                    }
                }
            });
        }
    }

    private void initAntiShakeView() {
        if (this.mMgtvVideoView != null) {
            this.createRadioLayout("\u6297\u6296:", DebugPanel.sSetting.isAntiViewShake ? 1 : 0, Arrays.asList("close", "open"), new OnRadioCheckListener(){

                @Override
                public void onRadioCheckChanged(int n2) {
                    boolean bl = sSetting.isAntiViewShake = n2 != 0;
                    if (DebugPanel.this.mMgtvVideoView != null) {
                        DebugPanel.this.mMgtvVideoView.setAntiViewShake(sSetting.isAntiViewShake);
                    }
                }
            });
        }
    }

    private void initAspectRatioView() {
        this.createRadioLayout("\u64ad\u653e\u6bd4\u4f8b:", DebugPanel.sSetting.aspectRatios, Arrays.asList("FIT_PARENT", "FILL_PARENT"), new OnRadioCheckListener(){

            @Override
            public void onRadioCheckChanged(int n2) {
                if (DebugPanel.this.mMgtvVideoView != null) {
                    sSetting.aspectRatios = n2;
                    DebugPanel.this.mMgtvVideoView.setAspectRatio(sSetting.aspectRatios);
                }
            }
        });
    }

    private void initRenderTypeView() {
        this.createRadioLayout("\u6e32\u67d3\u7c7b\u578b:", DebugPanel.sSetting.renderType == 0 ? 0 : 1, Arrays.asList("SurfaceView", "TextureView"), new OnRadioCheckListener(){

            @Override
            public void onRadioCheckChanged(int n2) {
                sSetting.renderType = n2 == 0 ? 0 : 1;
                if (DebugPanel.this.mMgtvVideoView != null) {
                    DebugPanel.this.mMgtvVideoView.convertRender(sSetting.renderType);
                }
            }
        });
    }

    private void initPlaySpeedView() {
        final EditText editText = new EditText(this.mContext);
        editText.setText((CharSequence)(DebugPanel.sSetting.playSpeed + ""));
        Button button = this.createBtn(this.mContext, "\u8bbe\u7f6e");
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                sSetting.playSpeed = NumericUtil.parseFloat(editText.getText().toString());
                if (DebugPanel.this.mMgtvVideoView != null) {
                    DebugPanel.this.mMgtvVideoView.setPlaybackSpeed(sSetting.playSpeed);
                }
            }
        });
        this.createNewLinear("\u500d\u901f\u64ad\u653e:", Arrays.asList(editText, button));
    }

    private void initAccSeekView() {
        this.createEnableLayout("\u7cbe\u51c6seek:", DebugPanel.sSetting.enableAccSeek, new OnEnableListener(){

            @Override
            public void onEnableChanged(boolean bl) {
                sSetting.enableAccSeek = bl;
                if (DebugPanel.this.mMgtvVideoView != null) {
                    DebugPanel.this.mMgtvVideoView.setAccurateSeekEnable(sSetting.enableAccSeek);
                }
            }
        });
    }

    private void initTsSkipErrView() {
        this.createEnableLayout("ts\u8df3\u8fc7\u5f02\u5e38:", DebugPanel.sSetting.enableTsSkipError, new OnEnableListener(){

            @Override
            public void onEnableChanged(boolean bl) {
                sSetting.enableTsSkipError = bl;
                if (DebugPanel.this.mMgtvVideoView != null) {
                    DebugPanel.this.mMgtvVideoView.enableTsSkipError(sSetting.enableTsSkipError);
                }
            }
        });
    }

    private void initDnsFamilyTypeView() {
        this.createRadioLayout("DnsFamily:", this.mMgtvVideoView.getDnsFamilyType(), Arrays.asList("DEFAULT", "ONLY_IPV4", "ONLY_IPV6"), new OnRadioCheckListener(){

            @Override
            public void onRadioCheckChanged(int n2) {
                if (DebugPanel.this.mMgtvVideoView != null) {
                    DebugPanel.this.mMgtvVideoView.setDnsFamilyType(n2);
                }
            }
        });
    }

    private void createEnableLayout(String string, boolean bl, final OnEnableListener onEnableListener) {
        this.createRadioLayout(string, bl ? 1 : 0, Arrays.asList("\u5173\u95ed", "\u6253\u5f00"), new OnRadioCheckListener(){

            @Override
            public void onRadioCheckChanged(int n2) {
                if (onEnableListener != null) {
                    onEnableListener.onEnableChanged(n2 == 1);
                }
            }
        });
    }

    private void createRadioLayout(String string, int n2, List<String> list, final OnRadioCheckListener onRadioCheckListener) {
        if (list == null || list.size() <= 0) {
            return;
        }
        RadioGroup radioGroup = new RadioGroup(this.mContext);
        radioGroup.setOrientation(0);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        final ArrayList<RadioButton> arrayList = new ArrayList<RadioButton>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            RadioButton radioButton = new RadioButton(this.mContext);
            radioButton.setText((CharSequence)list.get(i2));
            radioGroup.addView((View)radioButton, i2, (ViewGroup.LayoutParams)layoutParams);
            arrayList.add(radioButton);
        }
        if (this.mMgtvVideoView != null && n2 < arrayList.size()) {
            radioGroup.check(((RadioButton)arrayList.get(n2)).getId());
        }
        radioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup radioGroup, int n2) {
                if (onRadioCheckListener != null) {
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        if (n2 != ((RadioButton)arrayList.get(i2)).getId()) continue;
                        onRadioCheckListener.onRadioCheckChanged(i2);
                        return;
                    }
                }
            }
        });
        this.createNewLinear(string, Arrays.asList(radioGroup));
    }

    private LinearLayout createNewLinear(String string, List<View> list) {
        if (list == null) {
            return null;
        }
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setOrientation(0);
        TextView textView = new TextView(this.mContext);
        textView.setText((CharSequence)string);
        linearLayout.addView((View)textView);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        for (View view : list) {
            linearLayout.addView(view, (ViewGroup.LayoutParams)layoutParams);
        }
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-1, -2);
        this.mRootLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams2);
        return linearLayout;
    }

    private Button createBtn(Context context, String string) {
        Button button = new Button(context);
        button.setText((CharSequence)string);
        return button;
    }

    public void release() {
        this.unregisterLocalBroadCast();
    }

    private static interface OnRadioCheckListener {
        public void onRadioCheckChanged(int var1);
    }

    private static interface OnEnableListener {
        public void onEnableChanged(boolean var1);
    }

    public static class Setting {
        IVideoView.RenderFilter renderFilter = IVideoView.RenderFilter.NORMAL;
        int addrInfoTypeInt = 0;
        float fileStartTimeFloatS = -1.0f;
        boolean openImgods;
        int aspectRatios;
        int renderType;
        float playSpeed = 1.0f;
        boolean enableAccSeek = false;
        boolean enableTsSkipError = false;
        MgtvMediaPlayer.Prepared4StartMode prepared4StartMode = MgtvMediaPlayer.Prepared4StartMode.MODE_PREPARED4START_DEFAULT;
        boolean isForceHttpDns;
        boolean isAntiViewShake;
    }
}

