/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.widget.extra;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.util.DisplayMetrics;
import android.util.Log;
import com.hunantv.media.a.a;
import com.hunantv.media.a.b;
import com.hunantv.media.utils.Util;

final class SubtitlePainter {
    private static final String TAG = "SubtitlePainter";
    private static final float INNER_PADDING_RATIO = 0.125f;
    private final float outlineWidth;
    private final float shadowRadius;
    private final float shadowOffset;
    private final float spacingMult;
    private final float spacingAdd;
    private final TextPaint textPaint;
    private final Paint paint;
    private CharSequence cueText;
    private Layout.Alignment cueTextAlignment;
    private Bitmap cueBitmap;
    private float cueLine;
    private int cueLineType;
    private int cueLineAnchor;
    private float cuePosition;
    private int cuePositionAnchor;
    private float cueSize;
    private float cueBitmapHeight;
    private boolean applyEmbeddedStyles;
    private boolean applyEmbeddedFontSizes;
    private int foregroundColor;
    private int backgroundColor;
    private int windowColor;
    private int edgeColor;
    private int edgeType;
    private float defaultTextSizePx;
    private float cueTextSizePx;
    private float bottomPaddingFraction;
    private int parentLeft;
    private int parentTop;
    private int parentRight;
    private int parentBottom;
    private StaticLayout textLayout;
    private int textLeft;
    private int textTop;
    private int textPaddingX;
    private Rect bitmapRect;

    public SubtitlePainter(Context context) {
        int[] nArray = new int[]{16843287, 16843288};
        TypedArray typedArray = context.obtainStyledAttributes(null, nArray, 0, 0);
        this.spacingAdd = typedArray.getDimensionPixelSize(0, 0);
        this.spacingMult = typedArray.getFloat(1, 1.0f);
        typedArray.recycle();
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        int n2 = Math.round(2.0f * (float)displayMetrics.densityDpi / 160.0f);
        this.outlineWidth = n2;
        this.shadowRadius = n2;
        this.shadowOffset = n2;
        this.textPaint = new TextPaint();
        this.textPaint.setAntiAlias(true);
        this.textPaint.setSubpixelText(true);
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL);
    }

    public void draw(b b2, boolean bl, boolean bl2, a a2, float f2, float f3, float f4, Canvas canvas, int n2, int n3, int n4, int n5) {
        boolean bl3 = b2.c == null;
        int n6 = -16777216;
        if (bl3) {
            if (TextUtils.isEmpty((CharSequence)b2.a)) {
                return;
            }
            int n7 = n6 = b2.k && bl ? b2.l : a2.d;
        }
        if (SubtitlePainter.areCharSequencesEqual(this.cueText, b2.a) && Util.areEqual(this.cueTextAlignment, b2.b) && this.cueBitmap == b2.c && this.cueLine == b2.d && this.cueLineType == b2.e && Util.areEqual(this.cueLineAnchor, b2.f) && this.cuePosition == b2.g && Util.areEqual(this.cuePositionAnchor, b2.h) && this.cueSize == b2.i && this.cueBitmapHeight == b2.j && this.applyEmbeddedStyles == bl && this.applyEmbeddedFontSizes == bl2 && this.foregroundColor == a2.b && this.backgroundColor == a2.c && this.windowColor == n6 && this.edgeType == a2.e && this.edgeColor == a2.f && Util.areEqual(this.textPaint.getTypeface(), a2.g) && this.defaultTextSizePx == f2 && this.cueTextSizePx == f3 && this.bottomPaddingFraction == f4 && this.parentLeft == n2 && this.parentTop == n3 && this.parentRight == n4 && this.parentBottom == n5) {
            this.drawLayout(canvas, bl3);
            return;
        }
        this.cueText = b2.a;
        this.cueTextAlignment = b2.b;
        this.cueBitmap = b2.c;
        this.cueLine = b2.d;
        this.cueLineType = b2.e;
        this.cueLineAnchor = b2.f;
        this.cuePosition = b2.g;
        this.cuePositionAnchor = b2.h;
        this.cueSize = b2.i;
        this.cueBitmapHeight = b2.j;
        this.applyEmbeddedStyles = bl;
        this.applyEmbeddedFontSizes = bl2;
        this.foregroundColor = a2.b;
        this.backgroundColor = a2.c;
        this.windowColor = n6;
        this.edgeType = a2.e;
        this.edgeColor = a2.f;
        this.textPaint.setTypeface(a2.g);
        this.defaultTextSizePx = f2;
        this.cueTextSizePx = f3;
        this.bottomPaddingFraction = f4;
        this.parentLeft = n2;
        this.parentTop = n3;
        this.parentRight = n4;
        this.parentBottom = n5;
        if (bl3) {
            this.setupTextLayout();
        } else {
            this.setupBitmapLayout();
        }
        this.drawLayout(canvas, bl3);
    }

    /*
     * WARNING - void declaration
     */
    private void setupTextLayout() {
        int n2;
        int n3;
        int n4;
        int n5;
        SpannableStringBuilder spannableStringBuilder;
        int n6 = this.parentRight - this.parentLeft;
        int n7 = this.parentBottom - this.parentTop;
        this.textPaint.setTextSize(this.defaultTextSizePx);
        int n8 = (int)(this.defaultTextSizePx * 0.125f + 0.5f);
        int n9 = n6 - n8 * 2;
        if (this.cueSize != Float.MIN_VALUE) {
            n9 = (int)((float)n9 * this.cueSize);
        }
        if (n9 <= 0) {
            Log.w((String)TAG, (String)"Skipped drawing subtitle cue (insufficient space)");
            return;
        }
        CharSequence charSequence = this.cueText;
        if (!this.applyEmbeddedStyles) {
            charSequence = charSequence.toString();
        } else if (!this.applyEmbeddedFontSizes) {
            spannableStringBuilder = new SpannableStringBuilder(charSequence);
            n5 = spannableStringBuilder.length();
            AbsoluteSizeSpan[] absoluteSizeSpanArray = (AbsoluteSizeSpan[])spannableStringBuilder.getSpans(0, n5, AbsoluteSizeSpan.class);
            RelativeSizeSpan[] relativeSizeSpanArray = (RelativeSizeSpan[])spannableStringBuilder.getSpans(0, n5, RelativeSizeSpan.class);
            for (AbsoluteSizeSpan absoluteSizeSpan : absoluteSizeSpanArray) {
                spannableStringBuilder.removeSpan((Object)absoluteSizeSpan);
            }
            for (AbsoluteSizeSpan absoluteSizeSpan : relativeSizeSpanArray) {
                spannableStringBuilder.removeSpan((Object)absoluteSizeSpan);
            }
            charSequence = spannableStringBuilder;
        } else if (this.cueTextSizePx > 0.0f) {
            spannableStringBuilder = new SpannableStringBuilder(charSequence);
            spannableStringBuilder.setSpan((Object)new AbsoluteSizeSpan((int)this.cueTextSizePx), 0, spannableStringBuilder.length(), 0xFF0000);
            charSequence = spannableStringBuilder;
        }
        if (Color.alpha((int)this.backgroundColor) > 0) {
            spannableStringBuilder = new SpannableStringBuilder(charSequence);
            spannableStringBuilder.setSpan((Object)new BackgroundColorSpan(this.backgroundColor), 0, spannableStringBuilder.length(), 0xFF0000);
            charSequence = spannableStringBuilder;
        }
        spannableStringBuilder = this.cueTextAlignment == null ? Layout.Alignment.ALIGN_CENTER : this.cueTextAlignment;
        this.textLayout = new StaticLayout(charSequence, this.textPaint, n9, (Layout.Alignment)spannableStringBuilder, this.spacingMult, this.spacingAdd, true);
        n5 = this.textLayout.getHeight();
        int n10 = 0;
        int n11 = this.textLayout.getLineCount();
        for (n4 = 0; n4 < n11; ++n4) {
            n10 = Math.max((int)Math.ceil(this.textLayout.getLineWidth(n4)), n10);
        }
        if (this.cueSize != Float.MIN_VALUE && n10 < n9) {
            n10 = n9;
        }
        n10 += n8 * 2;
        if (this.cuePosition != Float.MIN_VALUE) {
            n3 = Math.round((float)n6 * this.cuePosition) + this.parentLeft;
            n4 = this.cuePositionAnchor == 2 ? n3 - n10 : (this.cuePositionAnchor == 1 ? (n3 * 2 - n10) / 2 : n3);
            n4 = Math.max(n4, this.parentLeft);
            n2 = Math.min(n4 + n10, this.parentRight);
        } else {
            n4 = (n6 - n10) / 2 + this.parentLeft;
            n2 = n4 + n10;
        }
        n10 = n2 - n4;
        if (n10 <= 0) {
            Log.w((String)TAG, (String)"Skipped drawing subtitle cue (invalid horizontal positioning)");
            return;
        }
        if (this.cueLine != Float.MIN_VALUE) {
            void var13_22;
            if (this.cueLineType == 0) {
                int n12 = Math.round((float)n7 * this.cueLine) + this.parentTop;
            } else {
                int n13 = this.textLayout.getLineBottom(0) - this.textLayout.getLineTop(0);
                if (this.cueLine >= 0.0f) {
                    int n14 = Math.round(this.cueLine * (float)n13) + this.parentTop;
                } else {
                    int n15 = Math.round((this.cueLine + 1.0f) * (float)n13) + this.parentBottom;
                }
            }
            int n16 = this.cueLineAnchor == 2 ? var13_22 - n5 : (n3 = this.cueLineAnchor == 1 ? (var13_22 * 2 - n5) / 2 : var13_22);
            if (n3 + n5 > this.parentBottom) {
                n3 = this.parentBottom - n5;
            } else if (n3 < this.parentTop) {
                n3 = this.parentTop;
            }
        } else {
            n3 = this.parentBottom - n5 - (int)((float)n7 * this.bottomPaddingFraction);
        }
        this.textLayout = new StaticLayout(charSequence, this.textPaint, n10, (Layout.Alignment)spannableStringBuilder, this.spacingMult, this.spacingAdd, true);
        this.textLeft = n4;
        this.textTop = n3;
        this.textPaddingX = n8;
    }

    private void setupBitmapLayout() {
        int n2;
        int n3 = this.parentRight - this.parentLeft;
        int n4 = this.parentBottom - this.parentTop;
        float f2 = (float)this.parentLeft + (float)n3 * this.cuePosition;
        float f3 = (float)this.parentTop + (float)n4 * this.cueLine;
        int n5 = Math.round((float)n3 * this.cueSize);
        int n6 = n2 = this.cueBitmapHeight != Float.MIN_VALUE ? Math.round((float)n4 * this.cueBitmapHeight) : Math.round((float)n5 * ((float)this.cueBitmap.getHeight() / (float)this.cueBitmap.getWidth()));
        int n7 = Math.round(this.cueLineAnchor == 2 ? f2 - (float)n5 : (this.cueLineAnchor == 1 ? f2 - (float)(n5 / 2) : f2));
        int n8 = Math.round(this.cuePositionAnchor == 2 ? f3 - (float)n2 : (this.cuePositionAnchor == 1 ? f3 - (float)(n2 / 2) : f3));
        this.bitmapRect = new Rect(n7, n8, n7 + n5, n8 + n2);
    }

    private void drawLayout(Canvas canvas, boolean bl) {
        if (bl) {
            this.drawTextLayout(canvas);
        } else {
            this.drawBitmapLayout(canvas);
        }
    }

    private void drawTextLayout(Canvas canvas) {
        StaticLayout staticLayout = this.textLayout;
        if (staticLayout == null) {
            return;
        }
        int n2 = canvas.save();
        canvas.translate((float)this.textLeft, (float)this.textTop);
        if (Color.alpha((int)this.windowColor) > 0) {
            this.paint.setColor(this.windowColor);
            canvas.drawRect((float)(-this.textPaddingX), 0.0f, (float)(staticLayout.getWidth() + this.textPaddingX), (float)staticLayout.getHeight(), this.paint);
        }
        if (this.edgeType == 1) {
            this.textPaint.setStrokeJoin(Paint.Join.ROUND);
            this.textPaint.setStrokeWidth(this.outlineWidth);
            this.textPaint.setColor(this.edgeColor);
            this.textPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            staticLayout.draw(canvas);
        } else if (this.edgeType == 2) {
            this.textPaint.setShadowLayer(this.shadowRadius, this.shadowOffset, this.shadowOffset, this.edgeColor);
        } else if (this.edgeType == 3 || this.edgeType == 4) {
            boolean bl = this.edgeType == 3;
            int n3 = bl ? -1 : this.edgeColor;
            int n4 = bl ? this.edgeColor : -1;
            float f2 = this.shadowRadius / 2.0f;
            this.textPaint.setColor(this.foregroundColor);
            this.textPaint.setStyle(Paint.Style.FILL);
            this.textPaint.setShadowLayer(this.shadowRadius, -f2, -f2, n3);
            staticLayout.draw(canvas);
            this.textPaint.setShadowLayer(this.shadowRadius, f2, f2, n4);
        }
        this.textPaint.setColor(this.foregroundColor);
        this.textPaint.setStyle(Paint.Style.FILL);
        staticLayout.draw(canvas);
        this.textPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        canvas.restoreToCount(n2);
    }

    private void drawBitmapLayout(Canvas canvas) {
        canvas.drawBitmap(this.cueBitmap, null, this.bitmapRect, null);
    }

    private static boolean areCharSequencesEqual(CharSequence charSequence, CharSequence charSequence2) {
        return charSequence == charSequence2 || charSequence != null && charSequence.equals(charSequence2);
    }
}

