/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.widget.extra;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.accessibility.CaptioningManager;
import androidx.annotation.Nullable;
import com.hunantv.media.a.a;
import com.hunantv.media.a.b;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.subtitle.SubtitleConfig;
import com.hunantv.media.player.subtitle.c;
import com.hunantv.media.player.subtitle.d;
import com.hunantv.media.utils.Util;
import com.hunantv.media.widget.extra.SubtitlePainter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public final class SubtitleView
extends View
implements d.c {
    private static final String TAG = "SubtitleView";
    public static final float DEFAULT_TEXT_SIZE_FRACTION = 0.04f;
    public static final float DEFAULT_BOTTOM_PADDING_FRACTION = 0.01f;
    private final List<SubtitlePainter> painters = new ArrayList<SubtitlePainter>();
    private List<b> cues;
    private int textSizeType = 0;
    private float textSize = 0.04f;
    private boolean applyEmbeddedStyles = true;
    private boolean applyEmbeddedFontSizes = true;
    private a style = new a(-1, 0x7F000000, 0, 0, -1, null);
    private float bottomPaddingFraction = 0.01f;
    private SubtitleConfig subtitleConfig;

    public SubtitleView(Context context) {
        this(context, null);
    }

    public SubtitleView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public void setSubtitleConfig(SubtitleConfig subtitleConfig) {
        DebugLog.i(TAG, subtitleConfig + "");
        this.subtitleConfig = subtitleConfig;
    }

    public void onCues(List<b> list) {
        this.setCues(list);
    }

    public void clear() {
        ArrayList<b> arrayList = new ArrayList<b>();
        arrayList.add(new b(""));
        this.setCues(arrayList);
    }

    public void setCues(@Nullable List<b> list) {
        int n2;
        if (this.cues == list) {
            return;
        }
        this.cues = list;
        int n3 = n2 = list == null ? 0 : list.size();
        while (this.painters.size() < n2) {
            this.painters.add(new SubtitlePainter(this.getContext()));
        }
        this.invalidate();
    }

    public void setFixedTextSize(int n2, float f2) {
        Context context = this.getContext();
        Resources resources = context == null ? Resources.getSystem() : context.getResources();
        this.setTextSize(2, TypedValue.applyDimension((int)n2, (float)f2, (DisplayMetrics)resources.getDisplayMetrics()));
    }

    public void setUserDefaultTextSize() {
        float f2 = Util.SDK_INT >= 19 && !this.isInEditMode() ? this.getUserCaptionFontScaleV19() : 1.0f;
        this.setFractionalTextSize(0.04f * f2);
    }

    public void setFractionalTextSize(float f2) {
        this.setFractionalTextSize(f2, false);
    }

    public void setFractionalTextSize(float f2, boolean bl) {
        this.setTextSize(bl ? 1 : 0, f2);
    }

    private void setTextSize(int n2, float f2) {
        if (this.textSizeType == n2 && this.textSize == f2) {
            return;
        }
        this.textSizeType = n2;
        this.textSize = f2;
        this.invalidate();
    }

    public void setApplyEmbeddedStyles(boolean bl) {
        if (this.applyEmbeddedStyles == bl && this.applyEmbeddedFontSizes == bl) {
            return;
        }
        this.applyEmbeddedStyles = bl;
        this.applyEmbeddedFontSizes = bl;
        this.invalidate();
    }

    public void setApplyEmbeddedFontSizes(boolean bl) {
        if (this.applyEmbeddedFontSizes == bl) {
            return;
        }
        this.applyEmbeddedFontSizes = bl;
        this.invalidate();
    }

    public void setUserDefaultStyle() {
        this.setStyle(Util.SDK_INT >= 19 && this.isCaptionManagerEnabled() && !this.isInEditMode() ? this.getUserCaptionStyleV19() : a.a);
    }

    public void setStyle(a a2) {
        if (this.style == a2) {
            return;
        }
        this.style = a2;
        this.invalidate();
    }

    public void setBottomPaddingFraction(float f2) {
        if (this.bottomPaddingFraction == f2) {
            return;
        }
        this.bottomPaddingFraction = f2;
        this.invalidate();
    }

    public void dispatchDraw(Canvas canvas) {
        float f2;
        int n2 = this.cues == null ? 0 : this.cues.size();
        int n3 = this.getHeight();
        int n4 = this.getPaddingLeft();
        int n5 = this.getPaddingTop();
        int n6 = this.getWidth() - this.getPaddingRight();
        int n7 = n3 - this.getPaddingBottom();
        if (n7 <= n5 || n6 <= n4) {
            return;
        }
        int n8 = n7 - n5;
        if (this.subtitleConfig != null) {
            if (this.subtitleConfig.textSizeRatio > 0.0f) {
                this.textSize = this.subtitleConfig.textSizeRatio;
            }
            if (this.subtitleConfig.paddingBottomRatio > 0.0f) {
                this.bottomPaddingFraction = this.subtitleConfig.paddingBottomRatio;
            }
            if (this.subtitleConfig.textColor != -1) {
                this.style.b = this.subtitleConfig.textColor;
            }
            if (this.subtitleConfig.backgroundColor != -1) {
                this.style.c = this.subtitleConfig.backgroundColor;
            }
        }
        if ((f2 = this.resolveTextSize(this.textSizeType, this.textSize, n3, n8)) <= 0.0f) {
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            b b2 = this.cues.get(i2);
            float f3 = this.resolveCueTextSize(b2, n3, n8);
            SubtitlePainter subtitlePainter = this.painters.get(i2);
            subtitlePainter.draw(b2, this.applyEmbeddedStyles, this.applyEmbeddedFontSizes, this.style, f2, f3, this.bottomPaddingFraction, canvas, n4, n5, n6, n7);
        }
    }

    private float resolveCueTextSize(b b2, int n2, int n3) {
        if (b2.m == Integer.MIN_VALUE || b2.n == Float.MIN_VALUE) {
            return 0.0f;
        }
        float f2 = this.resolveTextSize(b2.m, b2.n, n2, n3);
        return Math.max(f2, 0.0f);
    }

    private float resolveTextSize(int n2, float f2, int n3, int n4) {
        switch (n2) {
            case 2: {
                return f2;
            }
            case 0: {
                return f2 * (float)n4;
            }
            case 1: {
                return f2 * (float)n3;
            }
        }
        return Float.MIN_VALUE;
    }

    @TargetApi(value=19)
    private boolean isCaptionManagerEnabled() {
        CaptioningManager captioningManager = (CaptioningManager)this.getContext().getSystemService("captioning");
        return captioningManager.isEnabled();
    }

    @TargetApi(value=19)
    private float getUserCaptionFontScaleV19() {
        CaptioningManager captioningManager = (CaptioningManager)this.getContext().getSystemService("captioning");
        return captioningManager.getFontScale();
    }

    @TargetApi(value=19)
    private a getUserCaptionStyleV19() {
        CaptioningManager captioningManager = (CaptioningManager)this.getContext().getSystemService("captioning");
        return a.a(captioningManager.getUserStyle());
    }

    public void setOnChangedListener(d.c.a a2) {
    }

    public void setSize(int n2, int n3) {
    }

    @Override
    public void setVisible(boolean bl) {
        this.setVisibility(bl ? 0 : 4);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    @Override
    public void setActiveCues(Vector<d.a> vector) {
        int n2 = vector.size();
        ArrayList<b> arrayList = new ArrayList<b>();
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            com.hunantv.media.player.subtitle.a.b b2 = (com.hunantv.media.player.subtitle.a.b)vector.get(i2);
            if (b2 == null || b2.p == null) continue;
            for (String string2 : b2.p) {
                string = "".equals(string) ? string2 : string + "\n" + string2;
            }
        }
        c.a("subtitle", string);
        arrayList.add(new b(string));
        this.onCues(arrayList);
    }
}

