/*
 * Decompiled with CFR 0.152.
 */
package com.smartlife.nebula.librarybase.utils;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.fragment.app.FragmentStatePagerAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.smartlife.nebula.librarybase.interfaces.common.FragmentBackHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\u0005\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ\u0010\u0010\f\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/smartlife/nebula/librarybase/utils/BackHandlerHelper;", "", "Landroidx/fragment/app/FragmentManager;", "fragmentManager", "", "handleBackPress", "Landroidx/fragment/app/Fragment;", "fragment", "Landroidx/fragment/app/FragmentActivity;", "fragmentActivity", "Landroidx/viewpager/widget/ViewPager;", "viewPager", "isFragmentBackHandled", "<init>", "()V", "commons_release"})
public final class BackHandlerHelper {
    public final boolean handleBackPress(@NotNull FragmentManager fragmentManager) {
        FragmentManager fragmentManager2 = fragmentManager;
        Intrinsics.checkNotNullParameter((Object)fragmentManager2, (String)"fragmentManager");
        List list = fragmentManager2.getFragments();
        if (list == null) {
            return false;
        }
        int n = list.size() + -1;
        if (n >= 0) {
            do {
                int n2 = n;
                n = n2 + -1;
                if (!this.isFragmentBackHandled((Fragment)list.get(n2))) continue;
                return true;
            } while (n >= 0);
        }
        if (fragmentManager.getBackStackEntryCount() > 0) {
            fragmentManager.popBackStack();
            return true;
        }
        return false;
    }

    public final boolean handleBackPress(@NotNull Fragment fragment) {
        Fragment fragment2 = fragment;
        Intrinsics.checkNotNullParameter((Object)fragment2, (String)"fragment");
        FragmentManager fragmentManager = fragment2.getChildFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"fragment.childFragmentManager");
        return this.handleBackPress(fragmentManager);
    }

    public final boolean handleBackPress(@NotNull FragmentActivity fragmentActivity) {
        FragmentActivity fragmentActivity2 = fragmentActivity;
        Intrinsics.checkNotNullParameter((Object)fragmentActivity2, (String)"fragmentActivity");
        FragmentManager fragmentManager = fragmentActivity2.getSupportFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"fragmentActivity.supportFragmentManager");
        return this.handleBackPress(fragmentManager);
    }

    public final boolean handleBackPress(@Nullable ViewPager viewPager) {
        if (viewPager == null) {
            return false;
        }
        PagerAdapter pagerAdapter = viewPager.getAdapter();
        if (pagerAdapter == null) {
            return false;
        }
        int n = viewPager.getCurrentItem();
        Object object = pagerAdapter instanceof FragmentPagerAdapter ? ((FragmentPagerAdapter)pagerAdapter).getItem(n) : (pagerAdapter instanceof FragmentStatePagerAdapter ? ((FragmentStatePagerAdapter)pagerAdapter).getItem(n) : null);
        return this.isFragmentBackHandled((Fragment)object);
    }

    public final boolean isFragmentBackHandled(@Nullable Fragment fragment) {
        return fragment != null && fragment.isVisible() && fragment.getUserVisibleHint() && fragment instanceof FragmentBackHandler && ((FragmentBackHandler)fragment).onBackPressed();
    }
}

