/*
 * Transsion Top Secret
 * Copyright (C) 2021 Transsion Inc.
 * Welife
 * @author OS : chunming.hu (18646581)
 * @version 1.0
 */

package com.smartlife.nebula.device

import android.content.Context
import android.service.controls.Control
import android.service.controls.actions.ControlAction
import java.util.function.Consumer

/**
 * @author chunming.hu
 * @date 2021/2/27 18:06
 * @Description Device Control 提供抽象类
 */
abstract class AbstractDeviceControlProvide {

    private var mCallback: ((Control) -> Unit)? = null

    /**
     * 创建用于显示所有支持Device Control 的方法回调(该Control 无状态)
     * @param pid 产品唯一标识
     * @param mac 设备MAC 地址
     */
    abstract fun createStatelessControl(context: Context, pid: String, mac: String): List<Control>

    /**
     * 创建用户选择后的Device Control 的方法回调（该Control 有状态变化）
     */
    abstract fun createStatefulControl(context: Context, controlIdList: List<String>): List<Control>

    /**
     * 处理Device Control 用户的操作事件
     */
    abstract fun performControlAction(
        context: Context,
        controlId: String,
        action: ControlAction,
        consumer: Consumer<Int>
    )

    /**
     *  设置Device Control 更新的回调
     */
    fun setControlUpdateCallback(callback: (Control) -> Unit) {
        mCallback = callback
    }

    /**
     * 更新Device Control 状态
     */
    fun updateControlState(control: Control) {
        mCallback?.invoke(control)
    }

    /**
     * 创建ControlId
     * @param pid 产品唯一标识
     * @param mac 设备MAC地址
     * @param function 对应control 功能(没有多个功能区分可传入)
     */
    fun createControlId(pid: String, mac: String, function: String = ""): String {
        return "${pid}#${mac}#${function}"
    }

    fun getPid(controlId:String): String?{
        return getContent(controlId,0)
    }

    fun getMac(controlId:String): String?{
        return getContent(controlId,1)
    }

    fun getFunction(controlId:String): String?{
        return getContent(controlId,2)
    }

    private fun getContent(controlId:String,index:Int):String?{
        val contentList = controlId.split("#")
        return if(index < 2 && contentList.size >= 2
            || index == 2 && contentList.size == 3){
            contentList[index]
        }else{
            null
        }


    }
}