package com.smartlife.nebula.process

import android.bluetooth.le.ScanResult
import android.content.Context
import com.smartlife.nebula.device.IDeviceManger
import com.smartlife.nebula.device.WelifeDevice


/**
 *
 * @author jie.zhao6
 * @date 2021/09/15 10:42
 * @Description
 * @property mContext
 * @property mIDeviceManger
 * @property mWirelessType  pid中截取的无线连接类型
 * @property mScanProcessorId [WelifeDevice.getScanProcessorId]}生成的扫描任务id
 */
@Deprecated("3.0 replace with ILinkHelper")
abstract class AbsScanProcessor(
    protected val mContext: Context,
    protected val mIDeviceManger: IDeviceManger,
    welifeDevice: WelifeDevice
) : IScanProcessor {
    //是否开始扫描
    protected var mIsScanning = false
    protected val mWirelessType: Int = mIDeviceManger.getWirelessType(welifeDevice)
    protected val mScanProcessorId: Int =
        mIDeviceManger.getScanProcessorId(welifeDevice)

    protected var mScanFilter: IScanProcessorFilter? = null

    override fun onScanResult(scannedDeviceInfo: WelifeDevice.IScannedDeviceInfo) {
        if (mScanFilter == null) {
            mIDeviceManger.onScanResult(
                mWirelessType,
                mScanProcessorId,
                scannedDeviceInfo
            )
        } else {
            if (mScanFilter?.onScanResultFilter(scannedDeviceInfo.pid) == true) {
                mIDeviceManger.onScanResult(
                    mWirelessType,
                    mScanProcessorId,
                    scannedDeviceInfo
                )

            }
        }
    }


    override fun onScanStateChange(newState: WelifeDevice.ScanResultCallback.ScanState) {
        mIDeviceManger.onScanStateChange(mWirelessType, mScanProcessorId, newState)
        if (newState == WelifeDevice.ScanResultCallback.ScanState.SCAN_STATE_COMPLETE
            || newState == WelifeDevice.ScanResultCallback.ScanState.SCAN_STATE_TIME_OUT
        ) {
            //结束移除过滤
            mScanFilter = null
        }
    }

    override fun onScanError(errorCode: Int) {
        mIDeviceManger.onScanError(mWirelessType, mScanProcessorId, errorCode)
        //结束清除过滤
        mScanFilter = null

    }

    /**
     * 供外部调用的扫描方法
     *
     * @param filter 设备过滤规则，例如只需要扫描单一设备的时候需要过滤设备
     * @return
     */
    fun startScan(filter: IScanProcessorFilter? = null,reconnect:Boolean = false): WelifeDevice.ScanOperateState {
        mScanFilter = filter
        return startScan(reconnect)
    }

    /**
     * 默认返回设备的无线连接类型
     *
     * @return
     */
    open fun getWirelessType(): Int {
        return mWirelessType
    }

    /**
     *
     *任务唯一id
     * @return
     */
    open fun getScanProcessorId(): Int {
        return mScanProcessorId
    }

    /**
     *
     *
     * @param scanResult
     * @param deviceInfo 这里没有选择指定具体class类别是因为传递的对象在welink aar里面,
     * 当前module没有依赖welink aar，所以传递Any类型
     * 实际在运行中只会传递welink的扫描数据类型且不为空
     */
    open fun creatScanResultAndSend(
        scanResult: ScanResult,
        deviceInfo: Any
    ) {

    }
}