/*
 * Transsion Top Secret
 * Copyright (C) 2021 Transsion Inc.
 * Welife
 * @author OS : chunming.hu (18646581)
 * @version 1.0
 */

package com.smartlife.nebula.device

import android.os.Bundle
import android.os.PersistableBundle
import android.view.View
import android.view.ViewGroup
import android.view.ViewTreeObserver
import androidx.appcompat.app.AppCompatActivity


/**
 * @author chunming.hu
 * @date 2021/3/11 16:35
 * @Description 用于显示在Device Control 中的Activity的基类
 */
open class BaseControlActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?, persistentState: PersistableBundle?) {
        super.onCreate(savedInstanceState, persistentState)
        //在onCreate中获取contentView
        val contentView =
            (findViewById<View>(android.R.id.content) as ViewGroup).getChildAt(0) as ViewGroup
        //监听布局完成事件
        window.decorView.viewTreeObserver.addOnGlobalLayoutListener(object :
            ViewTreeObserver.OnGlobalLayoutListener {
            override fun onGlobalLayout() {
                //监听到页面渲染完成后移除监听
                window.decorView.viewTreeObserver.removeOnGlobalLayoutListener(this)
                //目前在Device Control 中 window.decorView.height 的高度 等于contentView.height，使用该添加判断是否需要修改根布局的高度
                if (window.decorView.height == contentView.height ) {
                    contentView.layoutParams = contentView.layoutParams.apply {
                        //重新设置contentView的高度为contentView 原高度减去导航栏高度
                        height = window.decorView.height - getNavigationBarHeight()
                    }
                }
            }

        })
    }

    /**
     * 获取导航栏高度
     */
    fun getNavigationBarHeight(): Int {
        val resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android")
        //获取NavigationBar的高度
        return resources.getDimensionPixelSize(resourceId)
    }


}