package com.smartlife.nebula.device.base

import android.os.Parcel
import android.os.Parcelable
import com.smartlife.nebula.device.WelifeDevice

/**
 * 用于适配[WelifeDevice.connect]的默认实现
 */
class AdapterScanDeviceInfo (
    override var deviceName: String,
    override var did: String,
    override var pid: String,
    override var extraString: String
) : WelifeDevice.IScannedDeviceInfo {
    constructor(parcel: Parcel) : this(
        parcel.readString() ?: "",
        parcel.readString() ?: "",
        parcel.readString() ?: "",
        parcel.readString() ?: ""
    ) {
    }

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeString(deviceName)
        parcel.writeString(did)
        parcel.writeString(pid)
        parcel.writeString(extraString)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<AdapterScanDeviceInfo> {
        override fun createFromParcel(parcel: Parcel): AdapterScanDeviceInfo {
            return AdapterScanDeviceInfo(parcel)
        }

        override fun newArray(size: Int): Array<AdapterScanDeviceInfo?> {
            return arrayOfNulls(size)
        }
    }

}