/*
 * Transsion Top Secret
 * Copyright (C) 2021 Transsion Inc.
 * Welife
 *  @author OS : jie.zhao6 (18648215)
 *  @version 1.0
 */

package com.smartlife.nebula.device.base

import android.content.Context
import com.smartlife.nebula.device.WelifeDevice
import com.smartlife.nebula.device.base.callback.IDeviceConnectStateCallback
import com.smartlife.nebula.device.base.callback.IDeviceUiStateCallback

abstract class DeviceType : IDeviceType {
    protected var mContext: Context? = null
    private var mDeviceConnectStateCallback: IDeviceConnectStateCallback? = null
    private var mDeviceUiStateCallback: IDeviceUiStateCallback? = null
    var mIsSupportRoomProperty = false
    var mControlPageClassName = ""
    var mDeviceTypeRemoteIcon:String?  = ""


    override fun initDeviceType(
        context: Context,
        iDeviceConnectStateCallback: IDeviceConnectStateCallback,
        iDeviceUiStateCallback: IDeviceUiStateCallback
    ) {
        mContext = context
        mDeviceConnectStateCallback = iDeviceConnectStateCallback
        mDeviceUiStateCallback = iDeviceUiStateCallback
    }

    fun onConnectStateChange(deviceAddress: String, newState: Int) {
        mDeviceConnectStateCallback?.onConnectStateChange(deviceAddress, newState)
    }

    fun onUiStateChange(deviceAddress: String, parameterMap: Map<Int, Any>) {
        mDeviceUiStateCallback?.onUiStateChange(getPid(),deviceAddress, parameterMap)
    }

    override fun isSupportRoomProperty(): Boolean {
        return mIsSupportRoomProperty
    }

    override fun getControlPageClassName(): String {
       return mControlPageClassName
    }

    override fun localSupport(): Boolean {
        return true
    }

    override fun getIcons(): DeviceTypeIcon {
        return DeviceTypeIcon(mDeviceTypeRemoteIcon,getLocalResIcon())
    }

    override fun getDeviceExtraInfo(param: String?, callback: WelifeDevice.IWelifeDeviceParameterCallback) {
    }
}