/*
 * Transsion Top Secret
 * Copyright (C) 2021 Transsion Inc.
 * Welife
 *  @author OS : jie.zhao6 (18648215)
 *  @version 1.0
 */

package com.smartlife.nebula.device.base

import android.content.Context
import com.smartlife.nebula.device.WelifeDevice
import com.smartlife.nebula.device.base.callback.IDeviceConnectStateCallback
import com.smartlife.nebula.device.base.callback.IDeviceUiStateCallback


interface IDeviceType {

    fun initDeviceType(
        context: Context,
        iDeviceConnectStateCallback: IDeviceConnectStateCallback,
        iDeviceUiStateCallback: IDeviceUiStateCallback
    )

    fun getPid(): String

    fun getDisplayName(): String

    fun getLocalResIcon(): Int

    fun getIcons(): DeviceTypeIcon

    fun getControlPagePath(): String

    fun connect(deviceAddress: String, extras: Any?)

    fun disconnect(deviceAddress: String)

    fun unbind(deviceAddress: String)

    fun localSupport():Boolean

    fun getControlPageClassName(): String

    fun isSupportRoomProperty():Boolean

    /**
     * 获取特定类型开的设备首页卡片填充内容
     * @param isExpended 是否为展内容
     * @param deviceAddress 设备唯一标识
     * @param cardDataType 数据类型
     * @return 特定卡片填充内容
     */
    fun getCardContent(
        isExpended: Boolean,
        deviceAddress: String,
        cardDataType: WelifeDevice.CardDataType
    ): Any?


    /**
     * 获取设备所有的卡片内容
     * @param isExpended 是否为展开内容
     * @param deviceAddress 设备唯一标识
     * @return 卡片所有填充内容
     */
    fun getCardContents(isExpended: Boolean, deviceAddress: String): HashMap<Int, Any>

    fun getDeviceExtraInfo(param: String?, callback: WelifeDevice.IWelifeDeviceParameterCallback)

    /**
     * 首页卡片显示回调
     * @param deviceAddress 设备唯一标识
     */
    fun onCardShow(deviceAddress: String)


    /**
     * 首页卡片隐藏回调
     * @param deviceAddress 设备唯一标识
     */
    fun onCardHide(deviceAddress: String)

}