package com.smartlife.nebula.device.base

import android.util.Log
import androidx.lifecycle.MutableLiveData
import com.smartlife.nebula.device.BuildConfig
import com.smartlife.nebula.device.base.callback.IDeviceConnectStateCallback
import com.smartlife.nebula.device.base.callback.IDeviceUiStateCallback
import com.smartlife.nebula.device.base.state.ConnectState
import com.smartlife.nebula.link.ILinkConnectHelper

class PairedDevice(
    private val mDeviceType: DeviceType,
    val mDid: String,
    private val mLinkConnectHelper: ILinkConnectHelper,
    var mLastConnectTime: Long = 0
) : IDeviceConnectStateCallback, IDeviceUiStateCallback {
    private val TAG = PairedDevice@this::javaClass.name
    private var mExtraObject: Any? = null
    private val mConnectState: MutableLiveData<Int> = MutableLiveData(ConnectState.STATE_DISCONNECT)
    private val mUiStateMap: MutableLiveData<Map<Int, Any>> = MutableLiveData()

    suspend fun connect() {
        mLinkConnectHelper.connect(mDid, extras = mExtraObject, this)
    }

    fun setExtraObject(extraObject: Any?) {
        mExtraObject = extraObject
    }

    fun getExtraObject(): Any? {
        return mExtraObject
    }

    suspend fun disConnect() {
        mLinkConnectHelper.disConnect(mDid, this)
    }

    override fun onConnectStateChange(deviceAddress: String, newState: Int) {
        if (deviceAddress == mDid) {
            if (newState == ConnectState.STATE_CONNECTED) {
                mLastConnectTime = System.currentTimeMillis()
            }
            mConnectState.postValue(newState)
        }

    }

    override fun onUiStateChange(pid: String, deviceAddress: String, parameterMap: Map<Int, Any>) {
        if (deviceAddress == mDid) {
            if (mUiStateMap.value == null) {
                mUiStateMap.postValue(parameterMap)

            } else {
                val hashMap: HashMap<Int, Any> = (mUiStateMap.value as HashMap<Int, Any>?)!!
                parameterMap.forEach { t, u ->
                    if (hashMap.containsKey(t)) {
                        hashMap[t] = u
                    } else {
                        hashMap[t] = u
                    }
                    if (BuildConfig.DEBUG){
                        Log.d(TAG,"onUiStateChange state key:${t},value:$u,pairedDevice:${PairedDevice@this}")
                    }
                }
                mUiStateMap.postValue(hashMap)
            }

        }
    }

    fun getConnectState(): MutableLiveData<Int> {
        return mConnectState
    }

    fun getUiState(): MutableLiveData<Map<Int, Any>> {
        return mUiStateMap
    }

    fun getPid(): String {
        return mDeviceType.getPid()
    }

    fun getDisplayName(): String {
        return mDeviceType.getDisplayName()
    }

    fun getIcons(): DeviceTypeIcon {
        return mDeviceType.getIcons()
    }

    fun getControlPagePath(): String {
        return mDeviceType.getControlPagePath()
    }

    fun getControlPageClassName(): String {
        return mDeviceType.getControlPageClassName()
    }

    fun isSupportRoomProperty(): Boolean {
        return mDeviceType.isSupportRoomProperty()
    }

    suspend fun unbind() {
        mLinkConnectHelper.unBind(mDid)
    }

    /**
     * 当设备处于卡片页可见状态时,调用该方法
     */
    fun onCardShow() {
        mLinkConnectHelper.onCardShow(mDid)
    }

    fun onCardHide(){
        mLinkConnectHelper.onCardHide(mDid)
    }

    override fun toString(): String {
        return "pid:${getPid()},name:${getDisplayName()},deviceAddress:${mDid},connect state:${mConnectState.value}"
    }

}