/*
 * Transsion Top Secret
 * Copyright (C) 2021 Transsion Inc.
 * Welife
 *  @author OS : jie.zhao6 (18648215)
 *  @version 1.0
 */

package com.smartlife.nebula.device.base

import android.util.Log
import com.smartlife.nebula.device.WelifeDevice
import com.smartlife.nebula.device.base.callback.IDeviceConnectStateCallback
import com.smartlife.nebula.link.ILinkConnectHelper

/**
 * 扫描发现的设备
 */
class ScanedDevice(
    private val mDeviceType: DeviceType,
    val mDid: String,
    val mExtraString: String,
    val mExtraObject: Any? = null,
    private val mConnectHelper: ILinkConnectHelper
):IDeviceConnectStateCallback {
    private val TAG = this.javaClass.simpleName
    private var mDeviceConnectStateCallback:IDeviceConnectStateCallback? = null

    suspend fun connect(iDeviceConnectStateCallback: IDeviceConnectStateCallback) {
        mDeviceConnectStateCallback = iDeviceConnectStateCallback
        mConnectHelper.connect(mDid, mExtraObject, this)
    }

    suspend fun disConnect(){
        mConnectHelper.disConnect(mDid)
        mDeviceConnectStateCallback = null
    }

    override fun onConnectStateChange(deviceAddress: String, newState: Int) {
        Log.d(TAG,"onConnectStateChange did:$deviceAddress,newState:$newState")
        mDeviceConnectStateCallback?.onConnectStateChange(deviceAddress, newState)
    }

    fun getPid(): String {
        return mDeviceType.getPid()
    }

    fun getDisplayName(): String {
        return mDeviceType.getDisplayName()
    }

    fun getIcons(): DeviceTypeIcon {
        return mDeviceType.getIcons()
    }

    fun getControlPagePath(): String {
        return mDeviceType.getControlPagePath()
    }

    fun getDeviceExtraInfo(param: String?, callback: WelifeDevice.IWelifeDeviceParameterCallback) {
        mDeviceType.getDeviceExtraInfo(param, callback)
    }


    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is ScanedDevice) return false

        if (mDid != other.mDid) return false

        return true
    }

    override fun hashCode(): Int {
        return mDid.hashCode()
    }

    override fun toString(): String {
        return "pid:${getPid()},name:${getDisplayName()},deviceAddress:${mDid}"
    }


}
