package com.smartlife.nebula.link

import android.content.Context
import com.smartlife.nebula.device.base.ScanedDevice
import com.smartlife.nebula.device.base.callback.IDeviceConnectStateCallback
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import java.util.concurrent.atomic.AtomicBoolean

abstract class BaseLinkHelper:ILinkHelper {
    protected var mCoroutineScope: CoroutineScope = GlobalScope
    protected val mIsScanning = AtomicBoolean(false)
    protected var mContext: Context? = null
    protected var mLinkHelperScanDataTransfor: ILinkHelperScanDataTransfor? = null
    protected var mLinkConnectHelper: ILinkConnectHelper? = null
    protected val mScanedScanedDeviceMap: HashMap<String, ScanedDevice> = HashMap()
    protected var mScanModle:Int = 0

    override fun initLinkHelper(
        context: Context,
        coroutineScope: CoroutineScope,
        iLinkHelperScanDataTransfor: ILinkHelperScanDataTransfor,
        iLinkConnectHelper: ILinkConnectHelper
    ) {
        mContext = context
        mCoroutineScope = coroutineScope
        mLinkHelperScanDataTransfor = iLinkHelperScanDataTransfor
        mLinkConnectHelper = iLinkConnectHelper
    }

    /**
     * 自定义添加一个扫描设备，目前只有AX1800调用
     */
    open suspend fun addCustomerScanedDevice(scanedDevice: ScanedDevice){
        if (!mScanedScanedDeviceMap.containsKey(scanedDevice.mDid)) {
            mScanedScanedDeviceMap[scanedDevice.mDid] = scanedDevice
            mLinkHelperScanDataTransfor?.onScanNewDevice(scanedDevice)
        }
    }


    override suspend fun disConnect(
        deviceAddress: String,
        iDeviceConnectStateCallback: IDeviceConnectStateCallback?
    ) {

    }

    override suspend fun connect(
        deviceAddress: String,
        extras: Any?,
        iDeviceConnectStateCallback: IDeviceConnectStateCallback
    ) {
        mLinkConnectHelper?.connect(deviceAddress, extras, iDeviceConnectStateCallback)//最终会进入设备类的connect方法
    }

    override fun clearScanDevice() {
        mCoroutineScope.launch {
            mLinkHelperScanDataTransfor?.onRemoveScanDevice(mScanedScanedDeviceMap.values)
            mScanedScanedDeviceMap.clear()
        }
    }

    override suspend fun unBind(deviceAddress: String) {
        mLinkConnectHelper?.unBind(deviceAddress)
    }

    override  fun onCardShow(deviceAddress: String) {
        mLinkConnectHelper?.onCardShow(deviceAddress)
    }

    override  fun onCardHide(deviceAddress: String) {
        mLinkConnectHelper?.onCardHide(deviceAddress)
    }

    override fun isScanning(): Boolean {
        return mIsScanning.get()
    }
}