/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieAnimationView;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;
import java.io.IOException;
import java.io.InputStream;

public class LoadingView
extends FrameLayout {
    private static final int DIMEN_MEDIUM = 0;
    private static final int DIMEN_LARGE = 1;
    private static final int DIMEN_SMALL = 2;
    private boolean mShowOnColorFull;
    private boolean mIsAutoAnim = true;
    private LottieAnimationView mAnimationView;
    private Runnable mRunnable;
    private int mDimenMode;

    public LoadingView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public LoadingView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LoadingView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public LoadingView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public void showOnColorFull(boolean showColorFull) {
        this.mShowOnColorFull = showColorFull;
        this.release();
        this.init();
    }

    private void init() {
        final boolean darkMode = Utils.isDarkMode(this.getContext());
        try {
            this.addView(LayoutInflater.from((Context)this.getContext()).inflate(R.layout.os_layout_loading, null));
            this.mAnimationView = (LottieAnimationView)this.findViewById(R.id.loadingView);
            this.mRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String loadingViewName = "loading_medium.json";
                    LoadingView.this.mDimenMode = 0;
                    int width = LoadingView.this.getMeasuredWidth();
                    Resources resources = LoadingView.this.getContext().getResources();
                    if (resources != null) {
                        if (width <= resources.getDimensionPixelSize(R.dimen.os_loading_small_size)) {
                            loadingViewName = LoadingView.this.mShowOnColorFull ? "loading_small_colorfull.json" : (darkMode ? "loading_small_night.json" : "loading_small.json");
                            LoadingView.this.mDimenMode = 2;
                        } else if (width <= resources.getDimensionPixelSize(R.dimen.os_loading_medium_size)) {
                            loadingViewName = LoadingView.this.mShowOnColorFull ? "loading_medium_colorfull.json" : (darkMode ? "loading_medium_night.json" : "loading_medium.json");
                            LoadingView.this.mDimenMode = 0;
                        } else {
                            loadingViewName = LoadingView.this.mShowOnColorFull ? "loading_large_colorfull.json" : (darkMode ? "loading_large_night.json" : "loading_large.json");
                            LoadingView.this.mDimenMode = 1;
                        }
                    }
                    InputStream inputStream = null;
                    try {
                        inputStream = LoadingView.this.getContext().getAssets().open(loadingViewName);
                        LoadingView.this.mAnimationView.setAnimation(loadingViewName);
                        if (LoadingView.this.mIsAutoAnim) {
                            LoadingView.this.mAnimationView.playAnimation();
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)"LoadingView", (String)"open asset file error", (Throwable)e);
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            };
            this.mAnimationView.setRepeatCount(-1);
            this.mAnimationView.setRepeatMode(1);
            this.post(this.mRunnable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void release() {
        try {
            if (this.mRunnable != null) {
                this.removeCallbacks(this.mRunnable);
            }
            if (this.mIsAutoAnim) {
                this.removeAllViews();
            }
            if (this.mAnimationView != null) {
                this.mAnimationView.setProgress(0.0f);
                this.mAnimationView.cancelAnimation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start() {
        if (this.mIsAutoAnim || this.mAnimationView.isAnimating()) {
            return;
        }
        if (this.mAnimationView != null) {
            this.mAnimationView.playAnimation();
        }
    }

    public void setAutoAnim(boolean autoAnim) {
        this.mIsAutoAnim = autoAnim;
    }

    public void setDarkMode() {
        String loadingViewName = this.mDimenMode == 2 ? "loading_small_night.json" : (this.mDimenMode == 1 ? "loading_large_night.json" : "loading_medium_night.json");
        this.replayAnim(loadingViewName);
    }

    public void setNormalMode() {
        String loadingViewName = this.mDimenMode == 2 ? "loading_small.json" : (this.mDimenMode == 1 ? "loading_large.json" : "loading_medium.json");
        this.replayAnim(loadingViewName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayAnim(String loadingViewName) {
        if (this.mAnimationView == null || this.mShowOnColorFull) {
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = this.getContext().getAssets().open(loadingViewName);
            float progress = this.mAnimationView.getProgress();
            this.mAnimationView.cancelAnimation();
            this.mAnimationView.setAnimation(loadingViewName);
            this.mAnimationView.playAnimation();
            this.mAnimationView.setProgress(progress);
        }
        catch (Exception e) {
            Log.e((String)"LoadingView", (String)"open asset file error", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

