/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;

public abstract class RecyclerAdapter<T, VH extends Holder>
extends RecyclerView.Adapter<VH> {
    protected final List<T> mDataList;
    protected AdapterView.OnItemClickListener mOnItemClickListener;

    protected RecyclerAdapter(List<T> dataList) {
        this.mDataList = dataList;
    }

    public void onBindViewHolder(@NonNull VH holder, int position) {
        final T data = this.mDataList.get(position);
        if (data == null) {
            return;
        }
        this.onBindViewHolder(holder, position, data);
        final View view = ((Holder)((Object)holder)).itemView;
        final int pst = position;
        if (((Holder)((Object)holder)).mIsSetOnClickListener) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    RecyclerAdapter.this.onItemClick(view, data, pst);
                    if (RecyclerAdapter.this.mOnItemClickListener != null) {
                        RecyclerAdapter.this.mOnItemClickListener.onItemClick(null, view, pst, RecyclerAdapter.this.getItemId(pst));
                    }
                }
            });
        }
        if (((Holder)((Object)holder)).mIsSetOnLongClickListener) {
            view.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return RecyclerAdapter.this.onItemLongClick(view, data, pst);
                }
            });
        }
    }

    public int getItemCount() {
        return this.mDataList == null ? 0 : this.mDataList.size();
    }

    public abstract void onBindViewHolder(@NonNull VH var1, int var2, T var3);

    public void onItemClick(View view, T data, int pst) {
    }

    public boolean onItemLongClick(View view, T data, int pst) {
        return false;
    }

    public List<T> getDataList() {
        return this.mDataList;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public static abstract class Holder
    extends RecyclerView.ViewHolder {
        protected boolean mIsSetOnClickListener;
        protected boolean mIsSetOnLongClickListener;

        public Holder(View view) {
            super(view);
        }

        public Holder(ViewGroup viewGroup, int layoutId) {
            this(LayoutInflater.from((Context)viewGroup.getContext()).inflate(layoutId, viewGroup, false));
        }

        public void setSetOnClickListener(boolean setOnClickListener) {
            this.mIsSetOnClickListener = setOnClickListener;
        }

        public void setSetOnLongClickListener(boolean setOnLongClickListener) {
            this.mIsSetOnLongClickListener = setOnLongClickListener;
        }
    }
}

