/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.anim;

import android.view.View;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;

public class OSSpringAnimation {
    private SpringAnimation mSpringAnimation;
    private final float mStartValue;
    private final float mFinalValue;
    private final View mView;
    private final float mStiffness;
    private final float mDampingRatio;
    private final FloatPropertyCompat<View> mProperty;
    private final float mVelocity;

    private OSSpringAnimation(Builder builder) {
        this.mStartValue = builder.startValue;
        this.mFinalValue = builder.finalValue;
        this.mView = builder.view;
        this.mStiffness = builder.stiffness;
        this.mDampingRatio = builder.dampingRatio;
        this.mProperty = builder.property;
        this.mVelocity = builder.velocity;
        this.createAnimation();
    }

    private OSSpringAnimation createAnimation() {
        SpringForce springForce = new SpringForce().setStiffness(this.mStiffness).setDampingRatio(this.mDampingRatio);
        springForce.setFinalPosition(this.mFinalValue);
        this.mSpringAnimation = new SpringAnimation((Object)this.mView, this.mProperty);
        this.mSpringAnimation.setSpring(springForce);
        this.mSpringAnimation.setStartValue(this.mStartValue);
        this.mSpringAnimation.setStartVelocity(this.mVelocity);
        this.mSpringAnimation.setMinimumVisibleChange(0.002f);
        return this;
    }

    private SpringAnimation getSpringAnimation() {
        return this.mSpringAnimation;
    }

    public static class Builder {
        private float startValue = 1.0f;
        private float finalValue;
        private View view;
        private float stiffness = 350.0f;
        private float dampingRatio = 1.2f;
        private FloatPropertyCompat<View> property;
        private float velocity = 0.0f;

        public Builder startValue(float startValue) {
            this.startValue = startValue;
            return this;
        }

        public Builder finalValue(float finalValue) {
            this.finalValue = finalValue;
            return this;
        }

        public Builder property(FloatPropertyCompat<View> property) {
            this.property = property;
            return this;
        }

        public Builder view(View view) {
            this.view = view;
            return this;
        }

        public Builder stiffness(float stiffness) {
            this.stiffness = stiffness;
            return this;
        }

        public Builder velocity(float velocity) {
            this.velocity = velocity;
            return this;
        }

        public Builder dampingRatio(float dampingRatio) {
            this.dampingRatio = dampingRatio;
            return this;
        }

        public SpringAnimation build() {
            if (this.view == null) {
                throw new IllegalStateException("view == null");
            }
            if (this.property == null) {
                throw new IllegalStateException("property == null");
            }
            return new OSSpringAnimation(this).getSpringAnimation();
        }
    }
}

