/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.util;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;

public class ListScaleHelper {
    private static final String LOG_TAG = "os_list";
    private static final String TAG = "ListScaleHelper";
    private static boolean DEBUG = false;
    private static final int STATE_IDLE = 0;
    private static final int STATE_RELEASE = 1;
    private static final int STATE_REBOUND = 2;
    private int mState = 0;
    private View mScaleView;
    private static final int SCALE_TIME = 150;
    private static final int SCALE_RELEASE_TIME = 150;
    private static final int SCALE_REBOUND_TIME = 150;
    private long mStartTime;
    private float mDuration;
    private float mScaleStart;
    private float mScaleFinish;
    private float mPviotY;
    private static final float EPSILON = 0.001f;
    private Interpolator mInterpolator = new DecelerateInterpolator();

    public ListScaleHelper(Context context) {
    }

    public void onRelease(View scaleView, float scaleY, float pviotY) {
        this.mScaleView = scaleView;
        this.setScales(scaleY, 1.0f);
        this.setPviotY(pviotY);
        long now = AnimationUtils.currentAnimationTimeMillis();
        this.mState = 1;
        this.mStartTime = now;
        this.mDuration = 150.0f;
        if (DEBUG) {
            Log.i((String)LOG_TAG, (String)("ListScaleHelper onRelease() now = " + now + ", scaleY = " + scaleY + ", pviotY = " + pviotY));
        }
    }

    public void onRebound(View scaleView, float scaleY, float pviotY) {
        this.mScaleView = scaleView;
        this.setScales(1.0f, scaleY);
        this.setPviotY(pviotY);
        long now = AnimationUtils.currentAnimationTimeMillis();
        this.mState = 2;
        this.mStartTime = now;
        this.mDuration = 150.0f;
        if (DEBUG) {
            Log.i((String)LOG_TAG, (String)("ListScaleHelper onRebound() now = " + now + ", scaleY = " + scaleY + ", pviotY = " + pviotY));
        }
    }

    public void finish() {
        this.mState = 0;
    }

    private void setScales(float startScale, float finishScale) {
        this.mScaleStart = startScale;
        this.mScaleFinish = finishScale;
    }

    private void setPviotY(float pviotY) {
        this.mPviotY = pviotY;
    }

    public boolean isFinished() {
        return this.mState == 0;
    }

    public boolean update() {
        long time = AnimationUtils.currentAnimationTimeMillis();
        float t = Math.min((float)(time - this.mStartTime) / this.mDuration, 1.0f);
        float interpolation = this.mInterpolator.getInterpolation(t);
        float scale = this.mScaleStart + (this.mScaleFinish - this.mScaleStart) * interpolation;
        switch (this.mState) {
            case 1: {
                if (DEBUG) {
                    Log.i((String)LOG_TAG, (String)("ListScaleHelper update() 1 duration = " + (time - this.mStartTime) + ", scale = " + scale + ", mPviotY = " + this.mPviotY));
                }
                this.mScaleView.setPivotY(this.mPviotY);
                this.mScaleView.setScaleY(scale);
                if (!((float)(time - this.mStartTime) > this.mDuration)) break;
                this.mState = 0;
                break;
            }
            case 2: {
                if (DEBUG) {
                    Log.i((String)LOG_TAG, (String)("ListScaleHelper update() 2 duration = " + (time - this.mStartTime) + ", scale = " + scale + ", mPviotY = " + this.mPviotY));
                }
                this.mScaleView.setPivotY(this.mPviotY);
                this.mScaleView.setScaleY(scale);
                if (!((float)(time - this.mStartTime) > this.mDuration)) break;
                this.mState = 1;
                this.mScaleStart = scale;
                this.mScaleFinish = 1.0f;
                this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                this.mDuration = 150.0f;
            }
        }
        return this.mState != 0;
    }
}

