/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.followsoft;

import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.graphics.Insets;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsAnimationCompat;
import androidx.core.view.WindowInsetsCompat;
import java.util.List;

public class RootViewDeferringInsetsCallback
extends WindowInsetsAnimationCompat.Callback
implements OnApplyWindowInsetsListener {
    private int persistentInsetTypes;
    private int deferredInsetTypes;
    private View view = null;
    private WindowInsetsCompat lastWindowInsets = null;
    private boolean deferredInsets = false;

    public RootViewDeferringInsetsCallback(int persistentInsetTypes, int deferredInsetTypes) {
        super(1);
        this.persistentInsetTypes = persistentInsetTypes;
        this.deferredInsetTypes = deferredInsetTypes;
        if ((persistentInsetTypes & deferredInsetTypes) != 0) {
            throw new IllegalArgumentException("persistentInsetTypes and deferredInsetTypes can not contain any of  same WindowInsetsCompat.Type values");
        }
    }

    @NonNull
    public WindowInsetsCompat onProgress(@NonNull WindowInsetsCompat insets, @NonNull List<WindowInsetsAnimationCompat> runningAnimations) {
        return insets;
    }

    public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat windowInsets) {
        this.view = v;
        this.lastWindowInsets = windowInsets;
        int types = 0;
        types = this.deferredInsets ? this.persistentInsetTypes : this.persistentInsetTypes | this.deferredInsetTypes;
        Insets typeInsets = windowInsets.getInsets(types);
        if (typeInsets.bottom <= RootViewDeferringInsetsCallback.dp2px(48)) {
            v.setPadding(typeInsets.left, typeInsets.top, typeInsets.right, typeInsets.bottom);
        }
        return WindowInsetsCompat.CONSUMED;
    }

    static int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static int getNavigationBarHeight(Resources resources) {
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        int height = resources.getDimensionPixelSize(resourceId);
        return height;
    }

    public void onPrepare(@NonNull WindowInsetsAnimationCompat animation) {
        if ((animation.getTypeMask() & this.deferredInsetTypes) != 0) {
            this.deferredInsets = true;
        }
    }

    public void onEnd(@NonNull WindowInsetsAnimationCompat animation) {
        if (this.deferredInsets && (animation.getTypeMask() & this.deferredInsetTypes) != 0) {
            this.deferredInsets = false;
            if (this.lastWindowInsets != null && this.view != null) {
                ViewCompat.dispatchApplyWindowInsets((View)this.view, (WindowInsetsCompat)this.lastWindowInsets);
            }
        }
    }
}

