/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.actionbar;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Outline;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.widget.actionbar.OverflowMenu;

public class FootActionBar
extends FrameLayout {
    private static final String TAG = "ActionBar";
    private LinearLayout mMenuContent;
    private OverflowMenu mOverflowMenu;
    private ImageButton mCenterBtn;
    private static final ViewOutlineProvider OVAL_OUTLINE_PROVIDER = new ViewOutlineProvider(){

        public void getOutline(View view, Outline outline) {
            outline.setOval(0, 0, view.getWidth(), view.getHeight());
        }
    };

    public FootActionBar(Context context) {
        this(context, null);
    }

    public FootActionBar(Context context, AttributeSet attrs) {
        this(context, attrs, R.style.OS_FooterMenuViewStyle);
    }

    public FootActionBar(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public FootActionBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        Drawable centerBtnSrc;
        Drawable centerBtnBg;
        Drawable overMenuSrc;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FooterMenuView, defStyleAttr, defStyleRes);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        int menuLayout = R.layout.os_footer_menu_2;
        inflater.inflate(menuLayout, (ViewGroup)this, true);
        int mintHeight = (int)a.getDimension(R.styleable.FooterMenuView_minHeight, 64.0f);
        this.setMinimumHeight(mintHeight);
        this.mOverflowMenu = (OverflowMenu)this.findViewById(R.id.os_menu_btn);
        this.mCenterBtn = (ImageButton)this.findViewById(R.id.os_menu_center);
        Drawable bgDrawable = a.getDrawable(R.styleable.FooterMenuView_menuContentBg);
        if (bgDrawable != null) {
            // empty if block
        }
        int overflowMenuGravity = a.getInt(R.styleable.FooterMenuView_overflowMenuGravity, -1);
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mOverflowMenu.getLayoutParams();
        if (overflowMenuGravity != -1) {
            lp.gravity = overflowMenuGravity;
            this.mOverflowMenu.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.updateAnim(lp.gravity);
        }
        Log.d((String)"os_menu", (String)("ActionBar, lp = " + lp + ", overflowMenuGravity = " + overflowMenuGravity));
        Drawable overMenuBg = a.getDrawable(R.styleable.FooterMenuView_overflowMenuBgColor);
        if (overMenuBg != null) {
            this.mOverflowMenu.setBackground(overMenuBg);
        }
        if ((overMenuSrc = a.getDrawable(R.styleable.FooterMenuView_overflowMenuColor)) != null && ColorDrawable.class.isInstance(overMenuSrc)) {
            this.mOverflowMenu.setOverMenuColor(((ColorDrawable)overMenuSrc).getColor());
        }
        if ((centerBtnBg = a.getDrawable(R.styleable.FooterMenuView_centerBtnBgColor)) != null) {
            this.mCenterBtn.setBackground(centerBtnBg);
        }
        if ((centerBtnSrc = a.getDrawable(R.styleable.FooterMenuView_centerBtnColor)) != null) {
            this.mCenterBtn.setImageDrawable(centerBtnSrc);
        }
        a.recycle();
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0) {
            Animation animEnter = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.os_footer_menu_enter);
            this.startAnimation(animEnter);
        }
        if (visibility == 8) {
            Animation animExit = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.os_footer_menu_exit);
            this.startAnimation(animExit);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Log.d((String)"os_menu", (String)"ActionBar, onAttachedToWindow()");
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mOverflowMenu = null;
        Log.d((String)"os_menu", (String)"ActionBar, onDetachedFromWindow()");
    }

    private void updateAnim(int gravity) {
        switch (gravity & 7) {
            case 0x800003: {
                break;
            }
        }
    }

    public void setOverMenuColor(int color2) {
        this.mOverflowMenu.setOverMenuColor(color2);
    }

    public static void setupViewFab(View view, Resources res) {
        view.setOutlineProvider(OVAL_OUTLINE_PROVIDER);
        view.setTranslationZ((float)res.getDimensionPixelSize(R.dimen.floating_action_button_translation_z));
    }

    public OverflowMenu getOverflowMenu() {
        return this.mOverflowMenu;
    }

    public ImageButton getCenterBtn() {
        return this.mCenterBtn;
    }
}

