/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.elasticitylistView;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListView;
import com.transsion.widgetslib.util.ListScaleHelper;

public class ElasticityListView
extends ListView {
    private static final String TAG = "ListView";
    private static final boolean DEBUG_TOUCHEVNET = false;
    private static final boolean DEBUG = false;
    private static final float MAX_SCALE_DISTANCE = 1.1f;
    private float mPviotY = 0.0f;
    private float mScaleY = 1.0f;
    private int mFirstVisibleItem = 0;
    private int mVisibleItemCount = 0;
    private float mDownY = 0.0f;
    private float mDistanceY = 0.0f;
    private InnerOnScrollListener scrollListener;
    private AbsListView.OnScrollListener mOutsideScrollListener;
    private int mMotionPosition = 0;
    private ListScaleHelper mScaleHelper;

    public ElasticityListView(Context context) {
        super(context);
        this.init();
    }

    public ElasticityListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ElasticityListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public ElasticityListView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.mScaleHelper = new ListScaleHelper(this.getContext());
        this.scrollListener = new InnerOnScrollListener();
        super.setOnScrollListener((AbsListView.OnScrollListener)this.scrollListener);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mOutsideScrollListener = l;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        boolean handled = false;
        switch (ev.getAction()) {
            case 0: {
                if (!this.mScaleHelper.isFinished()) {
                    this.mScaleHelper.finish();
                }
                this.mDownY = ev.getY();
                this.mMotionPosition = this.pointToPosition((int)ev.getX(), (int)this.mDownY);
                this.mScaleY = 1.0f;
                this.mDistanceY = 0.0f;
                break;
            }
            case 2: {
                if (this.mDownY == 0.0f) {
                    this.mDownY = ev.getY();
                    this.mScaleY = 1.0f;
                }
                this.mDistanceY = ev.getY() - this.mDownY;
                if (this.getChildCount() <= 0 || !(Math.abs(this.mDistanceY) > 10.0f) || !this.scaleWithDistance(this.mDistanceY)) break;
                handled = true;
                this.setPressed(false);
                View child = this.getChildAt(this.mMotionPosition - this.getFirstVisiblePosition());
                if (child != null) {
                    child.setPressed(false);
                }
                this.onCancelPendingInputEvents();
                break;
            }
            case 1: 
            case 3: {
                if (this.getScaleY() == 1.0f) break;
                this.mScaleHelper.onRelease((View)this, this.getScaleY(), this.mPviotY);
                this.mScaleY = 1.0f;
                this.mDownY = 0.0f;
                this.mDistanceY = 0.0f;
                this.invalidate();
            }
        }
        if (Math.abs(this.getScaleY() - 1.0f) > 0.01f) {
            return true;
        }
        return super.onTouchEvent(ev);
    }

    private boolean scaleWithDistance(float distance) {
        if (this.isReachedFirstItemEdge() && this.isReachedLastItemEdge()) {
            if (distance > 0.0f) {
                this.mPviotY = 0.0f;
                this.setPivotY(this.mPviotY);
                this.mScaleY = 1.0f + 0.1f * distance / (float)this.getMeasuredHeight();
                if (this.mScaleY < 1.0f) {
                    this.mScaleY = 1.0f;
                    return false;
                }
                if (this.mScaleY > 1.1f) {
                    this.mScaleY = 1.1f;
                }
                this.setScaleY(this.mScaleY);
                return true;
            }
            this.mPviotY = this.getMeasuredHeight();
            this.setPivotY(this.mPviotY);
            this.mScaleY = 1.0f - 0.1f * distance / (float)this.getMeasuredHeight();
            if (this.mScaleY < 1.0f) {
                this.mScaleY = 1.0f;
                return false;
            }
            if (this.mScaleY > 1.1f) {
                this.mScaleY = 1.1f;
            }
            this.setScaleY(this.mScaleY);
            return true;
        }
        if (this.isReachedFirstItemEdge()) {
            this.mPviotY = 0.0f;
            this.setPivotY(this.mPviotY);
            this.mScaleY = 1.0f + 0.1f * distance / (float)this.getMeasuredHeight();
            if (this.mScaleY < 1.0f) {
                this.mScaleY = 1.0f;
                return false;
            }
            if (this.mScaleY > 1.1f) {
                this.mScaleY = 1.1f;
            }
            this.setScaleY(this.mScaleY);
            return true;
        }
        if (this.isReachedLastItemEdge()) {
            this.mPviotY = this.getMeasuredHeight();
            this.setPivotY(this.mPviotY);
            this.mScaleY = 1.0f - 0.1f * distance / (float)this.getMeasuredHeight();
            if (this.mScaleY < 1.0f) {
                this.mScaleY = 1.0f;
                return false;
            }
            if (this.mScaleY > 1.1f) {
                this.mScaleY = 1.1f;
            }
            this.setScaleY(this.mScaleY);
            return true;
        }
        return false;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.mScaleHelper.isFinished() && this.mScaleHelper.update()) {
            this.invalidate();
        }
    }

    private void startScaleAnimation() {
        if (this.isReachedFirstItemEdge()) {
            this.mPviotY = 0.0f;
            this.mScaleY = 1.02f;
        }
        if (this.isReachedLastItemEdge()) {
            this.mPviotY = this.getMeasuredHeight();
            this.mScaleY = 1.02f;
        }
        if (this.mScaleY != 1.0f) {
            this.mScaleHelper.onRebound((View)this, this.mScaleY, this.mPviotY);
            this.mScaleY = 1.0f;
            this.invalidate();
        }
    }

    public boolean isReachedFirstItemEdge() {
        View childFirst;
        boolean result = false;
        int firstVisPos = this.getFirstVisiblePosition();
        if (firstVisPos == 0 && this.mFirstVisibleItem == 0 && (childFirst = this.getChildAt(0)) != null) {
            result = childFirst.getTop() + this.getPaddingTop() >= 0;
        }
        return result;
    }

    public boolean isReachedLastItemEdge() {
        View childLast;
        int itemCount;
        boolean result = false;
        int firstVisPos = this.getFirstVisiblePosition();
        int lastVisPos = this.getLastVisiblePosition();
        if ((lastVisPos == (itemCount = this.getCount()) - 1 || this.mFirstVisibleItem + this.mVisibleItemCount == itemCount) && (childLast = this.getChildAt(lastVisPos - firstVisPos)) != null) {
            result = this.getHeight() >= childLast.getBottom() + this.getPaddingBottom();
        }
        return result;
    }

    private class InnerOnScrollListener
    implements AbsListView.OnScrollListener {
        private int mScrollState = 0;

        private InnerOnScrollListener() {
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (scrollState == 0 && this.mScrollState == 2) {
                ElasticityListView.this.startScaleAnimation();
            }
            this.mScrollState = scrollState;
            if (ElasticityListView.this.mOutsideScrollListener != null) {
                ElasticityListView.this.mOutsideScrollListener.onScrollStateChanged(view, scrollState);
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            ElasticityListView.this.mFirstVisibleItem = firstVisibleItem;
            ElasticityListView.this.mVisibleItemCount = visibleItemCount;
            if (ElasticityListView.this.mOutsideScrollListener != null) {
                ElasticityListView.this.mOutsideScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
        }
    }
}

