/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.NonNull;
import com.transsion.widgetslib.R;

public class RedPointView
extends View {
    private static final String TAG = "RedPointView";
    private int backgroundColor = Color.parseColor((String)"#FB2C2F");
    private int mNumColor = Color.parseColor((String)"#FFFFFF");
    public static final int OSRedPointTypeSmall = 0;
    public static final int OSRedPointTypeMedium = 1;
    public static final int OSRedPointTypeBig = 2;
    public static final int OSRedPointTypeNumSmall = 3;
    public static final int OSRedPointTypeNumMedium = 4;
    public static final int OSRedPointTypeNumBig = 5;
    private int mCurrentRedPointType = 0;
    private int mHeight;
    private int mWidth;
    private int mPadding;
    private int mTextSize;
    private int plusTextSize;
    private int corner;
    private String mNumText;
    private float mTextWidth;
    private float mPlusWidth;
    private Paint mPaintBg;
    private Paint mPaintText;
    private RectF mRectf;

    public RedPointView(Context context) {
        this(context, null);
    }

    public RedPointView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    private void initView(@NonNull Context context, AttributeSet attrs) {
        this.mRectf = new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight);
        this.mPaintBg = new Paint();
        this.mPaintBg.setAntiAlias(true);
        this.mPaintText = new Paint();
        this.mPaintText.setAntiAlias(true);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.OSRedPointTextView);
        this.mCurrentRedPointType = ta.getInt(R.styleable.OSRedPointTextView_osRedPointTextViewType, 0);
        this.mNumText = this.setNum(ta.getInt(R.styleable.OSRedPointTextView_osRedPointTextViewNum, 0));
        ta.recycle();
        this.setRedPointType(this.mCurrentRedPointType);
    }

    public void setRedPointType(int type) {
        this.mPaintBg.setColor(this.backgroundColor);
        this.mPaintText.setColor(this.mNumColor);
        this.mCurrentRedPointType = type;
        switch (this.mCurrentRedPointType) {
            case 0: {
                this.mHeight = RedPointView.dp2px(6);
                this.mPadding = RedPointView.dp2px(0);
                this.mTextSize = RedPointView.dp2px(0);
                this.mWidth = this.mHeight;
                break;
            }
            case 1: {
                this.mHeight = RedPointView.dp2px(8);
                this.mPadding = RedPointView.dp2px(0);
                this.mTextSize = RedPointView.dp2px(0);
                this.mWidth = this.mHeight;
                break;
            }
            case 2: {
                this.mHeight = RedPointView.dp2px(12);
                this.mPadding = RedPointView.dp2px(0);
                this.mTextSize = RedPointView.dp2px(0);
                this.mWidth = this.mHeight;
                break;
            }
            case 3: {
                this.mHeight = RedPointView.dp2px(14);
                this.mPadding = RedPointView.dp2px(3);
                this.mTextSize = RedPointView.dp2px(9);
                this.plusTextSize = RedPointView.dp2px(6);
                this.mPaintText.setTextSize((float)this.mTextSize);
                if (!TextUtils.isEmpty((CharSequence)this.mNumText)) {
                    this.mTextWidth = this.mPaintText.measureText(this.mNumText);
                    this.mWidth = (int)(this.mTextWidth + (float)(this.mPadding * 2));
                    break;
                }
                this.mWidth = this.mHeight;
                break;
            }
            case 4: {
                this.mHeight = RedPointView.dp2px(19);
                this.mPadding = RedPointView.dp2px(4);
                this.mTextSize = RedPointView.dp2px(12);
                this.mPaintText.setTextSize((float)this.mTextSize);
                if (!TextUtils.isEmpty((CharSequence)this.mNumText)) {
                    this.mTextWidth = this.mPaintText.measureText(this.mNumText);
                    this.mWidth = (int)(this.mTextWidth + (float)(this.mPadding * 2));
                    break;
                }
                this.mWidth = this.mHeight;
                break;
            }
            case 5: {
                this.mHeight = RedPointView.dp2px(20);
                this.mPadding = RedPointView.dp2px(3);
                this.mTextSize = RedPointView.dp2px(12);
                this.plusTextSize = RedPointView.dp2px(9);
                this.mPaintText.setTextSize((float)this.mTextSize);
                if (!TextUtils.isEmpty((CharSequence)this.mNumText)) {
                    if (this.mNumText.endsWith("+")) {
                        String withoutPlus = this.mNumText.substring(0, this.mNumText.length() - 1);
                        float measureTextWidth = this.mPaintText.measureText(withoutPlus);
                        this.mPaintText.setTextSize((float)RedPointView.dp2px(9));
                        this.mPlusWidth = this.mPaintText.measureText("+");
                        this.mTextWidth = measureTextWidth + this.mPlusWidth;
                    } else {
                        this.mTextWidth = this.mPaintText.measureText(this.mNumText);
                    }
                    this.mWidth = (int)(this.mTextWidth + (float)(this.mPadding * 2));
                    break;
                }
                this.mWidth = this.mHeight;
            }
        }
        this.corner = this.mHeight / 2;
        this.mPaintText.setTextSize((float)this.mTextSize);
        this.mWidth = Math.max(this.mWidth, this.mHeight);
        this.mRectf.left = 0.0f;
        this.mRectf.top = 0.0f;
        this.mRectf.right = this.mWidth;
        this.mRectf.bottom = this.mHeight;
        this.invalidate();
    }

    static int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public String setNum(int numText) {
        this.mNumText = numText + "";
        if ((this.mCurrentRedPointType == 5 || this.mCurrentRedPointType == 3) && numText > 99) {
            this.mNumText = "99+";
        }
        this.setRedPointType(this.mCurrentRedPointType);
        return this.mNumText;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawRoundRect(this.mRectf, (float)this.corner, (float)this.corner, this.mPaintBg);
        if (!TextUtils.isEmpty((CharSequence)this.mNumText)) {
            Paint.FontMetrics fontMetrics = this.mPaintText.getFontMetrics();
            float baseLineHeight = (fontMetrics.bottom - fontMetrics.top) / 2.0f - fontMetrics.bottom;
            int baseLine = (int)((float)(this.mHeight / 2) + baseLineHeight);
            int right = (int)(((float)this.mWidth - this.mTextWidth) / 2.0f);
            if (this.mCurrentRedPointType == 5 && this.mNumText.contains("+")) {
                canvas.drawText(this.mNumText.substring(0, this.mNumText.length() - 1), (float)right, (float)baseLine, this.mPaintText);
                this.mPaintText.setTextSize((float)this.plusTextSize);
                Paint.FontMetrics fontMetricsPlus = this.mPaintText.getFontMetrics();
                float baseLineHeightPlus = (fontMetricsPlus.bottom - fontMetricsPlus.top) / 2.0f - fontMetricsPlus.bottom;
                int baseLinePlus = (int)((float)(this.mHeight / 2) + baseLineHeightPlus);
                canvas.drawText("+", (float)right + (this.mTextWidth - this.mPlusWidth), (float)baseLinePlus, this.mPaintText);
                this.mPaintText.setTextSize((float)this.mTextSize);
            } else {
                canvas.drawText(this.mNumText, (float)right, (float)baseLine, this.mPaintText);
            }
        }
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.setRedPointType(this.mCurrentRedPointType);
    }
}

