/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.swipmenu;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.Log;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;

public class OverScroller {
    private static final String TAG = "OverScroller";
    private int mMode;
    private final SplineOverScroller mScroller;
    private TimeInterpolator mInterpolator;
    private final boolean mFlywheel;
    private static final int DEFAULT_DURATION = 250;
    private static final int SCROLL_MODE = 0;
    private static final int FLING_MODE = 1;
    public static final Interpolator SCROLL = new Interpolator(){

        public float getInterpolation(float t) {
            return (t -= 1.0f) * t * t * t * t + 1.0f;
        }
    };

    public SplineOverScroller getScroller() {
        return this.mScroller;
    }

    public OverScroller(Context context) {
        this(context, null);
    }

    public OverScroller(Context context, Interpolator interpolator) {
        this(context, interpolator, true);
    }

    public OverScroller(Context context, Interpolator interpolator, boolean flywheel) {
        this.mInterpolator = interpolator == null ? SCROLL : interpolator;
        this.mFlywheel = flywheel;
        this.mScroller = new SplineOverScroller(context);
    }

    public void setInterpolator(TimeInterpolator interpolator) {
        this.mInterpolator = interpolator == null ? SCROLL : interpolator;
    }

    public final void setFriction(float friction) {
        this.mScroller.setFriction(friction);
    }

    public final boolean isFinished() {
        return this.mScroller.mFinished;
    }

    public final void forceFinished(boolean finished) {
        this.mScroller.mFinished = finished;
    }

    public final int getCurrPos() {
        this.mScroller.mIsFinalPointRead = true;
        return this.mScroller.mCurrentPosition;
    }

    public float getCurrVelocity() {
        return this.mScroller.mCurrVelocity;
    }

    public final int getStartPos() {
        return this.mScroller.mStart;
    }

    public final int getFinalPos() {
        return this.mScroller.mFinal;
    }

    public final int getDuration() {
        return this.mScroller.mDuration;
    }

    public void extendDuration(int extend) {
        this.mScroller.extendDuration(extend);
    }

    public void setFinalPos(int newPos) {
        this.mScroller.setFinalPosition(newPos);
    }

    public boolean computeScrollOffset() {
        if (this.isFinished()) {
            return false;
        }
        switch (this.mMode) {
            case 0: {
                int duration;
                if (this.isSpringing()) {
                    return true;
                }
                long time = AnimationUtils.currentAnimationTimeMillis();
                long elapsedTime = time - this.mScroller.mStartTime;
                if (elapsedTime < (long)(duration = this.mScroller.mDuration)) {
                    float q = this.mInterpolator.getInterpolation((float)elapsedTime / (float)duration);
                    this.mScroller.updateScroll(q);
                    break;
                }
                this.abortAnimation();
                break;
            }
            case 1: {
                if (this.mScroller.mFinished || this.mScroller.update() || this.mScroller.continueWhenFinished()) break;
                this.mScroller.finish();
            }
        }
        return true;
    }

    public void startScroll(int start, int delta) {
        this.startScroll(start, delta, 250);
    }

    public void startScroll(int start, int delta, int duration) {
        this.mMode = 0;
        this.mScroller.startScroll(start, delta, duration);
    }

    public void startScrollSpring(int start, int delta, int duration, float velocity) {
        this.mMode = 0;
        this.mScroller.mState = 3;
        this.mScroller.startScroll(start, delta, duration, velocity);
    }

    public boolean springBack(int start, int min, int max) {
        this.mMode = 1;
        return this.mScroller.springback(start, min, max);
    }

    public void fling(int start, int velocity, int min, int max) {
        this.fling(start, velocity, min, max, 0);
    }

    public void fling(int start, int velocity, int min, int max, int over) {
        if (this.mFlywheel && !this.isFinished()) {
            float oldVelocityX = this.mScroller.mCurrVelocity;
            if (Math.signum(velocity) == Math.signum(oldVelocityX)) {
                velocity = (int)((float)velocity + oldVelocityX);
            }
        }
        this.mMode = 1;
        this.mScroller.fling(start, velocity, min, max, over);
    }

    public void notifyEdgeReached(int start, int finalPos, int over) {
        this.mScroller.notifyEdgeReached(start, finalPos, over);
    }

    public boolean isOverScrolled() {
        return !this.mScroller.mFinished && this.mScroller.mState != 0;
    }

    public void abortAnimation() {
        this.mScroller.finish();
    }

    public void softAbortAnimation() {
        this.mScroller.softFinish();
    }

    public int timePassed() {
        long time = AnimationUtils.currentAnimationTimeMillis();
        return (int)(time - this.mScroller.mStartTime);
    }

    public boolean isSpringing() {
        return this.mScroller.mState == 3 && !this.isFinished();
    }

    static class SplineOverScroller {
        private int mStart;
        private int mCurrentPosition;
        private int mFinal;
        private int mVelocity;
        private float mCurrVelocity;
        private float mDeceleration;
        private long mStartTime;
        private int mDuration;
        private int mSplineDuration;
        private int mSplineDistance;
        private boolean mFinished;
        private int mOver;
        private float mFlingFriction = ViewConfiguration.getScrollFriction();
        private int mState = 0;
        private Context mContext;
        private SpringAnimation mSpring;
        private boolean mIsFinalPointRead = true;
        private static final float GRAVITY = 2000.0f;
        private float mPhysicalCoeff;
        private static float DECELERATION_RATE = (float)(Math.log(0.78) / Math.log(0.9));
        private static final float INFLEXION = 0.35f;
        private static final float START_TENSION = 0.5f;
        private static final float END_TENSION = 1.0f;
        private static final float P1 = 0.175f;
        private static final float P2 = 0.35000002f;
        private static final int NB_SAMPLES = 100;
        private static final float[] SPLINE_POSITION = new float[101];
        private static final float[] SPLINE_TIME = new float[101];
        private static final int SPLINE = 0;
        private static final int CUBIC = 1;
        private static final int BALLISTIC = 2;
        private static final int SPRING = 3;
        private static final int MIN_VELOCITY = 1500;
        private float mDensity = 3.0f;
        private static final float SPRING_STIFFNESS = 200.0f;
        private static final float SPRING_DAMPING_RATIO = 1.0f;
        private DynamicAnimation.OnAnimationUpdateListener mOnAnimationUpdateListener;
        private final FloatPropertyCompat<SplineOverScroller> SPRING_PROPERTY = new FloatPropertyCompat<SplineOverScroller>("splineOverScrollerSpring"){

            public float getValue(SplineOverScroller scroller) {
                return scroller.mCurrentPosition;
            }

            public void setValue(SplineOverScroller scroller, float value) {
                scroller.mIsFinalPointRead = false;
                scroller.mCurrentPosition = (int)value;
                Log.d((String)OverScroller.TAG, (String)("setValue: \u5361\u987f\u8fc7\u6ee4 SPRING_PROPERTY value = " + value));
            }
        };

        public void setSpringAnimationListener(DynamicAnimation.OnAnimationUpdateListener onAnimationUpdateListener) {
            this.mOnAnimationUpdateListener = onAnimationUpdateListener;
        }

        void setFriction(float friction) {
            this.mFlingFriction = friction;
        }

        SplineOverScroller(Context context) {
            this.mContext = context;
            this.mFinished = true;
            this.mDensity = context.getResources().getDisplayMetrics().density;
            float ppi = context.getResources().getDisplayMetrics().density * 160.0f;
            this.mPhysicalCoeff = 386.0878f * ppi * 0.84f;
            this.mSpring = new SpringAnimation((Object)this, this.SPRING_PROPERTY);
            this.mSpring.addUpdateListener(new DynamicAnimation.OnAnimationUpdateListener(){

                public void onAnimationUpdate(DynamicAnimation dynamicAnimation, float v, float v1) {
                    if (SplineOverScroller.this.mOnAnimationUpdateListener != null) {
                        SplineOverScroller.this.mOnAnimationUpdateListener.onAnimationUpdate(dynamicAnimation, v, v1);
                    }
                }
            });
            this.mSpring.addEndListener(new DynamicAnimation.OnAnimationEndListener(){

                public void onAnimationEnd(DynamicAnimation dynamicAnimation, boolean b, float value, float v1) {
                    SplineOverScroller.this.finish();
                    SplineOverScroller.this.mState = 0;
                    SplineOverScroller.this.mCurrentPosition = (int)value;
                }
            });
        }

        void updateScroll(float q) {
            if (this.mState == 3) {
                return;
            }
            this.mCurrentPosition = this.mStart + Math.round(q * (float)(this.mFinal - this.mStart));
        }

        private static float getDeceleration(int velocity) {
            return velocity > 0 ? -2000.0f : 2000.0f;
        }

        private void adjustDuration(int start, int oldFinal, int newFinal) {
            int newDistance = newFinal - start;
            int oldDistance = oldFinal - start;
            float x = Math.abs((float)newDistance / (float)oldDistance);
            int index = (int)(100.0f * x);
            if (index < 100) {
                float x_inf = (float)index / 100.0f;
                float x_sup = (float)(index + 1) / 100.0f;
                float t_inf = SPLINE_TIME[index];
                float t_sup = SPLINE_TIME[index + 1];
                float timeCoef = t_inf + (x - x_inf) / (x_sup - x_inf) * (t_sup - t_inf);
                this.mDuration = (int)((float)this.mDuration * timeCoef);
            }
        }

        void startScroll(int start, int distance, int duration) {
            this.startScroll(start, distance, duration, 0.0f);
        }

        void startScroll(int start, int distance, int duration, float velocity) {
            this.mFinished = false;
            this.mCurrentPosition = this.mStart = start;
            this.mFinal = start + distance;
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mDuration = duration;
            this.mDeceleration = 0.0f;
            this.mVelocity = 0;
        }

        void finish() {
            if (this.mSpring != null && this.mSpring.isRunning()) {
                this.mSpring.cancel();
            }
            this.mCurrentPosition = this.mFinal;
            this.mFinished = true;
        }

        void softFinish() {
            if (this.mSpring != null && this.mSpring.isRunning()) {
                this.mSpring.cancel();
            }
            this.mFinished = true;
        }

        void setFinalPosition(int position) {
            this.mFinal = position;
            if (this.mState == 3 && this.mSpring != null) {
                this.mSpring.animateToFinalPosition((float)this.mFinal);
            }
            this.mSplineDistance = this.mFinal - this.mStart;
            this.mFinished = false;
        }

        void extendDuration(int extend) {
            long time = AnimationUtils.currentAnimationTimeMillis();
            int elapsedTime = (int)(time - this.mStartTime);
            this.mDuration = this.mSplineDuration = elapsedTime + extend;
            this.mFinished = false;
        }

        boolean springback(int start, int min, int max) {
            this.mStart = this.mFinal = start;
            this.mCurrentPosition = this.mFinal;
            this.mVelocity = 0;
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mDuration = 0;
            if (start < min) {
                this.startSpringback(start, min, 0);
            } else if (start > max) {
                this.startSpringback(start, max, 0);
            }
            return !this.mFinished;
        }

        private void startSpringback(int start, int end, int velocity) {
            this.mFinished = false;
            this.mState = 3;
            this.mCurrentPosition = this.mStart = start;
            this.mFinal = end;
            if (this.mSpring != null && this.mSpring.isRunning()) {
                this.mSpring.cancel();
            }
            this.mSpring.setSpring(new SpringForce((float)this.mFinal).setStiffness(200.0f).setDampingRatio(1.0f));
            this.mSpring.setStartVelocity((float)velocity);
            this.mSpring.start();
        }

        void fling(int start, int velocity, int min, int max, int over) {
            this.mOver = over;
            this.mFinished = false;
            if ((float)Math.abs(velocity) < 1500.0f * this.mDensity) {
                velocity = velocity < 0 ? -1500 : 1500;
            }
            this.mVelocity = velocity;
            this.mCurrVelocity = this.mVelocity;
            this.mSplineDuration = 0;
            this.mDuration = 0;
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mCurrentPosition = this.mStart = start;
            if (start > max || start < min) {
                boolean positive = start > max;
                int edge = positive ? max : min;
                this.startSpringback(start, edge, 0);
                return;
            }
            this.mState = 0;
            double totalDistance = 0.0;
            if (velocity != 0) {
                this.mDuration = this.mSplineDuration = this.getSplineFlingDuration(velocity);
                totalDistance = this.getSplineFlingDistance(velocity);
            }
            this.mSplineDistance = (int)(totalDistance * (double)Math.signum(velocity));
            this.mFinal = start + this.mSplineDistance;
            if (this.mFinal < min) {
                this.adjustDuration(this.mStart, this.mFinal, min);
                this.mFinal = min;
            }
            if (this.mFinal > max) {
                this.adjustDuration(this.mStart, this.mFinal, max);
                this.mFinal = max;
            }
        }

        private double getSplineDeceleration(int velocity) {
            return Math.log(0.35f * (float)Math.abs(velocity) / (this.mFlingFriction * this.mPhysicalCoeff));
        }

        private double getSplineFlingDistance(int velocity) {
            double l = this.getSplineDeceleration(velocity);
            double decelMinusOne = (double)DECELERATION_RATE - 1.0;
            return (double)(this.mFlingFriction * this.mPhysicalCoeff) * Math.exp((double)DECELERATION_RATE / decelMinusOne * l);
        }

        private int getSplineFlingDuration(int velocity) {
            double l = this.getSplineDeceleration(velocity);
            double decelMinusOne = (double)DECELERATION_RATE - 1.0;
            return (int)(1000.0 * Math.exp(l / decelMinusOne));
        }

        private void fitOnBounceCurve(int start, int end, int velocity) {
            float durationToApex = (float)(-velocity) / this.mDeceleration;
            float velocitySquared = (float)velocity * (float)velocity;
            float distanceToApex = velocitySquared / 2.0f / Math.abs(this.mDeceleration);
            float distanceToEdge = Math.abs(end - start);
            float totalDuration = (float)Math.sqrt(2.0 * (double)(distanceToApex + distanceToEdge) / (double)Math.abs(this.mDeceleration));
            this.mStartTime -= (long)((int)(1000.0f * (totalDuration - durationToApex)));
            this.mCurrentPosition = this.mStart = end;
            this.mVelocity = (int)(-this.mDeceleration * totalDuration);
        }

        private void startBounceAfterEdge(int start, int end, int velocity) {
            this.mDeceleration = SplineOverScroller.getDeceleration(velocity == 0 ? start - end : velocity);
            this.startSpringback(end, end, velocity);
        }

        private void startAfterEdge(int start, int min, int max, int velocity) {
            boolean keepIncreasing;
            if (start > min && start < max) {
                Log.d((String)OverScroller.TAG, (String)("finish: " + Log.getStackTraceString((Throwable)new Throwable())));
                this.mFinished = true;
                return;
            }
            boolean positive = start > max;
            int edge = positive ? max : min;
            int overDistance = start - edge;
            boolean bl = keepIncreasing = overDistance * velocity >= 0;
            if (keepIncreasing) {
                this.startBounceAfterEdge(start, edge, velocity);
            } else {
                double totalDistance = this.getSplineFlingDistance(velocity);
                if (totalDistance > (double)Math.abs(overDistance)) {
                    this.fling(start, velocity, positive ? min : start, positive ? start : max, this.mOver);
                } else {
                    this.startSpringback(start, edge, velocity);
                }
            }
        }

        void notifyEdgeReached(int start, int end, int over) {
            if (this.mState == 0) {
                this.mOver = over;
                this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                this.startAfterEdge(start, end, end, (int)this.mCurrVelocity);
            }
        }

        private void onEdgeReached() {
            this.mState = 3;
            this.startSpringback(this.mStart, this.mStart, (int)((float)this.mVelocity * 0.85f));
        }

        boolean continueWhenFinished() {
            switch (this.mState) {
                case 0: {
                    if (this.mDuration < this.mSplineDuration) {
                        this.mCurrentPosition = this.mStart = this.mFinal;
                        this.mVelocity = (int)this.mCurrVelocity;
                        this.mDeceleration = SplineOverScroller.getDeceleration(this.mVelocity);
                        this.mStartTime += (long)this.mDuration;
                        this.onEdgeReached();
                        break;
                    }
                    return false;
                }
                case 2: {
                    this.mStartTime += (long)this.mDuration;
                    this.startSpringback(this.mFinal, this.mStart, 0);
                    break;
                }
                case 1: {
                    return false;
                }
            }
            this.update();
            return true;
        }

        boolean update() {
            if (this.mState == 3) {
                return this.mFinished;
            }
            long time = AnimationUtils.currentAnimationTimeMillis();
            long currentTime = time - this.mStartTime;
            if (currentTime == 0L) {
                return this.mDuration > 0;
            }
            if (currentTime > (long)this.mDuration) {
                return false;
            }
            double distance = 0.0;
            switch (this.mState) {
                case 0: {
                    float t = (float)currentTime / (float)this.mSplineDuration;
                    int index = (int)(100.0f * t);
                    float distanceCoef = 1.0f;
                    float velocityCoef = 0.0f;
                    if (index < 100) {
                        float t_inf = (float)index / 100.0f;
                        float t_sup = (float)(index + 1) / 100.0f;
                        float d_inf = SPLINE_POSITION[index];
                        float d_sup = SPLINE_POSITION[index + 1];
                        velocityCoef = (d_sup - d_inf) / (t_sup - t_inf);
                        distanceCoef = d_inf + (t - t_inf) * velocityCoef;
                    }
                    distance = distanceCoef * (float)this.mSplineDistance;
                    this.mCurrVelocity = velocityCoef * (float)this.mSplineDistance / (float)this.mSplineDuration * 1000.0f;
                    break;
                }
                case 2: {
                    float t = (float)currentTime / 1000.0f;
                    this.mCurrVelocity = (float)this.mVelocity + this.mDeceleration * t;
                    distance = (float)this.mVelocity * t + this.mDeceleration * t * t / 2.0f;
                    break;
                }
                case 1: {
                    float t = (float)currentTime / (float)this.mDuration;
                    float t2 = t * t;
                    float sign = Math.signum(this.mVelocity);
                    distance = sign * (float)this.mOver * (3.0f * t2 - 2.0f * t * t2);
                    this.mCurrVelocity = sign * (float)this.mOver * 6.0f * (-t + t2);
                    break;
                }
            }
            this.mCurrentPosition = this.mStart + (int)Math.round(distance);
            return true;
        }

        static {
            float x_min = 0.0f;
            float y_min = 0.0f;
            for (int i = 0; i < 100; ++i) {
                float y;
                float dy;
                float x;
                float coef;
                float tx;
                float alpha = (float)i / 100.0f;
                float x_max = 1.0f;
                while (!((double)Math.abs((tx = (coef = 3.0f * (x = x_min + (x_max - x_min) / 2.0f) * (1.0f - x)) * ((1.0f - x) * 0.175f + x * 0.35000002f) + x * x * x) - alpha) < 1.0E-5)) {
                    if (tx > alpha) {
                        x_max = x;
                        continue;
                    }
                    x_min = x;
                }
                SplineOverScroller.SPLINE_POSITION[i] = coef * ((1.0f - x) * 0.5f + x) + x * x * x;
                float y_max = 1.0f;
                while (!((double)Math.abs((dy = (coef = 3.0f * (y = y_min + (y_max - y_min) / 2.0f) * (1.0f - y)) * ((1.0f - y) * 0.5f + y) + y * y * y) - alpha) < 1.0E-5)) {
                    if (dy > alpha) {
                        y_max = y;
                        continue;
                    }
                    y_min = y;
                }
                SplineOverScroller.SPLINE_TIME[i] = coef * ((1.0f - y) * 0.175f + y * 0.35000002f) + y * y * y;
            }
            SplineOverScroller.SPLINE_TIME[100] = 1.0f;
            SplineOverScroller.SPLINE_POSITION[100] = 1.0f;
        }
    }
}

