/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.swipmenu;

import android.content.Context;
import com.transsion.widgetslib.view.swipmenu.SwipeMenuItem;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class SwipeMenu {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int mOrientation;
    private List<SwipeMenuItem> mSwipeMenuItems;
    private Context mContext;

    public Context getContext() {
        return this.mContext;
    }

    public void setmContext(Context mContext) {
        this.mContext = mContext;
    }

    public SwipeMenu(Context context) {
        this.mContext = context;
        this.mOrientation = 0;
        this.mSwipeMenuItems = new ArrayList<SwipeMenuItem>(2);
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void addMenuItem(SwipeMenuItem item) {
        this.mSwipeMenuItems.add(item);
    }

    public void removeMenuItem(SwipeMenuItem item) {
        this.mSwipeMenuItems.remove(item);
    }

    public List<SwipeMenuItem> getMenuItems() {
        return this.mSwipeMenuItems;
    }

    public boolean hasMenuItems() {
        return !this.mSwipeMenuItems.isEmpty();
    }

    public int getMenuTotalWidth() {
        int totalWidth = 0;
        for (int index = 0; index < this.mSwipeMenuItems.size(); ++index) {
            totalWidth += this.mSwipeMenuItems.get(index).getWidth();
        }
        return totalWidth;
    }

    public int getAdapterPosition() {
        if (this.mSwipeMenuItems != null && this.mSwipeMenuItems.size() > 0) {
            return this.mSwipeMenuItems.get(0).getPosition();
        }
        return -1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OrientationMode {
    }
}

